/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit.internal;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public final class NbModuleLogHandler
extends Handler {
    private static StringBuffer text;
    private static Level msg;
    private static Level exc;

    public static Test registerBuffer(Level level, Level level2) {
        if (level == null) {
            level = Level.OFF;
        }
        if (level2 == null) {
            level2 = Level.OFF;
        }
        if (level2 == Level.OFF && level == Level.OFF) {
            return null;
        }
        msg = level;
        exc = level2;
        text = new StringBuffer();
        Logger logger = Logger.getLogger("");
        Level level3 = level;
        if (level3.intValue() > level2.intValue()) {
            level3 = level2;
        }
        logger.setLevel(level3);
        return new FailOnException(level, level2);
    }

    public static void finish() {
        text = null;
    }

    public static StringBuffer toString(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append(logRecord.getLoggerName());
        stringBuffer.append("] THREAD: ");
        stringBuffer.append(Thread.currentThread().getName());
        stringBuffer.append(" MSG: ");
        String string = logRecord.getMessage();
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        if (resourceBundle != null) {
            try {
                string = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string != null && logRecord.getParameters() != null) {
            string = MessageFormat.format(string, logRecord.getParameters());
        }
        stringBuffer.append(string);
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                stringBuffer.append("\n  ").append(stackTraceElement.toString());
            }
        }
        return stringBuffer;
    }

    public void publish(LogRecord logRecord) {
        StringBuffer stringBuffer = text;
        if (stringBuffer == null) {
            return;
        }
        if (logRecord.getThrown() != null) {
            if (exc.intValue() <= logRecord.getLevel().intValue()) {
                stringBuffer.append(NbModuleLogHandler.toString(logRecord)).append('\n');
            }
        } else if (msg.intValue() <= logRecord.getLevel().intValue()) {
            stringBuffer.append(NbModuleLogHandler.toString(logRecord)).append('\n');
        }
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    private static final class FailOnException
    extends TestCase {
        private final Level msg;
        private final Level exc;

        private FailOnException(Level level, Level level2) {
            super("testNoWarningsReportedDuringExecution");
            this.msg = level;
            this.exc = level2;
        }

        public int countTestCases() {
            return 1;
        }

        public void run(TestResult testResult) {
            if (text.length() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("NbModuleSuite has been started with failOnMessage(");
                stringBuilder.append(this.msg);
                stringBuilder.append(") and failOnException(").append(this.exc);
                stringBuilder.append("). The following failures have been captured:\n");
                stringBuilder.append(text);
                testResult.addFailure((Test)this, new AssertionFailedError(stringBuilder.toString()));
            }
        }
    }
}

