/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.api.beans;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.api.beans.ConfigFileManager;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.ProjectSpringScopeProvider;
import org.netbeans.modules.spring.beans.SpringConfigModelAccessor;
import org.netbeans.modules.spring.beans.SpringScopeAccessor;
import org.netbeans.modules.spring.beans.model.SpringConfigFileModelManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpringScope {
    private final ConfigFileManager configFileManager;
    private final SpringConfigFileModelManager fileModelManager = new SpringConfigFileModelManager();

    private SpringScope(ConfigFileManager configFileManager) {
        this.configFileManager = configFileManager;
    }

    public static SpringScope getSpringScope(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fo", (Object)fileObject);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        ProjectSpringScopeProvider projectSpringScopeProvider = (ProjectSpringScopeProvider)project.getLookup().lookup(ProjectSpringScopeProvider.class);
        if (projectSpringScopeProvider == null) {
            return null;
        }
        return projectSpringScopeProvider.getSpringScope();
    }

    public ConfigFileManager getConfigFileManager() {
        return this.configFileManager;
    }

    public List<SpringConfigModel> getAllConfigModels() {
        Object object2;
        final ArrayList arrayList = new ArrayList();
        final ArrayList arrayList2 = new ArrayList();
        this.configFileManager.mutex().readAccess(new Runnable(){

            public void run() {
                arrayList.addAll(SpringScope.this.configFileManager.getConfigFileGroups());
                arrayList2.addAll(SpringScope.this.configFileManager.getConfigFiles());
            }
        });
        ArrayList<SpringConfigModel> arrayList3 = new ArrayList<SpringConfigModel>(arrayList.size());
        HashSet<File> hashSet = new HashSet<File>(arrayList.size() * 2);
        for (Object object2 : arrayList) {
            arrayList3.add(SpringConfigModelAccessor.getDefault().createSpringConfigModel(this.fileModelManager, (ConfigFileGroup)object2));
            hashSet.addAll(((ConfigFileGroup)object2).getFiles());
        }
        TreeSet treeSet = new TreeSet(arrayList2);
        treeSet.removeAll(hashSet);
        object2 = treeSet.iterator();
        while (object2.hasNext()) {
            File file = (File)object2.next();
            ConfigFileGroup configFileGroup = ConfigFileGroup.create(Collections.singletonList(file));
            arrayList3.add(SpringConfigModelAccessor.getDefault().createSpringConfigModel(this.fileModelManager, configFileGroup));
        }
        return Collections.unmodifiableList(arrayList3);
    }

    private SpringConfigModel getConfigModel(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        SpringConfigModel springConfigModel = this.getGroupConfigModel(file);
        if (springConfigModel != null) {
            return springConfigModel;
        }
        return this.getFileConfigModel(fileObject);
    }

    private SpringConfigModel getGroupConfigModel(File file) {
        for (ConfigFileGroup configFileGroup : this.configFileManager.getConfigFileGroups()) {
            if (!configFileGroup.containsFile(file)) continue;
            return SpringConfigModelAccessor.getDefault().createSpringConfigModel(this.fileModelManager, configFileGroup);
        }
        return null;
    }

    private SpringConfigModel getFileConfigModel(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file != null) {
            ConfigFileGroup configFileGroup = ConfigFileGroup.create(Collections.singletonList(file));
            return SpringConfigModelAccessor.getDefault().createSpringConfigModel(this.fileModelManager, configFileGroup);
        }
        return null;
    }

    static {
        SpringScopeAccessor.setDefault(new SpringScopeAccessor(){

            public SpringScope createSpringScope(ConfigFileManager configFileManager) {
                return new SpringScope(configFileManager);
            }

            public SpringConfigModel getConfigModel(SpringScope springScope, FileObject fileObject) {
                return springScope.getConfigModel(fileObject);
            }
        });
    }
}

