/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.eecommon.api.HttpMonitorHelper;
import org.netbeans.modules.glassfish.javaee.Hk2Configuration;
import org.netbeans.modules.glassfish.javaee.ide.DummyProgressObject;
import org.netbeans.modules.glassfish.javaee.ide.Hk2PluginProperties;
import org.netbeans.modules.glassfish.javaee.ide.Hk2Target;
import org.netbeans.modules.glassfish.javaee.ide.Hk2TargetModuleID;
import org.netbeans.modules.glassfish.javaee.ide.MonitorProgressObject;
import org.netbeans.modules.glassfish.javaee.ide.UpdateContextRoot;
import org.netbeans.modules.glassfish.spi.AppDesc;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class Hk2DeploymentManager
implements DeploymentManager {
    private volatile ServerInstance serverInstance;
    private volatile InstanceProperties instanceProperties;
    private Hk2PluginProperties pluginProperties;
    private String uri;
    private ServerUtilities su;

    public Hk2DeploymentManager(String string, String string2, String string3, ServerUtilities serverUtilities) {
        this.uri = string;
        this.su = serverUtilities;
        this.pluginProperties = new Hk2PluginProperties(this, serverUtilities);
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        return new Hk2Configuration(deployableObject);
    }

    public ProgressObject distribute(Target[] targetArray, File file, File file2) throws IllegalStateException {
        String string = file.getName();
        String string2 = string.substring(0, string.length() - 4);
        Hk2TargetModuleID hk2TargetModuleID = Hk2TargetModuleID.get((Hk2Target)targetArray[0], string2, null, file.getAbsolutePath());
        MonitorProgressObject monitorProgressObject = new MonitorProgressObject(this, hk2TargetModuleID, false);
        MonitorProgressObject monitorProgressObject2 = new MonitorProgressObject(this, hk2TargetModuleID, false);
        GlassfishModule glassfishModule = this.getCommonServerSupport();
        monitorProgressObject.addProgressListener(new UpdateContextRoot(monitorProgressObject2, hk2TargetModuleID, this.getServerInstance(), false));
        try {
            boolean bl = HttpMonitorHelper.synchronizeMonitor((String)((String)glassfishModule.getInstanceProperties().get("domainsfolder")), (String)((String)glassfishModule.getInstanceProperties().get("domainname")), (boolean)Boolean.parseBoolean((String)glassfishModule.getInstanceProperties().get("httpMonitorOn")), (String[])new String[]{"modules/org-netbeans-modules-schema2beans.jar"});
            if (bl) {
                glassfishModule.restartServer((OperationStateListener)monitorProgressObject);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "http monitor state", iOException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "http monitor state", sAXException);
        }
        glassfishModule.deploy((OperationStateListener)monitorProgressObject, file, string2);
        return monitorProgressObject2;
    }

    public ProgressObject distribute(Target[] targetArray, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        throw new UnsupportedOperationException("Hk2DeploymentManager.distribute(target [], stream, stream) not supported yet.");
    }

    public ProgressObject distribute(Target[] targetArray, ModuleType moduleType, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        throw new UnsupportedOperationException("Hk2DeploymentManager.distribute(target [], module_type, stream, stream) not supported yet.");
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, File file, File file2) throws UnsupportedOperationException, IllegalStateException {
        Hk2TargetModuleID hk2TargetModuleID = (Hk2TargetModuleID)targetModuleIDArray[0];
        String string = hk2TargetModuleID.getModuleID();
        MonitorProgressObject monitorProgressObject = new MonitorProgressObject(this, hk2TargetModuleID, false);
        MonitorProgressObject monitorProgressObject2 = new MonitorProgressObject(this, hk2TargetModuleID, false);
        GlassfishModule glassfishModule = this.getCommonServerSupport();
        monitorProgressObject.addProgressListener(new UpdateContextRoot(monitorProgressObject2, hk2TargetModuleID, this.getServerInstance(), false));
        try {
            boolean bl = HttpMonitorHelper.synchronizeMonitor((String)((String)glassfishModule.getInstanceProperties().get("domainsfolder")), (String)((String)glassfishModule.getInstanceProperties().get("domainname")), (boolean)Boolean.parseBoolean((String)glassfishModule.getInstanceProperties().get("httpMonitorOn")), (String[])new String[]{"modules/org-netbeans-modules-schema2beans.jar"});
            if (bl) {
                glassfishModule.restartServer((OperationStateListener)monitorProgressObject);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "http monitor state", iOException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "http monitor state", sAXException);
        }
        glassfishModule.deploy((OperationStateListener)monitorProgressObject, file, string);
        return monitorProgressObject2;
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, InputStream inputStream, InputStream inputStream2) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("Hk2DeploymentManager.redeploy(target_module [], stream, stream) not supported yet.");
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        if (targetModuleIDArray != null && targetModuleIDArray.length > 0) {
            GlassfishModule glassfishModule = this.getCommonServerSupport();
            MonitorProgressObject monitorProgressObject = new MonitorProgressObject(this, (Hk2TargetModuleID)targetModuleIDArray[0], CommandType.UNDEPLOY, false);
            glassfishModule.undeploy((OperationStateListener)monitorProgressObject, targetModuleIDArray[0].getModuleID());
            return monitorProgressObject;
        }
        throw new IllegalArgumentException("No TargetModuleID's specified.");
    }

    public ProgressObject stop(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        return new DummyProgressObject(targetModuleIDArray[0]);
    }

    public ProgressObject start(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        return new DummyProgressObject(targetModuleIDArray[0]);
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
    }

    public boolean isLocaleSupported(Locale locale) {
        return false;
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        return this.getDeployedModules(moduleType, targetArray);
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        Logger.getLogger("glassfish-javaee").log(Level.WARNING, "Hk2DeploymentManager.getNonRunningModules() not supported yet.");
        return new TargetModuleID[0];
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        return this.getDeployedModules(moduleType, targetArray);
    }

    private TargetModuleID[] getDeployedModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        AppDesc[] appDescArray;
        ArrayList<Hk2TargetModuleID> arrayList = new ArrayList<Hk2TargetModuleID>();
        GlassfishModule glassfishModule = this.getCommonServerSupport();
        if (glassfishModule != null && (appDescArray = glassfishModule.getModuleList("web")) != null && appDescArray.length > 0) {
            if (targetArray[0] instanceof Hk2Target) {
                Hk2Target hk2Target = (Hk2Target)targetArray[0];
                for (AppDesc appDesc : appDescArray) {
                    arrayList.add(Hk2TargetModuleID.get(hk2Target, appDesc.getName(), "".equals(appDesc.getContextRoot()) ? null : appDesc.getContextRoot(), appDesc.getPath()));
                }
            } else {
                String string = targetArray[0] != null ? targetArray[0].toString() : "(null)";
                throw new TargetException(NbBundle.getMessage(Hk2DeploymentManager.class, (String)"ERR_WrongTarget", (Object)string));
            }
        }
        return arrayList.size() > 0 ? arrayList.toArray(new TargetModuleID[arrayList.size()]) : new TargetModuleID[]{};
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        return false;
    }

    public void release() {
    }

    public boolean isRedeploySupported() {
        return true;
    }

    public Locale getCurrentLocale() {
        return null;
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return null;
    }

    public Locale getDefaultLocale() {
        return null;
    }

    public Locale[] getSupportedLocales() {
        return new Locale[]{Locale.getDefault()};
    }

    public Target[] getTargets() throws IllegalStateException {
        InstanceProperties instanceProperties = this.getInstanceProperties();
        String string = this.constructServerUri(instanceProperties.getProperty("host"), instanceProperties.getProperty("httpportnumber"), null);
        Hk2Target hk2Target = new Hk2Target(string);
        Target[] targetArray = new Hk2Target[]{hk2Target};
        return targetArray;
    }

    public String getUri() {
        return this.uri;
    }

    public Hk2PluginProperties getProperties() {
        return this.pluginProperties;
    }

    public InstanceProperties getInstanceProperties() {
        if (this.instanceProperties == null) {
            this.instanceProperties = InstanceProperties.getInstanceProperties((String)this.getUri());
        }
        return this.instanceProperties;
    }

    public ServerInstance getServerInstance() {
        if (this.serverInstance == null) {
            this.serverInstance = this.su.getServerInstance(this.uri);
            if (this.serverInstance == null) {
                String string = "Common server instance not found for " + this.uri;
                Logger.getLogger("glassfish-javaee").log(Level.WARNING, string);
                throw new IllegalStateException(string);
            }
        }
        return this.serverInstance;
    }

    public GlassfishModule getCommonServerSupport() {
        ServerInstance serverInstance = this.getServerInstance();
        return (GlassfishModule)serverInstance.getBasicNode().getLookup().lookup(GlassfishModule.class);
    }

    public String getPlainUri() {
        InstanceProperties instanceProperties = this.getInstanceProperties();
        return this.constructServerUri(instanceProperties.getProperty("host"), instanceProperties.getProperty("httpportnumber"), "/__asadmin/");
    }

    public String getServerUri() {
        InstanceProperties instanceProperties = this.getInstanceProperties();
        return this.constructServerUri(instanceProperties.getProperty("host"), instanceProperties.getProperty("adminPort"), null);
    }

    private final String constructServerUri(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("http://");
        stringBuilder.append(string);
        stringBuilder.append(":");
        stringBuilder.append(string2);
        if (string3 != null && string3.length() > 0) {
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }
}

