/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.dataprovider.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionCallTreeTableNode;
import org.netbeans.modules.dlight.core.stack.dataprovider.StackDataProvider;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StackDataProviderImpl
implements StackDataProvider {
    private final List<FunctionMetric> metricsList = Arrays.asList(FunctionMetric.CpuTimeInclusiveMetric, FunctionMetric.CpuTimeExclusiveMetric);
    private StackDataStorage storage;
    private ServiceInfoDataStorage serviceInfoDataStorage;

    StackDataProviderImpl() {
    }

    public void attachTo(DataStorage dataStorage) {
        this.storage = (StackDataStorage)dataStorage;
        this.attachTo((ServiceInfoDataStorage)dataStorage);
    }

    @Override
    public List<FunctionMetric> getMetricsList() {
        return this.metricsList;
    }

    @Override
    public List<FunctionCall> getCallers(FunctionCall[] functionCallArray, boolean bl) {
        return this.storage.getCallers(functionCallArray, bl);
    }

    @Override
    public List<FunctionCall> getCallees(FunctionCall[] functionCallArray, boolean bl) {
        return this.storage.getCallees(functionCallArray, bl);
    }

    @Override
    public List<FunctionCall> getHotSpotFunctions(List<DataTableMetadata.Column> list, List<DataTableMetadata.Column> list2, int n) {
        return this.storage.getHotSpotFunctions(FunctionMetric.CpuTimeInclusiveMetric, n);
    }

    public List<FunctionCallTreeTableNode> getTableView(List<DataTableMetadata.Column> list, List<DataTableMetadata.Column> list2, int n) {
        return FunctionCallTreeTableNode.getFunctionCallTreeTableNodes(this.getHotSpotFunctions(null, null, n));
    }

    public List<FunctionCallTreeTableNode> getChildren(List<FunctionCallTreeTableNode> list) {
        return FunctionCallTreeTableNode.getFunctionCallTreeTableNodes(this.getCallers(FunctionCallTreeTableNode.getFunctionCalls(list).toArray(new FunctionCall[0]), false));
    }

    public FunctionCallTreeTableNode getValueAt(int n) {
        return null;
    }

    public String getTableValueAt(DataTableMetadata.Column column, int n) {
        return null;
    }

    public void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
        this.serviceInfoDataStorage = serviceInfoDataStorage;
    }

    @Override
    public SourceFileInfoProvider.SourceFileInfo getSourceFileInfo(FunctionCall functionCall) {
        Collection collection = Lookup.getDefault().lookupAll(SourceFileInfoProvider.class);
        for (SourceFileInfoProvider sourceFileInfoProvider : collection) {
            SourceFileInfoProvider.SourceFileInfo sourceFileInfo = sourceFileInfoProvider.fileName(functionCall.getFunction().getName(), functionCall.getOffset(), this.serviceInfoDataStorage.getInfo());
            if (sourceFileInfo == null || !sourceFileInfo.isSourceKnown()) continue;
            return sourceFileInfo;
        }
        return null;
    }

    public void dataFiltersChanged(List<DataFilter> list) {
    }
}

