/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.dataprovider.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionCallTreeTableNode;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionsListDataProvider;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FunctionsListDataProviderImpl
implements FunctionsListDataProvider {
    private StackDataStorage storage;
    private ServiceInfoDataStorage serviceInfoStorage;

    FunctionsListDataProviderImpl() {
    }

    public void attachTo(DataStorage dataStorage) {
        this.storage = (StackDataStorage)dataStorage;
        this.attachTo((ServiceInfoDataStorage)dataStorage);
    }

    @Override
    public List<FunctionCall> getFunctionsList(DataTableMetadata dataTableMetadata, FunctionDatatableDescription functionDatatableDescription, List<DataTableMetadata.Column> list) {
        if (functionDatatableDescription.getOffsetColumn() == null) {
            ArrayList<FunctionCall> arrayList = new ArrayList<FunctionCall>();
            List<FunctionCallTreeTableNode> list2 = FunctionCallTreeTableNode.getFunctionCallTreeTableNodes(this.storage.getHotSpotFunctions(FunctionMetric.CpuTimeExclusiveMetric, Integer.MAX_VALUE));
            for (FunctionCallTreeTableNode functionCallTreeTableNode : list2) {
                FunctionCall functionCall = functionCallTreeTableNode.getDeligator();
                arrayList.add(functionCall);
            }
            return arrayList;
        }
        return this.storage.getFunctionsList(dataTableMetadata, list, functionDatatableDescription);
    }

    @Override
    public SourceFileInfoProvider.SourceFileInfo getSourceFileInfo(FunctionCall functionCall) {
        Collection collection = Lookup.getDefault().lookupAll(SourceFileInfoProvider.class);
        for (SourceFileInfoProvider sourceFileInfoProvider : collection) {
            SourceFileInfoProvider.SourceFileInfo sourceFileInfo = sourceFileInfoProvider.fileName(functionCall.getFunction().getName(), functionCall.getOffset(), this.serviceInfoStorage.getInfo());
            if (sourceFileInfo == null || !sourceFileInfo.isSourceKnown()) continue;
            return sourceFileInfo;
        }
        return null;
    }

    public void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
        this.serviceInfoStorage = serviceInfoDataStorage;
    }

    public void dataFiltersChanged(List<DataFilter> list) {
    }
}

