/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.gsf.testrunner.api.TestNodeAction;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.ruby.platform.execution.ExecutionUtils;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.testrunner.ui.OutputUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

abstract class BaseTestMethodNodeAction
extends TestNodeAction {
    private static final Logger LOGGER = Logger.getLogger(BaseTestMethodNodeAction.class.getName());
    protected final Testcase testcase;
    protected final Project project;
    protected final String name;

    public BaseTestMethodNodeAction(Testcase testcase, Project project, String string) {
        this.testcase = testcase;
        this.project = project;
        this.name = string;
    }

    public Object getValue(String string) {
        if ("Name".equals(string)) {
            return this.name;
        }
        return super.getValue(string);
    }

    protected String getTestMethod() {
        return BaseTestMethodNodeAction.getTestMethod(this.testcase);
    }

    static final String getTestMethod(Testcase testcase) {
        return testcase.getClassName() + "/" + testcase.getName();
    }

    protected FileObject getTestSourceRoot() {
        return BaseTestMethodNodeAction.getTestSourceRoot(this.project);
    }

    static final FileObject getTestSourceRoot(Project project) {
        RubyBaseProject rubyBaseProject = (RubyBaseProject)project.getLookup().lookup(RubyBaseProject.class);
        FileObject[] fileObjectArray = rubyBaseProject.getTestSourceRootFiles();
        return 0 == fileObjectArray.length ? project.getProjectDirectory() : fileObjectArray[0];
    }

    protected TestRunner getTestRunner(TestRunner.TestType testType) {
        Collection collection = Lookup.getDefault().lookupAll(TestRunner.class);
        for (TestRunner testRunner : collection) {
            if (!testRunner.supports(testType)) continue;
            return testRunner;
        }
        return null;
    }

    protected void doRspecRun(FileObject fileObject, ExecutionUtils.FileLocation fileLocation) {
    }

    protected final void runRspec() {
        if (this.testcase.getLocation() == null) {
            return;
        }
        ExecutionUtils.FileLocation fileLocation = ExecutionUtils.getLocation((String)this.testcase.getLocation());
        if (fileLocation == null) {
            return;
        }
        FileObject fileObject = OutputUtils.findFile(fileLocation.file, (LineConvertors.FileLocator)this.project.getLookup().lookup(LineConvertors.FileLocator.class));
        if (fileObject == null) {
            return;
        }
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)this.project);
        if (rubyPlatform == null || rubyPlatform.isJRuby()) {
            LOGGER.info("Rerunning an rspec test case on JRuby is currently not working");
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        assert (this.project.equals(project)) : "Resolving FileObject for " + this.getTestMethod() + "/" + fileObject + " failed." + "Got " + project + ", expected " + this.project;
        this.doRspecRun(fileObject, fileLocation);
    }
}

