/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javawebstart.ui.customizer.JWSCompositeCategoryProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWSProjectProperties {
    public static final String JNLP_ENABLED = "jnlp.enabled";
    public static final String JNLP_ICON = "jnlp.icon";
    public static final String JNLP_OFFLINE = "jnlp.offline-allowed";
    public static final String JNLP_CBASE_TYPE = "jnlp.codebase.type";
    public static final String JNLP_CBASE_USER = "jnlp.codebase.user";
    public static final String JNLP_CBASE_URL = "jnlp.codebase.url";
    public static final String JNLP_DESCRIPTOR = "jnlp.descriptor";
    public static final String JNLP_APPLET = "jnlp.applet.class";
    public static final String JNLP_SPEC = "jnlp.spec";
    public static final String JNLP_INIT_HEAP = "jnlp.initial-heap-size";
    public static final String JNLP_MAX_HEAP = "jnlp.max-heap-size";
    public static final String JNLP_SIGNED = "jnlp.signed";
    public static final String CB_TYPE_LOCAL = "local";
    public static final String CB_TYPE_WEB = "web";
    public static final String CB_TYPE_USER = "user";
    public static final String DEFAULT_APPLET_WIDTH = "300";
    public static final String DEFAULT_APPLET_HEIGHT = "300";
    public static final String CB_URL_WEB = "$$codebase";
    public static final String JNLP_EXT_RES_PREFIX = "jnlp.ext.resource.";
    public static final String JNLP_APPLET_PARAMS_PREFIX = "jnlp.applet.param.";
    public static final String JNLP_APPLET_WIDTH = "jnlp.applet.width";
    public static final String JNLP_APPLET_HEIGHT = "jnlp.applet.height";
    public static final String COS_UNSUPPORTED_PROPNAME = "compile.on.save.unsupported.javawebstart";
    public static final String CB_URL_WEB_PROP_VALUE = "$$$$codebase";
    private StoreGroup jnlpPropGroup = new StoreGroup();
    private J2SEPropertyEvaluator j2sePropEval;
    private PropertyEvaluator evaluator;
    private Project j2seProject;
    private List<Map<String, String>> extResProperties;
    private List<Map<String, String>> appletParamsProperties;
    public static final String[] extResSuffixes = new String[]{"href", "name", "version"};
    public static final String[] appletParamsSuffixes = new String[]{"name", "value"};
    public static final String CONFIG_LABEL_PROPNAME = "$label";
    public static final String CONFIG_TARGET_RUN_PROPNAME = "$target.run";
    public static final String CONFIG_TARGET_DEBUG_PROPNAME = "$target.debug";
    public static final String CONFIG_TARGET_RUN = "jws-run";
    public static final String CONFIG_TARGET_DEBUG = "jws-debug";
    private DescType selectedDescType = null;
    boolean isJnlpImplPreviousVersion = false;
    JToggleButton.ToggleButtonModel enabledModel;
    JToggleButton.ToggleButtonModel allowOfflineModel;
    JToggleButton.ToggleButtonModel signedModel;
    ComboBoxModel codebaseModel;
    ComboBoxModel appletClassModel;
    ButtonModel applicationDescButtonModel;
    ButtonModel appletDescButtonModel;
    ButtonModel compDescButtonModel;
    private ButtonGroup bg;
    PropertiesTableModel extResTableModel;
    PropertiesTableModel appletParamsTableModel;
    Document iconDocument;
    Document codebaseURLDocument;
    Document appletWidthDocument;
    Document appletHeightDocument;

    public JWSProjectProperties(Lookup lookup) {
        this.j2seProject = (Project)lookup.lookup(Project.class);
        if (this.j2seProject != null) {
            this.j2sePropEval = (J2SEPropertyEvaluator)this.j2seProject.getLookup().lookup(J2SEPropertyEvaluator.class);
            this.evaluator = this.j2sePropEval.evaluator();
            this.enabledModel = this.jnlpPropGroup.createToggleButtonModel(this.evaluator, JNLP_ENABLED);
            this.allowOfflineModel = this.jnlpPropGroup.createToggleButtonModel(this.evaluator, JNLP_OFFLINE);
            this.signedModel = this.jnlpPropGroup.createToggleButtonModel(this.evaluator, JNLP_SIGNED);
            this.iconDocument = this.jnlpPropGroup.createStringDocument(this.evaluator, JNLP_ICON);
            this.appletWidthDocument = this.jnlpPropGroup.createStringDocument(this.evaluator, JNLP_APPLET_WIDTH);
            this.appletHeightDocument = this.jnlpPropGroup.createStringDocument(this.evaluator, JNLP_APPLET_HEIGHT);
            this.codebaseModel = new CodebaseComboBoxModel();
            this.codebaseURLDocument = this.createCBTextFieldDocument();
            this.appletClassModel = new AppletClassComboBoxModel(this.j2seProject);
            this.initRadioButtons();
            this.extResProperties = JWSProjectProperties.readProperties(this.evaluator, JNLP_EXT_RES_PREFIX, extResSuffixes);
            this.appletParamsProperties = JWSProjectProperties.readProperties(this.evaluator, JNLP_APPLET_PARAMS_PREFIX, appletParamsSuffixes);
            FileObject fileObject = this.j2seProject.getProjectDirectory().getFileObject("nbproject/jnlp-impl.xml");
            if (fileObject != null) {
                try {
                    String string = JWSCompositeCategoryProvider.computeCrc32(fileObject.getInputStream());
                    this.isJnlpImplPreviousVersion = JWSCompositeCategoryProvider.isJnlpImplPreviousVer(string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    boolean isJWSEnabled() {
        return this.enabledModel.isSelected();
    }

    public DescType getDescTypeProp() {
        if (this.selectedDescType != null) {
            return this.selectedDescType;
        }
        String string = this.evaluator.getProperty(JNLP_DESCRIPTOR);
        DescType descType = string != null ? DescType.valueOf(string) : DescType.application;
        return descType;
    }

    public void updateDescType() {
        this.selectedDescType = this.getSelectedDescType();
    }

    public List<Map<String, String>> getExtResProperties() {
        return this.extResProperties;
    }

    public void setExtResProperties(List<Map<String, String>> list) {
        this.extResProperties = list;
    }

    public List<Map<String, String>> getAppletParamsProperties() {
        return this.appletParamsProperties;
    }

    public void setAppletParamsProperties(List<Map<String, String>> list) {
        this.appletParamsProperties = list;
    }

    private void initRadioButtons() {
        this.applicationDescButtonModel = new JToggleButton.ToggleButtonModel();
        this.appletDescButtonModel = new JToggleButton.ToggleButtonModel();
        this.compDescButtonModel = new JToggleButton.ToggleButtonModel();
        this.bg = new ButtonGroup();
        this.applicationDescButtonModel.setGroup(this.bg);
        this.appletDescButtonModel.setGroup(this.bg);
        this.compDescButtonModel.setGroup(this.bg);
        String string = this.evaluator.getProperty(JNLP_DESCRIPTOR);
        if (string != null) {
            if (string.equals(DescType.application.toString())) {
                this.applicationDescButtonModel.setSelected(true);
            } else if (string.equals(DescType.applet.toString())) {
                this.appletDescButtonModel.setSelected(true);
            } else if (string.equals(DescType.component.toString())) {
                this.compDescButtonModel.setSelected(true);
            }
        } else {
            this.applicationDescButtonModel.setSelected(true);
        }
    }

    private void storeRest(EditableProperties editableProperties) {
        Object object;
        String string;
        String string2 = ((CodebaseComboBoxModel)this.codebaseModel).getSelectedCodebaseItem();
        String string3 = null;
        String string4 = null;
        if (CB_TYPE_USER.equals(string2)) {
            string3 = JNLP_CBASE_USER;
            try {
                string4 = this.codebaseURLDocument.getText(0, this.codebaseURLDocument.getLength());
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        } else if (CB_TYPE_LOCAL.equals(string2)) {
            string3 = JNLP_CBASE_URL;
            string4 = this.getProjectDistDir();
        } else if (CB_TYPE_WEB.equals(string2)) {
            string3 = JNLP_CBASE_URL;
            string4 = CB_URL_WEB_PROP_VALUE;
        }
        if (string3 != null && string4 != null) {
            editableProperties.setProperty(JNLP_CBASE_TYPE, string2);
            editableProperties.setProperty(string3, string4);
        }
        if ((string = (String)this.appletClassModel.getSelectedItem()) != null && !string.equals("")) {
            editableProperties.setProperty(JNLP_APPLET, string);
            object = null;
            try {
                object = this.appletWidthDocument.getText(0, this.appletWidthDocument.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (object == null || "".equals(object)) {
                editableProperties.setProperty(JNLP_APPLET_WIDTH, "300");
            }
            String string5 = null;
            try {
                string5 = this.appletHeightDocument.getText(0, this.appletHeightDocument.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (string5 == null || "".equals(string5)) {
                editableProperties.setProperty(JNLP_APPLET_HEIGHT, "300");
            }
        }
        if ((object = this.getSelectedDescType()) != null && !object.equals("")) {
            editableProperties.setProperty(JNLP_DESCRIPTOR, object.toString());
        }
        JWSProjectProperties.storeProperties(editableProperties, this.extResProperties, JNLP_EXT_RES_PREFIX);
        JWSProjectProperties.storeProperties(editableProperties, this.appletParamsProperties, JNLP_APPLET_PARAMS_PREFIX);
    }

    public void store() throws IOException {
        final EditableProperties editableProperties = new EditableProperties(true);
        final FileObject fileObject = this.j2seProject.getProjectDirectory().getFileObject("nbproject/project.properties");
        try {
            final InputStream inputStream = fileObject.getInputStream();
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws Exception {
                    try {
                        editableProperties.load(inputStream);
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    JWSProjectProperties.this.jnlpPropGroup.store(editableProperties);
                    JWSProjectProperties.this.storeRest(editableProperties);
                    OutputStream outputStream = null;
                    FileLock fileLock = null;
                    try {
                        fileLock = fileObject.lock();
                        outputStream = fileObject.getOutputStream(fileLock);
                        editableProperties.store(outputStream);
                    }
                    finally {
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private DescType getSelectedDescType() {
        DescType descType = null;
        if (this.applicationDescButtonModel.isSelected()) {
            descType = DescType.application;
        } else if (this.appletDescButtonModel.isSelected()) {
            descType = DescType.applet;
        } else if (this.compDescButtonModel.isSelected()) {
            descType = DescType.component;
        }
        return descType;
    }

    private Document createCBTextFieldDocument() {
        PlainDocument plainDocument = new PlainDocument();
        String string = this.evaluator.getProperty(JNLP_CBASE_TYPE);
        String string2 = "";
        if (CB_TYPE_LOCAL.equals(string)) {
            string2 = this.getProjectDistDir();
        } else if (CB_TYPE_WEB.equals(string)) {
            string2 = CB_URL_WEB;
        } else if (CB_TYPE_USER.equals(string)) {
            string2 = this.getCodebaseLocation();
        }
        try {
            plainDocument.insertString(0, string2, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return plainDocument;
    }

    public String getCodebaseLocation() {
        return this.evaluator.getProperty(JNLP_CBASE_USER);
    }

    public String getProjectDistDir() {
        File file = new File(FileUtil.toFile((FileObject)this.j2seProject.getProjectDirectory()), this.evaluator.getProperty("dist.dir"));
        return file.toURI().toString();
    }

    public String getProperty(String string) {
        return this.evaluator.getProperty(string);
    }

    private static List<Map<String, String>> readProperties(PropertyEvaluator propertyEvaluator, String string, String[] stringArray) {
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        int n = 0;
        while (true) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n2 = 0;
            for (String string2 : stringArray) {
                String string3 = propertyEvaluator.getProperty(string + n + "." + string2);
                if (string3 == null) continue;
                hashMap.put(string2, string3);
                ++n2;
            }
            if (n2 == 0) break;
            arrayList.add(hashMap);
            ++n;
        }
        return arrayList;
    }

    private static void storeProperties(EditableProperties editableProperties, List<Map<String, String>> list, String string) {
        int n = 0;
        Set set = editableProperties.keySet();
        HashSet<String> hashSet = new HashSet<String>();
        for (String object : set) {
            if (!object.startsWith(string)) continue;
            hashSet.add(object);
        }
        for (String string2 : hashSet) {
            editableProperties.remove((Object)string2);
        }
        for (Map map : list) {
            boolean bl = true;
            for (String string3 : map.values()) {
                if (string3 == null || string3.equals("")) continue;
                bl = false;
                break;
            }
            if (!bl) {
                for (String string3 : map.keySet()) {
                    String string4 = (String)map.get(string3);
                    String string5 = string + n + "." + string3;
                    editableProperties.setProperty(string5, string4);
                }
            }
            ++n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertiesTableModel
    extends AbstractTableModel {
        private List<Map<String, String>> properties;
        private String[] propSuffixes;
        private String[] columnNames;

        public PropertiesTableModel(List<Map<String, String>> list, String[] stringArray, String[] stringArray2) {
            if (stringArray.length != stringArray2.length) {
                throw new IllegalArgumentException();
            }
            this.properties = list;
            this.propSuffixes = stringArray;
            this.columnNames = stringArray2;
        }

        @Override
        public int getRowCount() {
            return this.properties.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.properties.get(n).put(this.propSuffixes[n2], (String)object);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.properties.get(n).get(this.propSuffixes[n2]);
        }

        public void addRow() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : this.propSuffixes) {
                hashMap.put(string, "");
            }
            this.properties.add(hashMap);
        }

        public void removeRow(int n) {
            this.properties.remove(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AppletClassComboBoxModel
    extends DefaultComboBoxModel {
        Set<ClassIndex.SearchKind> kinds = new HashSet<ClassIndex.SearchKind>(Arrays.asList(ClassIndex.SearchKind.IMPLEMENTORS));
        Set<ClassIndex.SearchScope> scopes = new HashSet<ClassIndex.SearchScope>(Arrays.asList(ClassIndex.SearchScope.SOURCE));

        public AppletClassComboBoxModel(Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
            final HashMap hashMap = new HashMap();
            for (SourceGroup sourceGroup : sourceGroupArray) {
                FileObject fileObject = sourceGroup.getRootFolder();
                ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
                ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
                ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                ArrayList<ClassPath> arrayList = new ArrayList<ClassPath>();
                if (classPath != null) {
                    arrayList.add(classPath);
                }
                if (classPath2 != null) {
                    arrayList.add(classPath2);
                }
                if (classPath3 != null) {
                    arrayList.add(classPath3);
                }
                if (arrayList.size() != 3) continue;
                hashMap.put(fileObject, arrayList);
            }
            final HashSet hashSet = new HashSet();
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    for (FileObject fileObject : hashMap.keySet()) {
                        List list = (List)hashMap.get(fileObject);
                        ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)((ClassPath)list.get(0)), (ClassPath)((ClassPath)list.get(1)), (ClassPath)((ClassPath)list.get(2)));
                        final ClassIndex classIndex = classpathInfo.getClassIndex();
                        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
                        try {
                            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                                public void run(CompilationController compilationController) throws Exception {
                                    Object object2;
                                    Elements elements = compilationController.getElements();
                                    TypeElement typeElement = elements.getTypeElement("java.applet.Applet");
                                    ElementHandle elementHandle = ElementHandle.create((Element)typeElement);
                                    TypeElement typeElement2 = elements.getTypeElement("javax.swing.JApplet");
                                    ElementHandle elementHandle2 = ElementHandle.create((Element)typeElement2);
                                    Set set = classIndex.getElements(elementHandle, AppletClassComboBoxModel.this.kinds, AppletClassComboBoxModel.this.scopes);
                                    for (Object object2 : set) {
                                        hashSet.add(object2.getQualifiedName());
                                    }
                                    Set set2 = classIndex.getElements(elementHandle2, AppletClassComboBoxModel.this.kinds, AppletClassComboBoxModel.this.scopes);
                                    object2 = set2.iterator();
                                    while (object2.hasNext()) {
                                        ElementHandle elementHandle3 = (ElementHandle)object2.next();
                                        hashSet.add(elementHandle3.getQualifiedName());
                                    }
                                }

                                public void cancel() {
                                }
                            }, true);
                        }
                        catch (Exception exception) {}
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AppletClassComboBoxModel.this.addElements(hashSet);
                            String string = JWSProjectProperties.this.evaluator.getProperty(JWSProjectProperties.JNLP_APPLET);
                            if (string != null && hashSet.contains(string)) {
                                AppletClassComboBoxModel.this.setSelectedItem(string);
                            }
                        }
                    });
                }
            });
        }

        private void addElements(Set<String> set) {
            for (String string : set) {
                this.addElement(string);
            }
        }
    }

    public class CodebaseComboBoxModel
    extends DefaultComboBoxModel {
        String localLabel = NbBundle.getBundle(JWSProjectProperties.class).getString("LBL_CB_Combo_Local");
        String webLabel = NbBundle.getBundle(JWSProjectProperties.class).getString("LBL_CB_Combo_Web");
        String userLabel = NbBundle.getBundle(JWSProjectProperties.class).getString("LBL_CB_Combo_User");
        Object[] visItems = new Object[]{this.localLabel, this.webLabel, this.userLabel};
        String[] cbItems = new String[]{"local", "web", "user"};

        public CodebaseComboBoxModel() {
            this.addElement(this.visItems[0]);
            this.addElement(this.visItems[1]);
            this.addElement(this.visItems[2]);
            String string = JWSProjectProperties.this.evaluator.getProperty(JWSProjectProperties.JNLP_CBASE_TYPE);
            if (this.cbItems[2].equals(string)) {
                this.setSelectedItem(this.visItems[2]);
            } else if (this.cbItems[1].equals(string)) {
                this.setSelectedItem(this.visItems[1]);
            } else {
                this.setSelectedItem(this.visItems[0]);
            }
        }

        public String getSelectedCodebaseItem() {
            return this.cbItems[this.getIndexOf(this.getSelectedItem())];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DescType {
        application,
        applet,
        component;

    }
}

