/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.core.editor;

import java.io.IOException;
import org.netbeans.modules.asm.core.dataobjects.AsmDataObject;
import org.netbeans.modules.cnd.support.ReadOnlySupport;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.windows.CloneableOpenSupport;

public class AsmEditorSupport
extends DataEditorSupport
implements EditorCookie,
EditorCookie.Observable,
OpenCookie,
CloseCookie,
PrintCookie,
ReadOnlySupport {
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            AsmEditorSupport.this.saveDocument();
            AsmEditorSupport.this.getDataObject().setModified(false);
        }
    };
    private boolean isReadOnly = false;

    public AsmEditorSupport(DataObject dataObject) {
        super(dataObject, (CloneableEditorSupport.Env)new Environment(dataObject));
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean bl) {
        this.isReadOnly = bl;
    }

    private void addSaveCookie() {
        AsmDataObject asmDataObject = (AsmDataObject)this.getDataObject();
        if (asmDataObject.getCookie(SaveCookie.class) == null) {
            asmDataObject.addSaveCookie(this.saveCookie);
        }
    }

    private void removeSaveCookie() {
        AsmDataObject asmDataObject = (AsmDataObject)this.getDataObject();
        Node.Cookie cookie = asmDataObject.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            asmDataObject.removeSaveCookie(this.saveCookie);
        }
    }

    private static class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 3035543168452715818L;

        public Environment(DataObject dataObject) {
            super(dataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            ReadOnlySupport readOnlySupport = (ReadOnlySupport)this.getDataObject().getLookup().lookup(ReadOnlySupport.class);
            if (readOnlySupport != null && readOnlySupport.isReadOnly()) {
                throw new IOException();
            }
            return ((AsmDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(AsmEditorSupport.class);
        }
    }
}

