/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.core.editor;

import java.io.StringReader;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.asm.core.editor.AsmLanguageHierarchy;
import org.netbeans.modules.asm.core.editor.AsmModelAccessorImpl;
import org.netbeans.modules.asm.model.AsmModel;
import org.netbeans.modules.asm.model.AsmModelAccessor;
import org.netbeans.modules.asm.model.AsmModelProvider;
import org.netbeans.modules.asm.model.AsmSyntax;
import org.netbeans.modules.asm.model.AsmSyntaxProvider;
import org.netbeans.modules.asm.model.AsmTypesProvider;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.util.Lookup;

public class AsmEditorKit
extends NbEditorKit {
    public static final String MIME_TYPE = "text/x-asm";

    protected void initDocument(BaseDocument baseDocument) {
        super.initDocument(baseDocument);
        AsmEditorKit.initLanguage((Document)baseDocument);
    }

    public String getContentType() {
        return MIME_TYPE;
    }

    private static boolean initLanguage(Document document) {
        AsmModelAccessor asmModelAccessor = (AsmModelAccessor)document.getProperty(AsmModelAccessor.class);
        if (asmModelAccessor == null) {
            Object object2;
            if (document.getProperty(Language.class) != null) {
                return true;
            }
            String string = AsmObjectUtilities.getText(document);
            if (string.length() == 0) {
                string = AsmObjectUtilities.getText(NbEditorUtilities.getFileObject((Document)document));
            }
            if (string.length() == 0) {
                if (document.getProperty(LangInitializer.class) == null) {
                    LangInitializer langInitializer = new LangInitializer(document);
                    document.putProperty(LangInitializer.class, langInitializer);
                    document.addDocumentListener(langInitializer);
                }
                return false;
            }
            AsmModelProvider asmModelProvider = null;
            AsmSyntaxProvider asmSyntaxProvider = null;
            Collection collection = Lookup.getDefault().lookup(new Lookup.Template(AsmTypesProvider.class)).allInstances();
            AsmTypesProvider.ResolverResult resolverResult = null;
            for (Object object2 : collection) {
                resolverResult = object2.resolve(new StringReader(string));
                if (resolverResult == null) continue;
                asmModelProvider = resolverResult.getModelProvider();
                asmSyntaxProvider = resolverResult.getSyntaxProvider();
                Logger.getLogger(AsmEditorKit.class.getName()).log(Level.FINE, "Asm Regognized " + asmModelProvider + " " + asmSyntaxProvider);
            }
            if (resolverResult == null || asmModelProvider == null || asmSyntaxProvider == null) {
                return false;
            }
            AsmModel asmModel = asmModelProvider.getModel();
            object2 = asmSyntaxProvider.getSyntax(asmModel);
            asmModelAccessor = new AsmModelAccessorImpl(asmModel, (AsmSyntax)object2, document);
            document.putProperty(AsmModelAccessor.class, asmModelAccessor);
            document.putProperty(AsmModel.class, asmModel);
            document.putProperty(Language.class, new AsmLanguageHierarchy((AsmSyntax)object2).language());
            return true;
        }
        return false;
    }

    private static final class LangInitializer
    implements DocumentListener {
        private final Document doc;

        LangInitializer(Document document) {
            this.doc = document;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.initLanguage();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.initLanguage();
        }

        private void initLanguage() {
            if (AsmEditorKit.initLanguage(this.doc)) {
                this.doc.removeDocumentListener(this);
                this.doc.putProperty(LangInitializer.class, null);
            }
        }
    }
}

