/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.core.dataobjects;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.asm.model.AsmModel;
import org.netbeans.modules.asm.model.AsmModelAccessor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.windows.TopComponent;

public class AsmObjectUtilities {
    private static final Logger LOGGER = Logger.getLogger(AsmObjectUtilities.class.getName());

    public static Document getDocument(DataObject dataObject) {
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            LOGGER.log(Level.INFO, "Can't determine document");
            return null;
        }
        return editorCookie.getDocument();
    }

    public static Document getDocument(JTextComponent jTextComponent) {
        return jTextComponent.getDocument();
    }

    public static AsmModel getModel(DataObject dataObject) {
        Document document = AsmObjectUtilities.getDocument(dataObject);
        if (document == null) {
            LOGGER.log(Level.INFO, "Can't determine model for " + dataObject);
            return null;
        }
        return (AsmModel)document.getProperty(AsmModel.class);
    }

    public static AsmModelAccessor getAccessor(DataObject dataObject) {
        Document document = AsmObjectUtilities.getDocument(dataObject);
        if (document == null) {
            return null;
        }
        return AsmObjectUtilities.getAccessor(document);
    }

    public static AsmModelAccessor getAccessor(Document document) {
        return (AsmModelAccessor)document.getProperty(AsmModelAccessor.class);
    }

    public static AsmModelAccessor getAccessor(JTextComponent jTextComponent) {
        Document document = AsmObjectUtilities.getDocument(jTextComponent);
        return AsmObjectUtilities.getAccessor(document);
    }

    public static String getText(final Document document) {
        final String[] stringArray = new String[1];
        document.render(new Runnable(){

            public void run() {
                try {
                    stringArray[0] = document.getLength() == 0 ? "" : document.getText(0, document.getLength() - 1);
                }
                catch (BadLocationException badLocationException) {
                    stringArray[0] = "";
                    LOGGER.log(Level.INFO, "Impossible error with getText()");
                }
            }
        });
        return stringArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getText(FileObject fileObject) {
        if (fileObject == null) {
            return "";
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(fileObject.getInputStream());
            InputStreamReader inputStreamReader = new InputStreamReader(bufferedInputStream);
            String string = new String(AsmObjectUtilities.readContents(inputStreamReader));
            return string;
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, "Can't load FileObject text " + exception.getMessage());
            String string = "";
            return string;
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    ((InputStream)bufferedInputStream).close();
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, "Can't load FileObject text " + iOException.getMessage());
                return "";
            }
        }
    }

    public static char[] readContents(Reader reader) throws IOException {
        int n;
        char[] cArray;
        LinkedList<char[]> linkedList = new LinkedList<char[]>();
        int n2 = 0;
        int n3 = 0;
        while ((n3 = reader.read(cArray = new char[1024], n = 0, cArray.length)) != -1) {
            if ((n += n3) > 0) {
                linkedList.add(cArray);
            }
            n2 += n;
            if (n3 >= 0) continue;
        }
        reader.close();
        cArray = new char[n2];
        Iterator iterator = linkedList.iterator();
        int n4 = 0;
        while (iterator.hasNext()) {
            char[] cArray2 = (char[])iterator.next();
            int n5 = iterator.hasNext() ? cArray2.length : n2 - n4;
            System.arraycopy(cArray2, 0, cArray, n4, n5);
            n4 += n5;
        }
        return cArray;
    }

    public static void goToSource(DataObject dataObject, int n) {
        if (!AsmObjectUtilities.openFileInEditor(dataObject)) {
            return;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            try {
                editorCookie.openDocument();
            }
            catch (IOException iOException) {
                return;
            }
            JEditorPane jEditorPane = editorCookie.getOpenedPanes()[0];
            jEditorPane.setCaretPosition(n);
            TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, jEditorPane);
            if (topComponent != null) {
                topComponent.requestActive();
            }
        }
    }

    public static boolean openFileInEditor(DataObject dataObject) {
        EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
        if (editCookie != null) {
            editCookie.edit();
            return true;
        }
        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (openCookie != null) {
            openCookie.open();
            return true;
        }
        return false;
    }
}

