/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.core.assistance;

import java.io.IOException;
import java.util.Collection;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.netbeans.modules.asm.core.dataobjects.AsmDataObject;
import org.netbeans.modules.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.asm.core.ui.top.NavigatorUI;
import org.netbeans.modules.asm.model.AsmModelAccessor;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionNavigator
implements NavigatorPanel {
    private NavigatorUI panelUI;
    private Lookup.Result<AsmDataObject> result;
    private Lookup.Template<AsmDataObject> asmTemplate = new Lookup.Template(AsmDataObject.class);
    private AsmDataObject curDataObject;
    private StateListener stateListener;
    private LookupListener lookupListener;
    private boolean traceState = false;

    public String getDisplayName() {
        return "";
    }

    public String getDisplayHint() {
        return "";
    }

    public NavigatorUI getComponent() {
        if (this.panelUI == null) {
            this.panelUI = new NavigatorUI();
        }
        return this.panelUI;
    }

    public void panelActivated(Lookup lookup) {
        this.result = lookup.lookup(this.asmTemplate);
        this.result.addLookupListener(this.getLookupListener());
        this.setContent(this.result);
    }

    public void panelDeactivated() {
        this.unsubscribe();
        this.result.removeLookupListener(this.getLookupListener());
    }

    public Lookup getLookup() {
        return null;
    }

    private synchronized LookupListener getLookupListener() {
        if (this.lookupListener == null) {
            this.lookupListener = new ContextListener();
        }
        return this.lookupListener;
    }

    private synchronized StateListener getStateListener() {
        if (this.stateListener == null) {
            this.stateListener = new StateListener();
        }
        return this.stateListener;
    }

    private AsmModelAccessor getAccessor(DataObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        return AsmObjectUtilities.getAccessor(dataObject);
    }

    private void unsubscribe() {
        if (this.curDataObject != null) {
            JEditorPane jEditorPane;
            assert (this.traceState);
            AsmModelAccessor asmModelAccessor = this.getAccessor((DataObject)this.curDataObject);
            if (asmModelAccessor != null) {
                asmModelAccessor.removeParseListener(this.getStateListener());
            }
            if ((jEditorPane = this.getJEditorPane((DataObject)this.curDataObject)) != null) {
                jEditorPane.removeCaretListener(this.getStateListener());
            }
            this.curDataObject = null;
            this.traceState = false;
        }
    }

    private void subscribe(AsmDataObject asmDataObject) {
        assert (!this.traceState);
        this.curDataObject = asmDataObject;
        if (this.curDataObject != null) {
            try {
                JEditorPane jEditorPane;
                EditorCookie editorCookie = (EditorCookie)asmDataObject.getCookie(EditorCookie.class);
                if (editorCookie == null) {
                    this.traceState = true;
                    return;
                }
                editorCookie.openDocument();
                AsmModelAccessor asmModelAccessor = this.getAccessor((DataObject)this.curDataObject);
                if (asmModelAccessor != null) {
                    asmModelAccessor.addParseListener(this.getStateListener());
                }
                if ((jEditorPane = this.getJEditorPane((DataObject)this.curDataObject)) != null) {
                    jEditorPane.addCaretListener(this.getStateListener());
                }
                this.traceState = true;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    private void setContent(Lookup.Result<AsmDataObject> result) {
        Runnable runnable;
        Collection collection = result.allInstances();
        if (collection.size() != 0) {
            final AsmDataObject asmDataObject = (AsmDataObject)((Object)collection.iterator().next());
            if (this.curDataObject == asmDataObject) {
                return;
            }
            runnable = new Runnable(){

                public void run() {
                    FunctionNavigator.this.unsubscribe();
                    FunctionNavigator.this.subscribe(asmDataObject);
                    FunctionNavigator.this.update();
                }
            };
        } else {
            runnable = new Runnable(){

                public void run() {
                    FunctionNavigator.this.unsubscribe();
                    FunctionNavigator.this.update();
                }
            };
        }
        this.runInEDT(runnable);
    }

    private void update() {
        AsmModelAccessor asmModelAccessor = this.getAccessor((DataObject)this.curDataObject);
        if (asmModelAccessor == null) {
            return;
        }
        this.getComponent().update((DataObject)this.curDataObject, asmModelAccessor.getState());
    }

    private void updateCursor(int n) {
        this.getComponent().updateCursor(n);
    }

    private void runInEDT(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    private JEditorPane getJEditorPane(DataObject dataObject) {
        JEditorPane jEditorPane = null;
        if (dataObject == null) {
            return null;
        }
        CloneableEditorSupport cloneableEditorSupport = (CloneableEditorSupport)dataObject.getLookup().lookup(CloneableEditorSupport.class);
        if (cloneableEditorSupport != null) {
            JEditorPane[] jEditorPaneArray = cloneableEditorSupport.getOpenedPanes();
            if (jEditorPaneArray == null) {
                return null;
            }
            if (jEditorPaneArray.length >= 1) {
                jEditorPane = jEditorPaneArray[0];
            }
        }
        return jEditorPane;
    }

    private class StateListener
    implements AsmModelAccessor.ParseListener,
    CaretListener {
        private StateListener() {
        }

        public void caretUpdate(final CaretEvent caretEvent) {
            FunctionNavigator.this.runInEDT(new Runnable(){

                public void run() {
                    FunctionNavigator.this.updateCursor(caretEvent.getDot());
                }
            });
        }

        public void notifyParsed() {
            FunctionNavigator.this.runInEDT(new Runnable(){

                public void run() {
                    FunctionNavigator.this.update();
                }
            });
        }
    }

    private class ContextListener
    implements LookupListener {
        private ContextListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            FunctionNavigator.this.setContent((Lookup.Result<AsmDataObject>)((Lookup.Result)lookupEvent.getSource()));
        }
    }
}

