/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.base.att;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.asm.base.syntax.IdentResolver;
import org.netbeans.modules.asm.model.AbstractAsmModel;
import org.netbeans.modules.asm.model.lang.BitWidth;
import org.netbeans.modules.asm.model.lang.Register;
import org.netbeans.modules.asm.model.lang.instruction.Instruction;

public class ATTIdentResolver
implements IdentResolver {
    private AbstractAsmModel model;
    private Map<Character, BitWidth> suffixes;
    private static Set<String> directives;

    public ATTIdentResolver(AbstractAsmModel abstractAsmModel) {
        this.model = abstractAsmModel;
        this.suffixes = new HashMap<Character, BitWidth>(4, 1.0f);
        this.suffixes.put(Character.valueOf('b'), BitWidth.BYTE);
        this.suffixes.put(Character.valueOf('w'), BitWidth.WORD);
        this.suffixes.put(Character.valueOf('l'), BitWidth.DWORD);
        this.suffixes.put(Character.valueOf('q'), BitWidth.QWORD);
    }

    protected boolean isDirective(String string) {
        return directives.contains(string);
    }

    public Instruction getInstruction(String string) {
        int n = string.length();
        Instruction instruction = this.model.getInstructionByName(string);
        if (instruction == null && n > 1 && this.suffixes.get(Character.valueOf(string.charAt(n - 1))) != null) {
            string = string.substring(0, n - 1);
            instruction = this.model.getInstructionByName(string);
        }
        return instruction;
    }

    public Register getRegister(String string) {
        if (string.startsWith("%")) {
            string = string.substring(1);
        }
        return this.model.getRegisterByName(string);
    }

    public IdentResolver.IdentType getIdentType(String string) {
        if (this.isDirective(string)) {
            return IdentResolver.IdentType.DIRECTIVE;
        }
        if (this.getInstruction(string) != null) {
            return IdentResolver.IdentType.INSTRUCTION;
        }
        return IdentResolver.IdentType.UNKN_IDENT;
    }

    static {
        String[] stringArray = new String[]{".align", ".ascii", ".bcd", ".bss", ".byte", ".2byte", ".4byte", ".8byte", ".comm", ".data", ".double", ".even", ".file", ".float", ".globl", ".global", ".group", ".hidden", ".ident", ".lcomm", ".local", ".long", ".popsection", ".previous", ".pushsection", ".quad", ".rel", ".section", ".set", ".skip", ".sleb128", ".string", ".symbolic", ".size", ".tbss", ".tcomm", ".tdata", ".text", ".type", ".uleb128", ".value", ".word", ".weak", ".zero", ".register"};
        directives = new HashSet<String>();
        Collections.addAll(directives, stringArray);
    }
}

