/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rhtml.editor;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.csl.core.DeleteToNextCamelCasePosition;
import org.netbeans.modules.csl.core.DeleteToPreviousCamelCasePosition;
import org.netbeans.modules.csl.core.GsfEditorKitFactory;
import org.netbeans.modules.csl.core.NextCamelCasePosition;
import org.netbeans.modules.csl.core.PreviousCamelCasePosition;
import org.netbeans.modules.csl.core.SelectCodeElementAction;
import org.netbeans.modules.csl.core.SelectNextCamelCasePosition;
import org.netbeans.modules.csl.core.SelectPreviousCamelCasePosition;
import org.netbeans.modules.csl.editor.InstantRenameAction;
import org.netbeans.modules.html.editor.HtmlKit;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.modules.ruby.rhtml.lexer.api.RhtmlTokenId;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhtmlKit
extends HtmlKit {
    static final long serialVersionUID = -1381945567613910297L;

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RhtmlKit.class);
    }

    public RhtmlKit() {
        super("application/x-httpd-eruby");
    }

    public String getContentType() {
        return "application/x-httpd-eruby";
    }

    protected BaseKit.DeleteCharAction createDeletePrevAction() {
        return new RhtmlDeleteCharAction("delete-previous", false, super.createDeletePrevAction());
    }

    protected ExtKit.ExtDefaultKeyTypedAction createDefaultKeyTypedAction() {
        return new RhtmlDefaultKeyTypedAction(super.createDefaultKeyTypedAction());
    }

    protected Action[] createActions() {
        Action[] actionArray = super.createActions();
        return TextAction.augmentList(actionArray, new Action[]{new RhtmlToggleCommentAction(), new SelectCodeElementAction("select-element-next", true), new SelectCodeElementAction("select-element-previous", false), new NextCamelCasePosition(GsfEditorKitFactory.findAction((Action[])actionArray, (String)"caret-next-word")), new PreviousCamelCasePosition(GsfEditorKitFactory.findAction((Action[])actionArray, (String)"caret-previous-word")), new SelectNextCamelCasePosition(GsfEditorKitFactory.findAction((Action[])actionArray, (String)"selection-next-word")), new SelectPreviousCamelCasePosition(GsfEditorKitFactory.findAction((Action[])actionArray, (String)"selection-previous-word")), new DeleteToNextCamelCasePosition(GsfEditorKitFactory.findAction((Action[])actionArray, (String)"remove-word-next")), new DeleteToPreviousCamelCasePosition(GsfEditorKitFactory.findAction((Action[])actionArray, (String)"remove-word-previous")), new InstantRenameAction()});
    }

    private boolean handleDeletion(BaseDocument baseDocument, int n) {
        if (n > 0) {
            try {
                char c = baseDocument.getText(n - 1, 1).charAt(0);
                if (c == '%') {
                    Token token;
                    TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                    TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                    tokenSequence.move(n);
                    if (tokenSequence.movePrevious() && (token = tokenSequence.token()).id() == RhtmlTokenId.DELIMITER && tokenSequence.offset() + token.length() == n && tokenSequence.moveNext() && (token = tokenSequence.token()).id() == RhtmlTokenId.DELIMITER && tokenSequence.offset() == n) {
                        baseDocument.remove(n - 1, 1 + token.length());
                        return true;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return false;
    }

    private boolean handleInsertion(BaseDocument baseDocument, Caret caret, char c) {
        int n = caret.getDot();
        if (c == ' ' && n >= 2) {
            try {
                String string = baseDocument.getText(n - 2, 2);
                if ("%=".equals(string) && n >= 3) {
                    string = baseDocument.getText(n - 3, 3);
                }
                if ("<%".equals(string) || "<%=".equals(string)) {
                    baseDocument.insertString(n, "  ", null);
                    caret.setDot(n + 1);
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            return false;
        }
        if (n > 0 && (c == '%' || c == '>')) {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            tokenSequence.move(n);
            try {
                if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
                    String string;
                    Token token = tokenSequence.token();
                    if (token.id() == RhtmlTokenId.HTML && baseDocument.getText(n - 1, 1).charAt(0) == '<') {
                        int n2 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n, (int)Utilities.getRowEnd((BaseDocument)baseDocument, (int)n));
                        if (n2 == -1) {
                            baseDocument.insertString(n, "%%>", null);
                            caret.setDot(n + 1);
                            return true;
                        }
                    } else if (token.id() == RhtmlTokenId.DELIMITER) {
                        int n3;
                        String string2 = ((Object)token.text()).toString();
                        if (string2.endsWith("%>")) {
                            int n4 = c == '%' ? n : n - 1;
                            CharSequence charSequence = DocumentUtilities.getText((Document)baseDocument, (int)n4, (int)2);
                            if (CharSequenceUtilities.textEquals((CharSequence)charSequence, (CharSequence)"%>")) {
                                caret.setDot(n + 1);
                                return true;
                            }
                        } else if (string2.endsWith("<") && (n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n, (int)Utilities.getRowEnd((BaseDocument)baseDocument, (int)n))) == -1) {
                            baseDocument.insertString(n, "%%>", null);
                            caret.setDot(n + 1);
                            return true;
                        }
                    } else if ((token.id() == RhtmlTokenId.RUBY || token.id() == RhtmlTokenId.RUBY_EXPR) && n >= 1 && n <= baseDocument.getLength() - 3 && "% %>".equals(string = baseDocument.getText(n - 1, 4))) {
                        baseDocument.remove(n - 1, 2);
                        caret.setDot(n + 1);
                        return true;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return false;
    }

    public Object clone() {
        return new RhtmlKit();
    }

    private static Token<?> getToken(BaseDocument baseDocument, int n, boolean bl) {
        TokenSequence tokenSequence;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        TokenSequence tokenSequence2 = tokenHierarchy.tokenSequence();
        tokenSequence2.move(n);
        if (!tokenSequence2.moveNext() && !tokenSequence2.movePrevious()) {
            return null;
        }
        if (bl && (tokenSequence = tokenSequence2.embedded()) != null) {
            tokenSequence.move(n);
            if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
                return tokenSequence.token();
            }
        }
        return tokenSequence2.token();
    }

    public static class RhtmlToggleCommentAction
    extends ExtKit.ToggleCommentAction {
        static final long serialVersionUID = -1L;
        private static final String ERB_PREFIX = "<%";
        private static final String ERB_COMMENT = "<%#";
        private static final String ERB_TEXT = "<%#*";
        private static final String ERB_SUFFIX = "%>";
        private static final int ERB_PREFIX_LEN = "<%".length();
        private static final int ERB_SUFFIX_LEN = "%>".length();
        private static final int ERB_COMMENT_LEN = "<%#".length();
        private static final int ERB_TEXT_LEN = "<%#*".length();

        public RhtmlToggleCommentAction() {
            super(ERB_COMMENT);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            this.commentUncomment(actionEvent, jTextComponent, null);
        }

        private static boolean isLineCommented(BaseDocument baseDocument, int n) throws BadLocationException {
            assert (n != -1);
            Token token = RhtmlKit.getToken(baseDocument, n, false);
            if (token != null) {
                TokenId tokenId = token.id();
                if (tokenId == RhtmlTokenId.DELIMITER) {
                    if (((Object)token.text()).toString().endsWith("#")) {
                        return true;
                    }
                    int n2 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(n + token.length()), (int)Utilities.getRowEnd((BaseDocument)baseDocument, (int)n));
                    if (n2 == -1) {
                        return false;
                    }
                    char c = DocumentUtilities.getText((Document)baseDocument, (int)n2, (int)1).charAt(0);
                    return c == '#';
                }
                if (tokenId == RhtmlTokenId.RUBY || tokenId == RhtmlTokenId.RUBY_EXPR) {
                    token = RhtmlKit.getToken(baseDocument, n, true);
                    return token.id() == RubyTokenId.LINE_COMMENT;
                }
                return tokenId == RhtmlTokenId.RUBYCOMMENT;
            }
            int n3 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n) + 1;
            if (n3 - n < ERB_COMMENT_LEN) {
                return false;
            }
            CharSequence charSequence = DocumentUtilities.getText((Document)baseDocument, (int)n, (int)ERB_COMMENT_LEN);
            return CharSequenceUtilities.textEquals((CharSequence)charSequence, (CharSequence)ERB_COMMENT);
        }

        private void commentUncomment(ActionEvent actionEvent, final JTextComponent jTextComponent, final Boolean bl) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                baseDocument.runAtomic(new Runnable(){

                    public void run() {
                        try {
                            boolean bl3;
                            int n;
                            int n2;
                            Caret caret = jTextComponent.getCaret();
                            if (caret.isSelectionVisible()) {
                                n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart());
                                n = jTextComponent.getSelectionEnd();
                                if (n > 0 && Utilities.getRowStart((BaseDocument)baseDocument, (int)n) == n && n > n2) {
                                    --n;
                                }
                                n = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                            } else {
                                n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)caret.getDot());
                                n = Utilities.getRowEnd((BaseDocument)baseDocument, (int)caret.getDot());
                            }
                            int n3 = Utilities.getRowCount((BaseDocument)baseDocument, (int)n2, (int)n);
                            boolean bl2 = bl != null ? bl : (bl3 = !RhtmlToggleCommentAction.this.allComments(baseDocument, n2, n3));
                            if (bl3) {
                                RhtmlToggleCommentAction.this.comment(baseDocument, n2, n3);
                            } else {
                                RhtmlToggleCommentAction.this.uncomment(baseDocument, n2, n3);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            jTextComponent.getToolkit().beep();
                        }
                    }
                });
            }
        }

        private boolean allComments(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
            int n3 = n;
            while (n2 > 0) {
                int n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n3);
                if (n4 != -1 && !RhtmlToggleCommentAction.isLineCommented(baseDocument, n4)) {
                    return false;
                }
                n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n3, (int)1);
                --n2;
            }
            return true;
        }

        private void comment(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
            int n3 = n;
            while (n2 > 0) {
                if (!Utilities.isRowEmpty((BaseDocument)baseDocument, (int)n3) && !Utilities.isRowWhite((BaseDocument)baseDocument, (int)n3)) {
                    int n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n3);
                    Token token = RhtmlKit.getToken(baseDocument, n4, false);
                    if (token != null) {
                        TokenId tokenId = token.id();
                        if (tokenId == RhtmlTokenId.DELIMITER) {
                            if (!((Object)token.text()).toString().endsWith("#")) {
                                baseDocument.insertString(n4 + ERB_PREFIX_LEN, "#", null);
                            }
                        } else if (tokenId == RhtmlTokenId.RUBY || tokenId == RhtmlTokenId.RUBY_EXPR) {
                            token = RhtmlKit.getToken(baseDocument, n4, true);
                            baseDocument.insertString(n4, "#", null);
                        } else if (tokenId != RhtmlTokenId.RUBYCOMMENT) {
                            baseDocument.insertString(n4, ERB_TEXT, null);
                            baseDocument.insertString(Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n3) + 1, ERB_SUFFIX, null);
                        }
                    } else {
                        CharSequence charSequence;
                        int n5 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3);
                        if (n5 - n3 >= ERB_PREFIX_LEN && CharSequenceUtilities.textEquals((CharSequence)(charSequence = DocumentUtilities.getText((Document)baseDocument, (int)n4, (int)ERB_PREFIX_LEN)), (CharSequence)ERB_PREFIX)) {
                            baseDocument.insertString(n4 + ERB_PREFIX_LEN, "#", null);
                        } else {
                            baseDocument.insertString(n4, ERB_TEXT, null);
                            baseDocument.insertString(Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n3) + 1, ERB_SUFFIX, null);
                        }
                    }
                }
                --n2;
                n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n3, (int)1);
            }
        }

        /*
         * Unable to fully structure code
         */
        private void uncomment(BaseDocument var1_1, int var2_2, int var3_3) throws BadLocationException {
            var4_4 = var2_2;
            while (var3_3 > 0) {
                block11: {
                    block12: {
                        block13: {
                            block14: {
                                if (Utilities.isRowEmpty((BaseDocument)var1_1, (int)var4_4) || Utilities.isRowWhite((BaseDocument)var1_1, (int)var4_4)) break block11;
                                var5_5 = Utilities.getRowFirstNonWhite((BaseDocument)var1_1, (int)var4_4);
                                var6_6 = RhtmlKit.access$200(var1_1, var5_5, false);
                                if (var6_6 == null) break block12;
                                var7_7 = var6_6.id();
                                if (var7_7 != RhtmlTokenId.DELIMITER) break block13;
                                if (!var6_6.text().toString().endsWith("#")) break block14;
                                var8_9 = Utilities.getRowLastNonWhite((BaseDocument)var1_1, (int)var5_5) + 1;
                                if (var8_9 - var5_5 < RhtmlToggleCommentAction.ERB_TEXT_LEN) ** GOTO lbl-1000
                                var9_13 = DocumentUtilities.getText((Document)var1_1, (int)var5_5, (int)RhtmlToggleCommentAction.ERB_TEXT_LEN);
                                var10_16 = DocumentUtilities.getText((Document)var1_1, (int)(var8_9 - RhtmlToggleCommentAction.ERB_SUFFIX_LEN), (int)RhtmlToggleCommentAction.ERB_SUFFIX_LEN);
                                if (CharSequenceUtilities.textEquals((CharSequence)var9_13, (CharSequence)"<%#*")) {
                                    var1_1.remove(var5_5, RhtmlToggleCommentAction.ERB_TEXT_LEN);
                                    if (CharSequenceUtilities.textEquals((CharSequence)var10_16, (CharSequence)"%>")) {
                                        var1_1.remove(var8_9 - RhtmlToggleCommentAction.ERB_SUFFIX_LEN - RhtmlToggleCommentAction.ERB_TEXT_LEN, RhtmlToggleCommentAction.ERB_SUFFIX_LEN);
                                    }
                                } else if (var8_9 - var5_5 >= RhtmlToggleCommentAction.ERB_COMMENT_LEN && CharSequenceUtilities.textEquals((CharSequence)(var9_13 = DocumentUtilities.getText((Document)var1_1, (int)var5_5, (int)RhtmlToggleCommentAction.ERB_COMMENT_LEN)), (CharSequence)"<%#")) {
                                    var1_1.remove(var5_5 + 2, 1);
                                }
                                break block11;
                            }
                            var8_10 = Utilities.getFirstNonWhiteFwd((BaseDocument)var1_1, (int)(var5_5 + var6_6.length()), (int)Utilities.getRowEnd((BaseDocument)var1_1, (int)var5_5));
                            if (var8_10 != -1 && (var9_14 = DocumentUtilities.getText((Document)var1_1, (int)var8_10, (int)1).charAt(0)) == '#') {
                                var1_1.remove(var8_10, 1);
                            }
                            break block11;
                        }
                        if ((var7_7 == RhtmlTokenId.RUBY || var7_7 == RhtmlTokenId.RUBY_EXPR) && (var6_6 = RhtmlKit.access$200(var1_1, var5_5, true)).id() == RubyTokenId.LINE_COMMENT) {
                            var1_1.remove(var5_5, 1);
                        }
                        break block11;
                    }
                    var7_8 = Utilities.getRowLastNonWhite((BaseDocument)var1_1, (int)var5_5) + 1;
                    if (var7_8 - var5_5 < RhtmlToggleCommentAction.ERB_TEXT_LEN) ** GOTO lbl-1000
                    var8_11 = DocumentUtilities.getText((Document)var1_1, (int)var5_5, (int)RhtmlToggleCommentAction.ERB_TEXT_LEN);
                    var9_15 = DocumentUtilities.getText((Document)var1_1, (int)(var7_8 - RhtmlToggleCommentAction.ERB_SUFFIX_LEN), (int)RhtmlToggleCommentAction.ERB_SUFFIX_LEN);
                    if (CharSequenceUtilities.textEquals((CharSequence)var8_11, (CharSequence)"<%#*")) {
                        var1_1.remove(var5_5, RhtmlToggleCommentAction.ERB_TEXT_LEN);
                        if (CharSequenceUtilities.textEquals((CharSequence)var9_15, (CharSequence)"%>")) {
                            var1_1.remove(var7_8 - RhtmlToggleCommentAction.ERB_SUFFIX_LEN - RhtmlToggleCommentAction.ERB_TEXT_LEN, RhtmlToggleCommentAction.ERB_SUFFIX_LEN);
                        }
                    } else if (var7_8 - var5_5 >= RhtmlToggleCommentAction.ERB_COMMENT_LEN && CharSequenceUtilities.textEquals((CharSequence)(var8_12 = DocumentUtilities.getText((Document)var1_1, (int)var5_5, (int)RhtmlToggleCommentAction.ERB_COMMENT_LEN)), (CharSequence)"<%#")) {
                        var1_1.remove(var5_5 + 2, 1);
                    }
                }
                --var3_3;
                var4_4 = Utilities.getRowStart((BaseDocument)var1_1, (int)var4_4, (int)1);
            }
        }
    }

    private class RhtmlDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        private BaseKit.DeleteCharAction htmlAction;

        public RhtmlDeleteCharAction(String string, boolean bl, BaseKit.DeleteCharAction deleteCharAction) {
            super(string, bl);
            this.htmlAction = deleteCharAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            jTextComponent.putClientProperty(ExtKit.ExtDeleteCharAction.class, (Object)this);
            try {
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int n = caret.getDot();
                if (RhtmlKit.this.handleDeletion(baseDocument, n)) {
                    return;
                }
                this.htmlAction.actionPerformed(actionEvent, jTextComponent);
            }
            finally {
                jTextComponent.putClientProperty(ExtKit.ExtDeleteCharAction.class, null);
            }
        }

        public boolean getNextChar() {
            return this.nextChar;
        }
    }

    private class RhtmlDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        private ExtKit.ExtDefaultKeyTypedAction htmlAction;

        RhtmlDefaultKeyTypedAction(ExtKit.ExtDefaultKeyTypedAction extDefaultKeyTypedAction) {
            this.htmlAction = extDefaultKeyTypedAction;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            char c;
            Caret caret = jTextComponent.getCaret();
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            String string = actionEvent.getActionCommand();
            if (string.length() > 0 && RhtmlKit.this.handleInsertion(baseDocument, caret, c = string.charAt(0))) {
                return;
            }
            this.htmlAction.actionPerformed(actionEvent, jTextComponent);
        }
    }
}

