/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.DebuggerManager;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class Properties {
    private static Properties defaultProperties;

    public static synchronized Properties getDefault() {
        if (defaultProperties == null) {
            defaultProperties = new PropertiesImpl();
        }
        return defaultProperties;
    }

    public abstract String getString(String var1, String var2);

    public abstract void setString(String var1, String var2);

    public abstract int getInt(String var1, int var2);

    public abstract void setInt(String var1, int var2);

    public abstract char getChar(String var1, char var2);

    public abstract void setChar(String var1, char var2);

    public abstract float getFloat(String var1, float var2);

    public abstract void setFloat(String var1, float var2);

    public abstract long getLong(String var1, long var2);

    public abstract void setLong(String var1, long var2);

    public abstract double getDouble(String var1, double var2);

    public abstract void setDouble(String var1, double var2);

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract void setBoolean(String var1, boolean var2);

    public abstract byte getByte(String var1, byte var2);

    public abstract void setByte(String var1, byte var2);

    public abstract short getShort(String var1, short var2);

    public abstract void setShort(String var1, short var2);

    public abstract Object getObject(String var1, Object var2);

    public abstract void setObject(String var1, Object var2);

    public abstract Object[] getArray(String var1, Object[] var2);

    public abstract void setArray(String var1, Object[] var2);

    public abstract Collection getCollection(String var1, Collection var2);

    public abstract void setCollection(String var1, Collection var2);

    public abstract Map getMap(String var1, Map var2);

    public abstract void setMap(String var1, Map var2);

    public abstract Properties getProperties(String var1);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException("Unsupported listening on " + this.getClass() + " properties.");
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException("Unsupported listening on " + this.getClass() + " properties.");
    }

    private static class DelegatingProperties
    extends Properties {
        private Properties delegatingProperties;
        private String root;
        private final Map<String, Reference<Properties>> childProperties = new HashMap<String, Reference<Properties>>();
        private final Map<PropertyChangeListener, PropertyChangeListener> delegatingListeners = new WeakHashMap<PropertyChangeListener, PropertyChangeListener>();

        DelegatingProperties(Properties properties, String string) {
            this.delegatingProperties = properties;
            this.root = string;
        }

        public String getString(String string, String string2) {
            return this.delegatingProperties.getString(this.root + '.' + string, string2);
        }

        public void setString(String string, String string2) {
            this.delegatingProperties.setString(this.root + '.' + string, string2);
        }

        public int getInt(String string, int n) {
            return this.delegatingProperties.getInt(this.root + '.' + string, n);
        }

        public void setInt(String string, int n) {
            this.delegatingProperties.setInt(this.root + '.' + string, n);
        }

        public byte getByte(String string, byte by) {
            return this.delegatingProperties.getByte(this.root + '.' + string, by);
        }

        public void setByte(String string, byte by) {
            this.delegatingProperties.setByte(this.root + '.' + string, by);
        }

        public char getChar(String string, char c) {
            return this.delegatingProperties.getChar(this.root + '.' + string, c);
        }

        public void setChar(String string, char c) {
            this.delegatingProperties.setChar(this.root + '.' + string, c);
        }

        public boolean getBoolean(String string, boolean bl) {
            return this.delegatingProperties.getBoolean(this.root + '.' + string, bl);
        }

        public void setBoolean(String string, boolean bl) {
            this.delegatingProperties.setBoolean(this.root + '.' + string, bl);
        }

        public short getShort(String string, short s) {
            return this.delegatingProperties.getShort(this.root + '.' + string, s);
        }

        public void setShort(String string, short s) {
            this.delegatingProperties.setShort(this.root + '.' + string, s);
        }

        public long getLong(String string, long l) {
            return this.delegatingProperties.getLong(this.root + '.' + string, l);
        }

        public void setLong(String string, long l) {
            this.delegatingProperties.setLong(this.root + '.' + string, l);
        }

        public double getDouble(String string, double d) {
            return this.delegatingProperties.getDouble(this.root + '.' + string, d);
        }

        public void setDouble(String string, double d) {
            this.delegatingProperties.setDouble(this.root + '.' + string, d);
        }

        public float getFloat(String string, float f) {
            return this.delegatingProperties.getFloat(this.root + '.' + string, f);
        }

        public void setFloat(String string, float f) {
            this.delegatingProperties.setFloat(this.root + '.' + string, f);
        }

        public Object getObject(String string, Object object) {
            return this.delegatingProperties.getObject(this.root + '.' + string, object);
        }

        public void setObject(String string, Object object) {
            this.delegatingProperties.setObject(this.root + '.' + string, object);
        }

        public Object[] getArray(String string, Object[] objectArray) {
            return this.delegatingProperties.getArray(this.root + '.' + string, objectArray);
        }

        public void setArray(String string, Object[] objectArray) {
            this.delegatingProperties.setArray(this.root + '.' + string, objectArray);
        }

        public Collection getCollection(String string, Collection collection) {
            return this.delegatingProperties.getCollection(this.root + '.' + string, collection);
        }

        public void setCollection(String string, Collection collection) {
            this.delegatingProperties.setCollection(this.root + '.' + string, collection);
        }

        public Map getMap(String string, Map map) {
            return this.delegatingProperties.getMap(this.root + '.' + string, map);
        }

        public void setMap(String string, Map map) {
            this.delegatingProperties.setMap(this.root + '.' + string, map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Properties getProperties(String string) {
            Map<String, Reference<Properties>> map = this.childProperties;
            synchronized (map) {
                Properties properties;
                Reference<Properties> reference = this.childProperties.get(string);
                if (reference != null && (properties = reference.get()) != null) {
                    return properties;
                }
                properties = new DelegatingProperties(this.delegatingProperties, this.root + '.' + string);
                reference = new WeakReference<Properties>(properties);
                this.childProperties.put(string, reference);
                return properties;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            DelegatingPropertyChangeListener delegatingPropertyChangeListener = new DelegatingPropertyChangeListener(propertyChangeListener);
            Map<PropertyChangeListener, PropertyChangeListener> map = this.delegatingListeners;
            synchronized (map) {
                this.delegatingListeners.put(propertyChangeListener, delegatingPropertyChangeListener);
            }
            this.delegatingProperties.addPropertyChangeListener(delegatingPropertyChangeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            PropertyChangeListener propertyChangeListener2;
            Map<PropertyChangeListener, PropertyChangeListener> map = this.delegatingListeners;
            synchronized (map) {
                propertyChangeListener2 = this.delegatingListeners.get(propertyChangeListener);
            }
            if (propertyChangeListener2 != null) {
                this.delegatingProperties.removePropertyChangeListener(propertyChangeListener2);
            }
        }

        private class DelegatingPropertyChangeListener
        implements PropertyChangeListener {
            private PropertyChangeListener delegate;
            private String r;
            private int rl;

            public DelegatingPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.r = DelegatingProperties.this.root + '.';
                this.rl = this.r.length();
                this.delegate = propertyChangeListener;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.length() <= this.rl || !string.startsWith(this.r)) {
                    return;
                }
                PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(DelegatingProperties.this, propertyChangeEvent.getPropertyName().substring(this.rl), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                propertyChangeEvent2.setPropagationId(propertyChangeEvent.getPropagationId());
                this.delegate.propertyChange(propertyChangeEvent2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertiesImpl
    extends Properties {
        private static final Object BAD_OBJECT = new Object();
        private static final String BAD_STRING = "";
        private static final Map BAD_MAP = new HashMap();
        private static final Collection BAD_COLLECTION = new ArrayList();
        private static final Object[] BAD_ARRAY = new Object[0];
        private final Map<String, Reference<Properties>> childProperties = new HashMap<String, Reference<Properties>>();
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final Map<PropertyChangeListener, Properties> propertiesHeldByListener = new WeakHashMap<PropertyChangeListener, Properties>();
        ServicesHolder<Reader> readers = new ReaderHolder();
        ServicesHolder<Initializer> initializers = new InitializerHolder();
        private final PrimitiveRegister impl = new PrimitiveRegister();
        private static ClassLoader classLoader;

        PropertiesImpl() {
        }

        private <T> T getInitialValue(String string, Class<T> clazz) {
            Initializer initializer = this.initializers.find(string);
            if (initializer != null) {
                Object object = initializer.getDefaultPropertyValue(string);
                if (object != null && !clazz.isAssignableFrom(object.getClass())) {
                    Exceptions.printStackTrace((Throwable)new IllegalStateException("Value (" + object + ") of a bad type (" + object.getClass() + ") returned by " + initializer + " for property '" + string + "'. It can not be cast to " + clazz));
                    object = null;
                }
                return (T)object;
            }
            return null;
        }

        @Override
        public String getString(String string, String string2) {
            String string3 = this.impl.getProperty(string, null);
            if (string3 == null) {
                String string4 = this.getInitialValue(string, String.class);
                if (string4 == null) {
                    string4 = string2;
                }
                return string4;
            }
            if (!string3.startsWith("\"")) {
                ErrorManager.getDefault().log("Can not read string " + string3 + ".");
                return string2;
            }
            return string3.substring(1, string3.length() - 1);
        }

        @Override
        public void setString(String string, String string2) {
            if (string2 != null) {
                this.impl.setProperty(string, "\"" + string2 + "\"");
            } else {
                this.impl.setProperty(string, string2);
            }
            this.pcs.firePropertyChange(string, null, string2);
        }

        @Override
        public int getInt(String string, int n) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                Integer n2 = this.getInitialValue(string, Integer.class);
                if (n2 == null) {
                    n2 = n;
                }
                return n2;
            }
            try {
                int n3 = Integer.parseInt(string2);
                return n3;
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }

        @Override
        public void setInt(String string, int n) {
            this.impl.setProperty(string, Integer.toString(n));
            this.pcs.firePropertyChange(string, null, (Object)n);
        }

        @Override
        public char getChar(String string, char c) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                Character c2 = this.getInitialValue(string, Character.class);
                if (c2 == null) {
                    c2 = Character.valueOf(c);
                }
                return c2.charValue();
            }
            char c3 = string2.charAt(0);
            return c3;
        }

        @Override
        public void setChar(String string, char c) {
            this.impl.setProperty(string, Character.toString(c));
            this.pcs.firePropertyChange(string, null, Character.valueOf(c));
        }

        @Override
        public float getFloat(String string, float f) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                Float f2 = this.getInitialValue(string, Float.class);
                if (f2 == null) {
                    f2 = Float.valueOf(f);
                }
                return f2.floatValue();
            }
            try {
                float f3 = Float.parseFloat(string2);
                return f3;
            }
            catch (NumberFormatException numberFormatException) {
                return f;
            }
        }

        @Override
        public void setFloat(String string, float f) {
            this.impl.setProperty(string, Float.toString(f));
            this.pcs.firePropertyChange(string, null, Float.valueOf(f));
        }

        @Override
        public long getLong(String string, long l) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                Long l2 = this.getInitialValue(string, Long.class);
                if (l2 == null) {
                    l2 = l;
                }
                return l2;
            }
            try {
                long l3 = Long.parseLong(string2);
                return l3;
            }
            catch (NumberFormatException numberFormatException) {
                return l;
            }
        }

        @Override
        public void setLong(String string, long l) {
            this.impl.setProperty(string, Long.toString(l));
            this.pcs.firePropertyChange(string, null, l);
        }

        @Override
        public double getDouble(String string, double d) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                Double d2 = this.getInitialValue(string, Double.class);
                if (d2 == null) {
                    d2 = d;
                }
                return d2;
            }
            try {
                double d3 = Double.parseDouble(string2);
                return d3;
            }
            catch (NumberFormatException numberFormatException) {
                return d;
            }
        }

        @Override
        public void setDouble(String string, double d) {
            this.impl.setProperty(string, Double.toString(d));
            this.pcs.firePropertyChange(string, null, d);
        }

        @Override
        public boolean getBoolean(String string, boolean bl) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                Boolean bl2 = this.getInitialValue(string, Boolean.class);
                if (bl2 == null) {
                    bl2 = bl;
                }
                return bl2;
            }
            boolean bl3 = string2.equals("true");
            return bl3;
        }

        @Override
        public void setBoolean(String string, boolean bl) {
            this.impl.setProperty(string, bl ? "true" : "false");
            this.pcs.firePropertyChange(string, null, (Object)bl);
        }

        @Override
        public byte getByte(String string, byte by) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                Byte by2 = this.getInitialValue(string, Byte.class);
                if (by2 == null) {
                    by2 = by;
                }
                return by2;
            }
            try {
                byte by3 = Byte.parseByte(string2);
                return by3;
            }
            catch (NumberFormatException numberFormatException) {
                return by;
            }
        }

        @Override
        public void setByte(String string, byte by) {
            this.impl.setProperty(string, Byte.toString(by));
            this.pcs.firePropertyChange(string, null, (Object)by);
        }

        @Override
        public short getShort(String string, short s) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                Short s2 = this.getInitialValue(string, Short.class);
                if (s2 == null) {
                    s2 = s;
                }
                return s2;
            }
            try {
                short s3 = Short.parseShort(string2);
                return s3;
            }
            catch (NumberFormatException numberFormatException) {
                return s;
            }
        }

        @Override
        public void setShort(String string, short s) {
            this.impl.setProperty(string, Short.toString(s));
            this.pcs.firePropertyChange(string, null, (Object)s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getObject(String string, Object object) {
            PrimitiveRegister primitiveRegister = this.impl;
            synchronized (primitiveRegister) {
                Reader reader;
                String string2 = this.impl.getProperty(string, null);
                if (string2 == null) {
                    Object object2 = this.getInitialValue(string, Object.class);
                    if (object2 == null) {
                        object2 = object;
                    }
                    return object2;
                }
                if (string2.equals("# null")) {
                    return null;
                }
                if (!string2.startsWith("# ")) {
                    if (string2.startsWith("\"")) {
                        String string3 = this.getString(string, BAD_STRING);
                        if (string3 == BAD_STRING) {
                            return object;
                        }
                        return string3;
                    }
                    ErrorManager.getDefault().log("Can not read object " + string2 + ". No reader registered for type " + string2 + ".");
                    return object;
                }
                string2 = string2.substring(2);
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz != null) {
                    if (Map.class.isAssignableFrom(clazz)) {
                        Map map = this.getMap(string, BAD_MAP);
                        if (map == BAD_MAP) {
                            return object;
                        }
                        return map;
                    }
                    if (Object[].class.isAssignableFrom(clazz)) {
                        Object[] objectArray = this.getArray(string, BAD_ARRAY);
                        if (objectArray == BAD_ARRAY) {
                            return object;
                        }
                        return objectArray;
                    }
                    if (Collection.class.isAssignableFrom(clazz)) {
                        Collection collection = this.getCollection(string, BAD_COLLECTION);
                        if (collection == BAD_COLLECTION) {
                            return object;
                        }
                        return collection;
                    }
                }
                if ((reader = this.readers.find(string2)) == null) {
                    ErrorManager.getDefault().log("Can not read object. No reader registered for type " + string2 + ".");
                    return object;
                }
                return reader.read(string2, this.getProperties(string));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setObject(String string, Object object) {
            PrimitiveRegister primitiveRegister = this.impl;
            synchronized (primitiveRegister) {
                if (object == null) {
                    this.impl.setProperty(string, "# null");
                } else if (object instanceof String) {
                    this.setString(string, (String)object);
                } else if (object instanceof Map) {
                    this.setMap(string, (Map)object);
                } else if (object instanceof Collection) {
                    this.setCollection(string, (Collection)object);
                } else if (object instanceof Object[]) {
                    this.setArray(string, (Object[])object);
                } else {
                    Reader reader = this.readers.find(object.getClass().getName());
                    if (reader == null) {
                        ErrorManager.getDefault().log("Can not write object " + object);
                        return;
                    }
                    reader.write(object, this.getProperties(string));
                    this.impl.setProperty(string, "# " + object.getClass().getName());
                }
            }
            this.pcs.firePropertyChange(string, null, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] getArray(String string, Object[] objectArray) {
            PrimitiveRegister primitiveRegister = this.impl;
            synchronized (primitiveRegister) {
                String string2 = this.impl.getProperty(string + ".array_type", null);
                if (string2 == null) {
                    Object[] objectArray2 = this.getInitialValue(string, Object[].class);
                    if (objectArray2 == null) {
                        objectArray2 = objectArray;
                    }
                    return objectArray2;
                }
                Properties properties = this.getProperties(string);
                int n = properties.getInt("length", -1);
                if (n < 0) {
                    return objectArray;
                }
                Object[] objectArray3 = null;
                try {
                    objectArray3 = (Object[])Array.newInstance(PropertiesImpl.getClassLoader().loadClass(string2), n);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager.getDefault().notify((Throwable)classNotFoundException);
                    objectArray3 = new Object[n];
                }
                for (int i = 0; i < n; ++i) {
                    Object object = properties.getObject(BAD_STRING + i, BAD_OBJECT);
                    if (object == BAD_OBJECT) {
                        return objectArray;
                    }
                    objectArray3[i] = object;
                }
                return objectArray3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setArray(String string, Object[] objectArray) {
            PrimitiveRegister primitiveRegister = this.impl;
            synchronized (primitiveRegister) {
                this.impl.setProperty(string, "# array");
                this.impl.setProperty(string + ".array_type", objectArray.getClass().getComponentType().getName());
                Properties properties = this.getProperties(string);
                int n = objectArray.length;
                properties.setInt("length", n);
                for (int i = 0; i < n; ++i) {
                    properties.setObject(BAD_STRING + i, objectArray[i]);
                }
            }
            this.pcs.firePropertyChange(string, null, objectArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection getCollection(String string, Collection collection) {
            PrimitiveRegister primitiveRegister = this.impl;
            synchronized (primitiveRegister) {
                String string2 = this.impl.getProperty(string, null);
                if (string2 == null) {
                    Collection collection2 = this.getInitialValue(string, Collection.class);
                    if (collection2 == null) {
                        collection2 = collection;
                    }
                    return collection2;
                }
                if (!string2.startsWith("# ")) {
                    return collection;
                }
                Collection collection3 = null;
                try {
                    collection3 = (Collection)Class.forName(string2.substring(2)).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println(classNotFoundException.getLocalizedMessage());
                    ErrorManager.getDefault().log(classNotFoundException.getLocalizedMessage());
                    ErrorManager.getDefault().notify((Throwable)classNotFoundException);
                    return collection;
                }
                catch (InstantiationException instantiationException) {
                    System.err.println(instantiationException.getLocalizedMessage());
                    ErrorManager.getDefault().log(instantiationException.getLocalizedMessage());
                    ErrorManager.getDefault().notify((Throwable)instantiationException);
                    return collection;
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println(illegalAccessException.getLocalizedMessage());
                    ErrorManager.getDefault().log(illegalAccessException.getLocalizedMessage());
                    ErrorManager.getDefault().notify((Throwable)illegalAccessException);
                    return collection;
                }
                Properties properties = this.getProperties(string);
                int n = properties.getInt("length", 0);
                for (int i = 0; i < n; ++i) {
                    Object object = properties.getObject(BAD_STRING + i, BAD_OBJECT);
                    if (object == BAD_OBJECT) {
                        return collection;
                    }
                    collection3.add(object);
                }
                return collection3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCollection(String string, Collection collection) {
            PrimitiveRegister primitiveRegister = this.impl;
            synchronized (primitiveRegister) {
                if (collection == null) {
                    this.impl.setProperty(string, null);
                } else {
                    this.impl.setProperty(string, "# " + collection.getClass().getName());
                    Properties properties = this.getProperties(string);
                    Iterator iterator = collection.iterator();
                    int n = 0;
                    properties.setInt("length", collection.size());
                    while (iterator.hasNext()) {
                        properties.setObject(BAD_STRING + n, iterator.next());
                        ++n;
                    }
                }
            }
            this.pcs.firePropertyChange(string, null, collection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map getMap(String string, Map map) {
            PrimitiveRegister primitiveRegister = this.impl;
            synchronized (primitiveRegister) {
                String string2 = this.impl.getProperty(string, null);
                if (string2 == null) {
                    Map map2 = this.getInitialValue(string, Map.class);
                    if (map2 == null) {
                        map2 = map;
                    }
                    return map2;
                }
                if (!string2.startsWith("# ")) {
                    return map;
                }
                Map map3 = null;
                try {
                    map3 = (Map)Class.forName(string2.substring(2)).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager.getDefault().log(classNotFoundException.getLocalizedMessage());
                    return map;
                }
                catch (InstantiationException instantiationException) {
                    ErrorManager.getDefault().log(instantiationException.getLocalizedMessage());
                    return map;
                }
                catch (IllegalAccessException illegalAccessException) {
                    ErrorManager.getDefault().log(illegalAccessException.getLocalizedMessage());
                    return map;
                }
                Properties properties = this.getProperties(string);
                int n = properties.getInt("length", 0);
                for (int i = 0; i < n; ++i) {
                    Object object = properties.getObject(BAD_STRING + i + "-key", BAD_OBJECT);
                    if (object == BAD_OBJECT) {
                        return map;
                    }
                    Object object2 = properties.getObject(BAD_STRING + i + "-value", BAD_OBJECT);
                    if (object2 == BAD_OBJECT) {
                        return map;
                    }
                    map3.put(object, object2);
                }
                return map3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMap(String string, Map map) {
            PrimitiveRegister primitiveRegister = this.impl;
            synchronized (primitiveRegister) {
                if (map == null) {
                    this.impl.setProperty(string, null);
                } else {
                    this.impl.setProperty(string, "# " + map.getClass().getName());
                    Properties properties = this.getProperties(string);
                    Iterator iterator = map.keySet().iterator();
                    int n = 0;
                    properties.setInt("length", map.size());
                    while (iterator.hasNext()) {
                        Object k = iterator.next();
                        properties.setObject(BAD_STRING + n + "-key", k);
                        properties.setObject(BAD_STRING + n + "-value", map.get(k));
                        ++n;
                    }
                }
            }
            this.pcs.firePropertyChange(string, null, map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Properties getProperties(String string) {
            Map<String, Reference<Properties>> map = this.childProperties;
            synchronized (map) {
                Properties properties;
                Reference<Properties> reference = this.childProperties.get(string);
                if (reference != null && (properties = reference.get()) != null) {
                    return properties;
                }
                properties = new DelegatingProperties(this, string);
                reference = new WeakReference<Properties>(properties);
                this.childProperties.put(string, reference);
                return properties;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
            Map<PropertyChangeListener, Properties> map = this.propertiesHeldByListener;
            synchronized (map) {
                this.propertiesHeldByListener.put(propertyChangeListener, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
            Map<PropertyChangeListener, Properties> map = this.propertiesHeldByListener;
            synchronized (map) {
                this.propertiesHeldByListener.remove(propertyChangeListener);
            }
        }

        private static ClassLoader getClassLoader() {
            if (classLoader == null) {
                classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            }
            return classLoader;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class InitializerHolder
        extends ServicesHolder<Initializer> {
            public InitializerHolder() {
                super(Initializer.class);
            }

            @Override
            protected void registerService(Initializer initializer) {
                String[] stringArray = initializer.getSupportedPropertyNames();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    this.register.put(stringArray[i], initializer);
                }
            }

            @Override
            protected void unregisterService(Initializer initializer) {
                String[] stringArray = initializer.getSupportedPropertyNames();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    this.register.remove(stringArray[i]);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class ReaderHolder
        extends ServicesHolder<Reader> {
            public ReaderHolder() {
                super(Reader.class);
            }

            @Override
            protected void registerService(Reader reader) {
                String[] stringArray = reader.getSupportedClassNames();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    this.register.put(stringArray[i], reader);
                }
            }

            @Override
            protected void unregisterService(Reader reader) {
                String[] stringArray = reader.getSupportedClassNames();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    this.register.remove(stringArray[i]);
                }
            }

            @Override
            public synchronized Reader find(String string) {
                Reader reader = (Reader)super.find(string);
                if (reader != null) {
                    return reader;
                }
                Class<?> clazz = null;
                try {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager.getDefault().notify((Throwable)classNotFoundException);
                    return null;
                }
                for (clazz = PropertiesImpl.getClassLoader().loadClass(string); clazz != null && this.register.get(clazz.getName()) == null; clazz = clazz.getSuperclass()) {
                }
                if (clazz != null) {
                    reader = (Reader)this.register.get(clazz.getName());
                }
                return reader;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static abstract class ServicesHolder<T> {
            private Class<T> clazz;
            private List<? extends T> servicesList;
            protected HashMap<String, T> register;

            public ServicesHolder(Class<T> clazz) {
                this.clazz = clazz;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void init() {
                this.register = new HashMap();
                final List<T> list = DebuggerManager.getDebuggerManager().lookup(null, this.clazz);
                this.servicesList = list;
                List<T> list2 = list;
                synchronized (list2) {
                    for (T t : list) {
                        this.registerService(t);
                    }
                }
                ((Customizer)((Object)list)).addPropertyChangeListener(new PropertyChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        ServicesHolder servicesHolder = ServicesHolder.this;
                        synchronized (servicesHolder) {
                            HashSet hashSet = new HashSet(ServicesHolder.this.register.values());
                            List list2 = list;
                            synchronized (list2) {
                                for (Object e : list) {
                                    if (hashSet.remove(e)) continue;
                                    ServicesHolder.this.registerService(e);
                                }
                            }
                            for (Iterator iterator : hashSet) {
                                ServicesHolder.this.unregisterService(iterator);
                            }
                        }
                    }
                });
                ((Customizer)((Object)list)).setObject("load first");
                ((Customizer)((Object)list)).setObject("unload last");
            }

            protected abstract void registerService(T var1);

            protected abstract void unregisterService(T var1);

            public synchronized T find(String string) {
                if (this.register == null) {
                    this.init();
                }
                return this.register.get(string);
            }
        }
    }

    private static final class PrimitiveRegister {
        private HashMap properties = new HashMap();
        private boolean isInitialized = false;
        private RequestProcessor.Task task;

        private PrimitiveRegister() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getProperty(String string, String string2) {
            PrimitiveRegister primitiveRegister = this;
            synchronized (primitiveRegister) {
                String string3;
                if (!this.isInitialized) {
                    this.load();
                    this.isInitialized = true;
                }
                if ((string3 = (String)this.properties.get(string)) != null) {
                    return string3;
                }
            }
            return string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setProperty(String string, String string2) {
            PrimitiveRegister primitiveRegister = this;
            synchronized (primitiveRegister) {
                if (!this.isInitialized) {
                    this.load();
                    this.isInitialized = true;
                }
                this.properties.put(string, string2);
            }
            this.save();
        }

        private synchronized void load() {
            BufferedReader bufferedReader = null;
            try {
                FileObject fileObject = PrimitiveRegister.findSettings();
                InputStream inputStream = fileObject.getInputStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                while (string != null) {
                    int n = string.indexOf(58);
                    if (n > 0) {
                        String string2 = string.substring(n + 1);
                        string2 = PrimitiveRegister.translateSingleLineStringToMultiLine(string2);
                        this.properties.put(string.substring(0, n), string2);
                    }
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }

        private synchronized void save() {
            if (this.task == null) {
                this.task = new RequestProcessor("Debugger Properties Save RP", 1).create(new Runnable(){

                    public void run() {
                        PrimitiveRegister.this.saveIn();
                    }
                });
            }
            this.task.schedule(1000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void saveIn() {
            PrintWriter printWriter = null;
            FileLock fileLock = null;
            try {
                FileObject fileObject = PrimitiveRegister.findSettings();
                fileLock = fileObject.lock();
                OutputStream outputStream = fileObject.getOutputStream(fileLock);
                printWriter = new PrintWriter(outputStream);
                Set set = this.properties.keySet();
                ArrayList arrayList = new ArrayList(set);
                Collections.sort(arrayList);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    String string = (String)arrayList.get(i);
                    Object object = this.properties.get(string);
                    if (object == null) continue;
                    object = PrimitiveRegister.translateMultiLineStringToSingleLine(object.toString());
                    printWriter.println("" + string + ":" + object);
                }
                printWriter.flush();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)iOException, "Can not save debugger settings."));
            }
            finally {
                try {
                    if (printWriter != null) {
                        printWriter.close();
                    }
                }
                finally {
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        }

        private static String translateMultiLineStringToSingleLine(String string) {
            StringBuilder stringBuilder = null;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\n' || c == 'n' && i > 0 && string.charAt(i - 1) == '\\') {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string.substring(0, i));
                    }
                    stringBuilder.append("\\n");
                    continue;
                }
                if (stringBuilder == null) continue;
                stringBuilder.append(c);
            }
            if (stringBuilder == null) {
                return string;
            }
            return stringBuilder.toString();
        }

        private static String translateSingleLineStringToMultiLine(String string) {
            StringBuilder stringBuilder = null;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == 'n' && i > 0 && string.charAt(i - 1) == '\\') {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string.substring(0, i - 1));
                    } else {
                        int n = stringBuilder.length();
                        stringBuilder.delete(n - 1, n);
                    }
                    if (i > 1 && string.charAt(i - 2) == '\\') {
                        stringBuilder.append("n");
                        continue;
                    }
                    stringBuilder.append("\n");
                    continue;
                }
                if (stringBuilder == null) continue;
                stringBuilder.append(c);
            }
            if (stringBuilder == null) {
                return string;
            }
            return stringBuilder.toString();
        }

        private static FileObject findSettings() throws IOException {
            FileObject fileObject;
            FileObject fileObject2 = FileUtil.getConfigFile((String)"Services");
            if (fileObject2 == null) {
                fileObject2 = FileUtil.getConfigRoot().createFolder("Services");
            }
            if ((fileObject = fileObject2.getFileObject("org-netbeans-modules-debugger-Settings", "properties")) == null) {
                fileObject = fileObject2.createData("org-netbeans-modules-debugger-Settings", "properties");
            }
            return fileObject;
        }
    }

    public static interface Initializer {
        public String[] getSupportedPropertyNames();

        public Object getDefaultPropertyValue(String var1);
    }

    public static interface Reader {
        public String[] getSupportedClassNames();

        public Object read(String var1, Properties var2);

        public void write(Object var1, Properties var2);
    }
}

