/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreateMethodFix
implements Fix {
    private FileObject targetFile;
    private ElementHandle<TypeElement> target;
    private TypeMirrorHandle returnType;
    private List<TypeMirrorHandle> argumentTypes;
    private List<String> argumentNames;
    private ClasspathInfo cpInfo;
    private Set<Modifier> modifiers;
    private String name;
    private String inFQN;
    private String methodDisplayName;

    public CreateMethodFix(CompilationInfo compilationInfo, String string, Set<Modifier> set, TypeElement typeElement, TypeMirror typeMirror, List<? extends TypeMirror> list, List<String> list2, FileObject fileObject) {
        Object object;
        this.name = string;
        Name name = typeElement.getQualifiedName();
        if (name == null) {
            this.inFQN = "";
            Logger.getLogger(CreateMethodFix.class.getName()).warning("Target qualified name could not be resolved.");
        } else {
            object = name.toString();
            if (((String)object).length() == 0) {
                object = ((Object)typeElement.asType()).toString();
            }
            this.inFQN = object;
        }
        this.cpInfo = compilationInfo.getClasspathInfo();
        this.modifiers = set;
        this.targetFile = fileObject;
        this.target = ElementHandle.create((Element)typeElement);
        if (typeMirror != null && typeMirror.getKind() == TypeKind.NULL) {
            typeMirror = compilationInfo.getElements().getTypeElement("java.lang.Object").asType();
        }
        this.returnType = typeMirror != null ? TypeMirrorHandle.create((TypeMirror)typeMirror) : null;
        this.argumentTypes = new ArrayList<TypeMirrorHandle>();
        for (TypeMirror typeMirror2 : list) {
            this.argumentTypes.add(TypeMirrorHandle.create((TypeMirror)typeMirror2));
        }
        this.argumentNames = list2;
        object = new StringBuilder();
        if (typeMirror != null) {
            ((StringBuilder)object).append(string);
        } else {
            ((StringBuilder)object).append(typeElement.getSimpleName().toString());
        }
        ((StringBuilder)object).append('(');
        boolean bl = true;
        for (TypeMirror typeMirror2 : list) {
            boolean bl2;
            if (!bl2) {
                ((StringBuilder)object).append(',');
            }
            bl2 = false;
            ((StringBuilder)object).append(org.netbeans.modules.editor.java.Utilities.getTypeName((TypeMirror)typeMirror2, (boolean)true));
        }
        ((StringBuilder)object).append(')');
        this.methodDisplayName = ((StringBuilder)object).toString();
    }

    public String getText() {
        if (this.target.getKind() == ElementKind.ANNOTATION_TYPE) {
            return NbBundle.getMessage(CreateMethodFix.class, (String)"LBL_FIX_Create_Annotation_Element", (Object)this.methodDisplayName, (Object)this.inFQN);
        }
        if (this.returnType != null) {
            return NbBundle.getMessage(CreateMethodFix.class, (String)"LBL_FIX_Create_Method", (Object)this.methodDisplayName, (Object)this.inFQN);
        }
        return NbBundle.getMessage(CreateMethodFix.class, (String)"LBL_FIX_Create_Constructor", (Object)this.methodDisplayName, (Object)this.inFQN);
    }

    public ChangeInfo implement() throws IOException {
        JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[]{this.targetFile});
        ModificationResult modificationResult = javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                Object object;
                TypeMirrorHandle typeMirrorHandle;
                TypeMirror typeMirror;
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement typeElement = (TypeElement)CreateMethodFix.this.target.resolve((CompilationInfo)workingCopy);
                if (typeElement == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target.");
                    return;
                }
                TreePath treePath = workingCopy.getTrees().getPath(typeElement);
                if (treePath == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target tree: " + typeElement.getQualifiedName() + ".");
                    return;
                }
                TypeMirrorHandle typeMirrorHandle2 = CreateMethodFix.this.returnType;
                TypeMirror typeMirror2 = typeMirror = typeMirrorHandle2 != null ? typeMirrorHandle2.resolve((CompilationInfo)workingCopy) : null;
                if (typeMirrorHandle2 != null && typeMirror == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve proposed type.");
                    return;
                }
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
                Iterator iterator = CreateMethodFix.this.argumentTypes.iterator();
                Iterator iterator2 = CreateMethodFix.this.argumentNames.iterator();
                while (iterator.hasNext() && iterator2.hasNext()) {
                    typeMirrorHandle = (TypeMirrorHandle)iterator.next();
                    object = (String)iterator2.next();
                    arrayList.add(treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)object, treeMaker.Type(typeMirrorHandle.resolve((CompilationInfo)workingCopy)), null));
                }
                Object object2 = typeMirrorHandle = typeElement.getKind().isClass() ? CreateMethodFix.createDefaultMethodBody(workingCopy, typeMirror) : null;
                if (typeMirrorHandle != null && !typeMirrorHandle.getStatements().isEmpty()) {
                    workingCopy.tag((Tree)typeMirrorHandle.getStatements().get(0), (Object)"mbody");
                }
                object = treeMaker.Method(treeMaker.Modifiers(CreateMethodFix.this.modifiers), (CharSequence)CreateMethodFix.this.name, typeMirror != null ? treeMaker.Type(typeMirror) : null, Collections.emptyList(), arrayList, Collections.emptyList(), (BlockTree)typeMirrorHandle, null);
                ClassTree classTree = GeneratorUtilities.get((WorkingCopy)workingCopy).insertClassMember((ClassTree)treePath.getLeaf(), (Tree)object);
                workingCopy.rewrite(treePath.getLeaf(), (Tree)classTree);
            }
        });
        return Utilities.commitAndComputeChangeInfo(this.targetFile, modificationResult, "mbody");
    }

    private void addArguments(CompilationInfo compilationInfo, StringBuilder stringBuilder) {
        stringBuilder.append("(");
        Iterator<TypeMirrorHandle> iterator = this.argumentTypes.iterator();
        Iterator<String> iterator2 = this.argumentNames.iterator();
        boolean bl = true;
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            TypeMirrorHandle typeMirrorHandle = iterator.next();
            String string = iterator2.next();
            stringBuilder.append(org.netbeans.modules.editor.java.Utilities.getTypeName((TypeMirror)typeMirrorHandle.resolve(compilationInfo), (boolean)true));
            stringBuilder.append(' ');
            stringBuilder.append(string);
        }
        stringBuilder.append(")");
    }

    public String toDebugString(CompilationInfo compilationInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.returnType != null) {
            stringBuilder.append("CreateMethodFix:");
            stringBuilder.append(this.name);
            this.addArguments(compilationInfo, stringBuilder);
            stringBuilder.append(org.netbeans.modules.editor.java.Utilities.getTypeName((TypeMirror)this.returnType.resolve(compilationInfo), (boolean)true));
        } else {
            stringBuilder.append("CreateConstructorFix:");
            this.addArguments(compilationInfo, stringBuilder);
        }
        stringBuilder.append(':');
        stringBuilder.append(this.inFQN);
        return stringBuilder.toString();
    }

    private static BlockTree createDefaultMethodBody(WorkingCopy workingCopy, TypeMirror typeMirror) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ArrayList<ThrowTree> arrayList = new ArrayList<ThrowTree>();
        TypeElement typeElement = workingCopy.getElements().getTypeElement("java.lang.UnsupportedOperationException");
        if (typeElement != null) {
            NewClassTree newClassTree = treeMaker.NewClass(null, Collections.emptyList(), treeMaker.QualIdent((Element)typeElement), Collections.singletonList(treeMaker.Literal((Object)"Not yet implemented")), null);
            arrayList.add(treeMaker.Throw((ExpressionTree)newClassTree));
        }
        return treeMaker.Block(arrayList, false);
    }
}

