/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionRemove
extends AbstractHint {
    private final AtomicBoolean cancel = new AtomicBoolean();
    private static final Pattern SPLIT = Pattern.compile("(.+)\\.([^.]+)\\((.*)\\)");
    private static final Iterable<MappingDefinition> MAPPINGS = Arrays.asList(new MappingDefinition("java.util.Collection.remove(java.lang.Object)", "java.util.Collection.add(java.lang.Object)", 0, 0), new MappingDefinition("java.util.Collection.contains(java.lang.Object)", "java.util.Collection.add(java.lang.Object)", 0, 0), new MappingDefinition("java.util.Map.containsKey(java.lang.Object)", "java.util.Map.put(java.lang.Object, java.lang.Object)", 0, 0), new MappingDefinition("java.util.Map.get(java.lang.Object)", "java.util.Map.put(java.lang.Object, java.lang.Object)", 0, 0), new MappingDefinition("java.util.Map.remove(java.lang.Object)", "java.util.Map.put(java.lang.Object, java.lang.Object)", 0, 0), new MappingDefinition("java.util.Map.containsValue(java.lang.Object)", "java.util.Map.put(java.lang.Object, java.lang.Object)", 0, 1));
    private static final Map<String, Collection<MappingDefinition>> CHECKED_METHODS_MAP = new HashMap<String, Collection<MappingDefinition>>();

    public CollectionRemove() {
        super(true, true, AbstractHint.HintSeverity.WARNING, "collection-remove");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(CollectionRemove.class, (String)"DESC_CollectionRemove");
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        this.cancel.set(false);
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)treePath.getLeaf();
        ExpressionTree expressionTree = methodInvocationTree.getMethodSelect();
        TreePath treePath2 = new TreePath(treePath, expressionTree);
        Element element = compilationInfo.getTrees().getElement(treePath2);
        if (element == null || element.getKind() != ElementKind.METHOD) {
            return null;
        }
        String string = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        Collection<MappingDefinition> collection = CHECKED_METHODS_MAP.get(string);
        if (collection == null) {
            return null;
        }
        LinkedList<ErrorDescription> linkedList = new LinkedList<ErrorDescription>();
        for (MappingDefinition mappingDefinition : collection) {
            Object object;
            DeclaredType declaredType;
            ExecutableElement executableElement2;
            if (this.cancel.get()) {
                return null;
            }
            ExecutableElement executableElement3 = CollectionRemove.resolveMethod(compilationInfo, mappingDefinition.checkMethod);
            if (executableElement3 == null || executableElement != executableElement3 && !compilationInfo.getElements().overrides(executableElement, executableElement3, typeElement) || (executableElement2 = CollectionRemove.resolveMethod(compilationInfo, mappingDefinition.checkAgainstMethod)) == null) continue;
            block0 : switch (expressionTree.getKind()) {
                case MEMBER_SELECT: {
                    declaredType = (DeclaredType)compilationInfo.getTrees().getTypeMirror(new TreePath(treePath2, ((MemberSelectTree)expressionTree).getExpression()));
                    break;
                }
                case IDENTIFIER: {
                    for (object = compilationInfo.getTrees().getScope(treePath); object != null; object = object.getEnclosingScope()) {
                        for (ExecutableElement executableElement4 : ElementFilter.methodsIn(compilationInfo.getElements().getAllMembers(object.getEnclosingClass()))) {
                            if (executableElement4 != executableElement2 && !compilationInfo.getElements().overrides(executableElement4, executableElement2, typeElement)) continue;
                            declaredType = (DeclaredType)object.getEnclosingClass().asType();
                            break block0;
                        }
                    }
                    declaredType = null;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (declaredType == null) continue;
            object = (ExecutableType)compilationInfo.getTypes().asMemberOf(declaredType, executableElement2);
            for (Map.Entry entry : mappingDefinition.parametersMapping.entrySet()) {
                TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, methodInvocationTree.getArguments().get((Integer)entry.getKey())));
                TypeMirror typeMirror2 = object.getParameterTypes().get((Integer)entry.getValue());
                if (typeMirror2.getKind() == TypeKind.WILDCARD && (typeMirror2 = ((WildcardType)typeMirror2).getExtendsBound()) == null) {
                    typeMirror2 = compilationInfo.getElements().getTypeElement("java.lang.Object").asType();
                }
                if (compilationInfo.getTypes().isAssignable(typeMirror, typeMirror2)) continue;
                String string2 = CollectionRemove.compatibleTypes(compilationInfo, typeMirror, typeMirror2) ? "HINT_SuspiciousCall" : "HINT_SuspiciousCallIncompatibleTypes";
                String string3 = mappingDefinition.checkMethod.substring(0, mappingDefinition.checkMethod.indexOf(40));
                String string4 = NbBundle.getMessage(CollectionRemove.class, (String)string2, (Object)string3, (Object)Utilities.getTypeName((TypeMirror)typeMirror, (boolean)false), (Object)Utilities.getTypeName((TypeMirror)typeMirror2, (boolean)false));
                int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), methodInvocationTree);
                int n2 = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), methodInvocationTree);
                linkedList.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)string4, (FileObject)compilationInfo.getFileObject(), (int)n, (int)n2));
            }
        }
        return linkedList;
    }

    private static boolean compatibleTypes(CompilationInfo compilationInfo, TypeMirror typeMirror, TypeMirror typeMirror2) {
        typeMirror = compilationInfo.getTypes().erasure(typeMirror);
        typeMirror2 = compilationInfo.getTypes().erasure(typeMirror2);
        return compilationInfo.getTypeUtilities().isCastable(typeMirror, typeMirror2);
    }

    private static ExecutableElement resolveMethod(CompilationInfo compilationInfo, String string) {
        Matcher matcher = SPLIT.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        TypeElement typeElement = compilationInfo.getElements().getTypeElement(string2);
        if (typeElement == null) {
            return null;
        }
        String[] stringArray = string4.split(",");
        LinkedList<TypeMirror> linkedList = new LinkedList<TypeMirror>();
        TypeElement typeElement2 = (TypeElement)compilationInfo.getTopLevelElements().get(0);
        for (String string5 : stringArray) {
            linkedList.add(compilationInfo.getTreeUtilities().parseType(string5, typeElement2));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!string3.equals(executableElement.getSimpleName().toString()) || executableElement.getParameters().size() != linkedList.size()) continue;
            Iterator iterator = linkedList.iterator();
            boolean bl = true;
            for (VariableElement variableElement : executableElement.getParameters()) {
                if (compilationInfo.getTypes().isSameType(compilationInfo.getTypes().erasure(variableElement.asType()), (TypeMirror)iterator.next())) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return executableElement;
        }
        return null;
    }

    @Override
    public String getId() {
        return CollectionRemove.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(CollectionRemove.class, (String)"DN_CollectionRemove");
    }

    @Override
    public void cancel() {
        this.cancel.set(true);
    }

    static {
        for (MappingDefinition mappingDefinition : MAPPINGS) {
            Matcher matcher = SPLIT.matcher(mappingDefinition.checkMethod);
            if (!matcher.matches()) {
                throw new IllegalArgumentException();
            }
            String string = matcher.group(2);
            Collection<MappingDefinition> collection = CHECKED_METHODS_MAP.get(string);
            if (collection == null) {
                collection = new LinkedList<MappingDefinition>();
                CHECKED_METHODS_MAP.put(string, collection);
            }
            collection.add(mappingDefinition);
        }
    }

    private static final class MappingDefinition {
        private final String checkMethod;
        private final String checkAgainstMethod;
        private final Map<Integer, Integer> parametersMapping;

        public MappingDefinition(String string, String string2, int ... nArray) {
            this.checkMethod = string;
            this.checkAgainstMethod = string2;
            assert (nArray.length % 2 == 0);
            this.parametersMapping = new HashMap<Integer, Integer>();
            for (int i = 0; i < nArray.length; i += 2) {
                this.parametersMapping.put(nArray[i], nArray[i + 1]);
            }
        }
    }
}

