/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.fake.modules;

import java.util.Collection;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.web.fake.modules.FindComponentModules;
import org.netbeans.modules.web.fake.modules.ProgressMonitor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulesActivator {
    private Collection<UpdateElement> modules4enable;
    private RequestProcessor.Task enableTask = null;
    private OperationContainer<OperationSupport> enableContainer;
    private ProgressHandle enableHandle;
    private final ProgressMonitor progressMonitor;
    private Runnable doEnable = new Runnable(){

        public void run() {
            ModulesActivator.this.enableModules();
        }
    };

    public ModulesActivator(Collection<UpdateElement> collection, ProgressMonitor progressMonitor) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("Cannot construct ModulesActivator with null or empty Collection " + collection);
        }
        this.modules4enable = collection;
        this.progressMonitor = progressMonitor != null ? progressMonitor : ProgressMonitor.DEV_NULL_PROGRESS_MONITOR;
    }

    public RequestProcessor.Task getEnableTask() {
        if (this.enableTask == null) {
            this.enableTask = this.createEnableTask();
        }
        return this.enableTask;
    }

    private RequestProcessor.Task createEnableTask() {
        assert (this.enableTask == null || this.enableTask.isFinished()) : "The Enable Task cannot be started nor scheduled.";
        this.enableTask = RequestProcessor.getDefault().create(this.doEnable);
        return this.enableTask;
    }

    private void enableModules() {
        try {
            this.doEnableModules();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    private void doEnableModules() throws OperationException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot be called in EQ.";
        this.enableContainer = null;
        for (UpdateElement updateElement : this.modules4enable) {
            if (this.enableContainer == null) {
                this.enableContainer = OperationContainer.createForEnable();
            }
            if (!this.enableContainer.canBeAdded(updateElement.getUpdateUnit(), updateElement)) continue;
            this.enableContainer.add(updateElement);
        }
        if (this.enableContainer.listAll().isEmpty()) {
            return;
        }
        assert (this.enableContainer.listInvalid().isEmpty()) : "No invalid Update Elements " + this.enableContainer.listInvalid();
        if (!this.enableContainer.listInvalid().isEmpty()) {
            throw new IllegalArgumentException("Some are invalid for enable: " + this.enableContainer.listInvalid());
        }
        OperationSupport operationSupport = (OperationSupport)this.enableContainer.getSupport();
        if (this.enableHandle == null) {
            this.enableHandle = ProgressHandleFactory.createHandle((String)ModulesActivator.getBundle("ModulesActivator_Enable", ModulesActivator.presentUpdateElements(FindComponentModules.getVisibleUpdateElements(this.modules4enable))));
        }
        this.progressMonitor.onEnable(this.enableHandle);
        operationSupport.doOperation(this.enableHandle);
    }

    public static String presentUpdateElements(Collection<UpdateElement> collection) {
        String string = "";
        for (UpdateElement updateElement : new LinkedList<UpdateElement>(collection)) {
            string = string + (string.length() == 0 ? updateElement.getDisplayName() : ", " + updateElement.getDisplayName());
        }
        return string;
    }

    private static String getBundle(String string, Object ... objectArray) {
        return NbBundle.getMessage(ModulesActivator.class, (String)string, (Object[])objectArray);
    }
}

