/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.fake.frameworks;

import java.io.File;
import java.util.Map;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.fake.frameworks.FakeWebModuleExtender;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FakeWebFrameworkProvider {
    private FakeWebFrameworkProvider() {
    }

    public static WebFrameworkProvider create(Map<Object, Object> map) {
        String string = (String)map.get("name");
        String string2 = (String)map.get("codeNameBase");
        String string3 = (String)map.get("frameworkProviderClassName");
        assert (string != null);
        assert (string2 != null);
        assert (string3 != null);
        boolean bl = false;
        for (ModuleInfo moduleInfo : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            if (!string2.equals(moduleInfo.getCodeNameBase())) continue;
            if (moduleInfo.isEnabled()) {
                return null;
            }
            bl = true;
            break;
        }
        return new FakeWebFrameworkProviderImpl(string, string2, string3, bl);
    }

    static final class FakeWebFrameworkProviderImpl
    extends WebFrameworkProvider {
        private final String name;
        private final String codeNameBase;
        private final String frameworkProviderClassName;
        private final boolean modulePresent;
        private volatile WebFrameworkProvider delegate;

        FakeWebFrameworkProviderImpl(String string, String string2, String string3, boolean bl) {
            super(string, null);
            assert (string != null);
            assert (string2 != null);
            assert (string3 != null);
            this.name = string;
            this.codeNameBase = string2;
            this.frameworkProviderClassName = string3;
            this.modulePresent = bl;
        }

        public WebModuleExtender createWebModuleExtender(WebModule webModule, ExtenderController extenderController) {
            if (this.delegate != null) {
                return this.delegate.createWebModuleExtender(webModule, extenderController);
            }
            return new FakeWebModuleExtender(this, this.name, this.codeNameBase, webModule, extenderController);
        }

        public String getName() {
            if (this.delegate != null) {
                return this.delegate.getName();
            }
            return this.name;
        }

        public String getFrameworkProviderClassName() {
            return this.frameworkProviderClassName;
        }

        public boolean isInWebModule(WebModule webModule) {
            if (this.delegate != null) {
                return this.delegate.isInWebModule(webModule);
            }
            return false;
        }

        public File[] getConfigurationFiles(WebModule webModule) {
            if (this.delegate != null) {
                return this.delegate.getConfigurationFiles(webModule);
            }
            return new File[0];
        }

        public WebFrameworkProvider getDelegate() {
            return this.delegate;
        }

        public void setDelegate(WebFrameworkProvider webFrameworkProvider) {
            assert (webFrameworkProvider != null);
            this.delegate = webFrameworkProvider;
        }

        public boolean isModulePresent() {
            return this.modulePresent;
        }
    }
}

