/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rubyforge.debugcommons.model.Message;
import org.rubyforge.debugcommons.model.RubyDebugTarget;
import org.rubyforge.debugcommons.reader.VariablesReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(-\\S+)?");
    private static final Logger LOGGER = Logger.getLogger(Util.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Cannot close socket.", e);
                }
            }
        }
        return -1;
    }

    public static boolean isRunning(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException ex) {
            return true;
        }
    }

    public static int compareVersions(String version1, String version2) {
        if (version1.equals(version2)) {
            return 0;
        }
        Matcher matcher1 = VERSION_PATTERN.matcher(version1);
        if (matcher1.matches()) {
            int major1 = Integer.parseInt(matcher1.group(1));
            int minor1 = Integer.parseInt(matcher1.group(2));
            int micro1 = Integer.parseInt(matcher1.group(3));
            Matcher matcher2 = VERSION_PATTERN.matcher(version2);
            if (matcher2.matches()) {
                int major2 = Integer.parseInt(matcher2.group(1));
                int minor2 = Integer.parseInt(matcher2.group(2));
                int micro2 = Integer.parseInt(matcher2.group(3));
                if (major1 != major2) {
                    return major1 - major2;
                }
                if (minor1 != minor2) {
                    return minor1 - minor2;
                }
                if (micro1 != micro2) {
                    return micro1 - micro2;
                }
            }
        }
        return version1.compareTo(version2);
    }

    static String getProcessAsString(List<? extends String> process) {
        StringBuilder sb = new StringBuilder();
        for (String string : process) {
            sb.append(string).append(' ');
        }
        return sb.toString().trim();
    }

    public static String dumpAndDestroyProcess(RubyDebugTarget target) {
        StringBuilder info = new StringBuilder();
        if (target.isRemote()) {
            info.append("Remote process");
        } else {
            boolean running = target.isRunning();
            if (running) {
                info.append("Dumping and destroying process, when the debuggee process is running. You might try to increase the timeout. Killing...\n\n");
            }
            Process process = target.getProcess();
            info.append(Util.dumpStream(process.getInputStream(), Level.INFO, "Standard Output: ", running));
            info.append(Util.dumpStream(process.getErrorStream(), Level.SEVERE, "Error Output: ", running));
            if (running) {
                process.destroy();
            }
        }
        return info.toString();
    }

    private static String dumpStream(final InputStream stream, Level level, String msgPrefix, boolean asynch) {
        final StringBuilder output = new StringBuilder();
        if (asynch) {
            Thread collector = new Thread(new Runnable(){

                public void run() {
                    Util.collect(stream, output);
                }
            });
            collector.start();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
            collector.interrupt();
        } else {
            Util.collect(stream, output);
        }
        if (output.length() > 0) {
            LOGGER.log(level, msgPrefix);
            String outputS = output.toString();
            LOGGER.log(level, outputS);
            return msgPrefix + '\n' + outputS;
        }
        return "";
    }

    private static void collect(InputStream stream, StringBuilder output) {
        try {
            int c;
            while ((c = stream.read()) != -1) {
                output.append((char)c);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
        }
    }

    public static void logEvent(XmlPullParser xpp) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            try {
                int eventType = xpp.getEventType();
                if (eventType == 1) {
                    LOGGER.finest("Received: END_DOCUMENT event");
                    return;
                }
                if ("message".equals(xpp.getName())) {
                    return;
                }
                if (xpp.getName() == null) {
                    LOGGER.warning("Unexpected type: (" + Util.getType(xpp) + ") encountered in logEvent");
                    return;
                }
                StringBuilder toXml = new StringBuilder();
                if (eventType == 4) {
                    return;
                }
                toXml.append("<");
                if (eventType == 3) {
                    toXml.append('/');
                }
                toXml.append(xpp.getName());
                for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                    toXml.append(' ').append(xpp.getAttributeName(i)).append("='").append(xpp.getAttributeValue(i)).append("'");
                }
                toXml.append('>');
                LOGGER.finest("Received: " + toXml.toString());
            }
            catch (XmlPullParserException ex) {
                LOGGER.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
        }
    }

    public static void logMessage(Message message) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder messageXml = new StringBuilder("<message");
            if (message.isDebug()) {
                messageXml.append(" debug='true'");
            }
            messageXml.append('>');
            messageXml.append(message.getText());
            messageXml.append("</message>");
            LOGGER.finest("Received message: " + messageXml.toString());
        }
    }

    public static String getType(XmlPullParser xpp) {
        try {
            if (xpp.getEventType() == 3) {
                return "END_TAG";
            }
            if (xpp.getEventType() == 2) {
                return "START_TAG";
            }
            if (xpp.getEventType() == 4) {
                return "TEXT";
            }
            if (xpp.getEventType() == 0) {
                return "START_DOCUMENT";
            }
            if (xpp.getEventType() == 1) {
                return "END_DOCUMENT";
            }
            return "UNKNOWN: " + xpp.getEventType();
        }
        catch (XmlPullParserException e) {
            Logger.getLogger(VariablesReader.class.getName()).log(Level.SEVERE, null, e);
            return "<Unable to find a type>";
        }
    }

    public static boolean isEndTag(XmlPullParser xpp, String name) throws XmlPullParserException, IOException {
        return 3 == xpp.getEventType() && name.equals(xpp.getName());
    }
}

