/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.RubyDebugTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyDebuggerFactory {
    private static final Logger LOGGER = Logger.getLogger(RubyDebuggerFactory.class.getName());
    private static final String CLASSIC_DEBUG_NAME = "classic-debug.rb";
    private static final String CLASSIC_VERBOSE_DEBUG_NAME = "classic-debug-verbose.rb";
    private static final int DEFAULT_PORT = 1098;
    private static Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");

    public static RubyDebuggerProxy startClassicDebugger(Descriptor descriptor, String pathToClassicDebugDir, String interpreter, int timeout) throws IOException, RubyDebuggerException {
        descriptor.setType(RubyDebuggerProxy.CLASSIC_DEBUGGER);
        ArrayList<String> args = new ArrayList<String>();
        args.add(interpreter);
        if (descriptor.isJRuby()) {
            RubyDebuggerFactory.adjustForJRuby(args);
        }
        args.addAll(descriptor.getAddtionalOptions());
        args.add("-I");
        args.add(pathToClassicDebugDir);
        if (!descriptor.defaultPortUsed() && descriptor.getPort() != -1) {
            try {
                String path = RubyDebuggerFactory.createRemoteDebugPortFile(descriptor.getPort());
                args.add("-r");
                args.add(path);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Could not create 'RemoteDebugPortFile'. Using default port.", e);
            }
        }
        RubyDebuggerFactory.appendIOSynchronizer(args, descriptor);
        args.add("-r");
        args.add(descriptor.isVerbose() ? CLASSIC_VERBOSE_DEBUG_NAME : CLASSIC_DEBUG_NAME);
        args.add(descriptor.getDebuggeePath());
        if (descriptor.getScriptArguments() != null) {
            args.addAll(Arrays.asList(descriptor.getScriptArguments()));
        }
        return RubyDebuggerFactory.startDebugger(descriptor, args, timeout);
    }

    public static RubyDebuggerProxy startClassicDebugger(Descriptor descriptor, String pathToClassicDebugDir, String interpreter) throws IOException, RubyDebuggerException {
        return RubyDebuggerFactory.startClassicDebugger(descriptor, pathToClassicDebugDir, interpreter, 10);
    }

    public static RubyDebuggerProxy startRubyDebug(Descriptor descriptor, String rdebugExecutable, String interpreter, int timeout) throws IOException, RubyDebuggerException {
        descriptor.setType(RubyDebuggerProxy.RUBY_DEBUG);
        ArrayList<String> args = new ArrayList<String>();
        if (interpreter != null) {
            args.add(interpreter);
        }
        if (descriptor.isJRuby()) {
            RubyDebuggerFactory.adjustForJRuby(args);
        }
        args.addAll(descriptor.getAddtionalOptions());
        if (interpreter != null) {
            RubyDebuggerFactory.appendIOSynchronizer(args, descriptor);
        }
        args.add(rdebugExecutable);
        String version = descriptor.getRubyDebugIDEVersion();
        if (version != null) {
            args.add('_' + version + '_');
        }
        args.add("-p");
        args.add(String.valueOf(descriptor.getPort()));
        if (descriptor.isVerbose()) {
            args.add("--xml-debug");
        }
        args.add("--");
        args.add(descriptor.getDebuggeePath());
        if (descriptor.getScriptArguments() != null) {
            args.addAll(Arrays.asList(descriptor.getScriptArguments()));
        }
        return RubyDebuggerFactory.startDebugger(descriptor, args, timeout);
    }

    public static RubyDebuggerProxy startRubyDebug(Descriptor descriptor, List<String> args, String rdebugExecutable, int timeout) throws IOException, RubyDebuggerException {
        descriptor.setType(RubyDebuggerProxy.RUBY_DEBUG);
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("rdebug.path", rdebugExecutable);
        varMap.put("rdebug.port", Integer.toString(descriptor.getPort()));
        String version = descriptor.getRubyDebugIDEVersion();
        varMap.put("rdebug.version", version != null ? '_' + version + '_' : "");
        varMap.put("rdebug.iosynch", RubyDebuggerFactory.createIOSynchronizer());
        int size = args.size();
        for (int i = 0; i < size; ++i) {
            args.set(i, RubyDebuggerFactory.substitute(args.get(i), varMap));
        }
        return RubyDebuggerFactory.startDebugger(descriptor, args, timeout);
    }

    private static void adjustForJRuby(List<String> args) {
        args.add("-J-Djruby.reflection=true");
        args.add("-J-Djruby.compile.mode=OFF");
        args.add("-J-Djruby.debug.fullTrace=true");
    }

    private static RubyDebuggerProxy startDebugger(Descriptor desc, List<String> args, int timeout) throws IOException, RubyDebuggerException {
        LOGGER.fine("Running [basedir: " + desc.getBaseDirectory() + "]: \"" + Util.getProcessAsString(args) + "\"");
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.directory(desc.getBaseDirectory());
        if (desc.getEnvironment() != null) {
            pb.environment().putAll(desc.getEnvironment());
        }
        LOGGER.fine("Environment: " + pb.environment());
        RubyDebuggerProxy proxy = new RubyDebuggerProxy(desc.getType(), timeout);
        String rdebugIDEVer = desc.getRubyDebugIDEVersion();
        boolean suitableVersion = rdebugIDEVer == null || Util.compareVersions(rdebugIDEVer, "0.1.10") > 0;
        boolean supportsCondition = desc.getType() == RubyDebuggerProxy.RUBY_DEBUG && suitableVersion;
        proxy.setConditionSupport(supportsCondition);
        RubyDebugTarget target = new RubyDebugTarget(proxy, "localhost", desc.getPort(), pb.start(), desc.getDebuggeePath(), desc.getBaseDirectory());
        proxy.setDebugTarget(target);
        RubyDebuggerProxy.PROXIES.add(proxy);
        return proxy;
    }

    private static String createRemoteDebugPortFile(int port) throws IOException {
        File debugParameterFile = File.createTempFile("classic-debug", ".rb");
        debugParameterFile.deleteOnExit();
        FileWriter fWriter = new FileWriter(debugParameterFile);
        new PrintWriter(fWriter).println("$RemoteDebugPort=" + port);
        fWriter.close();
        return debugParameterFile.getCanonicalPath();
    }

    private static String createIOSynchronizer() throws IOException {
        File ioSynchronizer = File.createTempFile("io-synchronizer", ".rb");
        ioSynchronizer.deleteOnExit();
        FileWriter fWriter = new FileWriter(ioSynchronizer);
        PrintWriter pwWriter = new PrintWriter(fWriter);
        pwWriter.println("$stdout.sync=true");
        pwWriter.println("$stderr.sync=true");
        fWriter.close();
        return ioSynchronizer.getCanonicalPath();
    }

    private static void appendIOSynchronizer(List<? super String> args, Descriptor descriptor) throws IOException {
        if (descriptor.isSynchronizedOutput()) {
            String path = RubyDebuggerFactory.createIOSynchronizer();
            args.add("-r");
            args.add(path);
        }
    }

    static String substitute(String value, Map<String, String> varMap) {
        try {
            Matcher matcher = pattern.matcher(value);
            boolean result = matcher.find();
            if (result) {
                StringBuffer sb = new StringBuffer();
                do {
                    String key;
                    String replacement;
                    if ((replacement = varMap.get(key = matcher.group(1))) == null) {
                        replacement = System.getProperty(key);
                    }
                    replacement = replacement != null ? replacement.replace("\\", "\\\\").replace("$", "\\$") : "\\$\\{" + key + "\\}";
                    matcher.appendReplacement(sb, replacement);
                } while (result = matcher.find());
                matcher.appendTail(sb);
                value = sb.toString();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Descriptor {
        private int coputedPort = -1;
        private RubyDebuggerProxy.DebuggerType type;
        private boolean verbose;
        private boolean useDefaultPort;
        private String debuggeePath;
        private File baseDir;
        private String[] scriptArguments;
        private Map<? extends String, ? extends String> environment;
        private boolean synchronizedOutput;
        private Collection<? extends String> additionalOptions;
        private boolean jruby;
        private String rubyDebugIDEVersion;

        public RubyDebuggerProxy.DebuggerType getType() {
            return this.type;
        }

        public void setType(RubyDebuggerProxy.DebuggerType type) {
            this.type = type;
        }

        public boolean isVerbose() {
            return this.verbose || Level.FINEST.equals(Logger.getLogger("org.rubyforge.debugcommons").getLevel());
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public boolean defaultPortUsed() {
            return this.useDefaultPort;
        }

        public void useDefaultPort(boolean useDefaultPort) {
            this.useDefaultPort = useDefaultPort;
        }

        public String getDebuggeePath() {
            return this.debuggeePath;
        }

        public void setDebuggeePath(String debuggeePath) {
            this.debuggeePath = debuggeePath;
        }

        public void setBaseDirectory(File baseDir) {
            this.baseDir = baseDir;
        }

        public File getBaseDirectory() {
            return this.baseDir != null ? this.baseDir : new File(this.getDebuggeePath()).getParentFile();
        }

        public String[] getScriptArguments() {
            return this.scriptArguments;
        }

        public void setScriptArguments(String[] scriptArguments) {
            this.scriptArguments = scriptArguments;
        }

        public Map<? extends String, ? extends String> getEnvironment() {
            return this.environment;
        }

        public void setEnvironment(Map<? extends String, ? extends String> environment) {
            this.environment = environment;
        }

        public boolean isSynchronizedOutput() {
            return this.synchronizedOutput;
        }

        public void setSynchronizedOutput(boolean synchronizedOutput) {
            this.synchronizedOutput = synchronizedOutput;
        }

        public Collection<? extends String> getAddtionalOptions() {
            return this.additionalOptions == null ? Collections.emptySet() : this.additionalOptions;
        }

        public void setAdditionalOptions(Collection<? extends String> additionalOptions) {
            this.additionalOptions = additionalOptions;
        }

        int getPort() {
            if (this.coputedPort == -1) {
                this.coputedPort = this.defaultPortUsed() ? 1098 : Util.findFreePort();
            }
            return this.coputedPort;
        }

        public void setJRuby(boolean jruby) {
            this.jruby = jruby;
        }

        boolean isJRuby() {
            return this.jruby;
        }

        public void setRubyDebugIDEVersion(String rubyDebugIDEVersion) {
            this.rubyDebugIDEVersion = rubyDebugIDEVersion;
        }

        private String getRubyDebugIDEVersion() {
            return this.rubyDebugIDEVersion;
        }
    }
}

