/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.uid;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.repository.KeyHolder;
import org.netbeans.modules.cnd.modelimpl.repository.KeyObjectFactory;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KeyBasedUID<T>
implements CsmUID<T>,
KeyHolder,
SelfPersistent,
Comparable<CsmUID<T>> {
    private final Key key;

    protected KeyBasedUID(Key key) {
        assert (key != null);
        this.key = key;
    }

    public T getObject() {
        return RepositoryUtils.get(this);
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    public String toString() {
        String string = this.key.toString();
        return "KeyBasedUID on " + string;
    }

    public int hashCode() {
        int n = this.key.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        KeyBasedUID keyBasedUID = (KeyBasedUID)object;
        return this.key.equals(keyBasedUID.key);
    }

    public void write(DataOutput dataOutput) throws IOException {
        KeyObjectFactory.getDefaultFactory().writeKey(this.key, dataOutput);
    }

    KeyBasedUID(DataInput dataInput) throws IOException {
        this.key = KeyObjectFactory.getDefaultFactory().readKey(dataInput);
    }

    @Override
    public int compareTo(CsmUID<T> csmUID) {
        assert (csmUID != null);
        assert (csmUID instanceof KeyBasedUID);
        Comparable comparable = (Comparable)this.key;
        Comparable comparable2 = (Comparable)((KeyBasedUID)csmUID).key;
        return comparable.compareTo(comparable2);
    }
}

