/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.apt.debug.DebugUtils;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTSystemStorage;
import org.netbeans.modules.cnd.apt.support.StartEntry;
import org.netbeans.modules.cnd.modelimpl.csm.ClassEnumBase;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ClassifierContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeclarationContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeepReparsingUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.GraphContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.NativeProjectListenerImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParseFinishNotificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParseStatistics;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.PreprocessorStatePair;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProgressSupport;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectSettingsValidator;
import org.netbeans.modules.cnd.modelimpl.csm.core.SourceRootContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.Terminator;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTParseFileWalker;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTRestorePreprocStateWalker;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.DefaultCache;
import org.netbeans.modules.cnd.modelimpl.textcache.ProjectNameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.trace.TraceUtils;
import org.netbeans.modules.cnd.modelimpl.uid.LazyCsmCollection;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.netbeans.modules.cnd.utils.cache.TinyCharSequence;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectBase
implements CsmProject,
Persistent,
SelfPersistent,
CsmIdentifiable {
    private static final boolean TRACE_FILE = false;
    private CsmUID<CsmProject> uid = null;
    private volatile Status status;
    private Cancellable initializationTask;
    private final Object initializationTaskLock = new Object();
    private final Object waitParseLock = new Object();
    private final Object classifierReplaceLock = new Object();
    private ModelImpl model;
    private Unresolved unresolved;
    private CharSequence name;
    private CsmUID<CsmNamespace> globalNamespaceUID;
    private NamespaceImpl FAKE_GLOBAL_NAMESPACE;
    private Object platformProject;
    private volatile boolean disposing;
    private ReadWriteLock disposeLock = new ReentrantReadWriteLock();
    private CharSequence uniqueName = null;
    private Map<CharSequence, CsmUID<CsmNamespace>> namespaces = new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>();
    private Key classifierStorageKey;
    private APTSystemStorage sysAPTData = APTSystemStorage.getDefault();
    private final Object namespaceLock = new String("namespaceLock in Projectbase " + this.hashCode());
    private Key declarationsSorageKey;
    private Key fileContainerKey;
    private final Object fileContainerLock = new Object();
    private Key graphStorageKey;
    protected final SourceRootContainer projectRoots = new SourceRootContainer();
    private NativeProjectListenerImpl projectListener;
    private static final boolean TRACE_PP_STATE_OUT = DebugUtils.getBoolean((String)"cnd.dump.preproc.state", (boolean)false);
    private static final boolean REMEMBER_RESTORED = TraceFlags.CLEAN_MACROS_AFTER_PARSE && (DebugUtils.getBoolean((String)"cnd.remember.restored", (boolean)false) || TRACE_PP_STATE_OUT);
    public static final int GATHERING_MACROS = 0;
    public static final int GATHERING_TOKENS = 1;
    private static List<String> testRestoredFiles = null;
    private WeakReference<DeclarationContainer> weakDeclarationContainer = TraceFlags.USE_WEAK_MEMORY_CACHE ? new WeakReference<Object>(null) : null;
    private WeakReference<FileContainer> weakFileContainer = TraceFlags.USE_WEAK_MEMORY_CACHE ? new WeakReference<Object>(null) : null;
    private WeakReference<GraphContainer> weakGraphContainer = TraceFlags.USE_WEAK_MEMORY_CACHE ? new WeakReference<Object>(null) : null;
    private WeakReference<ClassifierContainer> weakClassifierContainer = TraceFlags.USE_WEAK_MEMORY_CACHE ? new WeakReference<Object>(null) : null;

    protected ProjectBase(ModelImpl modelImpl, Object object, String string) {
        RepositoryUtils.openUnit(ProjectBase.createProjectKey(object));
        this.setStatus(Status.Initial);
        this.name = ProjectNameCache.getManager().getString((CharSequence)string);
        this.init(modelImpl, object);
        this.initFields();
    }

    private void initFields() {
        NamespaceImpl namespaceImpl = new NamespaceImpl(this, false);
        assert (namespaceImpl != null);
        this.globalNamespaceUID = UIDCsmConverter.namespaceToUID(namespaceImpl);
        this.declarationsSorageKey = new DeclarationContainer(this).getKey();
        this.classifierStorageKey = new ClassifierContainer(this).getKey();
        this.fileContainerKey = new FileContainer(this).getKey();
        this.graphStorageKey = new GraphContainer(this).getKey();
        this.FAKE_GLOBAL_NAMESPACE = new NamespaceImpl(this, true);
    }

    private void init(ModelImpl modelImpl, Object object) {
        this.model = modelImpl;
        this.platformProject = object;
        RepositoryUtils.hang(this);
        if (TraceFlags.CLOSE_AFTER_PARSE) {
            Terminator.create(this);
        }
    }

    private boolean checkConsistency() {
        long l;
        long l2 = l = TraceFlags.TIMING ? System.currentTimeMillis() : 0L;
        if (this.getFileContainer() == FileContainer.empty()) {
            return false;
        }
        if (this.getDeclarationsSorage() == DeclarationContainer.empty()) {
            return false;
        }
        if (this.getGraph() == GraphContainer.empty()) {
            return false;
        }
        if (this.getGlobalNamespace() == this.FAKE_GLOBAL_NAMESPACE) {
            return false;
        }
        if (TraceFlags.TIMING) {
            System.err.printf("Consistency check took %d ms\n", System.currentTimeMillis() - l);
        }
        return true;
    }

    private void setStatus(Status status) {
        this.status = status;
    }

    protected static void cleanRepository(Object object, boolean bl) {
        Key key = ProjectBase.createProjectKey(object);
        RepositoryUtils.closeUnit(key, null, true);
    }

    private static Key createProjectKey(Object object) {
        return KeyUtilities.createProjectKey(((Object)ProjectBase.getUniqueName(object)).toString());
    }

    protected static ProjectBase readInstance(ModelImpl modelImpl, Object object, String string) {
        long l = 0L;
        if (TraceFlags.TIMING) {
            System.err.printf("Project %s: instantiating...\n", string);
            l = System.currentTimeMillis();
        }
        assert (TraceFlags.PERSISTENT_REPOSITORY);
        Key key = ProjectBase.createProjectKey(object);
        RepositoryUtils.openUnit(key);
        Persistent persistent = RepositoryUtils.get(key);
        if (persistent != null) {
            assert (persistent instanceof ProjectBase);
            ProjectBase projectBase = (ProjectBase)persistent;
            CharSequence charSequence = ProjectNameCache.getManager().getString((CharSequence)string);
            if (!projectBase.name.equals(charSequence)) {
                projectBase.setName(charSequence);
            }
            projectBase.init(modelImpl, object);
            if (TraceFlags.TIMING) {
                l = System.currentTimeMillis() - l;
                System.err.printf("Project %s: loaded. %d ms\n", string, l);
            }
            if (projectBase.checkConsistency()) {
                return projectBase;
            }
        }
        return null;
    }

    public final CsmNamespace getGlobalNamespace() {
        return this._getGlobalNamespace();
    }

    public final CharSequence getName() {
        return this.name;
    }

    protected final void setName(CharSequence charSequence) {
        this.name = charSequence;
    }

    public final CharSequence getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = ProjectBase.getUniqueName(this.getPlatformProject());
        }
        return this.uniqueName;
    }

    public static CharSequence getUniqueName(Object object) {
        String string;
        if (object instanceof NativeProject) {
            string = ((NativeProject)object).getProjectRoot() + 'N';
        } else if (object instanceof CharSequence) {
            string = ((Object)((CharSequence)object)).toString() + 'L';
        } else {
            if (object == null) {
                throw new IllegalArgumentException("Incorrect platform project: null");
            }
            throw new IllegalArgumentException("Incorrect platform project class: " + object.getClass());
        }
        return ProjectNameCache.getManager().getString((CharSequence)string);
    }

    public final Object getPlatformProject() {
        return this.platformProject;
    }

    protected final void setPlatformProject(Object object) {
        this.platformProject = object;
        this.uniqueName = null;
        this.uniqueName = this.getUniqueName();
    }

    public final CsmNamespace findNamespace(CharSequence charSequence, boolean bl) {
        CsmNamespace csmNamespace;
        block1: {
            CsmProject csmProject;
            csmNamespace = this.findNamespace(charSequence);
            if (csmNamespace != null || !bl) break block1;
            Iterator<CsmProject> iterator = this.getLibraries().iterator();
            while (iterator.hasNext() && (csmNamespace = (csmProject = iterator.next()).findNamespace(charSequence)) == null) {
            }
        }
        return csmNamespace;
    }

    public final CsmNamespace findNamespace(CharSequence charSequence) {
        NamespaceImpl namespaceImpl = this._getNamespace(charSequence);
        return namespaceImpl;
    }

    private static String getNestedNamespaceQualifiedName(CharSequence charSequence, NamespaceImpl namespaceImpl, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(charSequence);
        if (namespaceImpl != null) {
            if (charSequence.length() == 0 && bl) {
                stringBuilder.append(namespaceImpl.getNameForUnnamedElement());
            }
            if (!namespaceImpl.isGlobal()) {
                stringBuilder.insert(0, "::");
                stringBuilder.insert(0, namespaceImpl.getQualifiedName());
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NamespaceImpl findNamespaceCreateIfNeeded(NamespaceImpl namespaceImpl, CharSequence charSequence) {
        Object object = this.namespaceLock;
        synchronized (object) {
            String string = ProjectBase.getNestedNamespaceQualifiedName(charSequence, namespaceImpl, true);
            NamespaceImpl namespaceImpl2 = this._getNamespace(string);
            if (namespaceImpl2 == null) {
                namespaceImpl2 = new NamespaceImpl(this, namespaceImpl, ((Object)charSequence).toString(), string);
            }
            return namespaceImpl2;
        }
    }

    public final void registerNamespace(NamespaceImpl namespaceImpl) {
        this._registerNamespace(namespaceImpl);
    }

    public final void unregisterNamesace(NamespaceImpl namespaceImpl) {
        this._unregisterNamespace(namespaceImpl);
    }

    public final CsmClassifier findClassifier(CharSequence charSequence, boolean bl) {
        CsmClassifier csmClassifier;
        block1: {
            CsmProject csmProject;
            csmClassifier = this.findClassifier(charSequence);
            if (csmClassifier != null || !bl) break block1;
            Iterator<CsmProject> iterator = this.getLibraries().iterator();
            while (iterator.hasNext() && (csmClassifier = (csmProject = iterator.next()).findClassifier(charSequence)) == null) {
            }
        }
        return csmClassifier;
    }

    public final CsmClassifier findClassifier(CharSequence charSequence) {
        CsmClassifier csmClassifier = this.getClassifierSorage().getClassifier(charSequence);
        return csmClassifier;
    }

    public final Collection<CsmClassifier> findClassifiers(CharSequence charSequence) {
        CsmClassifier csmClassifier = this.getClassifierSorage().getClassifier(charSequence);
        ArrayList<CsmClassifier> arrayList = new ArrayList<CsmClassifier>();
        if (csmClassifier != null) {
            if (CsmKindUtilities.isBuiltIn((CsmObject)csmClassifier)) {
                return Collections.singletonList(csmClassifier);
            }
            CharSequence[] charSequenceArray = Utils.getAllClassifiersUniqueNames(csmClassifier.getUniqueName());
            ArrayList<CsmClassifier> arrayList2 = new ArrayList<CsmClassifier>(1);
            for (CharSequence charSequence2 : charSequenceArray) {
                Collection<CsmOffsetableDeclaration> collection;
                Collection<CsmOffsetableDeclaration> collection2 = collection = this.findDeclarations(charSequence2);
                for (CsmClassifier csmClassifier2 : collection2) {
                    if (ForwardClass.isForwardClass((CsmDeclaration)csmClassifier2)) {
                        arrayList2.add(csmClassifier2);
                        continue;
                    }
                    arrayList.add(csmClassifier2);
                }
            }
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public final CsmDeclaration findDeclaration(CharSequence charSequence) {
        return this.getDeclarationsSorage().getDeclaration(charSequence);
    }

    public final Collection<CsmOffsetableDeclaration> findDeclarations(CharSequence charSequence) {
        return this.getDeclarationsSorage().findDeclarations(charSequence);
    }

    public final Collection<CsmOffsetableDeclaration> findDeclarationsByPrefix(String string) {
        char c = '\u00ff';
        return this.getDeclarationsSorage().getDeclarationsRange((CharSequence)string, string + c);
    }

    public final Collection<CsmFriend> findFriendDeclarations(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        return this.getDeclarationsSorage().findFriends(csmOffsetableDeclaration);
    }

    public static boolean isCppFile(CsmFile csmFile) {
        return csmFile instanceof FileImpl && ((FileImpl)csmFile).isCppFile();
    }

    public static boolean canRegisterDeclaration(CsmDeclaration csmDeclaration) {
        assert (csmDeclaration != null);
        assert (csmDeclaration.getName() != null);
        if (csmDeclaration.getName().length() == 0) {
            return false;
        }
        CsmScope csmScope = csmDeclaration.getScope();
        if (csmScope instanceof CsmCompoundClassifier) {
            return ProjectBase.canRegisterDeclaration((CsmDeclaration)((CsmCompoundClassifier)csmScope));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean registerDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        if (!ProjectBase.canRegisterDeclaration((CsmDeclaration)csmOffsetableDeclaration)) {
            if (TraceFlags.TRACE_REGISTRATION) {
                ProjectBase.traceRegistration("not registered decl " + csmOffsetableDeclaration + " UID " + UIDs.get((Object)csmOffsetableDeclaration));
            }
            return false;
        }
        if (CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration) || CsmKindUtilities.isEnum((CsmObject)csmOffsetableDeclaration)) {
            ClassEnumBase classEnumBase = (ClassEnumBase)csmOffsetableDeclaration;
            CharSequence charSequence = classEnumBase.getQualifiedName();
            Object object = this.classifierReplaceLock;
            synchronized (object) {
                CsmClassifier csmClassifier = this.getClassifierSorage().getClassifier(charSequence);
                if (csmClassifier != null) {
                    if (classEnumBase.shouldBeReplaced(csmClassifier)) {
                        if (TraceFlags.TRACE_REGISTRATION) {
                            ProjectBase.traceRegistration("not registered decl " + csmOffsetableDeclaration + " UID " + UIDs.get((Object)csmOffsetableDeclaration));
                        }
                        return false;
                    }
                    if (csmClassifier instanceof ClassEnumBase && ((ClassEnumBase)csmClassifier).shouldBeReplaced((CsmClassifier)classEnumBase)) {
                        if (TraceFlags.TRACE_REGISTRATION) {
                            System.err.println("disposing old decl " + csmClassifier + " UID " + UIDs.get((Object)csmOffsetableDeclaration));
                        }
                        ((ClassEnumBase)csmClassifier).dispose();
                    }
                }
                this.getDeclarationsSorage().putDeclaration(csmOffsetableDeclaration);
                this.getClassifierSorage().putClassifier((CsmClassifier)csmOffsetableDeclaration);
            }
        } else if (CsmKindUtilities.isTypedef((CsmObject)csmOffsetableDeclaration)) {
            this.getDeclarationsSorage().putDeclaration(csmOffsetableDeclaration);
            this.getClassifierSorage().putClassifier((CsmClassifier)csmOffsetableDeclaration);
        } else {
            this.getDeclarationsSorage().putDeclaration(csmOffsetableDeclaration);
        }
        if (TraceFlags.TRACE_REGISTRATION) {
            System.err.println("registered " + csmOffsetableDeclaration + " UID " + UIDs.get((Object)csmOffsetableDeclaration));
        }
        return true;
    }

    public final void unregisterDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        if (TraceFlags.TRACE_REGISTRATION) {
            ProjectBase.traceRegistration("unregistered " + csmOffsetableDeclaration + " UID " + UIDs.get((Object)csmOffsetableDeclaration));
        }
        if (csmOffsetableDeclaration instanceof CsmClassifier) {
            this.getClassifierSorage().removeClassifier((CsmDeclaration)csmOffsetableDeclaration);
        }
        this.getDeclarationsSorage().removeDeclaration(csmOffsetableDeclaration);
    }

    private static void traceRegistration(String string) {
        assert (TraceFlags.TRACE_REGISTRATION) : "TraceFlags.TRACE_REGISTRATION should be checked *before* call !";
        System.err.printf("registration: %s\n", string);
    }

    public final void waitParse() {
        boolean bl = ParserThreadManager.instance().isParserThread();
        if (bl) {
            new Throwable("project.waitParse should NEVER be called in parser thread !!!").printStackTrace(System.err);
        }
        if (bl) {
            return;
        }
        this.ensureFilesCreated();
        this.ensureChangedFilesEnqueued();
        this.waitParseImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitParseImpl() {
        Object object = this.waitParseLock;
        synchronized (object) {
            while (ParserQueue.instance().hasFiles(this, null)) {
                try {
                    this.waitParseLock.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected void ensureChangedFilesEnqueued() {
    }

    protected boolean hasChangedFiles(CsmFile csmFile) {
        return false;
    }

    public final boolean acceptNativeItem(NativeFileItem nativeFileItem) {
        if (nativeFileItem.getFile() == null) {
            return false;
        }
        NativeFileItem.Language language = nativeFileItem.getLanguage();
        return (language == NativeFileItem.Language.C || language == NativeFileItem.Language.CPP || language == NativeFileItem.Language.C_HEADER) && !nativeFileItem.isExcluded();
    }

    protected final synchronized void registerProjectListeners() {
        if (this.platformProject instanceof NativeProject) {
            if (this.projectListener == null) {
                this.projectListener = new NativeProjectListenerImpl(this.getModel(), (NativeProject)this.platformProject);
            }
            ((NativeProject)this.platformProject).addProjectItemsListener((NativeProjectItemsListener)this.projectListener);
        }
    }

    protected final synchronized void unregisterProjectListeners() {
        if (this.projectListener != null && this.platformProject instanceof NativeProject) {
            ((NativeProject)this.platformProject).removeProjectItemsListener((NativeProjectItemsListener)this.projectListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureFilesCreated() {
        boolean bl = false;
        ProjectBase projectBase = this;
        synchronized (projectBase) {
            if (this.status == Status.Initial || this.status == Status.Restored) {
                try {
                    this.setStatus(this.status == Status.Initial ? Status.AddingFiles : Status.Validating);
                    long l = 0L;
                    if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                        System.err.println("suspend queue");
                        ParserQueue.instance().suspend();
                        if (TraceFlags.TIMING) {
                            l = System.currentTimeMillis();
                        }
                    }
                    ParserQueue.instance().onStartAddingProjectFiles(this);
                    this.registerProjectListeners();
                    NativeProject nativeProject = ModelSupport.getNativeProject(this.platformProject);
                    if (nativeProject != null) {
                        try {
                            ParserQueue.instance().suspend();
                            this.createProjectFilesIfNeed(nativeProject);
                        }
                        finally {
                            ParserQueue.instance().resume();
                        }
                    }
                    if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                        if (TraceFlags.TIMING) {
                            l = System.currentTimeMillis() - l;
                            System.err.println("getting files from project system + put in queue took " + l + "ms");
                        }
                        try {
                            System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_TIME + "sec before resuming queue");
                            Thread.sleep(TraceFlags.SUSPEND_PARSE_TIME * 1000);
                            System.err.println("woke up after sleep");
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ParserQueue.instance().resume();
                    }
                    bl = true;
                }
                finally {
                    this.setStatus(Status.Ready);
                }
            }
        }
        if (bl) {
            ParserQueue.instance().onEndAddingProjectFiles(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void createProjectFilesIfNeed(NativeProject var1_1) {
        block30: {
            block31: {
                if (TraceFlags.TIMING) {
                    System.err.printf("\n\nGetting files from project system for %s...\n", new Object[]{this.getName()});
                }
                if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                    try {
                        System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_TIME + "sec before getting files from project");
                        Thread.sleep(TraceFlags.SUSPEND_PARSE_TIME * 1000);
                        System.err.println("woke up after sleep");
                    }
                    catch (InterruptedException var2_2) {
                        // empty catch block
                    }
                }
                var2_3 = System.currentTimeMillis();
                var4_4 = Collections.synchronizedSet(new HashSet<E>());
                var5_5 = new NativeProjectItemsListener(){

                    public void fileAdded(NativeFileItem nativeFileItem) {
                    }

                    public void filesAdded(List<NativeFileItem> list) {
                    }

                    public void fileRemoved(NativeFileItem nativeFileItem) {
                        var4_4.add(nativeFileItem);
                    }

                    public void filesRemoved(List<NativeFileItem> list) {
                        var4_4.addAll(list);
                    }

                    public void fileRenamed(String string, NativeFileItem nativeFileItem) {
                    }

                    public void filePropertiesChanged(NativeFileItem nativeFileItem) {
                    }

                    public void filesPropertiesChanged(List<NativeFileItem> list) {
                    }

                    public void filesPropertiesChanged() {
                    }

                    public void projectDeleted(NativeProject nativeProject) {
                    }
                };
                var1_1.addProjectItemsListener(var5_5);
                var6_6 = new ArrayList<NativeFileItem>();
                var7_7 = new ArrayList<NativeFileItem>();
                var8_8 = new ArrayList<NativeFileItem>();
                block14: for (Object var10_11 : var1_1.getAllFiles()) {
                    if (!var10_11.isExcluded()) {
                        switch (3.$SwitchMap$org$netbeans$modules$cnd$api$project$NativeFileItem$Language[var10_11.getLanguage().ordinal()]) {
                            case 1: 
                            case 2: {
                                var6_6.add((NativeFileItem)var10_11);
                                continue block14;
                            }
                            case 3: {
                                var7_7.add((NativeFileItem)var10_11);
                                continue block14;
                            }
                        }
                        continue;
                    }
                    switch (3.$SwitchMap$org$netbeans$modules$cnd$api$project$NativeFileItem$Language[var10_11.getLanguage().ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: {
                            var8_8.add((NativeFileItem)var10_11);
                            break;
                        }
                    }
                }
                if (TraceFlags.TIMING) {
                    var2_3 = System.currentTimeMillis() - var2_3;
                    System.err.printf("Getting files from project system took  %d ms for %s\n", new Object[]{var2_3, this.getName()});
                    System.err.printf("FILES COUNT for %s:\nSource files:\t%d\nHeader files:\t%d\nTotal files:\t%d\n", new Object[]{this.getName(), var6_6.size(), var7_7.size(), var6_6.size() + var7_7.size()});
                    var2_3 = System.currentTimeMillis();
                }
                if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                    try {
                        System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_TIME + "sec after getting files from project");
                        Thread.sleep(TraceFlags.SUSPEND_PARSE_TIME * 1000);
                        System.err.println("woke up after sleep");
                    }
                    catch (InterruptedException var9_10) {
                        // empty catch block
                    }
                }
                if (TraceFlags.DUMP_PROJECT_ON_OPEN) {
                    ModelSupport.dumpNativeProject(var1_1);
                }
                this.disposeLock.readLock().lock();
                if (TraceFlags.TIMING) {
                    var2_3 = System.currentTimeMillis() - var2_3;
                    System.err.printf("Waited on disposeLock: %d ms for %s\n", new Object[]{var2_3, this.getName()});
                    var2_3 = System.currentTimeMillis();
                }
                if (!this.disposing) break block30;
                if (TraceFlags.TRACE_MODEL_STATE) {
                    System.err.printf("filling parser queue interrupted for %s\n", new Object[]{this.getName()});
                }
                this.disposeLock.readLock().unlock();
                if (!TraceFlags.TIMING) break block31;
                var2_3 = System.currentTimeMillis() - var2_3;
                System.err.printf("FILLING PARSER QUEUE took %d ms for %s\n", new Object[]{var2_3, this.getName()});
            }
            return;
        }
        try {
            var9_9 = null;
            if (this.status == Status.Validating) {
                var9_9 = new ProjectSettingsValidator(this);
                var9_9.restoreSettings();
            }
            if (this.status == Status.Validating && RepositoryUtils.getRepositoryErrorCount(this) > 0) {
                System.err.println("Clean index for project \"" + this.getUniqueName() + "\" because index was corrupted (was " + RepositoryUtils.getRepositoryErrorCount(this) + " errors).");
                var9_9 = null;
                this.reopenUnit();
            }
            this.projectRoots.fixFolder(var1_1.getProjectRoot());
            for (String var11_12 : var1_1.getSourceRoots()) {
                this.projectRoots.fixFolder(var11_12);
            }
            this.projectRoots.addSources(var6_6);
            this.projectRoots.addSources(var7_7);
            this.projectRoots.addSources(var8_8);
            this.createProjectFilesIfNeed(var6_6, true, var4_4, (ProjectSettingsValidator)var9_9);
            if (this.status != Status.Validating || RepositoryUtils.getRepositoryErrorCount(this) == 0) {
                this.createProjectFilesIfNeed(var7_7, false, var4_4, (ProjectSettingsValidator)var9_9);
            }
            if (this.status == Status.Validating && RepositoryUtils.getRepositoryErrorCount(this) > 0) {
                System.err.println("Clean index for project \"" + this.getUniqueName() + "\" because index was corrupted (was " + RepositoryUtils.getRepositoryErrorCount(this) + " errors).");
                var9_9 = null;
                this.reopenUnit();
                this.createProjectFilesIfNeed(var6_6, true, var4_4, (ProjectSettingsValidator)var9_9);
                this.createProjectFilesIfNeed(var7_7, false, var4_4, (ProjectSettingsValidator)var9_9);
            }
            this.disposeLock.readLock().unlock();
            ** if (!TraceFlags.TIMING) goto lbl-1000
        }
        catch (Throwable var12_13) {
            this.disposeLock.readLock().unlock();
            if (TraceFlags.TIMING) {
                var2_3 = System.currentTimeMillis() - var2_3;
                System.err.printf("FILLING PARSER QUEUE took %d ms for %s\n", new Object[]{var2_3, this.getName()});
            }
            throw var12_13;
        }
lbl-1000:
        // 1 sources

        {
            var2_3 = System.currentTimeMillis() - var2_3;
            System.err.printf("FILLING PARSER QUEUE took %d ms for %s\n", new Object[]{var2_3, this.getName()});
        }
lbl-1000:
        // 2 sources

        {
        }
        var1_1.removeProjectItemsListener(var5_5);
    }

    private void reopenUnit() {
        this.setStatus(Status.Initial);
        ParserQueue.instance().clean(this);
        RepositoryUtils.closeUnit(((Object)this.getUniqueName()).toString(), null, true);
        RepositoryUtils.openUnit(this);
        RepositoryUtils.hang(this);
        this.initFields();
    }

    private void createProjectFilesIfNeed(List<NativeFileItem> list, boolean bl, Set<NativeFileItem> set, ProjectSettingsValidator projectSettingsValidator) {
        ArrayList<FileImpl> arrayList = new ArrayList<FileImpl>();
        ArrayList<NativeFileItem> arrayList2 = new ArrayList<NativeFileItem>();
        for (NativeFileItem nativeFileItem : list) {
            if (this.disposing) {
                if (TraceFlags.TRACE_MODEL_STATE) {
                    System.err.printf("filling parser queue interrupted for %s\n", this.getName());
                }
                return;
            }
            if (set.contains(nativeFileItem)) continue;
            assert (nativeFileItem.getFile() != null) : "native file item must have valid File object";
            if (TraceFlags.DEBUG) {
                ModelSupport.trace(nativeFileItem);
            }
            try {
                this.createIfNeed(nativeFileItem, bl, projectSettingsValidator, arrayList, arrayList2);
                if (this.status != Status.Validating || RepositoryUtils.getRepositoryErrorCount(this) <= 0) continue;
                return;
            }
            catch (Exception exception) {
                DiagnosticExceptoins.register(exception);
            }
        }
        if (!arrayList.isEmpty()) {
            DeepReparsingUtils.reparseOnEdit(arrayList, this, true);
        }
        if (!arrayList2.isEmpty()) {
            DeepReparsingUtils.reparseOnPropertyChanged(arrayList2, this);
        }
    }

    protected final void createIfNeed(NativeFileItem nativeFileItem, boolean bl) {
        this.createIfNeed(nativeFileItem, bl, null, null, null);
    }

    private void createIfNeed(NativeFileItem nativeFileItem, boolean bl, ProjectSettingsValidator projectSettingsValidator, List<FileImpl> list, List<NativeFileItem> list2) {
        assert (nativeFileItem != null && nativeFileItem.getFile() != null);
        if (!this.acceptNativeItem(nativeFileItem)) {
            return;
        }
        File file = nativeFileItem.getFile();
        FileImpl.FileType fileType = bl ? ProjectBase.getFileType(nativeFileItem) : FileImpl.FileType.HEADER_FILE;
        FileAndHandler fileAndHandler = this.createOrFindFileImpl(ModelSupport.getFileBuffer(file), nativeFileItem, fileType);
        if (fileAndHandler.preprocHandler == null) {
            fileAndHandler.preprocHandler = this.createPreprocHandler(nativeFileItem);
        }
        if (projectSettingsValidator != null) {
            if (fileAndHandler.fileImpl.validate()) {
                if (projectSettingsValidator.arePropertiesChanged(nativeFileItem)) {
                    if (TraceFlags.TRACE_VALIDATION) {
                        System.err.printf("Validation: %s properties are changed \n", nativeFileItem.getFile().getAbsolutePath());
                    }
                    list2.add(nativeFileItem);
                }
            } else {
                if (TraceFlags.TRACE_VALIDATION) {
                    System.err.printf("Validation: file %s is changed\n", nativeFileItem.getFile().getAbsolutePath());
                }
                list.add(fileAndHandler.fileImpl);
            }
        } else {
            ParserQueue.instance().add(fileAndHandler.fileImpl, fileAndHandler.preprocHandler.getState(), ParserQueue.Position.TAIL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onAddedToModel() {
        boolean bl;
        boolean bl2 = bl = this.status == Status.Restored;
        if (this.status == Status.Initial || this.status == Status.Restored) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ProjectBase.this.onAddedToModelImpl(bl);
                    Object object = ProjectBase.this.initializationTaskLock;
                    synchronized (object) {
                        ProjectBase.this.initializationTask = null;
                    }
                }
            };
            String string = this.status == Status.Initial ? "Filling parser queue for " : "Validating files for ";
            Object object = this.initializationTaskLock;
            synchronized (object) {
                this.initializationTask = ModelImpl.instance().enqueueModelTask(runnable, string + this.getName());
            }
        }
    }

    protected final Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAddedToModelImpl(boolean bl) {
        if (this.disposing) {
            return;
        }
        try {
            this.disposeLock.readLock().lock();
            if (this.disposing) {
                return;
            }
            this.ensureFilesCreated();
            if (this.disposing) {
                return;
            }
            this.ensureChangedFilesEnqueued();
            if (this.disposing) {
                return;
            }
            Notificator.instance().flush();
        }
        finally {
            this.disposeLock.readLock().unlock();
        }
        if (bl) {
            ProgressSupport.instance().fireProjectLoaded(this);
        }
        try {
            this.disposeLock.readLock().lock();
            if (bl && !this.disposing) {
                try {
                    this.waitParseImpl();
                    this.checkForRemoved();
                }
                catch (Exception exception) {
                    DiagnosticExceptoins.register(exception);
                }
            }
            if (this.disposing) {
                return;
            }
            Notificator.instance().flush();
        }
        finally {
            this.disposeLock.readLock().unlock();
        }
    }

    private void checkForRemoved() {
        NativeFileItem nativeFileItem2;
        NativeProject nativeProject = this.platformProject instanceof NativeProject ? (NativeProject)this.platformProject : null;
        HashSet<String> hashSet = null;
        if (nativeProject != null) {
            hashSet = new HashSet<String>();
            for (NativeFileItem nativeFileItem2 : nativeProject.getAllFiles()) {
                if (nativeFileItem2.isExcluded()) continue;
                switch (nativeFileItem2.getLanguage()) {
                    case C: 
                    case CPP: 
                    case C_HEADER: {
                        hashSet.add(nativeFileItem2.getFile().getAbsolutePath());
                        break;
                    }
                }
            }
        }
        HashSet hashSet2 = new HashSet();
        nativeFileItem2 = new HashSet();
        for (FileImpl fileImpl : this.getAllFileImpls()) {
            if (!fileImpl.getFile().exists()) {
                nativeFileItem2.add(fileImpl);
                continue;
            }
            if (hashSet == null || hashSet.contains(((Object)fileImpl.getAbsolutePath()).toString())) continue;
            hashSet2.add(fileImpl);
        }
        if (!nativeFileItem2.isEmpty()) {
            if (TraceFlags.TRACE_VALIDATION) {
                for (FileImpl fileImpl : nativeFileItem2) {
                    System.err.printf("Validation: removing (physically deleted) %s\n", fileImpl.getAbsolutePath());
                }
            }
            this.onFileImplRemoved(new ArrayList<FileImpl>((Collection<FileImpl>)nativeFileItem2));
        }
        Iterator<FileImpl> iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            FileImpl fileImpl;
            fileImpl = iterator.next();
            boolean bl = true;
            Set<CsmFile> set = this.getGraphStorage().getParentFiles(fileImpl);
            for (CsmFile csmFile : set) {
                if (hashSet2.contains((FileImpl)csmFile)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            if (TraceFlags.TRACE_VALIDATION) {
                System.err.printf("Validation: removing (removed from project) %s\n", fileImpl.getAbsolutePath());
            }
            this.onFileRemoved(fileImpl);
        }
    }

    protected final APTPreprocHandler createEmptyPreprocHandler(File file) {
        StartEntry startEntry = new StartEntry(((Object)FileContainer.getFileKey(file, true)).toString(), RepositoryUtils.UIDtoKey(this.getUID()));
        return APTHandlersSupport.createEmptyPreprocHandler((StartEntry)startEntry);
    }

    protected final APTPreprocHandler createPreprocHandler(NativeFileItem nativeFileItem) {
        assert (nativeFileItem != null);
        APTMacroMap aPTMacroMap = this.getMacroMap(nativeFileItem);
        APTIncludeHandler aPTIncludeHandler = this.getIncludeHandler(nativeFileItem);
        APTPreprocHandler aPTPreprocHandler = APTHandlersSupport.createPreprocHandler((APTMacroMap)aPTMacroMap, (APTIncludeHandler)aPTIncludeHandler, (boolean)this.isSourceFile(nativeFileItem));
        return aPTPreprocHandler;
    }

    private APTIncludeHandler getIncludeHandler(NativeFileItem nativeFileItem) {
        if (!this.isSourceFile(nativeFileItem)) {
            nativeFileItem = DefaultFileItem.toDefault(nativeFileItem);
        }
        List list = nativeFileItem.getUserIncludePaths();
        List list2 = nativeFileItem.getSystemIncludePaths();
        List list3 = FilePathCache.asList((Collection)list);
        List list4 = this.sysAPTData.getIncludes((CharSequence)list2.toString(), list2);
        StartEntry startEntry = new StartEntry(((Object)FileContainer.getFileKey(nativeFileItem.getFile(), true)).toString(), RepositoryUtils.UIDtoKey(this.getUID()));
        return APTHandlersSupport.createIncludeHandler((StartEntry)startEntry, (List)list4, (List)list3);
    }

    private APTMacroMap getMacroMap(NativeFileItem nativeFileItem) {
        if (!this.isSourceFile(nativeFileItem)) {
            nativeFileItem = DefaultFileItem.toDefault(nativeFileItem);
        }
        List list = nativeFileItem.getUserMacroDefinitions();
        List list2 = nativeFileItem.getSystemMacroDefinitions();
        APTMacroMap aPTMacroMap = APTHandlersSupport.createMacroMap((APTMacroMap)this.getSysMacroMap(list2), (List)list);
        return aPTMacroMap;
    }

    protected final boolean isSourceFile(NativeFileItem nativeFileItem) {
        FileImpl.FileType fileType = ProjectBase.getFileType(nativeFileItem);
        return FileImpl.isSourceFileType(fileType);
    }

    protected static FileImpl.FileType getFileType(NativeFileItem nativeFileItem) {
        switch (nativeFileItem.getLanguage()) {
            case C: {
                return FileImpl.FileType.SOURCE_C_FILE;
            }
            case CPP: {
                return FileImpl.FileType.SOURCE_CPP_FILE;
            }
            case C_HEADER: {
                return FileImpl.FileType.HEADER_FILE;
            }
        }
        return FileImpl.FileType.UNDEFINED_FILE;
    }

    private APTMacroMap getSysMacroMap(List<String> list) {
        APTMacroMap aPTMacroMap = this.sysAPTData.getMacroMap(list.toString(), list);
        return aPTMacroMap;
    }

    public final APTPreprocHandler getPreprocHandler(File file) {
        return this.createPreprocHandler(file, this.getFileContainer().getPreprocState(file));
    }

    final APTPreprocHandler getPreprocHandler(File file, PreprocessorStatePair preprocessorStatePair) {
        return this.createPreprocHandler(file, preprocessorStatePair == null ? this.getFileContainer().getPreprocState(file) : preprocessorStatePair.state);
    }

    final APTPreprocHandler createPreprocHandler(File file, APTPreprocHandler.State state) {
        APTPreprocHandler aPTPreprocHandler = this.createEmptyPreprocHandler(file);
        if (state != null) {
            if (state.isCleaned()) {
                return this.restorePreprocHandler(file, aPTPreprocHandler, state);
            }
            if (TRACE_PP_STATE_OUT) {
                System.err.println("copying state for " + file);
            }
            aPTPreprocHandler.setState(state);
            return aPTPreprocHandler;
        }
        if (TRACE_PP_STATE_OUT) {
            System.err.printf("null state for %s, returning default one", file);
        }
        return aPTPreprocHandler;
    }

    final Collection<PreprocessorStatePair> getPreprocessorStatePairs(File file) {
        return this.getFileContainer().getStatePairs(file);
    }

    public final Collection<APTPreprocHandler> getPreprocHandlers(File file) {
        Collection<APTPreprocHandler.State> collection = this.getFileContainer().getPreprocStates(file);
        ArrayList<APTPreprocHandler> arrayList = new ArrayList<APTPreprocHandler>(collection.size());
        for (APTPreprocHandler.State state : collection) {
            APTPreprocHandler aPTPreprocHandler = this.createEmptyPreprocHandler(file);
            if (state != null) {
                if (state.isCleaned()) {
                    aPTPreprocHandler = this.restorePreprocHandler(file, aPTPreprocHandler, state);
                } else {
                    if (TRACE_PP_STATE_OUT) {
                        System.err.println("copying state for " + file);
                    }
                    aPTPreprocHandler.setState(state);
                }
            }
            if (TRACE_PP_STATE_OUT) {
                System.err.printf("null state for %s, returning default one", file);
            }
            arrayList.add(aPTPreprocHandler);
        }
        return arrayList;
    }

    public final APTPreprocHandler.State getPreprocState(FileImpl fileImpl) {
        APTPreprocHandler.State state = null;
        FileContainer fileContainer = this.getFileContainer();
        File file = fileImpl.getBuffer().getFile();
        state = fileContainer.getPreprocState(file);
        return state;
    }

    public final Collection<APTPreprocHandler.State> getPreprocStates(FileImpl fileImpl) {
        FileContainer fileContainer = this.getFileContainer();
        return fileContainer.getPreprocStates(fileImpl.getFile());
    }

    public final CsmFile testAPTParseFile(NativeFileItem nativeFileItem) {
        APTPreprocHandler aPTPreprocHandler = this.createPreprocHandler(nativeFileItem);
        return this.findFile(nativeFileItem.getFile(), false, ProjectBase.getFileType(nativeFileItem), aPTPreprocHandler, true, aPTPreprocHandler.getState(), nativeFileItem);
    }

    private final void putPreprocState(File file, APTPreprocHandler.State state) {
        if (state != null && !state.isCleaned()) {
            state = APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)state);
        }
        this.getFileContainer().putPreprocState(file, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final APTPreprocHandler.State setChangedFileState(NativeFileItem nativeFileItem) {
        APTPreprocHandler.State state = this.createPreprocHandler(nativeFileItem).getState();
        File file = nativeFileItem.getFile();
        FileContainer fileContainer = this.getFileContainer();
        FileContainer.FileEntry fileEntry = fileContainer.getEntry(file);
        Object object = fileEntry.getLock();
        synchronized (object) {
            fileEntry.invalidateStates();
            fileEntry.setState(state, FilePreprocessorConditionState.PARSING);
        }
        fileContainer.put();
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void invalidatePreprocState(File file) {
        Object object;
        FileContainer fileContainer = this.getFileContainer();
        Object object2 = object = fileContainer.getLock(file);
        synchronized (object2) {
            fileContainer.invalidatePreprocState(file);
        }
        fileContainer.put();
    }

    public final void debugInvalidateFiles() {
        this.getFileContainer().debugClearState();
        for (ProjectBase projectBase : this.getLibraries()) {
            projectBase.debugInvalidateFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final FileImpl onFileIncluded(ProjectBase var1_1, CharSequence var2_2, APTPreprocHandler var3_3, APTMacroMap.State var4_4, int var5_5, boolean var6_6) throws IOException {
        var7_7 = null;
        try {
            this.disposeLock.readLock().lock();
            if (this.disposing) {
                var8_8 = null;
                return var8_8;
            }
            var7_7 = this.findFile(new File(var2_2.toString()), true, FileImpl.FileType.HEADER_FILE, var3_3, false, null, null);
        }
        finally {
            this.disposeLock.readLock().unlock();
        }
        if (var4_4 != null) {
            var3_3.getMacroMap().setState(var4_4);
            return var7_7;
        }
        var8_9 = var3_3.getState();
        var9_11 = null;
        if (var5_5 == 1 && !APTHandlersSupport.extractIncludeStack((APTPreprocHandler.State)var8_9).isEmpty() && (var9_11 = var7_7.getCachedVisitedState(var8_9)) != null) {
            var3_3.getMacroMap().setState(APTHandlersSupport.extractMacroMapState((APTPreprocHandler.State)var9_11));
            return var7_7;
        }
        var10_12 = this.getAPTLight(var7_7);
        if (var10_12 == null) {
            Utils.LOG.info("Can not find or build APT for file " + var2_2);
            return var7_7;
        }
        var11_13 = new FilePreprocessorConditionState.Builder(var7_7.getAbsolutePath());
        var12_14 = var7_7.getAPTCacheEntry(var3_3);
        var13_15 = new APTParseFileWalker(var1_1, var10_12, var7_7, var3_3, var6_6, var11_13, var12_14);
        var13_15.visit();
        var14_16 = var11_13.build();
        if (var5_5 == 1 && !APTHandlersSupport.extractIncludeStack((APTPreprocHandler.State)var8_9).isEmpty()) {
            var7_7.cacheVisitedState(var8_9, var3_3);
        }
        var15_17 = false;
        this.disposeLock.readLock().lock();
        if (this.disposing) {
            var16_18 = null;
            this.disposeLock.readLock().unlock();
            if (var15_17 == false) return var16_18;
        }
        ** GOTO lbl-1000
        this.getFileContainer().put();
        return var16_18;
lbl-1000:
        // 1 sources

        {
            if (var6_6 == false) return var7_7;
            var16_19 = this.getFileContainer().getEntry(var7_7.getBuffer().getFile());
            if (var16_19 != null) ** GOTO lbl-1000
            this.entryNotFoundMessage(var2_2);
            var17_20 = var7_7;
            this.disposeLock.readLock().unlock();
            if (var15_17 == false) return var17_20;
        }
        this.getFileContainer().put();
        return var17_20;
lbl-1000:
        // 1 sources

        {
            var17_21 = var16_19.getLock();
            synchronized (var17_21) {
                var18_22 = new ArrayList<PreprocessorStatePair>();
                var19_23 = new AtomicBoolean();
                var20_24 = this.fillStatesToKeepBasedOnPPState(var8_9, var16_19.getStatePairs(), var18_22, var19_23);
                if (var20_24 != ComparisonResult.WORSE) ** break block37
                var21_25 = var7_7;
            }
            this.disposeLock.readLock().unlock();
            if (var15_17 == false) return var21_25;
        }
        this.getFileContainer().put();
        return var21_25;
        {
            if (var20_24 == ComparisonResult.SAME && var19_23.get()) {
                var21_26 = var7_7;
                // MONITOREXIT @DISABLED, blocks:[11, 29] lbl67 : MonitorExitStatement: MONITOREXIT : var17_21
                this.disposeLock.readLock().unlock();
                if (var15_17 == false) return var21_26;
                this.getFileContainer().put();
                return var21_26;
            }
            if (!ProjectBase.$assertionsDisabled && var20_24 == ComparisonResult.WORSE) {
                throw new AssertionError();
            }
            var22_28 = new ArrayList<APTPreprocHandler.State>();
            var22_28.add(var8_9);
            if (var20_24 == ComparisonResult.BETTER) {
                var21_27 = true;
                CndUtils.assertTrueInConsole((boolean)var18_22.isEmpty(), (String)"states to keep must be empty 2");
            } else {
                var21_27 = false;
                var20_24 = this.fillStatesToKeepBasedOnPCState(var14_16, new ArrayList<PreprocessorStatePair>(var18_22), var18_22);
                switch (3.$SwitchMap$org$netbeans$modules$cnd$modelimpl$csm$core$ProjectBase$ComparisonResult[var20_24.ordinal()]) {
                    case 1: {
                        CndUtils.assertTrueInConsole((boolean)var18_22.isEmpty(), (String)"states to keep must be empty 3");
                        var21_27 = true;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        var23_29 = var7_7;
                        // MONITOREXIT @DISABLED, blocks:[26, 11, 12, 15] lbl92 : MonitorExitStatement: MONITOREXIT : var17_21
                        this.disposeLock.readLock().unlock();
                        if (var15_17 == false) return var23_29;
                        this.getFileContainer().put();
                        return var23_29;
                    }
                    default: {
                        if (!ProjectBase.$assertionsDisabled) {
                            throw new AssertionError((Object)("unexpected comparison result: " + (Object)var20_24));
                        }
                        var23_30 = var7_7;
                        // MONITOREXIT @DISABLED, blocks:[16, 26, 11, 12] lbl101 : MonitorExitStatement: MONITOREXIT : var17_21
                        this.disposeLock.readLock().unlock();
                        if (var15_17 == false) return var23_30;
                        this.getFileContainer().put();
                        return var23_30;
                    }
                }
            }
            ** try [egrp 9[TRYBLOCK] [15 : 829->1025)] { 
lbl108:
            // 1 sources

            if (this.isDisposing() != false) return var7_7;
            if (var1_1.isDisposing() != false) return var7_7;
            if (var21_27) {
                for (PreprocessorStatePair var24_32 : var18_22) {
                    if (var24_32.pcState == FilePreprocessorConditionState.PARSING) continue;
                    var22_28.add(var24_32.state);
                }
            }
            var7_7.setAPTCacheEntry(var3_3, var12_14, var21_27);
            var16_19.setStates(var18_22, new PreprocessorStatePair(var8_9, var14_16));
            ParserQueue.instance().add(var7_7, var22_28, ParserQueue.Position.HEAD, var21_27, var21_27 != false ? ParserQueue.FileAction.MARK_REPARSE : ParserQueue.FileAction.MARK_MORE_PARSE);
            var7_7.setAPTCacheEntry(var3_3, var12_14, var21_27);
            if (TraceFlags.TRACE_PC_STATE || TraceFlags.TRACE_PC_STATE_COMPARISION) {
                ProjectBase.traceIncludeStates("scheduling", var7_7, var8_9, var14_16, var21_27, var22_28, var18_22);
            }
            var15_17 = true;
            return var7_7;
lbl125:
            // 1 sources

            finally {
                this.disposeLock.readLock().unlock();
                if (var15_17) {
                    this.getFileContainer().put();
                }
            }
        }
    }

    private void entryNotFoundMessage(CharSequence charSequence) {
        Status status;
        StringBuilder stringBuilder = new StringBuilder("File container does not have file ");
        stringBuilder.append("[" + charSequence + "]");
        if (this.getFileContainer() == FileContainer.empty()) {
            stringBuilder.append(" because file container is EMPTY.");
        } else {
            stringBuilder.append(".");
        }
        if (this.isDisposing()) {
            stringBuilder.append("\n\tIt is very strange but project is disposing.");
        }
        if (!this.isValid()) {
            stringBuilder.append("\n\tIt is very strange but project is invalid.");
        }
        if ((status = this.getStatus()) != null) {
            stringBuilder.append("\n\tProject " + this.toString() + " has status " + (Object)((Object)status) + ".");
        }
        Utils.LOG.info(stringBuilder.toString());
    }

    private static void traceIncludeStates(CharSequence charSequence, FileImpl fileImpl, APTPreprocHandler.State state, FilePreprocessorConditionState filePreprocessorConditionState, boolean bl, Collection<APTPreprocHandler.State> collection, Collection<PreprocessorStatePair> collection2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (PreprocessorStatePair object : collection2) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(object.pcState);
        }
        APTPreprocHandler aPTPreprocHandler = fileImpl.getProjectImpl(true).createEmptyPreprocHandler(fileImpl.getBuffer().getFile());
        aPTPreprocHandler.setState(state);
        System.err.printf("%s %s (1) %s\n\tfrom %s \n\t%s %s \n\t%s keeping [%s]\n", charSequence, bl ? "reparse" : "  parse", fileImpl.getAbsolutePath(), APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state).getStartFile(), TraceUtils.getPreprocStateString(aPTPreprocHandler.getState()), TraceUtils.getMacroString(aPTPreprocHandler, TraceFlags.logMacros), filePreprocessorConditionState, stringBuilder);
        if (collection != null) {
            for (APTPreprocHandler.State state2 : collection) {
                if (state.equals(state2)) continue;
                FilePreprocessorConditionState filePreprocessorConditionState2 = null;
                for (PreprocessorStatePair preprocessorStatePair : collection2) {
                    if (!state.equals(preprocessorStatePair.state)) continue;
                    filePreprocessorConditionState2 = preprocessorStatePair.pcState;
                    break;
                }
                System.err.printf("%s %s (2) %s \n\tfrom %s\n\t valid %b context %b %s\n", charSequence, "  parse", fileImpl.getAbsolutePath(), APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state2).getStartFile(), state2.isValid(), state2.isCompileContext(), filePreprocessorConditionState2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setParsedPCState(FileImpl fileImpl, APTPreprocHandler.State state, FilePreprocessorConditionState filePreprocessorConditionState) {
        File file = fileImpl.getBuffer().getFile();
        FileContainer.FileEntry fileEntry = this.getFileContainer().getEntry(file);
        if (fileEntry == null) {
            this.entryNotFoundMessage(file.getAbsolutePath());
            return false;
        }
        Object object = fileEntry.getLock();
        synchronized (object) {
            return fileEntry.setParsedPCState(state, filePreprocessorConditionState);
        }
    }

    private ComparisonResult fillStatesToKeepBasedOnPPState(APTPreprocHandler.State state, Collection<PreprocessorStatePair> collection, Collection<PreprocessorStatePair> collection2, AtomicBoolean atomicBoolean) {
        if (state == null || !state.isValid()) {
            return ComparisonResult.WORSE;
        }
        collection2.clear();
        atomicBoolean.set(false);
        ComparisonResult comparisonResult = ComparisonResult.SAME;
        for (PreprocessorStatePair preprocessorStatePair : collection) {
            if (state.equals(preprocessorStatePair.state)) {
                assert (!atomicBoolean.get());
                atomicBoolean.set(true);
                continue;
            }
            boolean bl = false;
            if (preprocessorStatePair.state != null && preprocessorStatePair.state.isValid()) {
                if (preprocessorStatePair.state.isCompileContext()) {
                    bl = true;
                    if (!state.isCompileContext()) {
                        return ComparisonResult.WORSE;
                    }
                } else {
                    boolean bl2 = bl = !state.isCompileContext();
                }
            }
            if (bl) {
                if (!preprocessorStatePair.state.isCleaned()) {
                    preprocessorStatePair = new PreprocessorStatePair(APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)preprocessorStatePair.state), preprocessorStatePair.pcState);
                }
                collection2.add(preprocessorStatePair);
                continue;
            }
            comparisonResult = ComparisonResult.BETTER;
        }
        if (comparisonResult == ComparisonResult.BETTER) {
            CndUtils.assertTrueInConsole((boolean)collection2.isEmpty(), (String)"states to keep must be empty ");
        }
        return comparisonResult;
    }

    private ComparisonResult fillStatesToKeepBasedOnPCState(FilePreprocessorConditionState filePreprocessorConditionState, Collection<PreprocessorStatePair> collection, Collection<PreprocessorStatePair> collection2) {
        boolean bl = true;
        collection2.clear();
        for (PreprocessorStatePair preprocessorStatePair : collection) {
            if (preprocessorStatePair.pcState == FilePreprocessorConditionState.PARSING) {
                bl = false;
                if (!preprocessorStatePair.state.isCleaned()) {
                    preprocessorStatePair = new PreprocessorStatePair(APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)preprocessorStatePair.state), preprocessorStatePair.pcState);
                }
                collection2.add(preprocessorStatePair);
                continue;
            }
            if (preprocessorStatePair.pcState.isBetterOrEqual(filePreprocessorConditionState)) {
                return ComparisonResult.WORSE;
            }
            if (filePreprocessorConditionState.isBetterOrEqual(preprocessorStatePair.pcState)) continue;
            bl = false;
            if (!preprocessorStatePair.state.isCleaned()) {
                preprocessorStatePair = new PreprocessorStatePair(APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)preprocessorStatePair.state), preprocessorStatePair.pcState);
            }
            collection2.add(preprocessorStatePair);
        }
        if (bl) {
            assert (collection2.isEmpty()) : "should be empty, but it is: " + Arrays.toString(collection2.toArray());
            return ComparisonResult.BETTER;
        }
        return ComparisonResult.SAME;
    }

    public ProjectBase findFileProject(CharSequence charSequence) {
        this.ensureFilesCreated();
        File file = new File(((Object)charSequence).toString());
        if (this.getFile(file, false) != null) {
            return this;
        }
        for (CsmProject csmProject : this.getLibraries()) {
            ((ProjectBase)csmProject).ensureFilesCreated();
            if (((ProjectBase)csmProject).getFile(file, false) == null) continue;
            return (ProjectBase)csmProject;
        }
        return null;
    }

    public final boolean isMySource(String string) {
        return this.projectRoots.isMySource(string);
    }

    public abstract void onFileAdded(NativeFileItem var1);

    public abstract void onFileAdded(List<NativeFileItem> var1);

    public abstract void onFileRemoved(FileImpl var1);

    public abstract void onFileImplRemoved(List<FileImpl> var1);

    public abstract void onFileRemoved(List<NativeFileItem> var1);

    public abstract void onFilePropertyChanged(NativeFileItem var1);

    public abstract void onFilePropertyChanged(List<NativeFileItem> var1);

    protected abstract ParserQueue.Position getIncludedFileParserQueuePosition();

    public abstract NativeFileItem getNativeFileItem(CsmUID<CsmFile> var1);

    protected abstract void putNativeFileItem(CsmUID<CsmFile> var1, NativeFileItem var2);

    protected abstract void removeNativeFileItem(CsmUID<CsmFile> var1);

    protected abstract void clearNativeFileContainer();

    public final void onFileRemoved(File file) {
        this.onFileRemoved(this.getFile(file, false));
    }

    public final void onFileExternalCreate(FileObject fileObject) {
        CndFileUtils.clearFileExistenceCache();
        DeepReparsingUtils.reparseOnAdded(fileObject, this);
    }

    public final void onFileExternalChange(FileImpl fileImpl) {
        DeepReparsingUtils.reparseOnEdit(fileImpl, this);
    }

    public final CsmFile findFile(Object object) {
        if (object instanceof CharSequence) {
            return this.findFileByPath((CharSequence)object);
        }
        if (object instanceof NativeFileItem) {
            return this.findFileByItem((NativeFileItem)object);
        }
        return null;
    }

    private CsmFile findFileByPath(CharSequence charSequence) {
        File file = new File(((Object)charSequence).toString());
        APTPreprocHandler aPTPreprocHandler = null;
        if (this.getFileContainer().getPreprocState(file) == null) {
            NativeProject nativeProject;
            NativeFileItem nativeFileItem = null;
            if (this.getPlatformProject() instanceof NativeProject && (nativeProject = (NativeProject)this.getPlatformProject()) != null) {
                nativeFileItem = nativeProject.findFileItem(file);
                if (nativeFileItem == null) {
                    return null;
                }
                if (!this.acceptNativeItem(nativeFileItem)) {
                    return null;
                }
                aPTPreprocHandler = this.createPreprocHandler(nativeFileItem);
            }
            if (aPTPreprocHandler != null) {
                return this.findFile(file, false, FileImpl.FileType.UNDEFINED_FILE, aPTPreprocHandler, true, aPTPreprocHandler.getState(), nativeFileItem);
            }
        }
        return this.findFile(file, false, FileImpl.FileType.UNDEFINED_FILE, aPTPreprocHandler, true, null, null);
    }

    private CsmFile findFileByItem(NativeFileItem nativeFileItem) {
        File file = nativeFileItem.getFile().getAbsoluteFile();
        APTPreprocHandler aPTPreprocHandler = null;
        if (this.getFileContainer().getPreprocState(file) == null) {
            NativeProject nativeProject;
            if (!this.acceptNativeItem(nativeFileItem)) {
                return null;
            }
            if (this.getPlatformProject() instanceof NativeProject && (nativeProject = nativeFileItem.getNativeProject()) != null && nativeFileItem.getFile() != null) {
                aPTPreprocHandler = this.createPreprocHandler(nativeFileItem);
            }
            if (aPTPreprocHandler != null) {
                return this.findFile(file, false, FileImpl.FileType.UNDEFINED_FILE, aPTPreprocHandler, true, aPTPreprocHandler.getState(), nativeFileItem);
            }
        }
        return this.findFile(file, false, FileImpl.FileType.UNDEFINED_FILE, aPTPreprocHandler, true, null, null);
    }

    protected final FileImpl findFile(File file, boolean bl, FileImpl.FileType fileType, APTPreprocHandler aPTPreprocHandler, boolean bl2, APTPreprocHandler.State state, NativeFileItem nativeFileItem) {
        FileImpl fileImpl = this.getFile(file, bl);
        if (fileImpl == null) {
            fileImpl = this.findFileImpl(file, bl, fileType, aPTPreprocHandler, bl2, state, nativeFileItem);
        }
        return fileImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileImpl findFileImpl(File file, boolean bl, FileImpl.FileType fileType, APTPreprocHandler aPTPreprocHandler, boolean bl2, APTPreprocHandler.State state, NativeFileItem nativeFileItem) {
        APTPreprocHandler.State state2;
        FileImpl fileImpl = null;
        Object object = this.fileContainerLock;
        synchronized (object) {
            fileImpl = this.getFile(file, bl);
            if (fileImpl == null) {
                aPTPreprocHandler = aPTPreprocHandler == null ? this.getPreprocHandler(file) : aPTPreprocHandler;
                fileImpl = new FileImpl(ModelSupport.getFileBuffer(file), this, fileType, nativeFileItem);
                if (nativeFileItem != null) {
                    this.putNativeFileItem(fileImpl.getUID(), nativeFileItem);
                }
                this.putFile(file, fileImpl, state);
                if (bl2) {
                    state2 = aPTPreprocHandler == null ? null : aPTPreprocHandler.getState();
                    ParserQueue.instance().add(fileImpl, state2, ParserQueue.Position.TAIL);
                }
            }
        }
        if (fileType == FileImpl.FileType.SOURCE_FILE && !fileImpl.isSourceFile()) {
            fileImpl.setSourceFile();
        } else if (fileType == FileImpl.FileType.HEADER_FILE && !fileImpl.isHeaderFile()) {
            fileImpl.setHeaderFile();
        }
        if (state != null) {
            object = this.getFileContainer().getLock(file);
            synchronized (object) {
                state2 = this.getFileContainer().getPreprocStates(file);
                if (state2 == null || state2.isEmpty() || state2.size() == 1 && state2.iterator().next() == null) {
                    this.putPreprocState(file, state);
                }
            }
        }
        return fileImpl;
    }

    protected final FileImpl createOrFindFileImpl(FileBuffer fileBuffer, NativeFileItem nativeFileItem) {
        return this.createOrFindFileImpl((FileBuffer)fileBuffer, (NativeFileItem)nativeFileItem, (FileImpl.FileType)ProjectBase.getFileType((NativeFileItem)nativeFileItem)).fileImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileAndHandler createOrFindFileImpl(FileBuffer fileBuffer, NativeFileItem nativeFileItem, FileImpl.FileType fileType) {
        APTPreprocHandler aPTPreprocHandler = null;
        File file = fileBuffer.getFile();
        FileImpl fileImpl = this.getFile(file, true);
        if (fileImpl == null) {
            Object object = this.fileContainerLock;
            synchronized (object) {
                fileImpl = this.getFile(file, true);
                if (fileImpl == null) {
                    aPTPreprocHandler = this.createPreprocHandler(nativeFileItem);
                    assert (aPTPreprocHandler != null);
                    fileImpl = new FileImpl(fileBuffer, this, fileType, nativeFileItem);
                    this.putFile(file, fileImpl, aPTPreprocHandler.getState());
                } else {
                    this.putNativeFileItem(fileImpl.getUID(), nativeFileItem);
                }
            }
        } else {
            this.putNativeFileItem(fileImpl.getUID(), nativeFileItem);
        }
        return new FileAndHandler(fileImpl, aPTPreprocHandler);
    }

    public final FileImpl getFile(File file, boolean bl) {
        return this.getFileContainer().getFile(file, bl);
    }

    protected final void removeFile(CharSequence charSequence) {
        this.getFileContainer().removeFile(charSequence);
    }

    protected final void putFile(File file, FileImpl fileImpl, APTPreprocHandler.State state) {
        if (state != null && !state.isCleaned()) {
            state = APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)state);
        }
        this.getFileContainer().putFile(file, fileImpl, state);
    }

    protected Collection<Key> getLibrariesKeys() {
        ArrayList<Key> arrayList = new ArrayList<Key>();
        if (this.platformProject instanceof NativeProject) {
            for (NativeProject nativeProject : ((NativeProject)this.platformProject).getDependences()) {
                Key key = ProjectBase.createProjectKey(nativeProject);
                if (key == null) continue;
                arrayList.add(key);
            }
        }
        if (!this.isArtificial()) {
            for (CsmUID csmUID : LibraryManager.getInstance().getLirariesKeys(this.getUID())) {
                arrayList.add(RepositoryUtils.UIDtoKey(csmUID));
            }
        }
        return arrayList;
    }

    public Collection<CsmProject> getLibraries() {
        ArrayList<CsmProject> arrayList = new ArrayList<CsmProject>();
        if (this.platformProject instanceof NativeProject) {
            for (NativeProject object : ((NativeProject)this.platformProject).getDependences()) {
                CsmProject csmProject = this.model.findProject(object);
                if (csmProject == null) continue;
                arrayList.add(csmProject);
            }
        }
        if (!this.isArtificial()) {
            for (LibProjectImpl libProjectImpl : LibraryManager.getInstance().getLibraries((ProjectImpl)this)) {
                arrayList.add(libProjectImpl);
            }
        }
        return arrayList;
    }

    public final List<ProjectBase> getDependentProjects() {
        ArrayList<ProjectBase> arrayList = new ArrayList<ProjectBase>();
        for (CsmProject csmProject : this.model.projects()) {
            if (!(csmProject instanceof ProjectBase) || !csmProject.getLibraries().contains(this)) continue;
            arrayList.add((ProjectBase)csmProject);
        }
        return arrayList;
    }

    public final CsmClass getDummyForUnresolved(CharSequence[] charSequenceArray, CsmFile csmFile, int n) {
        if (Diagnostic.needStatistics()) {
            Diagnostic.onUnresolvedError(charSequenceArray, csmFile, n);
        }
        return this.getUnresolved().getDummyForUnresolved(charSequenceArray);
    }

    public final CsmClass getDummyForUnresolved(CharSequence charSequence) {
        return this.getUnresolved().getDummyForUnresolved(charSequence);
    }

    public final CsmNamespace getUnresolvedNamespace() {
        return this.getUnresolved().getUnresolvedNamespace();
    }

    public final CsmFile getUnresolvedFile() {
        return this.getUnresolved().getUnresolvedFile();
    }

    private synchronized Unresolved getUnresolved() {
        if (this.unresolved == null) {
            this.unresolved = new Unresolved(this);
        }
        return this.unresolved;
    }

    public final boolean isValid() {
        return this.platformProject != null && !this.disposing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisposed() {
        this.disposing = true;
        Object object = this.initializationTaskLock;
        synchronized (object) {
            if (this.initializationTask != null) {
                this.initializationTask.cancel();
                this.initializationTask = null;
            }
        }
        this.unregisterProjectListeners();
        ParserQueue.instance().removeAll(this);
    }

    public final boolean isDisposing() {
        return this.disposing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose(boolean bl) {
        long l = 0L;
        if (TraceFlags.TIMING) {
            System.err.printf("\n\nProject %s: disposing...\n", this.name);
            l = System.currentTimeMillis();
        }
        this.setDisposed();
        try {
            this.disposeLock.writeLock().lock();
            ProjectSettingsValidator projectSettingsValidator = new ProjectSettingsValidator(this);
            projectSettingsValidator.storeSettings();
            this.getUnresolved().dispose();
            RepositoryUtils.closeUnit(this.getUID(), this.getRequiredUnits(), bl);
            this.weakClassifierContainer = null;
            this.weakDeclarationContainer = null;
            this.weakFileContainer = null;
            this.weakGraphContainer = null;
            this.platformProject = null;
            this.unresolved = null;
            this.uid = null;
        }
        finally {
            this.disposeLock.writeLock().unlock();
        }
        if (TraceFlags.TIMING) {
            l = System.currentTimeMillis() - l;
            System.err.printf("Project %s: disposing took %d ms\n", this.name, l);
        }
    }

    protected final Set<String> getRequiredUnits() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Key key : this.getLibrariesKeys()) {
            hashSet.add(((Object)key.getUnit()).toString());
        }
        return hashSet;
    }

    private NamespaceImpl _getGlobalNamespace() {
        NamespaceImpl namespaceImpl = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(this.globalNamespaceUID);
        if (namespaceImpl == null) {
            DiagnosticExceptoins.register(new IllegalStateException("Failed to get global namespace by key " + this.globalNamespaceUID));
        }
        return namespaceImpl != null ? namespaceImpl : this.FAKE_GLOBAL_NAMESPACE;
    }

    private NamespaceImpl _getNamespace(CharSequence charSequence) {
        charSequence = CharSequenceKey.create((CharSequence)charSequence);
        CsmUID<CsmNamespace> csmUID = this.namespaces.get(charSequence);
        NamespaceImpl namespaceImpl = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(csmUID);
        return namespaceImpl;
    }

    private void _registerNamespace(NamespaceImpl namespaceImpl) {
        assert (namespaceImpl != null);
        CharSequence charSequence = namespaceImpl.getQualifiedName();
        assert (charSequence instanceof TinyCharSequence);
        CsmUID<NamespaceImpl> csmUID = RepositoryUtils.put(namespaceImpl);
        assert (csmUID != null);
        this.namespaces.put(charSequence, csmUID);
    }

    private void _unregisterNamespace(NamespaceImpl namespaceImpl) {
        assert (namespaceImpl != null);
        assert (!namespaceImpl.isGlobal());
        CharSequence charSequence = namespaceImpl.getQualifiedName();
        assert (charSequence instanceof TinyCharSequence);
        CsmUID<CsmNamespace> csmUID = this.namespaces.remove(charSequence);
        assert (csmUID != null);
        RepositoryUtils.remove(csmUID);
    }

    protected final ModelImpl getModel() {
        return this.model;
    }

    public void onFileEditStart(FileBuffer fileBuffer, NativeFileItem nativeFileItem) {
    }

    public void onFileEditEnd(FileBuffer fileBuffer, NativeFileItem nativeFileItem) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CsmUID<CsmProject> getUID() {
        CsmUID<CsmProject> csmUID = this.uid;
        if (csmUID == null) {
            ProjectBase projectBase = this;
            synchronized (projectBase) {
                if (this.uid == null) {
                    this.uid = csmUID = UIDUtilities.createProjectUID(this);
                }
            }
        }
        return this.uid;
    }

    public boolean isStable(CsmFile csmFile) {
        if (this.status == Status.Ready && !this.disposing) {
            return !ParserQueue.instance().hasFiles(this, (FileImpl)csmFile);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onParseFinish(boolean bl) {
        Object object = this.waitParseLock;
        synchronized (object) {
            this.waitParseLock.notifyAll();
        }
        try {
            this.disposeLock.readLock().lock();
            if (!this.disposing) {
                this.fixFakeRegistration(bl);
            }
        }
        catch (Exception exception) {
            DiagnosticExceptoins.register(exception);
        }
        finally {
            this.disposeLock.readLock().unlock();
            ProjectComponent.setStable(this.declarationsSorageKey);
            ProjectComponent.setStable(this.fileContainerKey);
            ProjectComponent.setStable(this.graphStorageKey);
            ProjectComponent.setStable(this.classifierStorageKey);
            ProjectBase.checkStates(this, bl);
            if (!bl) {
                ParseFinishNotificator.onParseFinish(this);
            }
        }
        if (TraceFlags.PARSE_STATISTICS) {
            ParseStatistics.getInstance().printResults(this);
            ParseStatistics.getInstance().clear(this);
        }
    }

    private static void checkStates(ProjectBase projectBase, boolean bl) {
    }

    private int getNumberThreads() {
        int n = Integer.getInteger("cnd.modelimpl.parser.threads", Runtime.getRuntime().availableProcessors());
        n = Math.min(n, 4);
        return Math.max(n, 1);
    }

    public final void fixFakeRegistration(boolean bl) {
        Collection<CsmUID<CsmFile>> collection = this.getAllFilesUID();
        CountDownLatch countDownLatch = new CountDownLatch(collection.size());
        RequestProcessor requestProcessor = new RequestProcessor("Fix registration", this.getNumberThreads());
        for (CsmUID<CsmFile> csmUID : collection) {
            MyRunnable myRunnable = new MyRunnable(countDownLatch, csmUID, bl);
            requestProcessor.post((Runnable)myRunnable);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public final void onLibParseFinish() {
        this.onParseFinish(true);
    }

    public final Collection<CsmFile> getAllFiles() {
        return this.getFileContainer().getFiles();
    }

    public final Collection<CsmUID<CsmFile>> getAllFilesUID() {
        return this.getFileContainer().getFilesUID();
    }

    public final Collection<FileImpl> getAllFileImpls() {
        return this.getFileContainer().getFileImpls();
    }

    public final Collection<CsmFile> getSourceFiles() {
        ArrayList arrayList = new ArrayList();
        for (FileImpl fileImpl : this.getAllFileImpls()) {
            if (!fileImpl.isSourceFile()) continue;
            arrayList.add(fileImpl.getUID());
        }
        return new LazyCsmCollection(arrayList, TraceFlags.SAFE_UID_ACCESS);
    }

    public final Collection<CsmFile> getHeaderFiles() {
        ArrayList arrayList = new ArrayList();
        for (FileImpl fileImpl : this.getAllFileImpls()) {
            if (fileImpl.isSourceFile()) continue;
            arrayList.add(fileImpl.getUID());
        }
        return new LazyCsmCollection(arrayList, TraceFlags.SAFE_UID_ACCESS);
    }

    public final long getMemoryUsageEstimation() {
        return this.getFileContainer().getSize();
    }

    public final String toString() {
        return ((Object)this.getName()).toString() + ' ' + this.getClass().getName() + " @" + this.hashCode() + ":" + super.hashCode();
    }

    private StartEntryInfo getStartEntryInfo(APTPreprocHandler aPTPreprocHandler, APTPreprocHandler.State state) {
        NativeFileItem nativeFileItem;
        FileImpl fileImpl;
        StartEntry startEntry = APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state);
        ProjectBase projectBase = ProjectBase.getStartProject(startEntry);
        FileImpl fileImpl2 = fileImpl = projectBase == null ? null : projectBase.getFile(new File(((Object)startEntry.getStartFile()).toString()), false);
        if (fileImpl != null && (nativeFileItem = fileImpl.getNativeFileItem()) != null && nativeFileItem.getFile() != null) {
            aPTPreprocHandler = projectBase.createPreprocHandler(nativeFileItem);
        }
        return new StartEntryInfo(aPTPreprocHandler, projectBase, fileImpl);
    }

    private APTPreprocHandler restorePreprocHandler(File file, APTPreprocHandler aPTPreprocHandler, APTPreprocHandler.State state) {
        assert (state != null);
        assert (state.isCleaned());
        List list = APTHandlersSupport.extractIncludeStack((APTPreprocHandler.State)state);
        assert (list != null);
        if (list.isEmpty()) {
            if (TRACE_PP_STATE_OUT) {
                System.err.println("stack is empty; return default for " + file);
            }
            return this.getStartEntryInfo((APTPreprocHandler)aPTPreprocHandler, (APTPreprocHandler.State)state).preprocHandler;
        }
        if (TRACE_PP_STATE_OUT) {
            System.err.println("restoring for " + file);
        }
        assert (!list.isEmpty()) : "state of stack is " + list;
        Stack<APTIncludeHandler.IncludeInfo> stack = ProjectBase.reverse(list);
        StartEntryInfo startEntryInfo = this.getStartEntryInfo(aPTPreprocHandler, state);
        FileImpl fileImpl = startEntryInfo.csmFile;
        ProjectBase projectBase = startEntryInfo.startProject;
        aPTPreprocHandler = startEntryInfo.preprocHandler;
        APTFile aPTFile = null;
        try {
            aPTFile = fileImpl == null ? null : this.getAPTLight(fileImpl);
        }
        catch (IOException iOException) {
            System.err.println("can't restore preprocessor state for " + file + "\nreason: " + iOException.getMessage());
            DiagnosticExceptoins.register(iOException);
        }
        boolean bl = false;
        if (aPTFile != null) {
            long l = REMEMBER_RESTORED ? System.currentTimeMillis() : 0L;
            int n = stack.size();
            APTRestorePreprocStateWalker aPTRestorePreprocStateWalker = new APTRestorePreprocStateWalker(projectBase, aPTFile, fileImpl, aPTPreprocHandler, stack, ((Object)FileContainer.getFileKey(file, false)).toString(), fileImpl.getAPTCacheEntry(aPTPreprocHandler));
            aPTRestorePreprocStateWalker.visit();
            if (aPTPreprocHandler.isValid()) {
                if (REMEMBER_RESTORED) {
                    if (testRestoredFiles == null) {
                        testRestoredFiles = new ArrayList<String>();
                    }
                    FileImpl fileImpl2 = this.getFile(file, false);
                    assert (fileImpl2 != null);
                    String string = file.getAbsolutePath() + " [" + (fileImpl2.isHeaderFile() ? "H" : (fileImpl2.isSourceFile() ? "S" : "U")) + "]";
                    l = System.currentTimeMillis() - l;
                    string = string + " within " + l + "ms" + " stack " + n + " elems";
                    System.err.println("#" + testRestoredFiles.size() + " restored: " + string);
                    testRestoredFiles.add(string);
                }
                if (TRACE_PP_STATE_OUT) {
                    System.err.println("after restoring " + aPTPreprocHandler);
                }
                bl = true;
            }
        }
        if (!bl) {
            if (projectBase == null) {
                projectBase = this;
            }
            aPTPreprocHandler = projectBase.createDefaultPreprocHandler(file);
        }
        return aPTPreprocHandler;
    }

    private NativeProject findNativeProjectHolder(Set<ProjectBase> set) {
        NativeProject nativeProject;
        block1: {
            set.add(this);
            nativeProject = ModelSupport.getNativeProject(this.getPlatformProject());
            if (nativeProject != null) break block1;
            List<ProjectBase> list = this.getDependentProjects();
            for (ProjectBase projectBase : list) {
                if (!set.contains(projectBase) && (nativeProject = projectBase.findNativeProjectHolder(set)) != null) break;
            }
        }
        return nativeProject;
    }

    private APTPreprocHandler createDefaultPreprocHandler(File file) {
        NativeProject nativeProject = this.findNativeProjectHolder(new HashSet<ProjectBase>(10));
        APTPreprocHandler aPTPreprocHandler = null;
        if (nativeProject != null) {
            DefaultFileItem defaultFileItem = new DefaultFileItem(nativeProject, file.getAbsolutePath());
            aPTPreprocHandler = this.createPreprocHandler(defaultFileItem);
        } else {
            aPTPreprocHandler = this.createEmptyPreprocHandler(file);
        }
        assert (aPTPreprocHandler != null) : "failed creating default ppState for " + file;
        return aPTPreprocHandler;
    }

    private static <T> Stack<T> reverse(List<T> list) {
        Stack<T> stack = new Stack<T>();
        for (int i = list.size() - 1; i >= 0; --i) {
            T t = list.get(i);
            stack.push(t);
        }
        return stack;
    }

    public static NativeFileItem getCompiledFileItem(FileImpl fileImpl) {
        NativeFileItem nativeFileItem = null;
        ProjectBase projectBase = fileImpl.getProjectImpl(true);
        if (projectBase != null) {
            APTPreprocHandler.State state = projectBase.getPreprocState(fileImpl);
            FileImpl fileImpl2 = ProjectBase.getStartFile(state);
            nativeFileItem = fileImpl2 != null ? fileImpl2.getNativeFileItem() : null;
        }
        return nativeFileItem;
    }

    public static FileImpl getStartFile(APTPreprocHandler.State state) {
        StartEntry startEntry = APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state);
        ProjectBase projectBase = ProjectBase.getStartProject(startEntry);
        FileImpl fileImpl = projectBase == null ? null : projectBase.getFile(new File(((Object)startEntry.getStartFile()).toString()), false);
        return fileImpl;
    }

    public static ProjectBase getStartProject(APTPreprocHandler.State state) {
        return ProjectBase.getStartProject(APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state));
    }

    public static ProjectBase getStartProject(StartEntry startEntry) {
        if (startEntry == null) {
            return null;
        }
        Key key = startEntry.getStartFileProject();
        ProjectBase projectBase = (ProjectBase)RepositoryUtils.get(key);
        return projectBase;
    }

    public final APTFile getAPTLight(CsmFile csmFile) throws IOException {
        APTFile aPTFile = null;
        aPTFile = APTDriver.getInstance().findAPTLight((APTFileBuffer)((FileImpl)csmFile).getBuffer());
        return aPTFile;
    }

    public final GraphContainer getGraph() {
        return this.getGraphStorage();
    }

    public static List<String> testGetRestoredFiles() {
        return testRestoredFiles;
    }

    public void write(DataOutput dataOutput) throws IOException {
        assert (dataOutput != null);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        assert (uIDObjectFactory != null);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        uIDObjectFactory.writeUID(this.globalNamespaceUID, dataOutput);
        uIDObjectFactory.writeStringToUIDMap(this.namespaces, dataOutput, false);
        ProjectComponent.writeKey(this.fileContainerKey, dataOutput);
        ProjectComponent.writeKey(this.declarationsSorageKey, dataOutput);
        ProjectComponent.writeKey(this.graphStorageKey, dataOutput);
        ProjectComponent.writeKey(this.classifierStorageKey, dataOutput);
        PersistentUtils.writeUTF(this.uniqueName, dataOutput);
    }

    protected ProjectBase(DataInput dataInput) throws IOException {
        this.setStatus(Status.Restored);
        assert (dataInput != null);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        assert (uIDObjectFactory != null) : "default UID factory can not be bull";
        this.name = PersistentUtils.readUTF(dataInput, ProjectNameCache.getManager());
        assert (this.name != null) : "project name can not be null";
        this.globalNamespaceUID = uIDObjectFactory.readUID(dataInput);
        assert (this.globalNamespaceUID != null) : "globalNamespaceUID can not be null";
        uIDObjectFactory.readStringToUIDMap(this.namespaces, dataInput, QualifiedNameCache.getManager());
        this.fileContainerKey = ProjectComponent.readKey(dataInput);
        assert (this.fileContainerKey != null) : "fileContainerKey can not be null";
        this.declarationsSorageKey = ProjectComponent.readKey(dataInput);
        assert (this.declarationsSorageKey != null) : "declarationsSorageKey can not be null";
        this.graphStorageKey = ProjectComponent.readKey(dataInput);
        assert (this.graphStorageKey != null) : "graphStorageKey can not be null";
        this.classifierStorageKey = ProjectComponent.readKey(dataInput);
        assert (this.classifierStorageKey != null) : "classifierStorageKey can not be null";
        this.uniqueName = PersistentUtils.readUTF(dataInput, DefaultCache.getManager());
        assert (this.uniqueName != null) : "uniqueName can not be null";
        this.uniqueName = ProjectNameCache.getManager().getString(this.uniqueName);
        this.model = (ModelImpl)CsmModelAccessor.getModel();
        this.FAKE_GLOBAL_NAMESPACE = new NamespaceImpl(this, true);
    }

    DeclarationContainer getDeclarationsSorage() {
        DeclarationContainer declarationContainer = null;
        WeakReference<DeclarationContainer> weakReference = null;
        if (TraceFlags.USE_WEAK_MEMORY_CACHE && this.isValid() && (weakReference = this.weakDeclarationContainer) != null && (declarationContainer = (DeclarationContainer)weakReference.get()) != null) {
            return declarationContainer;
        }
        declarationContainer = (DeclarationContainer)RepositoryUtils.get(this.declarationsSorageKey);
        if (declarationContainer == null && this.isValid()) {
            DiagnosticExceptoins.register(new IllegalStateException("Failed to get DeclarationsSorage by key " + this.declarationsSorageKey));
        }
        if (TraceFlags.USE_WEAK_MEMORY_CACHE && declarationContainer != null && this.weakDeclarationContainer != null) {
            this.weakDeclarationContainer = new WeakReference<DeclarationContainer>(declarationContainer);
        }
        return declarationContainer != null ? declarationContainer : DeclarationContainer.empty();
    }

    FileContainer getFileContainer() {
        FileContainer fileContainer = null;
        WeakReference<FileContainer> weakReference = null;
        if (TraceFlags.USE_WEAK_MEMORY_CACHE && this.isValid() && (weakReference = this.weakFileContainer) != null && (fileContainer = (FileContainer)weakReference.get()) != null) {
            return fileContainer;
        }
        fileContainer = (FileContainer)RepositoryUtils.get(this.fileContainerKey);
        if (fileContainer == null && this.isValid()) {
            DiagnosticExceptoins.register(new IllegalStateException("Failed to get FileContainer by key " + this.fileContainerKey));
        }
        if (TraceFlags.USE_WEAK_MEMORY_CACHE && fileContainer != null && this.weakFileContainer != null) {
            this.weakFileContainer = new WeakReference<FileContainer>(fileContainer);
        }
        return fileContainer != null ? fileContainer : FileContainer.empty();
    }

    public final GraphContainer getGraphStorage() {
        GraphContainer graphContainer = null;
        WeakReference<GraphContainer> weakReference = null;
        if (TraceFlags.USE_WEAK_MEMORY_CACHE && this.isValid() && (weakReference = this.weakGraphContainer) != null && (graphContainer = (GraphContainer)weakReference.get()) != null) {
            return graphContainer;
        }
        graphContainer = (GraphContainer)RepositoryUtils.get(this.graphStorageKey);
        if (graphContainer == null && this.isValid()) {
            DiagnosticExceptoins.register(new IllegalStateException("Failed to get GraphContainer by key " + this.graphStorageKey));
        }
        if (TraceFlags.USE_WEAK_MEMORY_CACHE && graphContainer != null && this.weakGraphContainer != null) {
            this.weakGraphContainer = new WeakReference<GraphContainer>(graphContainer);
        }
        return graphContainer != null ? graphContainer : GraphContainer.empty();
    }

    final ClassifierContainer getClassifierSorage() {
        ClassifierContainer classifierContainer = null;
        WeakReference<ClassifierContainer> weakReference = null;
        if (TraceFlags.USE_WEAK_MEMORY_CACHE && this.isValid() && (weakReference = this.weakClassifierContainer) != null && (classifierContainer = (ClassifierContainer)weakReference.get()) != null) {
            return classifierContainer;
        }
        classifierContainer = (ClassifierContainer)RepositoryUtils.get(this.classifierStorageKey);
        if (classifierContainer == null && this.isValid()) {
            DiagnosticExceptoins.register(new IllegalStateException("Failed to get ClassifierSorage by key " + this.classifierStorageKey));
        }
        if (TraceFlags.USE_WEAK_MEMORY_CACHE && classifierContainer != null && this.weakClassifierContainer != null) {
            this.weakClassifierContainer = new WeakReference<ClassifierContainer>(classifierContainer);
        }
        return classifierContainer != null ? classifierContainer : ClassifierContainer.empty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyRunnable
    implements Runnable {
        private final CountDownLatch countDownLatch;
        private final CsmUID<CsmFile> file;
        private final boolean libsAlreadyParsed;

        private MyRunnable(CountDownLatch countDownLatch, CsmUID<CsmFile> csmUID, boolean bl) {
            this.countDownLatch = countDownLatch;
            this.file = csmUID;
            this.libsAlreadyParsed = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.file == null) {
                    return;
                }
                FileImpl fileImpl = (FileImpl)UIDCsmConverter.UIDtoFile(this.file);
                CndUtils.assertTrueInConsole((fileImpl != null ? 1 : 0) != 0, (String)("no deref file for " + this.file));
                if (fileImpl == null) {
                    return;
                }
                Thread.currentThread().setName("Fix registration " + this.file);
                fileImpl.onProjectParseFinished(this.libsAlreadyParsed);
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Status {
        Initial,
        Restored,
        AddingFiles,
        Validating,
        Ready;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class DefaultFileItem
    implements NativeFileItem {
        private NativeProject project;
        private String absolutePath;

        public DefaultFileItem(NativeProject nativeProject, String string) {
            this.project = nativeProject;
            this.absolutePath = string;
        }

        public DefaultFileItem(NativeFileItem nativeFileItem) {
            this.project = nativeFileItem.getNativeProject();
            this.absolutePath = nativeFileItem.getFile().getAbsolutePath();
        }

        public static NativeFileItem toDefault(NativeFileItem nativeFileItem) {
            if (!(nativeFileItem instanceof DefaultFileItem)) {
                nativeFileItem = new DefaultFileItem(nativeFileItem);
            }
            return nativeFileItem;
        }

        public List<String> getUserMacroDefinitions() {
            if (this.project != null) {
                return this.project.getUserMacroDefinitions();
            }
            return Collections.emptyList();
        }

        public List<String> getUserIncludePaths() {
            if (this.project != null) {
                return this.project.getUserIncludePaths();
            }
            return Collections.emptyList();
        }

        public List<String> getSystemMacroDefinitions() {
            if (this.project != null) {
                return this.project.getSystemMacroDefinitions();
            }
            return Collections.emptyList();
        }

        public List<String> getSystemIncludePaths() {
            if (this.project != null) {
                return this.project.getSystemIncludePaths();
            }
            return Collections.emptyList();
        }

        public NativeProject getNativeProject() {
            return this.project;
        }

        public File getFile() {
            return new File(this.absolutePath);
        }

        public NativeFileItem.Language getLanguage() {
            return NativeFileItem.Language.C_HEADER;
        }

        public NativeFileItem.LanguageFlavor getLanguageFlavor() {
            return NativeFileItem.LanguageFlavor.GENERIC;
        }

        public boolean isExcluded() {
            return false;
        }

        public String toString() {
            return this.absolutePath;
        }
    }

    private static class StartEntryInfo {
        public final APTPreprocHandler preprocHandler;
        public final ProjectBase startProject;
        public final FileImpl csmFile;

        public StartEntryInfo(APTPreprocHandler aPTPreprocHandler, ProjectBase projectBase, FileImpl fileImpl) {
            this.preprocHandler = aPTPreprocHandler;
            this.startProject = projectBase;
            this.csmFile = fileImpl;
        }
    }

    private static class FileAndHandler {
        public FileImpl fileImpl;
        public APTPreprocHandler preprocHandler;

        public FileAndHandler(FileImpl fileImpl, APTPreprocHandler aPTPreprocHandler) {
            this.fileImpl = fileImpl;
            this.preprocHandler = aPTPreprocHandler;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ComparisonResult {
        BETTER,
        SAME,
        WORSE;

    }
}

