/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFriendClass;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.ClassForwardDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.core.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FriendClassImpl
extends OffsetableDeclarationBase<CsmFriendClass>
implements CsmFriendClass,
CsmTemplate {
    private final CharSequence name;
    private final CharSequence[] nameParts;
    private final CsmUID<CsmClass> parentUID;
    private final CsmUID<CsmClassForwardDeclaration> classForwardUID;
    private CsmUID<CsmClass> friendUID;
    private TemplateDescriptor templateDescriptor = null;

    public FriendClassImpl(AST aST, CsmClassForwardDeclaration csmClassForwardDeclaration, FileImpl fileImpl, CsmClass csmClass, boolean bl) {
        super(aST, fileImpl);
        this.parentUID = UIDs.get((Object)csmClass);
        AST aST2 = AstUtil.findSiblingOfType(aST, 288);
        this.name = aST2 == null ? CharSequenceKey.empty() : QualifiedNameCache.getManager().getString(AstRenderer.getQualifiedName(aST2));
        this.nameParts = this.initNameParts(aST2);
        this.classForwardUID = UIDCsmConverter.declarationToUID(csmClassForwardDeclaration);
        AST aST3 = AstUtil.findSiblingOfType(aST, 31);
        if (aST3 != null) {
            List<CsmTemplateParameter> list = TemplateUtils.getTemplateParameters(aST3, fileImpl, (CsmScope)csmClass, bl);
            String string = "<" + TemplateUtils.getClassSpecializationSuffix(aST3, null) + ">";
            this.setTemplateDescriptor(list, string, bl);
        }
        if (bl) {
            this.registerInProject();
        } else {
            Utils.setSelfUID(this);
        }
    }

    private void registerInProject() {
        CsmProject csmProject = this.getContainingFile().getProject();
        if (csmProject instanceof ProjectBase) {
            ((ProjectBase)csmProject).registerDeclaration(this);
        }
    }

    public CsmClass getContainingClass() {
        return (CsmClass)this.parentUID.getObject();
    }

    public CsmScope getScope() {
        return this.getContainingClass();
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        CsmClass csmClass = this.getContainingClass();
        CharSequence charSequence = csmClass.getQualifiedName();
        if (charSequence != null && charSequence.length() > 0) {
            return CharSequenceKey.create((CharSequence)(((Object)charSequence).toString() + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.CLASS_FRIEND_DECLARATION;
    }

    public CsmClass getReferencedClass() {
        return this.getReferencedClass(null);
    }

    public CsmClass getReferencedClass(Resolver resolver) {
        CsmClassForwardDeclaration csmClassForwardDeclaration;
        CsmClass csmClass = UIDCsmConverter.UIDtoClass(this.friendUID);
        if (!CsmBaseUtilities.isValid((CsmObject)csmClass) || ForwardClass.isForwardClass((CsmDeclaration)csmClass)) {
            csmClass = null;
            csmClassForwardDeclaration = UIDCsmConverter.UIDtoCsmObject(this.classForwardUID);
            if (CsmBaseUtilities.isValid((CsmObject)csmClassForwardDeclaration)) {
                csmClass = csmClassForwardDeclaration.getCsmClass();
            }
            this.friendUID = UIDCsmConverter.declarationToUID(csmClass);
        }
        if ((!CsmBaseUtilities.isValid((CsmObject)csmClass) || ForwardClass.isForwardClass((CsmDeclaration)csmClass)) && CsmKindUtilities.isClass((CsmObject)(csmClassForwardDeclaration = this.resolve(resolver)))) {
            csmClass = (CsmClass)csmClassForwardDeclaration;
            this.friendUID = UIDCsmConverter.objectToUID(csmClass);
        }
        return csmClass;
    }

    private CharSequence[] initNameParts(AST aST) {
        if (aST != null) {
            return AstRenderer.getNameTokens(aST);
        }
        return new CharSequence[0];
    }

    private CsmObject resolve(Resolver resolver) {
        CsmObject csmObject = ResolverFactory.createResolver((CsmOffsetable)this, resolver).resolve(this.nameParts, 4);
        if (csmObject == null) {
            csmObject = ((ProjectBase)this.getContainingFile().getProject()).getDummyForUnresolved(this.nameParts, this.getContainingFile(), this.getStartOffset());
        }
        return csmObject;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.unregisterInProject();
    }

    private void unregisterInProject() {
        CsmClassForwardDeclaration csmClassForwardDeclaration = UIDCsmConverter.UIDtoCsmObject(this.classForwardUID);
        if (csmClassForwardDeclaration instanceof ClassForwardDeclarationImpl) {
            ((ClassForwardDeclarationImpl)csmClassForwardDeclaration).dispose();
        }
        ((ProjectBase)this.getContainingFile().getProject()).unregisterDeclaration(this);
        this.cleanUID();
    }

    private void setTemplateDescriptor(List<CsmTemplateParameter> list, String string, boolean bl) {
        this.templateDescriptor = new TemplateDescriptor(list, string, bl);
    }

    public boolean isTemplate() {
        return this.templateDescriptor != null;
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        return this.templateDescriptor != null ? this.templateDescriptor.getTemplateParameters() : Collections.emptyList();
    }

    public CharSequence getDisplayName() {
        return this.templateDescriptor != null ? CharSequenceKey.create((CharSequence)(((Object)this.getName()).toString() + this.templateDescriptor.getTemplateSuffix())) : this.getName();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        PersistentUtils.writeStrings(this.nameParts, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.parentUID, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.friendUID, dataOutput);
        PersistentUtils.writeTemplateDescriptor(this.templateDescriptor, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.classForwardUID, dataOutput);
    }

    public FriendClassImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = PersistentUtils.readUTF(dataInput, QualifiedNameCache.getManager());
        assert (this.name != null);
        this.nameParts = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.parentUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        this.friendUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        this.templateDescriptor = PersistentUtils.readTemplateDescriptor(dataInput);
        this.classForwardUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

