/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jdesktop.application.ResourceConverter;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.swingapp.ActionManager;
import org.netbeans.modules.swingapp.ActionPropertyEditorPanel;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.DesignResourceMap;
import org.netbeans.modules.swingapp.DisabledEditorPanel;
import org.netbeans.modules.swingapp.JumpToOrCreateNewAction;
import org.netbeans.modules.swingapp.ProxyAction;
import org.netbeans.modules.swingapp.ResourceUtils;
import org.netbeans.modules.swingapp.ResourceValueImpl;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionEditor
extends PropertyEditorSupport
implements FormAwareEditor,
XMLPropertyEditor,
ExPropertyEditor,
VetoableChangeListener {
    private List<String> actionNames = new ArrayList<String>();
    private FormModel formModel;
    private RADProperty formProperty;
    private RADComponent radComponent;
    private Map<ProxyAction.Scope, List<ProxyAction>> actionMap = new HashMap<ProxyAction.Scope, List<ProxyAction>>();
    private ActionPropertyEditorPanel panel;
    private ProxyAction action;
    private boolean scannedOnce = false;
    private FileObject sourceFile;
    private String GLOBAL_SUFFIX = "(global)";
    private static Action jumpToSourceAction;
    private static final String CODE_MARK_END = "*/\n\\0";
    private static final String CODE_MARK_LINE_COMMENT = "*/\n\\1";
    private static final String CODE_MARK_VARIABLE_SUBST = "*/\n\\2";
    private PropertyEnv env;

    public ActionEditor(FileObject fileObject) {
        this();
        this.sourceFile = fileObject;
    }

    public ActionEditor() {
        this.actionMap.put(ProxyAction.Scope.Application, new ArrayList());
        this.actionMap.put(ProxyAction.Scope.Form, new ArrayList());
    }

    @Override
    public String getJavaInitializationString() {
        if (!this.isAppFramework()) {
            return super.getJavaInitializationString();
        }
        return CODE_MARK_VARIABLE_SUBST + AppFrameworkSupport.getActionMapCode(this.getSourceFile()) + CODE_MARK_VARIABLE_SUBST + ActionMap.class.getName() + CODE_MARK_VARIABLE_SUBST + "actionMap" + CODE_MARK_LINE_COMMENT + "NOI18N" + CODE_MARK_END + ".get(\"" + this.action.getId() + "\")";
    }

    public void setContext(FormModel formModel, FormProperty formProperty) {
        this.formModel = formModel;
        ActionManager.registerFormModel(formModel, this.getSourceFile());
        this.formProperty = (RADProperty)formProperty;
        this.radComponent = this.formProperty.getRADComponent();
        FormEditor formEditor = FormEditor.getFormEditor((FormModel)formModel);
        if (formEditor != null) {
            if (jumpToSourceAction == null) {
                jumpToSourceAction = new JumpToOrCreateNewAction();
            }
            formEditor.registerDefaultComponentAction(jumpToSourceAction);
        }
    }

    public void updateFormVersionLevel() {
        this.formModel.raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
    }

    private String getComponentName() {
        if (this.radComponent == null) {
            return null;
        }
        return this.radComponent.getName();
    }

    @Override
    public Component getCustomEditor() {
        if (!this.isAppFramework()) {
            return new DisabledEditorPanel();
        }
        if (this.panel == null) {
            this.panel = new ActionPropertyEditorPanel((FormProperty)this.formProperty, this.getSourceFile());
            this.panel.addPropertyChangeListener("action", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ActionEditor.this.setValue(ActionEditor.this.panel.getSelectedAction());
                }
            });
        }
        FileObject fileObject = this.getSourceFile();
        HashMap<ProxyAction.Scope, String> hashMap = new HashMap<ProxyAction.Scope, String>();
        this.scanForActions();
        hashMap.put(ProxyAction.Scope.Application, AppFrameworkSupport.getApplicationClassName(fileObject));
        hashMap.put(ProxyAction.Scope.Form, AppFrameworkSupport.getClassNameForFile(fileObject));
        this.panel.resetFields();
        if (this.action != null) {
            ActionManager.initActionFromSource(this.action, this.sourceFile);
        }
        this.panel.updatePanel(this.actionMap, this.action, hashMap, this.getComponentName(), fileObject);
        this.panel.setMode(ActionPropertyEditorPanel.Mode.Form);
        this.panel.attachEnv(this.env);
        return this.panel;
    }

    @Override
    public boolean supportsCustomEditor() {
        if (!this.isAppFramework()) {
            return super.supportsCustomEditor();
        }
        return true;
    }

    @Override
    public String getAsText() {
        if (!this.isAppFramework()) {
            return null;
        }
        if (this.action == null) {
            return "null";
        }
        return this.action.getId();
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if (!this.isAppFramework()) {
            return;
        }
        if ("null".equals(string)) {
            this.setValue(null);
            return;
        }
        for (List<ProxyAction> list : this.actionMap.values()) {
            for (ProxyAction proxyAction : list) {
                if (proxyAction == null) continue;
                if (proxyAction.getId().equals(string)) {
                    this.setValue(proxyAction);
                    return;
                }
                if (string == null || !string.endsWith(this.GLOBAL_SUFFIX) || !proxyAction.isAppWide()) continue;
                String string2 = string.substring(0, string.length() - this.GLOBAL_SUFFIX.length());
                if (!proxyAction.getId().equals(string2)) continue;
                this.setValue(proxyAction);
                return;
            }
        }
        this.setValue(null);
    }

    @Override
    public Object getValue() {
        if (!this.isAppFramework()) {
            return super.getValue();
        }
        return this.action;
    }

    @Override
    public void setValue(Object object) {
        if (!this.isAppFramework()) {
            super.setValue(object);
            return;
        }
        if (object instanceof ProxyAction) {
            ProxyAction proxyAction = this.action;
            this.action = (ProxyAction)object;
            ActionManager actionManager = ActionManager.getActionManager(this.getSourceFile());
            this.action.setResourceMap(this.getResourceMapForAction(this.action));
            if (!ActionManager.actionsMatch(proxyAction, this.action)) {
                if (proxyAction != null) {
                    actionManager.removeRADComponent(proxyAction, this.radComponent);
                }
                actionManager.addRADComponent(this.action, this.radComponent);
            }
        } else {
            ProxyAction proxyAction = this.action;
            this.action = null;
            ActionManager.getActionManager(this.getSourceFile()).removeRADComponent(proxyAction, this.radComponent);
        }
    }

    @Override
    public String[] getTags() {
        if (!this.isAppFramework()) {
            return null;
        }
        this.scanForActions();
        return this.actionNames.toArray(new String[0]);
    }

    private void scanForActions() {
        this.actionMap.clear();
        ArrayList<ProxyAction> arrayList = new ArrayList<ProxyAction>();
        ArrayList<ProxyAction> arrayList2 = new ArrayList<ProxyAction>();
        this.actionMap.put(ProxyAction.Scope.Application, arrayList);
        this.actionMap.put(ProxyAction.Scope.Form, arrayList2);
        arrayList.add(null);
        this.actionNames.clear();
        this.actionNames.add("null");
        List<ProxyAction> list = this.getClassActions();
        for (ProxyAction proxyAction : list) {
            proxyAction.setAppWide(false);
            arrayList2.add(proxyAction);
            this.actionNames.add(proxyAction.getId());
        }
        list = this.getApplicationActions();
        for (ProxyAction proxyAction : list) {
            proxyAction.setAppWide(true);
            arrayList.add(proxyAction);
            this.actionNames.add(proxyAction.getId() + this.GLOBAL_SUFFIX);
        }
        this.scannedOnce = true;
    }

    private List<ProxyAction> getClassActions() {
        return ActionManager.getActions(this.getSourceFile(), !this.scannedOnce);
    }

    private List<ProxyAction> getApplicationActions() {
        String string = AppFrameworkSupport.getApplicationClassName(this.getSourceFile());
        assert (string != null);
        FileObject fileObject = AppFrameworkSupport.getFileForClass(this.getSourceFile(), string);
        return ActionManager.getActions(fileObject, !this.scannedOnce);
    }

    private FileObject getSourceFile() {
        if (this.sourceFile == null && this.formModel != null) {
            this.sourceFile = FormEditor.getFormDataObject((FormModel)this.formModel).getPrimaryFile();
        }
        return this.sourceFile;
    }

    private DesignResourceMap getResourceMapForAction(ProxyAction proxyAction) {
        FileObject fileObject = AppFrameworkSupport.getFileForClass(this.getSourceFile(), proxyAction.getClassname());
        return ResourceUtils.getDesignResourceMap(fileObject != null ? fileObject : this.getSourceFile(), true);
    }

    public void readFromXML(Node node) throws IOException {
        if (node != null) {
            Element element = (Element)node;
            if (element.hasAttribute("id")) {
                FileObject fileObject = this.getSourceFile();
                String string = element.getAttribute("class");
                String string2 = element.getAttribute("id");
                String string3 = element.getAttribute("methodName");
                if (string3 == null) {
                    string3 = string2;
                }
                ProxyAction proxyAction = new ProxyAction(string, string2, string3);
                boolean bl = !string.endsWith(fileObject.getName()) || string.length() != fileObject.getName().length() && string.charAt(string.length() - fileObject.getName().length() - 1) != '.';
                proxyAction.setAppWide(bl);
                proxyAction.setResourceMap(this.getResourceMapForAction(proxyAction));
                proxyAction.loadFromResourceMap();
                this.setValue(proxyAction);
            } else {
                this.setValue(null);
            }
        }
    }

    public Node storeToXML(Document document) {
        Element element = document.createElement("action");
        if (this.action != null) {
            element.setAttribute("id", this.action.getId());
            element.setAttribute("class", this.action.getClassname());
            element.setAttribute("methodName", this.action.getMethodName());
        }
        return element;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
        propertyEnv.removeVetoableChangeListener((VetoableChangeListener)this);
        propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propertyEnv.addVetoableChangeListener((VetoableChangeListener)this);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (!this.isAppFramework()) {
            return;
        }
        if ("state".equals(propertyChangeEvent.getPropertyName())) {
            try {
                this.confirmChanges(propertyChangeEvent);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new PropertyVetoException(illegalArgumentException.getMessage(), propertyChangeEvent);
            }
        }
    }

    void confirmChanges(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        ProxyAction proxyAction;
        if ("state".equals(propertyChangeEvent.getPropertyName()) && !PropertyEnv.STATE_VALID.equals(propertyChangeEvent.getNewValue())) {
            return;
        }
        if (this.panel.isNewActionCreated()) {
            if (!this.panel.canCreateNewAction()) {
                if (!this.panel.isMethodNonEmpty()) {
                    throw new PropertyVetoException(NbBundle.getMessage(ActionEditor.class, (String)"ActionEditor.createMethodError.emptyMethod"), propertyChangeEvent);
                }
                if (this.panel.doesMethodContainBadChars()) {
                    throw new PropertyVetoException(NbBundle.getMessage(ActionEditor.class, (String)"ActionEditor.createMethodError.invalidName", (Object)this.panel.getNewMethodName()), propertyChangeEvent);
                }
                if (!this.panel.isValidClassname()) {
                    throw new PropertyVetoException(NbBundle.getMessage(ActionEditor.class, (String)"ActionEditor.createMethodError.invalidClassname"), propertyChangeEvent);
                }
                if (this.panel.isDuplicateMethod()) {
                    throw new PropertyVetoException(NbBundle.getMessage(ActionEditor.class, (String)"ActionEditor.createMethodError.duplicateMethod", (Object)this.panel.getNewMethodName()), propertyChangeEvent);
                }
            }
            ProxyAction proxyAction2 = this.createNewAction();
            this.panel.setMode(ActionPropertyEditorPanel.Mode.Form);
            this.setValue(proxyAction2);
            this.scanForActions();
            ActionManager.getActionManager(this.getSourceFile()).jumpToActionSource(proxyAction2);
            return;
        }
        if (this.panel.getSelectedAction() == null) {
            this.setValue(null);
            return;
        }
        if (this.panel.isViewSource()) {
            proxyAction = this.panel.getSelectedAction();
            ActionManager.getActionManager(this.getSourceFile()).jumpToActionSource(proxyAction);
            this.panel.resetFields();
        }
        if (this.panel.isActionPropertiesUpdated()) {
            proxyAction = this.panel.getUpdatedAction();
            this.saveChangedActionProperties(proxyAction);
            this.panel.resetFields();
            FileObject fileObject = AppFrameworkSupport.getFileForClass(this.getSourceFile(), proxyAction.getClassname());
            ActionManager.getActionManager(fileObject != null ? fileObject : this.getSourceFile()).updateAction(proxyAction);
            this.setValue(proxyAction);
        }
    }

    private void saveChangedActionProperties(ProxyAction proxyAction) {
        FileObject fileObject = AppFrameworkSupport.getFileForClass(this.getSourceFile(), proxyAction.getClassname());
        if (fileObject == null) {
            fileObject = this.getSourceFile();
        }
        DesignResourceMap designResourceMap = ResourceUtils.getDesignResourceMap(fileObject, true);
        String string = proxyAction.getId() + ".Action";
        this.updateOrDeleteResource(proxyAction, string + ".text", "Name", fileObject, designResourceMap, String.class);
        this.updateOrDeleteResource(proxyAction, string + ".shortDescription", "ShortDescription", fileObject, designResourceMap, String.class);
        if (proxyAction.getValue("SmallIcon") != null) {
            this.updateOrDeleteResource(proxyAction, string + ".icon", "SmallIcon.IconName", fileObject, designResourceMap, Icon.class);
        } else {
            this.updateOrDeleteResource(proxyAction, string + ".icon", "SwingLargeIconKey.IconName", fileObject, designResourceMap, Icon.class);
        }
        this.updateOrDeleteResource(proxyAction, string + ".smallIcon", "SmallIcon.IconName", fileObject, designResourceMap, Icon.class);
        this.updateOrDeleteResource(proxyAction, string + ".largeIcon", "SwingLargeIconKey.IconName", fileObject, designResourceMap, Icon.class);
        this.updateOrDeleteResource(proxyAction, string + ".accelerator", "AcceleratorKey", fileObject, designResourceMap, KeyStroke.class);
        String string2 = proxyAction.getId() + ".BlockingDialog.";
        this.updateOrDeleteResource(proxyAction, string2 + "optionPane.message", "BlockingDialog.message", fileObject, designResourceMap, String.class);
        this.updateOrDeleteResource(proxyAction, string2 + "title", "BlockingDialog.title", fileObject, designResourceMap, String.class);
        designResourceMap.save();
    }

    private void updateOrDeleteResource(ProxyAction proxyAction, String string, String string2, FileObject fileObject, DesignResourceMap designResourceMap, Class clazz) {
        Object object;
        int n = 2;
        if (proxyAction.isAppWide()) {
            n = 0;
        }
        Object object2 = proxyAction.getValue(string2);
        if (proxyAction.getValue(string2) == null) {
            ResourceValueImpl resourceValueImpl = designResourceMap.getResourceValue(string, clazz);
            if (resourceValueImpl != null) {
                designResourceMap.removeResourceValue(resourceValueImpl);
            }
            return;
        }
        String string3 = null;
        if (object2 instanceof String) {
            if (Icon.class.equals((Object)clazz)) {
                object = (String)object2;
                String string4 = designResourceMap.getResourcesDir();
                string3 = ((String)object).startsWith(string4) ? ((String)object).substring(string4.length()) : object;
                object2 = null;
            } else {
                string3 = (String)object2;
            }
        } else {
            string3 = String.class.equals((Object)clazz) ? "" + object2 : ResourceConverter.forType(clazz).toString(object2);
        }
        object = new ResourceValueImpl(string, clazz, object2, null, string3, true, n, fileObject);
        designResourceMap.addResourceValue((ResourceValueImpl)object);
    }

    public ProxyAction createNewAction() {
        ProxyAction proxyAction = this.panel.getNewAction();
        boolean bl = proxyAction.getClassname().equals(AppFrameworkSupport.getApplicationClassName(this.getSourceFile()));
        proxyAction.setAppWide(bl);
        if (ActionManager.getActionManager(this.getSourceFile()).createActionMethod(proxyAction)) {
            ActionManager.getActionManager(this.getSourceFile()).addNewAction(proxyAction);
            this.saveChangedActionProperties(proxyAction);
        }
        return proxyAction;
    }

    private boolean isAppFramework() {
        return AppFrameworkSupport.isFrameworkEnabledProject(this.getSourceFile());
    }
}

