/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalFileSystemEx
extends LocalFileSystem {
    private static HashMap<String, FileObject> allLocks = new HashMap(7);
    private static HashSet<String> pLocks = new HashSet(7);
    private static final Logger LOGGER = Logger.getLogger(LocalFileSystemEx.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getLocks() {
        LinkedList<String> linkedList = new LinkedList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        Object object = allLocks;
        synchronized (object) {
            linkedList.addAll(allLocks.keySet());
            hashSet.addAll(pLocks);
        }
        object = LocalFileSystemEx.getInvalid(hashSet);
        hashSet.removeAll((Collection<?>)object);
        linkedList.addAll(hashSet);
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            pLocks.removeAll((Collection<?>)object);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasLocks() {
        boolean bl;
        HashSet<String> hashSet = new HashSet<String>();
        Object object = allLocks;
        synchronized (object) {
            bl = allLocks.isEmpty();
            hashSet.addAll(pLocks);
        }
        object = LocalFileSystemEx.getInvalid(hashSet);
        hashSet.removeAll((Collection<?>)object);
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            pLocks.removeAll((Collection<?>)object);
        }
        return !bl || !hashSet.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void potentialLock(String string) {
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            pLocks.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void potentialLock(String string, String string2) {
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            if (pLocks.remove(string)) {
                pLocks.add(string2);
            }
        }
    }

    private static Set<String> getInvalid(Set set) {
        LOGGER.finest("133616 - checking invalid");
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            FileObject fileObject = FileUtil.getConfigFile((String)string);
            if (null != fileObject && fileObject.isLocked()) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public LocalFileSystemEx() {
        this(false);
    }

    LocalFileSystemEx(boolean bl) {
        if (bl) {
            this.attr = new DelegatingAttributes(this.attr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lock(String string) throws IOException {
        LOGGER.finest("133616 - in lock");
        super.lock(string);
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            FileObject fileObject = this.findResource(string);
            allLocks.put(string, fileObject);
            pLocks.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlock(String string) {
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            if (allLocks.containsKey(string)) {
                allLocks.remove(string);
            } else {
                FileObject fileObject = this.findResource(string);
                if (fileObject != null) {
                    for (Map.Entry<String, FileObject> entry : allLocks.entrySet()) {
                        if (!fileObject.equals(entry.getValue())) continue;
                        allLocks.remove(entry.getKey());
                        break;
                    }
                } else {
                    Logger.getLogger(LocalFileSystemEx.class.getName()).log(Level.WARNING, null, new Throwable("Can't unlock file " + string + ", it's lock was not found or it wasn't locked."));
                }
            }
        }
        super.unlock(string);
    }

    private class WritableRemover
    implements Callable {
        private String name;

        public WritableRemover(String string) {
            this.name = string;
        }

        public Object call() throws Exception {
            FileObject fileObject = LocalFileSystemEx.this.findResource(this.name);
            if (null != fileObject) {
                fileObject.delete();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelegatingAttributes
    implements AbstractFileSystem.Attr {
        private AbstractFileSystem.Attr a;

        public DelegatingAttributes(AbstractFileSystem.Attr attr) {
            this.a = attr;
        }

        public Object readAttribute(String string, String string2) {
            if ("removeWritables".equals(string2)) {
                return new WritableRemover(string);
            }
            return this.a.readAttribute(string, string2);
        }

        public void writeAttribute(String string, String string2, Object object) throws IOException {
            this.a.writeAttribute(string, string2, object);
        }

        public Enumeration<String> attributes(String string) {
            return this.a.attributes(string);
        }

        public void renameAttributes(String string, String string2) {
            this.a.renameAttributes(string, string2);
        }

        public void deleteAttributes(String string) {
            this.a.deleteAttributes(string);
        }
    }
}

