/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.print.ui.Attribute;
import org.netbeans.modules.print.ui.Paper;
import org.netbeans.modules.print.ui.Printer;
import org.netbeans.modules.print.ui.UI;
import org.netbeans.modules.print.util.Config;
import org.netbeans.modules.print.util.Percent;
import org.netbeans.spi.print.PrintPage;
import org.netbeans.spi.print.PrintProvider;
import org.openide.DialogDescriptor;

public final class Preview
extends UI.Dialog
implements Percent.Listener {
    private JPanel myPaperPanel;
    private List<Paper> myPapers;
    private JButton myFirst;
    private JButton myPrevious;
    private JButton myNext;
    private JButton myLast;
    private JButton myFit;
    private JButton myIncrease;
    private JButton myDecrease;
    private JButton myPrintButton;
    private JButton myCloseButton;
    private Percent myScale;
    private JTextField myGoto;
    private int myPaperNumber;
    private int myCustomIndex;
    private JToggleButton myToggle;
    private MyScrollPane myScrollPane;
    private KeyListener myKeyListener;
    private Printer myPrinter;
    private PrintProvider[] myPrintProviders;
    private static final int GAP_SIZE = 20;
    private static final int GOTO_WIDTH = 60;
    private static final int SCROLL_INCREMENT = 40;
    private static final double SCALE_RATIO = 1.05;
    private static final double PREVIEW_HEIGHT_RATIO = 0.66;
    private static final double PREVIEW_WIDTH_RATIO = 0.44;
    private static final int[] PERCENTS = new int[]{25, 50, 75, 100, 200, 400};
    private static final String LAST = "last";
    private static final String FIRST = "first";
    private static final String INCREASE = "increase";
    private static final String DECREASE = "decrease";
    private final String[] CUSTOMS = new String[]{this.i18n("LBL_Fit_to_Width"), this.i18n("LBL_Fit_to_Height"), this.i18n("LBL_Fit_to_All")};
    private static final Preview DEFAULT = new Preview();

    public static Preview getDefault() {
        return DEFAULT;
    }

    private Preview() {
        this.myPrinter = new Printer();
        this.myKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c == '+' || c == '=') {
                    Preview.this.myScale.increaseValue();
                } else if (c == '-' || c == '_') {
                    Preview.this.myScale.decreaseValue();
                } else if (c == '/') {
                    Preview.this.myScale.normalValue();
                } else if (c == '*') {
                    Preview.this.showCustom(true);
                }
            }
        };
    }

    public void print(PrintProvider[] printProviderArray, boolean bl) {
        assert (printProviderArray != null) : "Print providers cannot be null";
        assert (printProviderArray.length > 0) : "Must be at least one provider";
        this.myPrintProviders = printProviderArray;
        if (bl) {
            this.show(true);
        } else {
            this.print(true);
        }
    }

    private JPanel createPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel.add((Component)this.createNavigatePanel(), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.createScalePanel(), gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 13, 2, 0);
        this.myToggle = UI.createToggleButton(new UI.ButtonAction(UI.icon(Config.class, "toggle"), this.i18n("TLT_Toggle")){

            public void actionPerformed(ActionEvent actionEvent) {
                Preview.this.toggle();
            }
        });
        this.myToggle.addKeyListener(this.myKeyListener);
        this.myToggle.setSelected(true);
        jPanel.add((Component)this.myToggle, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(13, 0, 13, 0);
        jPanel2.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this.createScrollPanel(), gridBagConstraints);
        this.toggle();
        return jPanel2;
    }

    protected void updated() {
        this.createPapers();
        this.toggle();
    }

    private void toggle() {
        this.updatePaperNumber();
        this.addPapers();
        this.updateButtons();
    }

    private JComponent createNavigatePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.myFirst = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, FIRST), this.i18n("TLT_First")){

            public void actionPerformed(ActionEvent actionEvent) {
                Preview.this.first();
            }
        });
        this.myFirst.addKeyListener(this.myKeyListener);
        jPanel.add((Component)this.myFirst, gridBagConstraints);
        this.myPrevious = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "previous"), this.i18n("TLT_Previous")){

            public void actionPerformed(ActionEvent actionEvent) {
                Preview.this.previous();
            }
        });
        this.myPrevious.addKeyListener(this.myKeyListener);
        jPanel.add((Component)this.myPrevious, gridBagConstraints);
        this.myGoto = new JTextField();
        int n = this.myPrevious.getPreferredSize().height;
        this.myGoto.setPreferredSize(new Dimension(60, n));
        this.myGoto.setMinimumSize(new Dimension(60, n));
        InputMap inputMap = this.myGoto.getInputMap();
        ActionMap actionMap = this.myGoto.getActionMap();
        this.populateInputMap(inputMap);
        this.populateActionMap(actionMap);
        this.myGoto.setHorizontalAlignment(0);
        this.myGoto.setToolTipText(this.i18n("TLT_Goto"));
        this.myGoto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preview.this.goTo();
            }
        });
        jPanel.add((Component)this.myGoto, gridBagConstraints);
        this.myNext = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "next"), this.i18n("TLT_Next")){

            public void actionPerformed(ActionEvent actionEvent) {
                Preview.this.next();
            }
        });
        this.myNext.addKeyListener(this.myKeyListener);
        jPanel.add((Component)this.myNext, gridBagConstraints);
        this.myLast = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, LAST), this.i18n("TLT_Last")){

            public void actionPerformed(ActionEvent actionEvent) {
                Preview.this.last();
            }
        });
        this.myLast.addKeyListener(this.myKeyListener);
        jPanel.add((Component)this.myLast, gridBagConstraints);
        return jPanel;
    }

    private void populateInputMap(InputMap inputMap) {
        inputMap.put(KeyStroke.getKeyStroke('k'), INCREASE);
        inputMap.put(KeyStroke.getKeyStroke('K'), INCREASE);
        inputMap.put(KeyStroke.getKeyStroke('+'), INCREASE);
        inputMap.put(KeyStroke.getKeyStroke('='), INCREASE);
        inputMap.put(KeyStroke.getKeyStroke('g'), DECREASE);
        inputMap.put(KeyStroke.getKeyStroke('G'), DECREASE);
        inputMap.put(KeyStroke.getKeyStroke('-'), DECREASE);
        inputMap.put(KeyStroke.getKeyStroke('_'), DECREASE);
        inputMap.put(KeyStroke.getKeyStroke('l'), LAST);
        inputMap.put(KeyStroke.getKeyStroke('L'), LAST);
        inputMap.put(KeyStroke.getKeyStroke('*'), LAST);
        inputMap.put(KeyStroke.getKeyStroke('f'), FIRST);
        inputMap.put(KeyStroke.getKeyStroke('F'), FIRST);
        inputMap.put(KeyStroke.getKeyStroke('/'), FIRST);
    }

    private void populateActionMap(ActionMap actionMap) {
        actionMap.put(INCREASE, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preview.this.next();
            }
        });
        actionMap.put(DECREASE, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preview.this.previous();
            }
        });
        actionMap.put(LAST, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preview.this.last();
            }
        });
        actionMap.put(FIRST, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preview.this.first();
            }
        });
    }

    private JComponent createScalePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 13, 2, 2);
        this.myFit = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "fit"), this.i18n("TLT_Fit")){

            public void actionPerformed(ActionEvent actionEvent) {
                Preview.this.showCustom(true);
            }
        });
        this.myFit.addKeyListener(this.myKeyListener);
        jPanel.add((Component)this.myFit, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.myScale = new Percent(this, 1.0, PERCENTS, this.CUSTOMS.length - 1, this.CUSTOMS, this.i18n("TLT_Preview_Scale"));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Preview.this.myScale.setValue(Preview.this.getAllWidthScale());
            }
        });
        int n = (int)Math.round((double)this.myScale.getPreferredSize().width * 1.05);
        int n2 = this.myPrevious.getPreferredSize().height;
        this.myScale.setPreferredSize(new Dimension(n, n2));
        this.myScale.setMinimumSize(new Dimension(n, n2));
        jPanel.add((Component)this.myScale, gridBagConstraints);
        this.myDecrease = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "minus"), this.i18n("TLT_Zoom_Out")){

            public void actionPerformed(ActionEvent actionEvent) {
                Preview.this.myScale.decreaseValue();
            }
        });
        this.myDecrease.addKeyListener(this.myKeyListener);
        jPanel.add((Component)this.myDecrease, gridBagConstraints);
        this.myIncrease = UI.createButton(new UI.ButtonAction(UI.icon(Config.class, "plus"), this.i18n("TLT_Zoom_In")){

            public void actionPerformed(ActionEvent actionEvent) {
                Preview.this.myScale.increaseValue();
            }
        });
        this.myIncrease.addKeyListener(this.myKeyListener);
        jPanel.add((Component)this.myIncrease, gridBagConstraints);
        return jPanel;
    }

    private JComponent createScrollPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.myPaperPanel = new JPanel(new GridBagLayout());
        this.myPaperPanel.setBackground(Color.lightGray);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.setBackground(Color.lightGray);
        jPanel.add((Component)this.myPaperPanel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        this.myScrollPane = new MyScrollPane(jPanel);
        this.myScrollPane.setFocusable(true);
        this.myScrollPane.addWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (SwingUtilities.isRightMouseButton(mouseWheelEvent) || mouseWheelEvent.isControlDown()) {
                    Preview.this.myScrollPane.setWheelScrollingEnabled(false);
                    if (mouseWheelEvent.getWheelRotation() > 0) {
                        Preview.this.myScale.increaseValue();
                    } else {
                        Preview.this.myScale.decreaseValue();
                    }
                } else {
                    Preview.this.myScrollPane.setWheelScrollingEnabled(true);
                }
            }
        });
        this.myScrollPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        Preview.this.myScale.decreaseValue();
                    } else {
                        Preview.this.myScale.increaseValue();
                    }
                }
            }
        });
        this.myScrollPane.addKeyListener(this.myKeyListener);
        return this.myScrollPane;
    }

    private void showCustom(boolean bl) {
        if (bl) {
            ++this.myCustomIndex;
            if (this.myCustomIndex == this.CUSTOMS.length) {
                this.myCustomIndex = 0;
            }
        }
        this.myScale.customValue(this.myCustomIndex);
    }

    private void updateButtons() {
        this.myGoto.setText(this.getPaper(this.myPaperNumber));
        this.myFirst.setEnabled(this.myPaperNumber > 1);
        this.myPrevious.setEnabled(this.myPaperNumber > 1);
        this.myNext.setEnabled(this.myPaperNumber < this.getPaperCount());
        this.myLast.setEnabled(this.myPaperNumber < this.getPaperCount());
        boolean bl = this.getPaperCount() > 0;
        this.myGoto.setEnabled(bl);
        this.myScale.setEnabled(bl);
        this.myToggle.setEnabled(bl);
        this.myFit.setEnabled(bl);
        this.myIncrease.setEnabled(bl);
        this.myDecrease.setEnabled(bl);
        this.myPrintButton.setEnabled(bl);
    }

    private void scrollTo() {
        Paper paper = this.myPapers.get(this.myPaperNumber - 1);
        int n = this.getGap();
        int n2 = paper.getX() - n;
        int n3 = paper.getY() - n;
        int n4 = paper.getWidth();
        int n5 = paper.getHeight();
        JViewport jViewport = this.myScrollPane.getViewport();
        if (!jViewport.getViewRect().contains(n2, n3, n4, n5)) {
            jViewport.setViewPosition(new Point(n2, n3));
            this.updatePaperPanel();
        }
    }

    public double getCustomValue(int n) {
        if (this.getPaperCount() == 0) {
            return 0.0;
        }
        int n2 = this.myPapers.get(0).getPaperWidth() + 20;
        int n3 = this.myPapers.get(0).getPaperHeight() + 20;
        if (n == 0) {
            return this.getWidthScale(n2);
        }
        if (n == 1) {
            return this.getHeightScale(n3);
        }
        if (n == 2) {
            return this.getAllScale(n2, n3);
        }
        return 1.0;
    }

    private double getWidthScale(int n) {
        double d = this.myScrollPane.getWidth() - this.myScrollPane.getVerticalScrollBar().getWidth() - 5;
        return d / (double)n;
    }

    private double getHeightScale(int n) {
        double d = this.myScrollPane.getHeight() - this.myScrollPane.getHorizontalScrollBar().getHeight() - 5;
        return d / (double)n;
    }

    private double getAllScale(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (!this.isSingleMode()) {
            int n5 = 0;
            int n6 = 0;
            for (Paper paper : this.myPapers) {
                n5 = Math.max(n5, paper.getRow());
                n6 = Math.max(n6, paper.getColumn());
            }
            n3 *= n6 + 1;
            n4 *= n5 + 1;
        }
        return Math.min(this.getWidthScale(n3), this.getHeightScale(n4));
    }

    private double getAllWidthScale() {
        if (this.myPapers.size() == 0) {
            return 1.0;
        }
        int n = this.myPapers.get(0).getPaperWidth() + 20;
        if (!this.isSingleMode()) {
            int n2 = 0;
            for (Paper paper : this.myPapers) {
                n2 = Math.max(n2, paper.getColumn());
            }
            n *= n2 + 1;
        }
        return this.getWidthScale(n);
    }

    public void valueChanged(double d, int n) {
        if (n != -1) {
            this.myCustomIndex = n;
        }
        if (this.getPaperCount() == 0) {
            return;
        }
        for (Paper paper : this.myPapers) {
            paper.setScale(d);
        }
        this.addPapers();
    }

    private void addPapers() {
        this.myPaperPanel.removeAll();
        if (this.getPaperCount() == 0) {
            this.updatePaperPanel();
            return;
        }
        int n = this.getGap();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(n, n, 0, 0);
        if (this.isSingleMode()) {
            this.myPaperPanel.add((Component)this.myPapers.get(this.myPaperNumber - 1), gridBagConstraints);
        } else {
            for (Paper paper : this.myPapers) {
                gridBagConstraints.gridx = paper.getColumn();
                gridBagConstraints.gridy = paper.getRow();
                this.myPaperPanel.add((Component)paper, gridBagConstraints);
            }
        }
        this.updatePaperPanel();
    }

    private void updatePaperPanel() {
        this.myPaperPanel.revalidate();
        this.myPaperPanel.repaint();
    }

    private void createPapers() {
        this.myPapers = new ArrayList<Paper>();
        int n = Config.getDefault().getPageWidth();
        int n2 = Config.getDefault().getPageHeight();
        double d = Config.getDefault().getZoom();
        double d2 = 1.0;
        if (this.myScale != null) {
            d2 = this.myScale.getValue();
        }
        int n3 = 0;
        int n4 = 0;
        for (PrintProvider printProvider : this.myPrintProviders) {
            Date date;
            String string = printProvider.getName();
            if (string == null) {
                string = "";
            }
            if ((date = printProvider.lastModified()) == null) {
                date = new Date(System.currentTimeMillis());
            }
            PrintPage[][] printPageArray = printProvider.getPages(n, n2, d);
            for (int i = 0; i < printPageArray.length; ++i) {
                for (int j = 0; j < printPageArray[i].length; ++j) {
                    PrintPage printPage = printPageArray[i][j];
                    if (printPage == null) continue;
                    Paper paper = new Paper(printPage, string, date);
                    paper.setCoordinate(n4 + 1, i + n3, j, d2);
                    this.myPapers.add(paper);
                    ++n4;
                }
            }
            n3 += printPageArray.length;
        }
        int n5 = this.myPapers.size();
        for (Paper paper : this.myPapers) {
            paper.setCount(n5);
        }
    }

    private int getPaperCount() {
        if (this.myPapers == null) {
            return 0;
        }
        return this.myPapers.size();
    }

    public void invalidValue(String string) {
    }

    private void first() {
        this.updatePaperNumber();
        this.changePaper();
    }

    private void previous() {
        if (this.myPaperNumber == 1) {
            return;
        }
        --this.myPaperNumber;
        this.changePaper();
    }

    private void next() {
        if (this.myPaperNumber == this.getPaperCount()) {
            return;
        }
        ++this.myPaperNumber;
        this.changePaper();
    }

    private void last() {
        this.myPaperNumber = this.getPaperCount();
        this.changePaper();
    }

    private void goTo() {
        String string = this.myGoto.getText();
        int n = this.getPaperNumber(string);
        int n2 = this.getPaperCount();
        if (n < 1 || n > n2) {
            this.myGoto.setText(this.getPaper(this.myPaperNumber));
        } else {
            this.myPaperNumber = n;
            this.changePaper();
        }
        this.myGoto.selectAll();
    }

    private void changePaper() {
        if (this.isSingleMode()) {
            this.addPapers();
        } else {
            this.scrollTo();
        }
        this.updateButtons();
    }

    private void updatePaperNumber() {
        this.myPaperNumber = this.getPaperCount() == 0 ? 0 : 1;
    }

    private int getGap() {
        return (int)Math.round(20.0 * this.myScale.getValue());
    }

    private String getPaper(int n) {
        return Config.getPageOfCount(String.valueOf(n), String.valueOf(this.getPaperCount()));
    }

    protected DialogDescriptor createDescriptor() {
        Object[] objectArray = this.getRightButtons();
        Object[] objectArray2 = this.getLeftButtons();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)UI.getResizable(this.createPanel()), this.i18n("LBL_Print_Preview"), true, objectArray, (Object)this.myPrintButton, 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{this.myPrintButton, this.myCloseButton});
        dialogDescriptor.setAdditionalOptions(objectArray2);
        return dialogDescriptor;
    }

    protected void opened() {
        this.myScrollPane.requestFocus();
    }

    protected void resized() {
        if (this.myScale.isCustomValue()) {
            this.showCustom(false);
        }
    }

    private Object[] getLeftButtons() {
        JButton jButton = UI.createButton(new UI.ButtonAction(this.i18n("LBL_Page_Setup_Button"), this.i18n("TLT_Page_Setup_Button")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Config.getDefault().showPageSetup()) {
                    Preview.this.updated();
                }
            }
        });
        JButton jButton2 = UI.createButton(new UI.ButtonAction(this.i18n("LBL_Print_Option_Button"), this.i18n("TLT_Print_Option_Button")){

            public void actionPerformed(ActionEvent actionEvent) {
                Preview.this.option();
            }
        });
        jButton2.addKeyListener(this.myKeyListener);
        return new Object[]{jButton, jButton2};
    }

    private Object[] getRightButtons() {
        this.myPrintButton = UI.createButton(new UI.ButtonAction(this.i18n("LBL_Print_Button"), this.i18n("TLT_Print_Button")){

            public void actionPerformed(ActionEvent actionEvent) {
                Preview.this.print(false);
            }
        });
        this.myPrintButton.addKeyListener(this.myKeyListener);
        this.myCloseButton = UI.createButton(new UI.ButtonAction(this.i18n("LBL_Close_Button"), this.i18n("TLT_Close_Button")){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.myCloseButton.addKeyListener(this.myKeyListener);
        return new Object[]{this.myPrintButton, this.myCloseButton};
    }

    protected void closed() {
        this.myPapers = null;
        this.myPrintProviders = null;
    }

    private boolean isSingleMode() {
        return !this.myToggle.isSelected();
    }

    private void print(boolean bl) {
        if (bl) {
            this.createPapers();
        }
        this.myPrinter.print(this.myPapers);
    }

    private void option() {
        new Attribute(this).show(false);
    }

    private int getPaperNumber(String string) {
        char c;
        String string2 = string.trim();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string2.length() && UI.isDigit(c = string2.charAt(i)); ++i) {
            stringBuilder.append(c);
        }
        return UI.getInt(stringBuilder.toString());
    }

    private static final class MyScrollPane
    extends JScrollPane {
        private List<MouseWheelListener> myMouseWheelListeners;

        MyScrollPane(JPanel jPanel) {
            super(jPanel, 22, 32);
            this.getVerticalScrollBar().setUnitIncrement(40);
            int n = Toolkit.getDefaultToolkit().getScreenSize().height;
            int n2 = (int)Math.round((double)n * 0.66);
            int n3 = (int)Math.round((double)n2 * 0.44);
            Dimension dimension = new Dimension(n3, n2);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
        }

        public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
            if (this.myMouseWheelListeners == null) {
                this.myMouseWheelListeners = new ArrayList<MouseWheelListener>();
            }
            this.myMouseWheelListeners.add(mouseWheelListener);
        }

        public void addWheelListener(MouseWheelListener mouseWheelListener) {
            super.addMouseWheelListener(mouseWheelListener);
            for (int i = 0; i < this.myMouseWheelListeners.size(); ++i) {
                super.addMouseWheelListener(this.myMouseWheelListeners.get(i));
            }
        }
    }
}

