/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.provider;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.print.provider.ComponentDocument;
import org.netbeans.modules.print.provider.ComponentProvider;
import org.netbeans.modules.print.util.Config;
import org.openide.cookies.EditorCookie;
import org.openide.util.Lookup;

public final class TextProvider
extends ComponentProvider {
    private EditorCookie myEditor;
    private static final int MAX_LENGTH = 64000;

    public TextProvider(EditorCookie editorCookie, Date date) {
        super(null, TextProvider.getName(editorCookie), date);
        this.myEditor = editorCookie;
    }

    protected JComponent getComponent() {
        AttributedCharacterIterator[] attributedCharacterIteratorArray;
        int n;
        int n2;
        JTextComponent jTextComponent = this.getTextComponent();
        if (jTextComponent == null) {
            return null;
        }
        if (Config.getDefault().isAsEditor()) {
            return jTextComponent;
        }
        StyledDocument styledDocument = this.myEditor.getDocument();
        if (styledDocument == null) {
            return null;
        }
        if (Config.getDefault().isSelection()) {
            n2 = jTextComponent.getSelectionStart();
            n = jTextComponent.getSelectionEnd();
        } else {
            n2 = 0;
            n = styledDocument.getLength();
        }
        int n3 = n - n2;
        if (n3 < 64000 && (attributedCharacterIteratorArray = this.getIterators(styledDocument, n2, n)) != null) {
            return new ComponentDocument(attributedCharacterIteratorArray);
        }
        try {
            return new ComponentDocument(jTextComponent.getText(n2, n3));
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private AttributedCharacterIterator[] getIterators(Document document, int n, int n2) {
        ActionListener actionListener = (ActionListener)Lookup.getDefault().lookup(ActionListener.class);
        if (actionListener == null) {
            return null;
        }
        if (!actionListener.getClass().getName().contains(".print.")) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(document);
        arrayList.add(n);
        arrayList.add(n2);
        ActionEvent actionEvent = new ActionEvent(arrayList, 0, null);
        actionListener.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (!(object instanceof List)) {
            return null;
        }
        List list = (List)object;
        if (list.size() != 4) {
            return null;
        }
        Object e = list.get(3);
        if (!(e instanceof AttributedCharacterIterator[])) {
            return null;
        }
        return (AttributedCharacterIterator[])e;
    }

    private JTextComponent getTextComponent() {
        JEditorPane[] jEditorPaneArray = this.myEditor.getOpenedPanes();
        if (jEditorPaneArray != null && jEditorPaneArray.length != 0) {
            return jEditorPaneArray[0];
        }
        return null;
    }

    private static String getName(EditorCookie editorCookie) {
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return null;
        }
        return ((String)styledDocument.getProperty("title")).replace('\\', '/');
    }
}

