/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNode;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView;
import org.netbeans.modules.versioning.system.cvss.ui.history.TooltipWindow;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class DiffTreeTable
extends TreeTableView
implements MouseListener,
MouseMotionListener {
    private RevisionsRootNode rootNode;
    private List results;
    WeakReference<Node> lastExpanded = new WeakReference<Object>(null);

    public DiffTreeTable() {
        this.treeTable.setShowHorizontalLines(true);
        this.treeTable.setShowVerticalLines(false);
        this.setRootVisible(false);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
        this.setupColumns();
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setOpenIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        defaultTreeCellRenderer.setLeafIcon(null);
        this.tree.setCellRenderer(defaultTreeCellRenderer);
        this.treeTable.addMouseListener(this);
        this.treeTable.addMouseMotionListener(this);
    }

    private SearchHistoryPanel.DispRevision getRevisionWithTagsAt(Point point) {
        SearchHistoryPanel.DispRevision dispRevision = this.getRevisionWithPropertyAt(point, "tagsRevision");
        if (dispRevision != null && dispRevision.getBranches() != null && dispRevision.getBranches().size() + dispRevision.getTags().size() > 1) {
            return dispRevision;
        }
        return null;
    }

    private SearchHistoryPanel.DispRevision getRevisionWithPropertyAt(Point point, String string) {
        int n = this.treeTable.rowAtPoint(point);
        int n2 = this.treeTable.columnAtPoint(point);
        if (n == -1 || n2 == -1) {
            return null;
        }
        Object object = this.treeTable.getValueAt(n, n2);
        if (object instanceof Node.Property) {
            Node.Property property = (Node.Property)object;
            return (SearchHistoryPanel.DispRevision)property.getValue(string);
        }
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Window window;
        Point point = new Point(mouseEvent.getPoint());
        SearchHistoryPanel.DispRevision dispRevision = this.getRevisionWithTagsAt(point);
        if (dispRevision != null) {
            window = SwingUtilities.windowForComponent(this.treeTable);
            SwingUtilities.convertPointToScreen(point, this.treeTable);
            point.x += 10;
            point.y += 10;
            SummaryView.showAllTags(window, point, dispRevision);
        }
        if ((dispRevision = this.getRevisionWithPropertyAt(point = new Point(mouseEvent.getPoint()), "messageRevision")) != null) {
            window = SwingUtilities.windowForComponent(this.treeTable);
            SwingUtilities.convertPointToScreen(point, this.treeTable);
            if ((point.x -= 150) < 0) {
                point.x = 10;
            }
            point.y += this.treeTable.getRowHeight() * 3 / 2;
            this.showMessage(window, point, dispRevision);
        }
    }

    private void showMessage(Window window, Point point, SearchHistoryPanel.DispRevision dispRevision) {
        final JTextPane jTextPane = new JTextPane();
        jTextPane.setBackground(SummaryView.darker(UIManager.getColor("List.background")));
        jTextPane.setBorder(BorderFactory.createEmptyBorder(6, 8, 0, 0));
        jTextPane.setEditable(false);
        Style style = jTextPane.addStyle("headerStyle", null);
        StyleConstants.setBold(style, true);
        Document document = jTextPane.getDocument();
        try {
            document.insertString(document.getLength(), NbBundle.getMessage(DiffTreeTable.class, (String)"CTL_MessageWindow_Title") + "\n\n", style);
            document.insertString(document.getLength(), dispRevision.getRevision().getMessage() + "\n", null);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(DiffTreeTable.class.getName()).log(Level.WARNING, "Internal error creating commit message popup", badLocationException);
        }
        Dimension dimension = jTextPane.getPreferredSize();
        jTextPane.setPreferredSize(new Dimension(dimension.width * 7 / 6, dimension.height));
        JScrollPane jScrollPane = new JScrollPane(jTextPane);
        jScrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
        TooltipWindow tooltipWindow = new TooltipWindow(window, jScrollPane);
        tooltipWindow.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                jTextPane.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
        tooltipWindow.show(point);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.getRevisionWithTagsAt(mouseEvent.getPoint()) != null || this.getRevisionWithPropertyAt(mouseEvent.getPoint(), "messageRevision") != null) {
            this.treeTable.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.treeTable.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void setupColumns() {
        Node.Property[] propertyArray;
        ResourceBundle resourceBundle = NbBundle.getBundle(DiffTreeTable.class);
        if (CvsModuleConfig.getDefault().getPreferences().getBoolean("searchHistory.fetchTags", true)) {
            propertyArray = new Node.Property[6];
            propertyArray[4] = new ColumnDescriptor("tags", List.class, resourceBundle.getString("LBL_DiffTree_Column_Tags"), resourceBundle.getString("LBL_DiffTree_Column_Tags_Desc"));
            propertyArray[5] = new ColumnDescriptor("message", String.class, resourceBundle.getString("LBL_DiffTree_Column_Message"), resourceBundle.getString("LBL_DiffTree_Column_Message_Desc"));
        } else {
            propertyArray = new Node.Property[5];
            propertyArray[4] = new ColumnDescriptor("message", String.class, resourceBundle.getString("LBL_DiffTree_Column_Message"), resourceBundle.getString("LBL_DiffTree_Column_Message_Desc"));
        }
        propertyArray[0] = new ColumnDescriptor("name", String.class, "", "");
        propertyArray[0].setValue("TreeColumnTTV", (Object)Boolean.TRUE);
        propertyArray[1] = new ColumnDescriptor("location", String.class, resourceBundle.getString("LBL_DiffTree_Column_Location"), resourceBundle.getString("LBL_DiffTree_Column_Location_Desc"));
        propertyArray[2] = new ColumnDescriptor("date", String.class, resourceBundle.getString("LBL_DiffTree_Column_Time"), resourceBundle.getString("LBL_DiffTree_Column_Time_Desc"));
        propertyArray[3] = new ColumnDescriptor("username", String.class, resourceBundle.getString("LBL_DiffTree_Column_Username"), resourceBundle.getString("LBL_DiffTree_Column_Username_Desc"));
        this.setProperties(propertyArray);
    }

    private void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = DiffTreeTable.this.getWidth();
                if (CvsModuleConfig.getDefault().getPreferences().getBoolean("searchHistory.fetchTags", true)) {
                    if (DiffTreeTable.this.treeTable.getColumnModel().getColumnCount() != 6) {
                        return;
                    }
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(0).setPreferredWidth(n * 15 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(1).setPreferredWidth(n * 15 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(2).setPreferredWidth(n * 10 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(3).setPreferredWidth(n * 10 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(4).setPreferredWidth(n * 10 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(5).setPreferredWidth(n * 40 / 100);
                } else {
                    if (DiffTreeTable.this.treeTable.getColumnModel().getColumnCount() != 5) {
                        return;
                    }
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(0).setPreferredWidth(n * 20 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(1).setPreferredWidth(n * 20 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(2).setPreferredWidth(n * 10 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(3).setPreferredWidth(n * 10 / 100);
                    DiffTreeTable.this.treeTable.getColumnModel().getColumn(4).setPreferredWidth(n * 40 / 100);
                }
            }
        });
    }

    void setSelection(int n) {
        this.treeTable.getSelectionModel().setValueIsAdjusting(false);
        this.treeTable.scrollRectToVisible(this.treeTable.getCellRect(n, 1, true));
        this.treeTable.getSelectionModel().setSelectionInterval(n, n);
    }

    void setSelection(SearchHistoryPanel.ResultsContainer resultsContainer) {
        RevisionNode revisionNode = (RevisionNode)this.getNode((Node)this.rootNode, resultsContainer);
        if (revisionNode == null) {
            return;
        }
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
        try {
            explorerManager.setSelectedNodes(new Node[]{revisionNode});
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify((Throwable)propertyVetoException);
        }
    }

    void setSelection(SearchHistoryPanel.DispRevision dispRevision) {
        final RevisionNode revisionNode = (RevisionNode)this.getNode((Node)this.rootNode, dispRevision);
        if (revisionNode == null) {
            return;
        }
        final ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
        if (explorerManager.getRootContext() != this.lastExpanded.get()) {
            int n;
            for (n = 0; n < this.tree.getRowCount(); ++n) {
                this.tree.expandRow(n);
            }
            for (n = this.tree.getRowCount() - 1; n >= 0; --n) {
                this.tree.collapseRow(n);
            }
            this.lastExpanded = new WeakReference<Node>(explorerManager.getRootContext());
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    explorerManager.setSelectedNodes(new Node[]{revisionNode});
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            int[] nArray = DiffTreeTable.this.getSelection();
                            if (nArray != null && nArray.length > 0) {
                                DiffTreeTable.this.tree.scrollRowToVisible(nArray[0]);
                            }
                        }
                    });
                }
                catch (PropertyVetoException propertyVetoException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, propertyVetoException);
                }
            }
        });
    }

    private Node getNode(Node node, Object object) {
        Object object2 = node.getLookup().lookup(object.getClass());
        if (object.equals(object2)) {
            return node;
        }
        Enumeration enumeration = node.getChildren().nodes();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            Node node3 = this.getNode(node2, object);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    public int[] getSelection() {
        return this.treeTable.getSelectedRows();
    }

    public int getRowCount() {
        return this.treeTable.getRowCount();
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
        boolean bl = this.rootNode != explorerManager.getRootContext();
        explorerManager.setRootContext((Node)this.rootNode);
        this.setDefaultColumnSizes();
    }

    public void setResults(List list) {
        this.results = list;
        this.rootNode = new RevisionsRootNode();
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
        if (explorerManager != null) {
            explorerManager.setRootContext((Node)this.rootNode);
        }
    }

    private class RevisionsRootNodeChildren
    extends Children.Keys {
        protected void addNotify() {
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        private void refreshKeys() {
            this.setKeys(DiffTreeTable.this.results);
        }

        protected Node[] createNodes(Object object) {
            RevisionNode revisionNode = object instanceof SearchHistoryPanel.ResultsContainer ? new RevisionNode((SearchHistoryPanel.ResultsContainer)object) : new RevisionNode((SearchHistoryPanel.DispRevision)object);
            return new Node[]{revisionNode};
        }
    }

    private class RevisionsRootNode
    extends AbstractNode {
        public RevisionsRootNode() {
            super((Children)new RevisionsRootNodeChildren(), Lookups.singleton((Object)DiffTreeTable.this.results));
        }

        public String getName() {
            return "revision";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(DiffTreeTable.class, (String)"LBL_DiffTree_Column_Name");
        }

        public String getShortDescription() {
            return NbBundle.getMessage(DiffTreeTable.class, (String)"LBL_DiffTree_Column_Name_Desc");
        }
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

