/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CvsFileNode {
    private final File file;

    public CvsFileNode(File file) {
        this.file = FileUtil.normalizeFile((File)file);
    }

    public String getName() {
        return this.file.getName();
    }

    public FileInformation getInformation() {
        return CvsVersioningSystem.getInstance().getStatusCache().getStatus(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof CvsFileNode && this.file.equals(((CvsFileNode)object).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public FileObject getFileObject() {
        return FileUtil.toFileObject((File)this.file);
    }

    public Object[] getLookupObjects() {
        ArrayList<File> arrayList = new ArrayList<File>(2);
        arrayList.add(this.file);
        FileObject fileObject = this.getFileObject();
        if (fileObject != null) {
            arrayList.add((File)fileObject);
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }
}

