/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.api.ExtractSuperclassRefactoring;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ExtractSuperclassPanel
extends JPanel
implements CustomRefactoringPanel {
    private static final String[] COLUMN_NAMES = new String[]{"LBL_Selected", "LBL_ExtractSC_Member", "LBL_ExtractSC_MakeAbstract"};
    private static final Class[] COLUMN_CLASSES = new Class[]{Boolean.class, MemberInfo.class, Boolean.class};
    private final ExtractSuperclassRefactoring refactoring;
    private final TableModel tableModel;
    private Object[][] members = new Object[0][0];
    private JLabel chooseLabel;
    private JTable membersTable;
    private JLabel nameLabel;
    private JPanel namePanel;
    private JTextField nameText;
    private JScrollPane scrollPane;

    public ExtractSuperclassPanel(ExtractSuperclassRefactoring extractSuperclassRefactoring, final ChangeListener changeListener) {
        this.refactoring = extractSuperclassRefactoring;
        this.tableModel = new TableModel();
        this.initComponents();
        this.setPreferredSize(new Dimension(420, 380));
        String string = "NewClass";
        this.nameText.setText(string);
        this.nameText.setSelectionStart(0);
        this.nameText.setSelectionEnd(string.length());
        this.nameText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                changeListener.stateChanged(null);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                changeListener.stateChanged(null);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                changeListener.stateChanged(null);
            }
        });
    }

    public void requestFocus() {
        super.requestFocus();
        this.nameText.requestFocus();
    }

    public void initialize() {
        this.membersTable.setDefaultRenderer(COLUMN_CLASSES[1], new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, this.extractText(object), bl, bl2, n, n2);
                if (object instanceof MemberInfo) {
                    this.setIcon(((MemberInfo)object).getIcon());
                }
                return this;
            }

            protected String extractText(Object object) {
                String string = object instanceof MemberInfo ? ((MemberInfo)object).getHtmlText() : String.valueOf(object);
                return string;
            }
        });
        this.membersTable.getColumnModel().getColumn(2).setCellRenderer(new UIUtilities.BooleanTableCellRenderer(this.membersTable));
        this.scrollPane.setBackground(this.membersTable.getBackground());
        this.scrollPane.getViewport().setBackground(this.membersTable.getBackground());
        this.membersTable.setRowHeight(18);
        if (UIManager.getColor("control") != null) {
            this.membersTable.setGridColor(UIManager.getColor("control"));
        }
        UIUtilities.initColumnWidth(this.membersTable, 0, Boolean.TRUE, 4);
        UIUtilities.initColumnWidth(this.membersTable, 2, Boolean.TRUE, 4);
    }

    public String getSuperClassName() {
        return this.nameText.getText();
    }

    public MemberInfo[] getMembers() {
        ArrayList<MemberInfo> arrayList = new ArrayList<MemberInfo>();
        for (int i = 0; i < this.members.length; ++i) {
            if (!this.members[i][0].equals(Boolean.TRUE)) continue;
            MemberInfo memberInfo = (MemberInfo)this.members[i][1];
            memberInfo.setMakeAbstract(this.members[i][2] != null && (Boolean)this.members[i][2] != false);
            arrayList.add(memberInfo);
        }
        return arrayList.toArray(new MemberInfo[arrayList.size()]);
    }

    private void initComponents() {
        this.namePanel = new JPanel();
        this.nameLabel = new JLabel();
        this.chooseLabel = new JLabel();
        this.nameText = new JTextField();
        this.scrollPane = new JScrollPane();
        this.membersTable = new JTable();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setLayout(new BorderLayout());
        this.namePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.namePanel.setLayout(new BorderLayout(12, 0));
        this.nameLabel.setLabelFor(this.nameText);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(ExtractSuperclassPanel.class, (String)"LBL_ExtractSC_Name"));
        this.namePanel.add((Component)this.nameLabel, "West");
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExtractSuperclassPanel.class, (String)"ExtractSuperclassPanel.nameLabel.AccessibleContext.accessibleDescription"));
        this.chooseLabel.setLabelFor(this.membersTable);
        Mnemonics.setLocalizedText((JLabel)this.chooseLabel, (String)NbBundle.getMessage(ExtractSuperclassPanel.class, (String)"LBL_ExtractSCLabel"));
        this.chooseLabel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.namePanel.add((Component)this.chooseLabel, "South");
        this.chooseLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExtractSuperclassPanel.class, (String)"ExtractSuperclassPanel.chooseLabel.AccessibleContext.accessibleDescription"));
        this.namePanel.add((Component)this.nameText, "Center");
        this.nameText.getAccessibleContext().setAccessibleName(null);
        this.nameText.getAccessibleContext().setAccessibleDescription(null);
        this.add((Component)this.namePanel, "North");
        this.membersTable.setModel(this.tableModel);
        this.membersTable.setAutoResizeMode(1);
        this.scrollPane.setViewportView(this.membersTable);
        this.membersTable.getAccessibleContext().setAccessibleName(null);
        this.membersTable.getAccessibleContext().setAccessibleDescription(null);
        this.add((Component)this.scrollPane, "Center");
    }

    public Component getComponent() {
        return this;
    }

    static /* synthetic */ Object[][] access$202(ExtractSuperclassPanel extractSuperclassPanel, Object[][] objectArray) {
        extractSuperclassPanel.members = objectArray;
        return objectArray;
    }

    private class TableModel
    extends AbstractTableModel {
        TableModel() {
            this.initialize();
        }

        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return UIUtilities.getColumnName(NbBundle.getMessage(ExtractSuperclassPanel.class, (String)COLUMN_NAMES[n]));
        }

        public Class getColumnClass(int n) {
            return COLUMN_CLASSES[n];
        }

        public int getRowCount() {
            return ExtractSuperclassPanel.this.members.length;
        }

        public Object getValueAt(int n, int n2) {
            return ExtractSuperclassPanel.this.members[n][n2];
        }

        public void setValueAt(Object object, int n, int n2) {
            ((ExtractSuperclassPanel)ExtractSuperclassPanel.this).members[n][n2] = object;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 2) {
                if (ExtractSuperclassPanel.this.members[n][2] == null) {
                    return false;
                }
                MemberInfo memberInfo = (MemberInfo)ExtractSuperclassPanel.this.members[n][1];
                return !memberInfo.getModifiers().contains((Object)Modifier.STATIC) && !memberInfo.getModifiers().contains((Object)Modifier.ABSTRACT);
            }
            return n2 == 0;
        }

        private void initialize() {
            final TreePathHandle treePathHandle = ExtractSuperclassPanel.this.refactoring.getSourceType();
            if (treePathHandle == null) {
                return;
            }
            FileObject fileObject = treePathHandle.getFileObject();
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            try {
                javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        TableModel.this.initializeInTransaction(compilationController, treePathHandle);
                    }
                }, true);
            }
            catch (IOException iOException) {
                new IllegalStateException(iOException);
            }
        }

        private void initializeInTransaction(CompilationController compilationController, TreePathHandle treePathHandle) {
            AnnotatedConstruct annotatedConstruct;
            TreePath treePath;
            TreePath treePath2 = treePathHandle.resolve((CompilationInfo)compilationController);
            ClassTree classTree = (ClassTree)treePath2.getLeaf();
            ArrayList<MemberInfo<Object>> arrayList = new ArrayList<MemberInfo<Object>>();
            for (Tree object : classTree.getImplementsClause()) {
                treePath = compilationController.getTrees().getPath(compilationController.getCompilationUnit(), object);
                annotatedConstruct = compilationController.getTrees().getTypeMirror(treePath);
                arrayList.add(MemberInfo.create(annotatedConstruct, object, (CompilationInfo)compilationController));
            }
            for (Tree tree : classTree.getMembers()) {
                treePath = compilationController.getTrees().getPath(compilationController.getCompilationUnit(), tree);
                if (compilationController.getTreeUtilities().isSynthetic(treePath) || (annotatedConstruct = compilationController.getTrees().getElement(treePath)) == null || annotatedConstruct.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                if (annotatedConstruct.getKind() == ElementKind.FIELD) {
                    arrayList.add(MemberInfo.create(annotatedConstruct, (CompilationInfo)compilationController));
                    continue;
                }
                if (annotatedConstruct.getKind() != ElementKind.METHOD) continue;
                arrayList.add(MemberInfo.create(annotatedConstruct, (CompilationInfo)compilationController));
            }
            Collections.sort(arrayList, new Comparator<MemberInfo<?>>(){

                @Override
                public int compare(MemberInfo<?> memberInfo, MemberInfo<?> memberInfo2) {
                    int n = memberInfo.getGroup().compareTo(memberInfo2.getGroup());
                    if (n == 0) {
                        n = memberInfo.getName().compareTo(memberInfo2.getName());
                    }
                    return n;
                }
            });
            ExtractSuperclassPanel.access$202(ExtractSuperclassPanel.this, new Object[arrayList.size()][3]);
            for (int i = 0; i < ExtractSuperclassPanel.this.members.length; ++i) {
                ((ExtractSuperclassPanel)ExtractSuperclassPanel.this).members[i][0] = Boolean.FALSE;
                MemberInfo memberInfo = (MemberInfo)arrayList.get(i);
                ((ExtractSuperclassPanel)ExtractSuperclassPanel.this).members[i][1] = memberInfo;
                ((ExtractSuperclassPanel)ExtractSuperclassPanel.this).members[i][2] = memberInfo.getGroup() == MemberInfo.Group.METHOD ? Boolean.valueOf(memberInfo.isMakeAbstract()) : null;
            }
            this.fireTableDataChanged();
        }
    }
}

