/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.callhierarchy;

import com.sun.source.util.TreePath;
import java.awt.EventQueue;
import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.swing.Icon;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.callhierarchy.CallDescriptor;
import org.netbeans.modules.refactoring.java.callhierarchy.CallHierarchyModel;
import org.netbeans.modules.refactoring.java.callhierarchy.CallOccurrence;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Call
implements CallDescriptor {
    private static final String TYPE_COLOR = "#707070";
    private List<Call> references;
    private List<CallOccurrence> occurrences;
    CallHierarchyModel model;
    private String displayName;
    private String htmlDisplayName;
    private Icon icon;
    TreePathHandle selection;
    TreePathHandle declaration;
    private TreePathHandle overridden;
    private ElementHandle identity;
    private Call parent;
    private boolean leaf;
    private boolean canceled = false;
    private State state;

    private Call() {
    }

    public List<Call> getReferences() {
        return this.references != null ? this.references : Collections.emptyList();
    }

    void setReferences(List<Call> list) {
        this.references = list;
    }

    public List<CallOccurrence> getOccurrences() {
        return this.occurrences;
    }

    CallHierarchyModel getModel() {
        return this.model;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    public boolean isCanceled() {
        return this.state == State.CANCELED;
    }

    void setCanceled(boolean bl) {
        if (bl) {
            this.state = State.CANCELED;
        }
    }

    void setBroken() {
        this.state = State.BROKEN;
    }

    public boolean isBroken() {
        return this.state == State.BROKEN;
    }

    TreePathHandle getSourceToQuery() {
        return this.overridden != null ? this.overridden : (this.declaration != null ? this.declaration : this.selection);
    }

    @Override
    public void open() {
        if (this.occurrences != null && !this.occurrences.isEmpty()) {
            this.occurrences.get(0).open();
        }
    }

    public static Call createRoot(CompilationInfo compilationInfo, TreePath treePath, Element element, boolean bl) {
        return Call.createReference(compilationInfo, treePath, element, null, bl, Collections.<TreePath>emptyList());
    }

    public static Call createUsage(CompilationInfo compilationInfo, TreePath treePath, Element element, Call call, List<TreePath> list) {
        return Call.createReference(compilationInfo, treePath, element, call, call.model.getType() == CallHierarchyModel.HierarchyType.CALLER, list);
    }

    private static Call createReference(CompilationInfo compilationInfo, TreePath treePath, Element element, Call call, boolean bl, List<TreePath> list) {
        Iterator<TreePath> iterator;
        Call call2 = new Call();
        if (element.getKind() == ElementKind.INSTANCE_INIT || element.getKind() == ElementKind.STATIC_INIT) {
            call2.displayName = "<init>";
            call2.identity = null;
        } else {
            call2.displayName = ElementHeaders.getHeader((Element)element, (CompilationInfo)compilationInfo, (String)"%name%");
            call2.identity = ElementHandle.create((Element)element);
        }
        call2.htmlDisplayName = Call.createHtmlHeader(element, list.size(), compilationInfo);
        call2.icon = ElementIcons.getElementIcon((ElementKind)element.getKind(), element.getModifiers());
        call2.selection = TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo);
        call2.parent = call;
        if (call != null) {
            call2.model = call.model;
        }
        Element element2 = compilationInfo.getTrees().getElement(treePath);
        if (bl && element2 != null && element2.getKind() == ElementKind.METHOD && !(iterator = RetoucheUtils.getOverridenMethods((ExecutableElement)element2, compilationInfo)).isEmpty()) {
            ExecutableElement object2 = (ExecutableElement)iterator.iterator().next();
            call2.overridden = TreePathHandle.create((Element)object2, (CompilationInfo)compilationInfo);
            call2.identity = ElementHandle.create((Element)object2);
        }
        if (element2 != null && (iterator = compilationInfo.getTrees().getPath(element2)) != null) {
            call2.declaration = TreePathHandle.create(iterator, (CompilationInfo)compilationInfo);
        }
        if (call2.identity != null) {
            iterator = (Iterator<TreePath>)new boolean[]{false};
            call2.leaf = Call.isLeaf(element, call2.identity, call, bl, iterator);
            if (iterator[0] != false) {
                Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/refactoring/java/resources/recursion_badge.png");
                Image image2 = ImageUtilities.icon2Image((Icon)call2.icon);
                Image image3 = ImageUtilities.mergeImages((Image)image2, (Image)image, (int)8, (int)8);
                call2.icon = ImageUtilities.image2Icon((Image)image3);
            }
        } else {
            call2.leaf = true;
        }
        call2.occurrences = new ArrayList<CallOccurrence>(list.size());
        for (TreePath treePath2 : list) {
            call2.occurrences.add(CallOccurrence.createOccurrence(compilationInfo, treePath2, call));
        }
        return call2;
    }

    public String toString() {
        return String.format("name='%s', handle='%s', refs='%s'", this.displayName, this.selection, this.references);
    }

    private static boolean isLeaf(Element element, ElementHandle elementHandle, Call call, boolean bl, boolean[] blArray) {
        ElementKind elementKind = element.getKind();
        blArray[0] = false;
        if (elementKind != ElementKind.METHOD && elementKind != ElementKind.CONSTRUCTOR) {
            return true;
        }
        if (!bl && element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return true;
        }
        while (call != null) {
            if (elementHandle.equals((Object)call.identity)) {
                blArray[0] = true;
                return true;
            }
            call = call.parent;
        }
        return false;
    }

    private static String createHtmlHeader(Element element, int n, CompilationInfo compilationInfo) {
        String string;
        switch (element.getKind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                string = Call.createHtmlHeader((ExecutableElement)element, compilationInfo);
                break;
            }
            case INSTANCE_INIT: 
            case STATIC_INIT: {
                string = "&lt;init&gt;";
                break;
            }
            default: {
                string = ElementHeaders.getHeader((Element)element, (CompilationInfo)compilationInfo, (String)"%name%");
            }
        }
        String string2 = String.format("<font color=%s>%s</font>", TYPE_COLOR, compilationInfo.getElements().getBinaryName((TypeElement)element.getEnclosingElement()).toString());
        String string3 = n > 1 ? ", " + n + " occurrences" : "";
        return String.format("<html>%s :: %s%s</html>", string, string2, string3);
    }

    private static String createHtmlHeader(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        boolean bl = compilationInfo.getElements().isDeprecated(executableElement);
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("<s>");
        }
        if (executableElement.getKind() == ElementKind.CONSTRUCTOR) {
            stringBuilder.append(executableElement.getEnclosingElement().getSimpleName());
        } else {
            stringBuilder.append(executableElement.getSimpleName());
        }
        if (bl) {
            stringBuilder.append("</s>");
        }
        stringBuilder.append("(");
        for (VariableElement variableElement : executableElement.getParameters()) {
            stringBuilder.append("<font color=#707070>");
            stringBuilder.append(Call.print(variableElement.asType()));
            stringBuilder.append("</font>");
            stringBuilder.append(" ");
            stringBuilder.append(variableElement.getSimpleName());
            stringBuilder.append(", ");
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) == '(') {
            stringBuilder.append(")");
        } else {
            stringBuilder.replace(stringBuilder.length() - 2, stringBuilder.length(), ")");
        }
        return stringBuilder.toString();
    }

    private static String print(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                StringBuilder stringBuilder = new StringBuilder(declaredType.asElement().getSimpleName().toString());
                List<? extends TypeMirror> list = declaredType.getTypeArguments();
                if (!list.isEmpty()) {
                    stringBuilder.append("&lt;");
                    Iterator<? extends TypeMirror> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        TypeMirror typeMirror2 = iterator.next();
                        stringBuilder.append(Call.print(typeMirror2));
                        if (!iterator.hasNext()) continue;
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("&gt;");
                }
                return stringBuilder.toString();
            }
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)typeMirror;
                StringBuilder stringBuilder = new StringBuilder(typeVariable.asElement().getSimpleName().toString());
                return stringBuilder.toString();
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)typeMirror;
                StringBuilder stringBuilder = new StringBuilder(Call.print(arrayType.getComponentType()));
                stringBuilder.append("[]");
                return stringBuilder.toString();
            }
            case WILDCARD: {
                WildcardType wildcardType = (WildcardType)typeMirror;
                StringBuilder stringBuilder = new StringBuilder("?");
                if (wildcardType.getExtendsBound() != null) {
                    stringBuilder.append(" extends ");
                    stringBuilder.append(Call.print(wildcardType.getExtendsBound()));
                }
                if (wildcardType.getSuperBound() != null) {
                    stringBuilder.append(" super ");
                    stringBuilder.append(Call.print(wildcardType.getSuperBound()));
                }
                return stringBuilder.toString();
            }
        }
        return ((Object)typeMirror).toString();
    }

    static boolean doOpen(FileObject fileObject, PositionBounds positionBounds) {
        try {
            Object object;
            final int n = positionBounds.getBegin().getOffset();
            final int n2 = positionBounds.getEnd().getOffset();
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            final EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (editorCookie != null && lineCookie != null && n != -1 && (object = editorCookie.openDocument()) != null) {
                Line line;
                int n3 = NbDocument.findLineNumber((StyledDocument)object, (int)n);
                int n4 = NbDocument.findLineOffset((StyledDocument)object, (int)n3);
                int n5 = n - n4;
                if (n3 != -1 && (line = lineCookie.getLineSet().getCurrent(n3)) != null) {
                    line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, n5);
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            editorCookie.getOpenedPanes()[0].setSelectionStart(n);
                            editorCookie.getOpenedPanes()[0].setSelectionEnd(n2);
                        }
                    });
                    return true;
                }
            }
            if ((object = (OpenCookie)dataObject.getCookie(OpenCookie.class)) != null) {
                object.open();
                return true;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Call.class, (String)"Call.open.warning", (Object)FileUtil.getFileDisplayName((FileObject)fileObject)));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        CANCELED,
        BROKEN;

    }
}

