/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.common.xmlutils;

import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.ddloaders.common.xmlutils.SAXParseError;
import org.netbeans.modules.j2ee.ddloaders.common.xmlutils.XMLJ2eeEditorSupport;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XMLJ2eeDataObject
extends XMLDataObject
implements CookieSet.Factory {
    protected boolean nodeDirty = false;
    private boolean documentDirty = true;
    private boolean savingDocument;
    private InputStream inputStream;
    private InputOutput inOut;
    protected XMLJ2eeEditorSupport editor;
    private boolean documentValid = true;
    private SAXParseError error;
    private Annotation errorAnnotation;
    private static final long serialVersionUID = -515751072013886985L;
    public static final String PROP_DOC_VALID = "documentValid";

    public XMLJ2eeDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add(XMLJ2eeEditorSupport.class, (CookieSet.Factory)this);
        cookieSet.add(EditCookie.class, (CookieSet.Factory)this);
        cookieSet.add(EditorCookie.class, (CookieSet.Factory)this);
        cookieSet.add(LineCookie.class, (CookieSet.Factory)this);
        cookieSet.add(PrintCookie.class, (CookieSet.Factory)this);
        cookieSet.add(CloseCookie.class, (CookieSet.Factory)this);
        InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkXMLSupport = new CheckXMLSupport(inputSource);
        cookieSet.add((Node.Cookie)checkXMLSupport);
    }

    protected EditorCookie createEditorCookie() {
        return null;
    }

    protected abstract SAXParseError updateNode(InputSource var1) throws IOException;

    protected abstract String getIconBaseForValidDocument();

    protected abstract String getIconBaseForInvalidDocument();

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(XMLJ2eeEditorSupport.class)) {
            return this.getEditorSupport();
        }
        return null;
    }

    protected synchronized XMLJ2eeEditorSupport getEditorSupport() {
        if (this.editor == null) {
            this.editor = new XMLJ2eeEditorSupport(this);
        }
        return this.editor;
    }

    public String getOutputStringForInvalidDocument(SAXParseError sAXParseError) {
        String string = NbBundle.getMessage(XMLJ2eeDataObject.class, (String)"TXT_errorMessage", (Object[])new Object[]{sAXParseError.getErrorText(), new Integer(sAXParseError.getErrorLine()), new Integer(sAXParseError.getErrorColumn())});
        return string;
    }

    public boolean isNodeDirty() {
        return this.nodeDirty;
    }

    public void setDocumentDirty(boolean bl) {
        this.documentDirty = bl;
    }

    public boolean isDocumentDirty() {
        return this.documentDirty;
    }

    public void setNodeDirty(boolean bl) {
        this.nodeDirty = bl;
    }

    protected void repairNode() {
        if (this.inOut != null) {
            this.inOut.closeInputOutput();
            this.errorAnnotation.detach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parsingDocument() {
        SAXParseError sAXParseError = null;
        try {
            sAXParseError = this.updateNode(this.prepareInputSource());
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.INFO, null, exception);
            this.setDocumentValid(false);
            return;
        }
        finally {
            this.closeInputSource();
            this.documentDirty = false;
        }
        if (sAXParseError == null) {
            this.setDocumentValid(true);
        } else {
            this.setDocumentValid(false);
        }
    }

    protected InputSource prepareInputSource() throws IOException {
        if (this.editor != null && this.editor.isDocumentLoaded()) {
            final StyledDocument styledDocument = this.editor.getDocument();
            final String[] stringArray = new String[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        stringArray[0] = styledDocument.getText(0, styledDocument.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            };
            styledDocument.render(runnable);
            StringReader stringReader = new StringReader(stringArray[0]);
            return new InputSource(stringReader);
        }
        this.inputStream = new BufferedInputStream(this.getPrimaryFile().getInputStream());
        return new InputSource(this.inputStream);
    }

    protected void closeInputSource() {
        InputStream inputStream = this.inputStream;
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (inputStream == this.inputStream) {
                this.inputStream = null;
            }
        }
    }

    public boolean isDocumentValid() {
        return this.documentValid;
    }

    public void setDocumentValid(boolean bl) {
        if (this.documentValid != bl) {
            if (bl) {
                this.repairNode();
            }
            this.documentValid = bl;
            this.firePropertyChange(PROP_DOC_VALID, !this.documentValid ? Boolean.TRUE : Boolean.FALSE, this.documentValid ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void addSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().add((Node.Cookie)saveCookie);
    }

    public void removeSaveCookie() {
        Node.Cookie cookie = this.getCookie(SaveCookie.class);
        if (cookie != null) {
            this.getCookieSet().remove(cookie);
        }
    }

    public void setSavingDocument(boolean bl) {
        this.savingDocument = bl;
    }

    public boolean isSavingDocument() {
        return this.savingDocument;
    }

    public void displayErrorMessage() {
        if (this.error == null) {
            return;
        }
        if (this.errorAnnotation == null) {
            this.errorAnnotation = new Annotation(){

                public String getAnnotationType() {
                    return "xml-j2ee-annotation";
                }

                public String getShortDescription() {
                    return NbBundle.getMessage(XMLJ2eeDataObject.class, (String)"HINT_XMLErrorDescription");
                }
            };
        }
        if (this.inOut == null) {
            this.inOut = IOProvider.getDefault().getIO(NbBundle.getMessage(XMLJ2eeDataObject.class, (String)"TXT_parser"), false);
        }
        this.inOut.setFocusTaken(false);
        OutputWriter outputWriter = this.inOut.getOut();
        int n = Math.max(0, this.error.getErrorLine());
        LineCookie lineCookie = (LineCookie)this.getCookie(LineCookie.class);
        Line line = lineCookie.getLineSet().getCurrent(n == 0 ? 0 : n - 1);
        this.errorAnnotation.attach((Annotatable)line);
        try {
            outputWriter.reset();
            IOCtl iOCtl = new IOCtl(line);
            outputWriter.println(this.getOutputStringForInvalidDocument(this.error), (OutputListener)iOCtl);
        }
        catch (IOException iOException) {
            Logger.getLogger("XMLJ2eeDataObject").log(Level.FINE, "ignored exception", iOException);
        }
    }

    public void setValid(boolean bl) throws PropertyVetoException {
        if (!bl && this.inOut != null) {
            this.inOut.closeInputOutput();
        }
        super.setValid(bl);
    }

    private void createSAXParseError(SAXParseException sAXParseException) {
        this.error = new SAXParseError(sAXParseException);
    }

    public static class J2eeErrorHandler
    implements ErrorHandler {
        private XMLJ2eeDataObject xmlJ2eeDataObject;

        public J2eeErrorHandler(XMLJ2eeDataObject xMLJ2eeDataObject) {
            this.xmlJ2eeDataObject = xMLJ2eeDataObject;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.xmlJ2eeDataObject.createSAXParseError(sAXParseException);
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.xmlJ2eeDataObject.createSAXParseError(sAXParseException);
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.xmlJ2eeDataObject.createSAXParseError(sAXParseException);
            throw sAXParseException;
        }
    }

    final class IOCtl
    implements OutputListener {
        Line xline;

        public IOCtl(Line line) {
            this.xline = line;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            XMLJ2eeDataObject.this.errorAnnotation.attach((Annotatable)this.xline);
            this.xline.show(0);
        }

        public void outputLineAction(OutputEvent outputEvent) {
            XMLJ2eeDataObject.this.errorAnnotation.attach((Annotatable)this.xline);
            this.xline.show(0);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            XMLJ2eeDataObject.this.errorAnnotation.detach();
        }
    }
}

