/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.common;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.ddloaders.common.xmlutils.XMLJ2eeDataObject;
import org.netbeans.modules.j2ee.ddloaders.common.xmlutils.XMLJ2eeUtils;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.util.RequestProcessor;

public abstract class DD2beansDataObject
extends XMLJ2eeDataObject
implements CookieSet.Factory {
    private static final int DELAY_FOR_TIMER = 200;
    protected static final RequestProcessor RP = new RequestProcessor("XML Parsing");
    private final RequestProcessor.Task generationTask;
    private String prefixMark;
    private static final long serialVersionUID = -5363900668319174348L;

    public DD2beansDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        this(fileObject, multiFileLoader, true);
    }

    public DD2beansDataObject(FileObject fileObject, MultiFileLoader multiFileLoader, final boolean bl) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.generationTask = RP.create(new Runnable(){
            int numberOfStartedGens;

            public void run() {
                ++this.numberOfStartedGens;
                final String string = DD2beansDataObject.this.generateDocument();
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            SaveCookie saveCookie;
                            StyledDocument styledDocument = DD2beansDataObject.this.getEditorSupport().openDocument();
                            XMLJ2eeUtils.replaceDocument(styledDocument, string, DD2beansDataObject.this.prefixMark);
                            DD2beansDataObject.this.setDocumentValid(true);
                            if (bl && (saveCookie = (SaveCookie)DD2beansDataObject.this.getCookie(SaveCookie.class)) != null) {
                                saveCookie.save();
                            }
                            DD2beansDataObject.this.getEditorSupport().getUndo().discardAllEdits();
                        }
                        catch (BadLocationException badLocationException) {
                            Logger.getLogger("global").log(Level.INFO, null, badLocationException);
                        }
                        catch (IOException iOException) {
                            Logger.getLogger("global").log(Level.INFO, null, iOException);
                        }
                        finally {
                            RequestProcessor.Task task = DD2beansDataObject.this.generationTask;
                            synchronized (task) {
                                --numberOfStartedGens;
                                if (numberOfStartedGens == 0) {
                                    DD2beansDataObject.this.nodeDirty = false;
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    protected abstract String generateDocument();

    protected final void setPrefixMark(String string) {
        this.prefixMark = string;
    }

    protected final String getPrefixMark() {
        return this.prefixMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeDirty(boolean bl) {
        if (bl) {
            DD2beansDataObject dD2beansDataObject = this;
            synchronized (dD2beansDataObject) {
                this.nodeDirty = true;
                this.restartGen();
            }
        }
    }

    public RequestProcessor.Task getGenerationTask() {
        return this.generationTask;
    }

    protected void restartGen() {
        this.generationTask.schedule(200);
    }
}

