/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.core.UiUtils;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.model.FindUsageSupport;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelFactory;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.OccurencesSupport;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.refactoring.php.findusages.AttributedNodes;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedElement;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WhereUsedSupport {
    private ASTNode node;
    private FileObject fo;
    private int offset;
    private PhpKind kind;
    private ModelElement modelElement;
    private Results results;
    private Set<Modifier> modifier;
    private FindUsageSupport usageSupport;

    private WhereUsedSupport(PHPIndex pHPIndex, ModelElement modelElement, ASTNode aSTNode, FileObject fileObject) {
        this(pHPIndex, modelElement, aSTNode.getStartOffset(), fileObject);
        this.node = aSTNode;
    }

    private WhereUsedSupport(PHPIndex pHPIndex, ModelElement modelElement, int n, FileObject fileObject) {
        this.fo = fileObject;
        this.offset = n;
        this.modelElement = modelElement;
        this.usageSupport = FindUsageSupport.getInstance((PHPIndex)pHPIndex, (ModelElement)modelElement);
        this.kind = modelElement.getPhpKind();
        this.results = new Results();
    }

    public String getName() {
        return this.modelElement.getName();
    }

    public ASTNode getASTNode() {
        return this.node;
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    public int getOffset() {
        return this.offset;
    }

    public PhpKind getKind() {
        return this.kind;
    }

    public ElementKind getElementKind() {
        return this.modelElement.getPHPElement().getKind();
    }

    public Set<Modifier> getModifiers() {
        ModelElement modelElement = this.getModelElement();
        return this.getModifiers(modelElement);
    }

    public Results getResults() {
        return this.results;
    }

    void collectDirectSubclasses(final FileObject fileObject) {
        try {
            ParserManager.parse(Collections.singleton(Source.create((FileObject)fileObject)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    ParserResult parserResult = (ParserResult)resultIterator.getParserResult();
                    AttributedNodes attributedNodes = AttributedNodes.getInstance(parserResult);
                    Map<ASTNode, AttributedNodes.AttributedElement> map = null;
                    map = attributedNodes.findDirectSubclasses(WhereUsedSupport.this.modelElement);
                    for (Map.Entry<ASTNode, AttributedNodes.AttributedElement> entry : map.entrySet()) {
                        WhereUsedSupport.this.results.addEntry(fileObject, entry);
                    }
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
    }

    void collectUsages(FileObject fileObject) {
        Collection collection = this.usageSupport.occurences(fileObject);
        for (Occurence occurence : collection) {
            this.results.addEntry(fileObject, occurence);
        }
    }

    public static WhereUsedSupport getInstance(ParserResult parserResult, int n) {
        Model model = ModelFactory.getModel((ParserResult)parserResult);
        OccurencesSupport occurencesSupport = model.getOccurencesSupport(n);
        Occurence occurence = occurencesSupport.getOccurence();
        return occurence != null && occurence.getAllDeclarations().size() == 1 ? new WhereUsedSupport(PHPIndex.get((ParserResult)parserResult), occurence.getDeclaration(), n, parserResult.getSnapshot().getSource().getFileObject()) : null;
    }

    public ModelElement getModelElement() {
        return this.modelElement;
    }

    Set<FileObject> getRelevantFiles() {
        return this.usageSupport.inFiles();
    }

    private Set<Modifier> getModifiers(ModelElement modelElement) {
        if (this.modifier == null) {
            Set set = Collections.emptySet();
            if (modelElement != null && modelElement.getInScope() instanceof TypeScope) {
                set = new HashSet();
                if (modelElement.getPhpModifiers().isPrivate()) {
                    set.add(Modifier.PRIVATE);
                } else if (modelElement.getPhpModifiers().isProtected()) {
                    set.add(Modifier.PROTECTED);
                }
                if (modelElement.getPhpModifiers().isPublic()) {
                    set.add(Modifier.PUBLIC);
                }
                if (modelElement.getPhpModifiers().isStatic()) {
                    set.add(Modifier.STATIC);
                }
            }
            this.modifier = set;
        }
        return this.modifier;
    }

    public static boolean isAlreadyInResults(ASTNode aSTNode, Set<ASTNode> set) {
        OffsetRange offsetRange = new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset());
        for (ASTNode aSTNode2 : set) {
            OffsetRange offsetRange2 = new OffsetRange(aSTNode2.getStartOffset(), aSTNode2.getEndOffset());
            if (!offsetRange.containsInclusive(offsetRange2.getStart()) && !offsetRange2.containsInclusive(offsetRange.getStart())) continue;
            return true;
        }
        return false;
    }

    public static boolean matchDirectSubclass(ModelElement modelElement, ASTNode aSTNode, AttributedNodes.AttributedElement attributedElement) {
        AttributedNodes.ClassElement classElement;
        boolean bl = false;
        if (attributedElement != null && attributedElement instanceof AttributedNodes.ClassElement && aSTNode instanceof ClassDeclaration && (classElement = ((AttributedNodes.ClassElement)attributedElement).getSuperClass()) != null && classElement.getName().equals(modelElement.getName())) {
            bl = true;
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Results {
        Collection<WhereUsedElement> elements = new TreeSet<WhereUsedElement>(new Comparator<WhereUsedElement>(){

            @Override
            public int compare(WhereUsedElement whereUsedElement, WhereUsedElement whereUsedElement2) {
                String string;
                String string2 = whereUsedElement.getParentFile().getPath();
                int n = string2.compareTo(string = whereUsedElement2.getParentFile().getPath());
                if (n == 0) {
                    int n2;
                    int n3 = whereUsedElement.getPosition().getBegin().getOffset();
                    n = n3 < (n2 = whereUsedElement2.getPosition().getBegin().getOffset()) ? -1 : 1;
                }
                return n;
            }
        });

        private Results() {
        }

        private void addEntry(FileObject fileObject, Occurence occurence) {
            ModelElement modelElement = occurence.getDeclaration();
            ImageIcon imageIcon = UiUtils.getElementIcon((ElementKind)WhereUsedSupport.this.getElementKind(), (Collection)modelElement.getPHPElement().getModifiers());
            this.elements.add(WhereUsedElement.create(modelElement.getName(), fileObject, occurence.getOccurenceRange(), imageIcon));
        }

        private void addEntry(FileObject fileObject, Map.Entry<ASTNode, AttributedNodes.AttributedElement> entry) {
            AttributedNodes.AttributedElement attributedElement = entry.getValue();
            ASTNode aSTNode = entry.getKey();
            if (aSTNode instanceof ClassDeclaration) {
                aSTNode = ((ClassDeclaration)aSTNode).getName();
            }
            OffsetRange offsetRange = new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset());
            ImageIcon imageIcon = UiUtils.getElementIcon((ElementKind)WhereUsedSupport.this.getElementKind(), this.getModifiers(attributedElement));
            this.elements.add(WhereUsedElement.create(attributedElement.getName(), fileObject, offsetRange, imageIcon));
        }

        public Collection<WhereUsedElement> getResultElements() {
            return this.elements;
        }

        private Set<Modifier> getModifiers(AttributedNodes.AttributedElement attributedElement) {
            if (WhereUsedSupport.this.modifier == null) {
                AttributedNodes.ClassMemberElement classMemberElement;
                Set set = Collections.emptySet();
                if (attributedElement != null && attributedElement.isClassMember() && (classMemberElement = (AttributedNodes.ClassMemberElement)attributedElement).getModifier() >= 0) {
                    set = new HashSet();
                    if (classMemberElement.isPrivate()) {
                        set.add(Modifier.PRIVATE);
                    } else if (classMemberElement.isProtected()) {
                        set.add(Modifier.PROTECTED);
                    }
                    if (classMemberElement.isPublic()) {
                        set.add(Modifier.PUBLIC);
                    }
                    if (classMemberElement.isStatic()) {
                        set.add(Modifier.STATIC);
                    }
                }
                WhereUsedSupport.this.modifier = set;
            }
            return WhereUsedSupport.this.modifier;
        }
    }
}

