/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CancellationException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.support.HostInfoFetcher;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HostInfoUtils {
    public static final String LOCALHOST = "127.0.0.1";
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final List<String> myIPAdresses = new ArrayList<String>();
    private static final Map<String, Boolean> filesExistenceHash = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<ExecutionEnvironment, HostInfoFetcher> hostInfoProviders = new HashMap<ExecutionEnvironment, HostInfoFetcher>();

    public static void dumpInfo(HostInfo hostInfo, PrintStream printStream) {
        printStream.println("------------");
        if (hostInfo == null) {
            printStream.println("HostInfo is NULL");
        } else {
            printStream.println("Hostname      : " + hostInfo.getHostname());
            printStream.println("OS Family     : " + (Object)((Object)hostInfo.getOSFamily()));
            printStream.println("OS            : " + hostInfo.getOS().getName());
            printStream.println("OS Version    : " + hostInfo.getOS().getVersion());
            printStream.println("OS Bitness    : " + (Object)((Object)hostInfo.getOS().getBitness()));
            printStream.println("CPU Family    : " + (Object)((Object)hostInfo.getCpuFamily()));
            printStream.println("CPU #         : " + hostInfo.getCpuNum());
            printStream.println("shell to use  : " + hostInfo.getShell());
            printStream.println("tmpdir to use : " + hostInfo.getTempDir());
        }
        printStream.println("------------");
    }

    public static boolean fileExists(ExecutionEnvironment executionEnvironment, String string) throws IOException {
        return HostInfoUtils.fileExists(executionEnvironment, string, true);
    }

    public static boolean fileExists(ExecutionEnvironment executionEnvironment, String string, boolean bl) throws IOException {
        String string2 = ((Object)executionEnvironment).toString() + string;
        if (bl && filesExistenceHash.containsKey(string2)) {
            return filesExistenceHash.get(string2);
        }
        boolean bl2 = false;
        if (executionEnvironment.isLocal()) {
            bl2 = new File(string).exists();
        } else {
            if (!ConnectionManager.getInstance().isConnectedTo(executionEnvironment)) {
                throw new ConnectException();
            }
            NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder(executionEnvironment);
            nativeProcessBuilder.setExecutable("test").setArguments("-e", string);
            try {
                bl2 = nativeProcessBuilder.call().waitFor() == 0;
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException.getMessage());
            }
        }
        filesExistenceHash.put(string2, bl2);
        return bl2;
    }

    public static String searchFile(ExecutionEnvironment executionEnvironment, List<String> list, String string, boolean bl) {
        try {
            String string2;
            BufferedReader bufferedReader;
            NativeProcess nativeProcess;
            NativeProcessBuilder nativeProcessBuilder;
            HostInfo hostInfo = HostInfoUtils.getHostInfo(executionEnvironment);
            if (hostInfo == null) {
                return null;
            }
            String string3 = hostInfo.getShell();
            if (string3 == null) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>(list);
            if (bl) {
                nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder(executionEnvironment);
                nativeProcessBuilder.setExecutable(string3).setArguments("-c", "echo $PATH");
                nativeProcess = nativeProcessBuilder.call();
                nativeProcess.waitFor();
                bufferedReader = new BufferedReader(new InputStreamReader(nativeProcess.getInputStream()));
                string2 = bufferedReader.readLine();
                if (string2 != null) {
                    arrayList.addAll(Arrays.asList(string2.split("[;:]")));
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append("/bin/ls " + (String)iterator.next() + "/" + string);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(" || ");
            }
            nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder(executionEnvironment);
            nativeProcessBuilder.setExecutable(string3).setArguments("-c", stringBuilder.toString());
            nativeProcess = nativeProcessBuilder.call();
            nativeProcess.waitFor();
            bufferedReader = new BufferedReader(new InputStreamReader(nativeProcess.getInputStream()));
            string2 = bufferedReader.readLine();
            return string2 == null || "".equals(string2.trim()) ? null : string2.trim();
        }
        catch (IOException iOException) {
            log.finest("Exception in searchFile() " + iOException.toString());
        }
        catch (InterruptedException interruptedException) {
            log.finest("Exception in searchFile() " + interruptedException.toString());
        }
        log.finest("File " + string + " not found");
        return null;
    }

    public static boolean isLocalhost(String string) {
        boolean bl = false;
        try {
            bl = myIPAdresses.contains(InetAddress.getByName(string).getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHostInfoAvailable(ExecutionEnvironment executionEnvironment) {
        HostInfoFetcher hostInfoFetcher;
        Object object = hostInfoProviders;
        synchronized (object) {
            hostInfoFetcher = hostInfoProviders.get(executionEnvironment);
        }
        if (hostInfoFetcher == null) {
            return false;
        }
        object = null;
        try {
            object = hostInfoFetcher.getInfo(false);
        }
        catch (IOException iOException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return object != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostInfo getHostInfo(ExecutionEnvironment executionEnvironment) throws IOException, CancellationException {
        HostInfoFetcher hostInfoFetcher;
        Map<ExecutionEnvironment, HostInfoFetcher> map = hostInfoProviders;
        synchronized (map) {
            hostInfoFetcher = hostInfoProviders.get(executionEnvironment);
            if (hostInfoFetcher == null) {
                hostInfoFetcher = new HostInfoFetcher(executionEnvironment);
                hostInfoProviders.put(executionEnvironment, hostInfoFetcher);
            }
        }
        return hostInfoFetcher.getInfo(true);
    }

    static {
        NetworkInterface networkInterface = null;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    myIPAdresses.add(enumeration2.nextElement().getHostAddress());
                }
            }
        }
        catch (SocketException socketException) {
            Exceptions.printStackTrace((Throwable)socketException);
        }
    }
}

