/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.nativeexecution.ExternalTerminalAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminal;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.TerminalProfile;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExternalTerminalProvider {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final HashMap<String, List<TerminalProfile>> profiles = new HashMap();
    private static final HashMap<ExecutionEnvironment, TerminalProfile> hash = new HashMap();

    private ExternalTerminalProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExternalTerminal getTerminal(ExecutionEnvironment executionEnvironment, String string) {
        HashMap<ExecutionEnvironment, TerminalProfile> hashMap = hash;
        synchronized (hashMap) {
            TerminalProfile terminalProfile = hash.get(executionEnvironment);
            if (terminalProfile != null) {
                return new ExternalTerminal(terminalProfile);
            }
            List<TerminalProfile> list = profiles.get(string);
            if (list == null) {
                throw new IllegalArgumentException("Unsupported terminal type");
            }
            ExternalTerminalAccessor externalTerminalAccessor = ExternalTerminalAccessor.getDefault();
            for (TerminalProfile terminalProfile2 : list) {
                ExternalTerminal externalTerminal = new ExternalTerminal(terminalProfile2);
                List<String> list2 = terminalProfile2.getValidationCommands();
                if (list2 == null || list2.isEmpty()) {
                    return externalTerminal;
                }
                for (String string2 : list2) {
                    try {
                        Object object;
                        if (string2.contains("$self")) {
                            object = externalTerminalAccessor.getExecutable(externalTerminal, executionEnvironment);
                            if (object == null) {
                                return null;
                            }
                            string2 = string2.replaceAll("\\$self", (String)object);
                        }
                        object = NativeProcessBuilder.newProcessBuilder(executionEnvironment);
                        ((NativeProcessBuilder)object).setExecutable(HostInfoUtils.getHostInfo(executionEnvironment).getShell());
                        ((NativeProcessBuilder)object).setArguments("-c", string2);
                        NativeProcess nativeProcess = ((NativeProcessBuilder)object).call();
                        int n = nativeProcess.waitFor();
                        if (n != 0) continue;
                        hash.put(executionEnvironment, terminalProfile2);
                        return externalTerminal;
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                    catch (IOException iOException) {
                    }
                }
            }
            return null;
        }
    }

    public static Collection<String> getSupportedTerminalIDs() {
        return profiles.keySet();
    }

    private static void init() {
        FileObject fileObject = FileUtil.getConfigFile((String)"NativeExecution/ExtTerminalSupport");
        if (fileObject != null && fileObject.isFolder()) {
            FileObject[] fileObjectArray;
            for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                try {
                    ExternalTerminalProvider.readConfiguration(fileObject2.getInputStream());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Exceptions.printStackTrace((Throwable)fileNotFoundException);
                }
            }
        }
    }

    private static void readConfiguration(InputStream inputStream) {
        Object object;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        XMLReader xMLReader = null;
        try {
            object = sAXParserFactory.newSAXParser();
            xMLReader = ((SAXParser)object).getXMLReader();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        object = new SAXHandler();
        xMLReader.setContentHandler((ContentHandler)object);
        try {
            InputSource inputSource = new InputSource(inputStream);
            xMLReader.parse(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        ExternalTerminalProvider.init();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Context {
        unknown,
        root,
        terminaldefinition,
        terminal,
        searchpaths,
        searchpath,
        arguments,
        argument,
        validation,
        validation_platform,
        validation_test;

    }

    private static final class SAXHandler
    extends DefaultHandler {
        private Stack<Context> context = new Stack();
        private TerminalProfile info;
        private StringBuilder accumulator = new StringBuilder();
        private int version = 1;

        private SAXHandler() {
            this.info = new TerminalProfile();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.accumulator.setLength(0);
            if ("terminaldefinition".equals(string3)) {
                this.context.push(Context.root);
                String string4 = attributes.getValue("xmlns");
                if (string4 != null) {
                    int n = string4.lastIndexOf(47);
                    if (n >= 0 && n + 1 < string4.length()) {
                        String string5 = string4.substring(n + 1);
                        if (string5.length() > 0) {
                            try {
                                this.version = Integer.parseInt(string5);
                            }
                            catch (NumberFormatException numberFormatException) {
                                log.fine("Incorrect version information:" + string4);
                            }
                        }
                    } else {
                        log.fine("Incorrect version information:" + string4);
                    }
                }
            } else {
                this.context.push(this.elementStarted(string3, attributes));
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.accumulator.append(cArray, n, n2);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            Context context = this.context.pop();
            if (context != Context.root) {
                this.elementEnded(context, this.accumulator.toString());
            } else {
                ArrayList<TerminalProfile> arrayList = (ArrayList<TerminalProfile>)profiles.get(this.info.getID());
                if (arrayList == null) {
                    arrayList = new ArrayList<TerminalProfile>();
                    profiles.put(this.info.getID(), arrayList);
                }
                arrayList.add(this.info);
            }
        }

        public Context elementStarted(String string, Attributes attributes) {
            Context context = (Context)((Object)this.context.lastElement());
            if ("terminal".equals(string)) {
                this.info.setID(attributes.getValue("id"));
                return Context.terminal;
            }
            if ("validation".equals(string)) {
                return Context.validation;
            }
            if (context == Context.validation) {
                if ("platforms".equals(string)) {
                    return Context.validation_platform;
                }
                if ("test".equals(string)) {
                    this.info.addValidationCommand(attributes.getValue("command"));
                    return Context.validation_test;
                }
            }
            if ("searchpaths".equals(string)) {
                return Context.searchpaths;
            }
            if (context == Context.searchpaths && "path".equals(string)) {
                return Context.searchpath;
            }
            if ("platforms".equals(string)) {
                return Context.terminaldefinition;
            }
            if ("command".equals(string)) {
                this.info.setCommand(attributes.getValue("stringvalue"));
                return Context.terminaldefinition;
            }
            if ("arguments".equals(string)) {
                return Context.arguments;
            }
            if (context == Context.arguments && "arg".equals(string)) {
                return Context.argument;
            }
            return Context.unknown;
        }

        private void elementEnded(Context context, String string) {
            switch (context) {
                case argument: {
                    this.info.addArgument(string);
                    break;
                }
                case validation_platform: {
                    this.info.setSupportedPlatforms(string);
                    break;
                }
                case searchpath: {
                    this.info.addSearchPath(string);
                }
            }
        }
    }
}

