/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.netbeans.modules.nativeexecution.api.util.SolarisPrivilegesSupportProvider;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.netbeans.modules.nativeexecution.support.RemoteUserInfoProvider;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public final class ConnectionManager {
    private static final java.util.logging.Logger log = org.netbeans.modules.nativeexecution.support.Logger.getInstance();
    private static final ConnectionManager instance = new ConnectionManager();
    private final HashMap<ExecutionEnvironment, Session> sessions;
    private final JSch jsch;
    private volatile boolean connecting;
    AtomicInteger idx = new AtomicInteger();

    private ConnectionManager() {
        JSch.setConfig((String)"PreferredAuthentications", (String)"password,keyboard-interactive");
        this.jsch = new JSch();
        if (log.isLoggable(Level.FINEST)) {
            JSch.setLogger((Logger)new Logger(){

                public boolean isEnabled(int n) {
                    return true;
                }

                public void log(int n, String string) {
                    log.log(Level.FINEST, "JSCH: " + string);
                }
            });
        }
        this.connecting = false;
        try {
            this.jsch.setKnownHosts(System.getProperty("user.home") + "/.ssh/known_hosts");
        }
        catch (JSchException jSchException) {
            log.warning("Unable to setKnownHosts for jsch. " + jSchException.getMessage());
        }
        this.sessions = new HashMap();
    }

    public static ConnectionManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession(ExecutionEnvironment executionEnvironment, boolean bl) {
        int n = 2;
        Session session = null;
        HashMap<ExecutionEnvironment, Session> hashMap = this.sessions;
        synchronized (hashMap) {
            while (n-- > 0) {
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                session = this.sessions.get(executionEnvironment);
                if (session == null || session.isConnected()) break;
                SolarisPrivilegesSupportProvider.getSupportFor(executionEnvironment).invalidate();
                if (!bl) continue;
                session = null;
                try {
                    this.doConnect(executionEnvironment, RemoteUserInfoProvider.getUserInfo(executionEnvironment, false));
                }
                catch (IOException iOException) {
                    log.log(Level.FINEST, Thread.currentThread() + " : ConnectionManager.getSession()", iOException);
                }
                catch (CancellationException cancellationException) {
                    log.log(Level.FINEST, Thread.currentThread() + " : ConnectionManager.getSession()", cancellationException);
                }
            }
            return session;
        }
    }

    public boolean connectTo(ExecutionEnvironment executionEnvironment, char[] cArray, boolean bl) throws IOException, CancellationException {
        if (executionEnvironment.isLocal()) {
            return true;
        }
        Session session = this.getSession(executionEnvironment, false);
        if (session != null && session.isConnected()) {
            return true;
        }
        if (cArray != null) {
            PasswordManager.getInstance().put(executionEnvironment, cArray, bl);
        }
        return this.doConnect(executionEnvironment, RemoteUserInfoProvider.getUserInfo(executionEnvironment, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connectTo(ExecutionEnvironment executionEnvironment) throws IOException, CancellationException {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (this.connecting) {
                return false;
            }
            this.connecting = true;
        }
        try {
            boolean bl = false;
            executionEnvironment.prepareForConnection();
            char[] cArray = PasswordManager.getInstance().get(executionEnvironment);
            if (cArray == null || cArray.length == 0) {
                bl = this.doConnect(executionEnvironment, RemoteUserInfoProvider.getUserInfo(executionEnvironment, true));
            } else {
                try {
                    bl = this.connectTo(executionEnvironment, cArray, false);
                }
                catch (ConnectException connectException) {
                    if (connectException.getMessage().equals("Auth fail")) {
                        bl = this.doConnect(executionEnvironment, RemoteUserInfoProvider.getUserInfo(executionEnvironment, true));
                    }
                    throw connectException;
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.connecting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doConnect(final ExecutionEnvironment executionEnvironment, final UserInfo userInfo) throws IOException, CancellationException {
        try {
            Callable<Session> callable = new Callable<Session>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Session call() throws Exception {
                    String string = executionEnvironment.getUser();
                    String string2 = executionEnvironment.getHostAddress();
                    int n = executionEnvironment.getSSHPort();
                    try {
                        JSch jSch = ConnectionManager.this.jsch;
                        synchronized (jSch) {
                            Session session = ConnectionManager.this.jsch.getSession(string, string2, n);
                            session.setUserInfo(userInfo);
                            session.connect();
                            return session;
                        }
                    }
                    catch (JSchException jSchException) {
                        if (jSchException.getMessage().equals("Auth fail")) {
                            throw new ConnectException(jSchException.getMessage());
                        }
                        if (jSchException.getMessage().equals("Auth cancel")) {
                            throw new CancellationException(jSchException.getMessage());
                        }
                        Throwable throwable = jSchException.getCause();
                        if (throwable != null && throwable instanceof IOException) {
                            throw (IOException)throwable;
                        }
                        throw new IOException(jSchException.getMessage());
                    }
                }
            };
            final Future<Session> future = NativeTaskExecutorService.submit(callable, "Connect to " + ((Object)executionEnvironment).toString());
            Cancellable cancellable = new Cancellable(){

                public boolean cancel() {
                    return future.cancel(true);
                }
            };
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)ConnectionManager.loc("ConnectionManager.Connecting", ((Object)executionEnvironment).toString()), (Cancellable)cancellable);
            progressHandle.start();
            Session session = null;
            try {
                session = future.get();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable != null) {
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    if (throwable instanceof CancellationException) {
                        throw (CancellationException)throwable;
                    }
                }
                throw new IOException(executionException.getMessage());
            }
            finally {
                progressHandle.finish();
            }
            if (session != null) {
                HashMap<ExecutionEnvironment, Session> hashMap = this.sessions;
                synchronized (hashMap) {
                    this.sessions.put(executionEnvironment, session);
                }
                NativeTaskExecutorService.submit(new Runnable(){

                    public void run() {
                        try {
                            HostInfoUtils.getHostInfo(executionEnvironment);
                        }
                        catch (IOException iOException) {
                        }
                        catch (CancellationException cancellationException) {
                            // empty catch block
                        }
                    }
                }, "Fetch hosts info " + ((Object)executionEnvironment).toString());
                log.fine("New connection established: " + ((Object)executionEnvironment).toString());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.connecting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectedTo(ExecutionEnvironment executionEnvironment) {
        if (executionEnvironment.isLocal()) {
            return true;
        }
        HashMap<ExecutionEnvironment, Session> hashMap = this.sessions;
        synchronized (hashMap) {
            if (this.sessions.containsKey(executionEnvironment)) {
                return this.sessions.get(executionEnvironment).isConnected();
            }
            return false;
        }
    }

    public AsynchronousAction getConnectToAction(ExecutionEnvironment executionEnvironment, Runnable runnable) {
        return new ConnectToAction(executionEnvironment, runnable);
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(ConnectionManager.class, (String)string, (Object[])stringArray);
    }

    static {
        ConnectionManagerAccessor.setDefault(new ConnectionManagerAccessorImpl());
    }

    private static final class ConnectionManagerAccessorImpl
    extends ConnectionManagerAccessor {
        private ConnectionManagerAccessorImpl() {
        }

        public Session getConnectionSession(ConnectionManager connectionManager, ExecutionEnvironment executionEnvironment, boolean bl) {
            return connectionManager.getSession(executionEnvironment, bl);
        }
    }

    private static class ConnectToAction
    extends AbstractAction
    implements AsynchronousAction {
        private static final ConnectionManager cm = ConnectionManager.getInstance();
        private final ExecutionEnvironment env;
        private final Runnable onConnect;

        private ConnectToAction(ExecutionEnvironment executionEnvironment, Runnable runnable) {
            this.env = executionEnvironment;
            this.onConnect = runnable;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NativeTaskExecutorService.submit(new Runnable(){

                public void run() {
                    try {
                        ConnectToAction.this.invoke();
                    }
                    catch (Throwable throwable) {
                        log.warning(throwable.getMessage());
                    }
                }
            }, "Connecting to " + ((Object)this.env).toString());
        }

        public void invoke() throws IOException, CancellationException {
            boolean bl = cm.connectTo(this.env);
            if (bl) {
                this.onConnect.run();
            }
        }
    }
}

