/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.nativeexecution.AbstractNativeProcess;
import org.netbeans.modules.nativeexecution.ExternalTerminalAccessor;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminal;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.support.EnvWriter;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.MacroMap;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class TerminalLocalNativeProcess
extends AbstractNativeProcess {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final File dorunScript;
    private ExternalTerminal terminal;
    private InputStream processOutput;
    private InputStream processError;
    private File resultFile;
    private final boolean isWindows;
    private final boolean isMacOS;

    public TerminalLocalNativeProcess(NativeProcessInfo nativeProcessInfo, ExternalTerminal externalTerminal) {
        super(nativeProcessInfo);
        this.terminal = externalTerminal;
        this.processOutput = new ByteArrayInputStream((TerminalLocalNativeProcess.loc("TerminalLocalNativeProcess.ProcessStarted.text", new String[0]) + '\n').getBytes());
        this.isWindows = this.hostInfo != null && this.hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS;
        this.isMacOS = this.hostInfo != null && this.hostInfo.getOSFamily() == HostInfo.OSFamily.MACOSX;
    }

    protected void create() throws Throwable {
        try {
            Object object;
            Object object2;
            if (dorunScript == null) {
                throw new IOException(TerminalLocalNativeProcess.loc("TerminalLocalNativeProcess.dorunNotFound.text", new String[0]));
            }
            if (this.isWindows && this.hostInfo.getShell() == null) {
                throw new IOException(TerminalLocalNativeProcess.loc("NativeProcess.shellNotFound.text", new String[0]));
            }
            String string = this.info.getCommandLineForShell();
            String string2 = this.info.getWorkingDirectory(true);
            String string3 = string2 == null || this.isWindows ? "." : new File(string2).getAbsolutePath();
            File file = File.createTempFile("dlight", "termexec");
            file.deleteOnExit();
            this.resultFile = new File(file.getAbsolutePath() + ".res");
            String string4 = file.toString();
            String string5 = string4 + ".env";
            ExternalTerminalAccessor externalTerminalAccessor = ExternalTerminalAccessor.getDefault();
            if (externalTerminalAccessor.getTitle(this.terminal) == null) {
                this.terminal = this.terminal.setTitle(string);
            }
            String string6 = string;
            if (this.isWindows) {
                string4 = string4.replaceAll("\\\\", "/");
                string5 = string5.replaceAll("\\\\", "/");
            }
            List<String> list = externalTerminalAccessor.wrapCommand(this.info.getExecutionEnvironment(), this.terminal, dorunScript.getAbsolutePath(), "-w", string3, "-e", string5, "-p", string4, "-x", externalTerminalAccessor.getPrompt(this.terminal), string6);
            ProcessBuilder processBuilder = new ProcessBuilder(list);
            if ((this.isWindows || this.isMacOS) && string2 != null) {
                processBuilder.directory(new File(string2));
            }
            MacroMap macroMap = this.info.getEnvVariables();
            if (this.isMacOS) {
                object2 = new ProcessBuilder("/bin/sh", "-c", "/bin/echo $DISPLAY");
                object = ((ProcessBuilder)object2).start();
                int n = ((Process)object).waitFor();
                String string7 = null;
                if (n == 0) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
                    string7 = bufferedReader.readLine();
                }
                if (string7 == null || "".equals(string7)) {
                    string7 = ":0.0";
                }
                processBuilder.environment().put("DISPLAY", string7);
            }
            if (!macroMap.isEmpty()) {
                if (this.isWindows) {
                    object2 = macroMap.get("PATH");
                    macroMap.put("PATH", WindowsSupport.getInstance().convertToAllShellPaths((String)object2));
                }
                macroMap.put("PATH", "/bin:/usr/bin:$PATH");
                object2 = new File(string5);
                object = new FileOutputStream((File)object2);
                EnvWriter envWriter = new EnvWriter((OutputStream)object);
                envWriter.write(macroMap);
                ((OutputStream)object).close();
            }
            this.processError = new ByteArrayInputStream(new byte[0]);
            this.waitPID(processBuilder.start(), file);
        }
        catch (Throwable throwable) {
            String string = throwable.getMessage() == null ? throwable.toString() : throwable.getMessage();
            this.processError = new ByteArrayInputStream(string.getBytes());
            this.resultFile = null;
            throw throwable;
        }
    }

    public void cancel() {
        this.sendSignal(9);
    }

    private synchronized int sendSignal(int n) {
        int n2 = 1;
        int n3 = -1;
        try {
            n3 = this.getPID();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n3 < 0) {
            return -1;
        }
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.isWindows) {
                arrayList.add(this.hostInfo.getShell());
                arrayList.add("-c");
                arrayList.add("kill -" + n + " " + this.getPID());
            } else {
                arrayList.add("/bin/kill");
                arrayList.add("-" + n);
                arrayList.add("" + this.getPID());
            }
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            Process process = processBuilder.start();
            n2 = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return n2;
    }

    public int waitResult() throws InterruptedException {
        int n = -1;
        try {
            n = this.getPID();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n < 0) {
            return -1;
        }
        if (this.isWindows || this.isMacOS) {
            while (this.sendSignal(0) == 0) {
                Thread.sleep(300L);
            }
        } else {
            File file = new File("/proc/" + n);
            while (file.exists()) {
                Thread.sleep(300L);
            }
        }
        if (this.resultFile == null) {
            return -1;
        }
        int n2 = -1;
        try {
            this.resultFile.deleteOnExit();
            int n3 = 10;
            while (n3-- > 0) {
                if (this.resultFile.exists() && this.resultFile.length() > 0L) {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(this.resultFile));
                    String string = bufferedReader.readLine();
                    if (string != null) {
                        n2 = Integer.parseInt(string.trim());
                    }
                    break;
                }
                Thread.sleep(500L);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException();
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public OutputStream getOutputStream() {
        return null;
    }

    public InputStream getInputStream() {
        return this.processOutput;
    }

    public InputStream getErrorStream() {
        return this.processError;
    }

    private void waitPID(Process process, File file) throws IOException {
        while (!this.isInterrupted()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            if (file.exists() && file.length() > 0L) {
                FileInputStream fileInputStream = new FileInputStream(file);
                this.readPID(fileInputStream);
                ((InputStream)fileInputStream).close();
                break;
            }
            try {
                int n = process.exitValue();
                if (n != 0) {
                    log.info(TerminalLocalNativeProcess.loc("TerminalLocalNativeProcess.terminalFailed.text", new String[0]));
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        log.info("- " + string);
                        string = bufferedReader.readLine();
                    }
                }
                this.interrupt();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        }
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(TerminalLocalNativeProcess.class, (String)string, (Object[])stringArray);
    }

    static {
        InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
        dorunScript = installedFileLocator.locate("bin/nativeexecution/dorun.sh", null, false);
        if (dorunScript != null) {
            CommonTasksSupport.chmod(ExecutionEnvironmentFactory.getLocal(), dorunScript.getAbsolutePath(), 493, null);
        } else {
            log.severe("Unable to locate bin/nativeexecution/dorun.sh file!");
        }
    }
}

