/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

public final class ExecutionEnvironmentImpl
implements ExecutionEnvironment {
    private final String user;
    private final String host;
    private final int sshPort;
    private final String toString;

    ExecutionEnvironmentImpl() {
        this(null, null);
    }

    ExecutionEnvironmentImpl(String string, String string2) {
        this(string, string2, 0);
    }

    ExecutionEnvironmentImpl(String string, String string2, int n) {
        this.user = string == null ? System.getProperty("user.name") : string;
        this.host = string2 == null ? "127.0.0.1" : string2;
        this.sshPort = !HostInfoUtils.isLocalhost(string2) && n == 0 ? 22 : n;
        this.toString = this.user + "@" + this.host + (this.sshPort == 0 ? "" : ":" + this.sshPort);
    }

    public String getHost() {
        return this.host;
    }

    public String getHostAddress() {
        return this.getHost();
    }

    public String getDisplayName() {
        if (this.isLocal()) {
            return "localhost";
        }
        String string = this.user + "@" + this.host;
        if (this.sshPort != 22) {
            string = string + ":" + this.sshPort;
        }
        return string;
    }

    public String toString() {
        return this.toString;
    }

    public String getUser() {
        return this.user;
    }

    public int getSSHPort() {
        return this.sshPort;
    }

    public boolean isRemote() {
        return !this.isLocal();
    }

    public boolean isLocal() {
        return this.sshPort == 0;
    }

    public boolean equals(Object object) {
        ExecutionEnvironmentImpl executionEnvironmentImpl = null;
        if (object == null || !(object instanceof ExecutionEnvironmentImpl)) {
            return false;
        }
        executionEnvironmentImpl = (ExecutionEnvironmentImpl)object;
        boolean bl = HostInfoUtils.isLocalhost(executionEnvironmentImpl.host) && HostInfoUtils.isLocalhost(this.host);
        boolean bl2 = (bl || executionEnvironmentImpl.host.equals(this.host)) && executionEnvironmentImpl.user.equals(this.user) && executionEnvironmentImpl.sshPort == this.sshPort;
        return bl2;
    }

    public final int hashCode() {
        int n = 7;
        n = 97 * n + (this.user != null ? this.user.hashCode() : 0);
        n = 97 * n + (this.host != null ? this.host.hashCode() : 0);
        n = 97 * n + this.sshPort;
        return n;
    }

    public void prepareForConnection() throws IOException, CancellationException {
    }
}

