/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import antlr.TokenStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.apt.utils.ListBasedTokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APTMacroImpl
implements APTMacro {
    private final CharSequence file;
    private final APTDefine defineNode;
    private final APTMacro.Kind macroType;
    private volatile int hashCode = 0;

    public APTMacroImpl(CharSequence charSequence, APTDefine aPTDefine, APTMacro.Kind kind) {
        assert (aPTDefine.getName() != null);
        this.file = charSequence;
        assert (charSequence != null);
        assert (charSequence.length() == 0 || kind == APTMacro.Kind.DEFINED) : "file info has only #defined macro " + charSequence;
        this.defineNode = aPTDefine;
        this.macroType = kind;
    }

    @Override
    public CharSequence getFile() {
        return this.file;
    }

    @Override
    public APTMacro.Kind getKind() {
        return this.macroType;
    }

    @Override
    public boolean isFunctionLike() {
        return this.defineNode.isFunctionLike();
    }

    @Override
    public APTToken getName() {
        return this.defineNode.getName();
    }

    @Override
    public Collection<APTToken> getParams() {
        return this.defineNode.getParams();
    }

    @Override
    public TokenStream getBody() {
        return new ListBasedTokenStream(this.defineNode.getBody());
    }

    @Override
    public APTDefine getDefineNode() {
        return this.defineNode;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == null || !(object instanceof APTMacroImpl)) {
            bl = false;
        } else {
            APTMacroImpl aPTMacroImpl = (APTMacroImpl)object;
            bl = APTMacroImpl.equals(this, aPTMacroImpl);
        }
        return bl;
    }

    private static final boolean equals(APTMacroImpl aPTMacroImpl, APTMacroImpl aPTMacroImpl2) {
        if (aPTMacroImpl.macroType != aPTMacroImpl2.macroType) {
            return false;
        }
        if (aPTMacroImpl.file == aPTMacroImpl2.file && aPTMacroImpl.file != null && !aPTMacroImpl.file.equals(aPTMacroImpl2.file)) {
            return false;
        }
        return aPTMacroImpl.defineNode.equals(aPTMacroImpl2.defineNode);
    }

    public int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = 31 * n + this.macroType.ordinal();
            n = 31 * n + (this.file == null ? 0 : this.file.hashCode());
            this.hashCode = n = 31 * n + this.defineNode.hashCode();
        }
        return n;
    }

    public String toString() {
        TokenStream tokenStream;
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.getKind()) {
            case DEFINED: {
                stringBuilder.append("<U>");
                break;
            }
            case COMPILER_PREDEFINED: {
                stringBuilder.append("<S>");
                break;
            }
            case POSITION_PREDEFINED: {
                stringBuilder.append("<S>");
                break;
            }
            default: {
                stringBuilder.append("<S>");
            }
        }
        stringBuilder.append("#define '");
        stringBuilder.append(this.getName());
        if (this.getParams() != null) {
            stringBuilder.append("[");
            boolean bl = true;
            for (APTToken aPTToken : this.getParams()) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                stringBuilder.append(aPTToken);
            }
            stringBuilder.append("]");
        }
        if ((tokenStream = this.getBody()) != null) {
            stringBuilder.append("'='");
            stringBuilder.append(APTUtils.toString(tokenStream));
        }
        return stringBuilder.toString();
    }

    public void write(DataOutput dataOutput) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public APTMacroImpl(DataInput dataInput) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

