/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.APTBaseMacroMap;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroImpl;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroMapSnapshot;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTFileMacroMap
extends APTBaseMacroMap {
    private APTMacroMap sysMacroMap;
    private Map<CharSequence, APTMacro> macroCache = new HashMap<CharSequence, APTMacro>();
    private Stack<CharSequence> expandingMacros = new Stack();
    private static final Lock maRefLock = new ReentrantLock();
    private static Reference<ConcurrentMap<APTMacro, APTMacro>> mapRef = new SoftReference(new ConcurrentHashMap());
    private static volatile long cacheHits = 0L;
    private static volatile long cacheCollisionsHits = 0L;
    private static final boolean TRACE_HITS = false;

    public APTFileMacroMap() {
    }

    public APTFileMacroMap(APTMacroMap aPTMacroMap, List<String> list) {
        if (aPTMacroMap == null) {
            aPTMacroMap = APTBaseMacroMap.EMPTY;
        }
        this.sysMacroMap = aPTMacroMap;
        this.fill(list, false);
    }

    public void setSysMacros(APTMacroMap aPTMacroMap) {
        this.sysMacroMap = aPTMacroMap;
    }

    @Override
    public APTMacro getMacro(APTToken aPTToken) {
        CharSequence charSequence = aPTToken.getTextID();
        APTMacro aPTMacro = this.macroCache.get(charSequence);
        if (aPTMacro == null) {
            aPTMacro = super.getMacro(aPTToken);
            if (aPTMacro == null && this.sysMacroMap != null) {
                aPTMacro = this.sysMacroMap.getMacro(aPTToken);
            }
            if (aPTMacro == null) {
                aPTMacro = APTMacroMapSnapshot.UNDEFINED_MACRO;
            }
            if (aPTMacro.getKind() != APTMacro.Kind.POSITION_PREDEFINED) {
                this.macroCache.put(charSequence, aPTMacro);
            }
        }
        return aPTMacro != APTMacroMapSnapshot.UNDEFINED_MACRO ? aPTMacro : null;
    }

    @Override
    public void define(APTFile aPTFile, APTDefine aPTDefine, APTMacro.Kind kind) {
        APTToken aPTToken = aPTDefine.getName();
        super.define(aPTFile, aPTDefine, APTMacro.Kind.DEFINED);
        this.macroCache.remove(aPTToken.getTextID());
    }

    @Override
    public void undef(APTFile aPTFile, APTToken aPTToken) {
        super.undef(aPTFile, aPTToken);
        this.macroCache.remove(aPTToken.getTextID());
    }

    @Override
    protected APTMacro createMacro(CharSequence charSequence, APTDefine aPTDefine, APTMacro.Kind kind) {
        ConcurrentMap<APTMacro, APTMacro> concurrentMap;
        APTMacroImpl aPTMacroImpl = new APTMacroImpl(charSequence, aPTDefine, kind);
        APTMacro aPTMacro = null;
        if (APTTraceFlags.APT_SHARE_MACROS && (aPTMacro = (APTMacro)(concurrentMap = APTFileMacroMap.getSharedMap()).get(aPTMacroImpl)) == null) {
            aPTMacro = concurrentMap.putIfAbsent(aPTMacroImpl, aPTMacroImpl);
        }
        return aPTMacro != null ? aPTMacro : aPTMacroImpl;
    }

    @Override
    protected APTMacroMapSnapshot makeSnapshot(APTMacroMapSnapshot aPTMacroMapSnapshot) {
        return new APTMacroMapSnapshot(aPTMacroMapSnapshot);
    }

    @Override
    public APTMacroMap.State getState() {
        this.changeActiveSnapshotIfNeeded();
        return new FileStateImpl(this.active.parent, this.sysMacroMap);
    }

    @Override
    public void setState(APTMacroMap.State state) {
        this.active = this.makeSnapshot(((APTBaseMacroMap.StateImpl)state).snap);
        if (state instanceof FileStateImpl) {
            this.sysMacroMap = ((FileStateImpl)state).sysMacroMap;
        }
        this.macroCache.clear();
    }

    @Override
    public boolean pushExpanding(APTToken aPTToken) {
        assert (aPTToken != null);
        if (!this.isExpanding(aPTToken)) {
            this.expandingMacros.push(aPTToken.getTextID());
            return true;
        }
        return false;
    }

    @Override
    public void popExpanding() {
        block2: {
            try {
                this.expandingMacros.pop();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"why pop from empty stack?");
            }
        }
    }

    @Override
    public boolean isExpanding(APTToken aPTToken) {
        try {
            return this.expandingMacros.contains(aPTToken.getTextID());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            assert (false) : "why ask empty stack?";
            return false;
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Own Map:\n");
        stringBuilder.append(super.toString());
        stringBuilder.append("System Map:\n");
        stringBuilder.append(this.sysMacroMap);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentMap<APTMacro, APTMacro> getSharedMap() {
        ConcurrentMap<APTMacro, APTMacro> concurrentMap = mapRef.get();
        if (concurrentMap == null) {
            try {
                maRefLock.lock();
                concurrentMap = mapRef.get();
                if (concurrentMap == null) {
                    cacheHits = 0L;
                    cacheCollisionsHits = 0L;
                    concurrentMap = new ConcurrentHashMap<APTMacro, APTMacro>();
                    mapRef = new SoftReference<ConcurrentMap<APTMacro, APTMacro>>(concurrentMap);
                }
            }
            finally {
                maRefLock.unlock();
            }
        }
        return concurrentMap;
    }

    private static void traceHits(int n) {
        if (cacheHits % 5000L == 0L) {
            System.err.printf("%s hits with %s collisions, map size %s\n", cacheHits, cacheCollisionsHits, n);
        }
    }

    public static class FileStateImpl
    extends APTBaseMacroMap.StateImpl {
        public final APTMacroMap sysMacroMap;

        public FileStateImpl(APTMacroMapSnapshot aPTMacroMapSnapshot, APTMacroMap aPTMacroMap) {
            super(aPTMacroMapSnapshot);
            this.sysMacroMap = aPTMacroMap;
        }

        private FileStateImpl(FileStateImpl fileStateImpl, boolean bl) {
            super(fileStateImpl, bl);
            this.sysMacroMap = fileStateImpl.sysMacroMap;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("FileState\n");
            stringBuilder.append("Snapshot\n");
            stringBuilder.append(super.toString());
            stringBuilder.append("\nSystem MacroMap\n");
            stringBuilder.append(this.sysMacroMap);
            return stringBuilder.toString();
        }

        public void write(DataOutput dataOutput) throws IOException {
            super.write(dataOutput);
            APTSerializeUtils.writeSystemMacroMap(this.sysMacroMap, dataOutput);
        }

        public FileStateImpl(DataInput dataInput) throws IOException {
            super(dataInput);
            APTMacroMap aPTMacroMap = APTSerializeUtils.readSystemMacroMap(dataInput);
            this.sysMacroMap = aPTMacroMap == null ? APTBaseMacroMap.EMPTY : aPTMacroMap;
        }

        public APTBaseMacroMap.StateImpl copyCleaned() {
            return new FileStateImpl(this, true);
        }
    }
}

