/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import antlr.TokenStream;
import java.io.IOException;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTBuilder;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public class APTDriverImpl {
    private static final ConcurrentHashMap<CharSequence, APTSyncCreator> file2creator = new ConcurrentHashMap();
    private static Map<CharSequence, Reference<APTFile>> file2ref2apt = new ConcurrentHashMap<CharSequence, Reference<APTFile>>();
    private static Map<CharSequence, APTFile> file2apt = new ConcurrentHashMap<CharSequence, APTFile>();

    private APTDriverImpl() {
    }

    public static APTFile findAPT(APTFileBuffer aPTFileBuffer, boolean bl) throws IOException {
        CharSequence charSequence = aPTFileBuffer.getAbsolutePath();
        APTFile aPTFile = APTDriverImpl._getAPTFile(charSequence, bl);
        if (aPTFile == null) {
            APTSyncCreator aPTSyncCreator;
            APTSyncCreator aPTSyncCreator2 = file2creator.get(charSequence);
            if (aPTSyncCreator2 == null && (aPTSyncCreator = file2creator.putIfAbsent(charSequence, aPTSyncCreator2 = new APTSyncCreator())) != null) {
                aPTSyncCreator2 = aPTSyncCreator;
            }
            assert (aPTSyncCreator2 != null);
            aPTFile = aPTSyncCreator2.findAPT(aPTFileBuffer, bl);
            file2creator.remove(charSequence);
        }
        return aPTFile;
    }

    public static void invalidateAPT(APTFileBuffer aPTFileBuffer) {
        CharSequence charSequence = aPTFileBuffer.getAbsolutePath();
        if (APTTraceFlags.APT_USE_SOFT_REFERENCE) {
            file2ref2apt.remove(charSequence);
        } else {
            file2apt.remove(charSequence);
        }
    }

    public static void invalidateAll() {
        if (APTTraceFlags.APT_USE_SOFT_REFERENCE) {
            file2ref2apt.clear();
        } else {
            file2apt.clear();
        }
    }

    private static APTFile _getAPTFile(CharSequence charSequence, boolean bl) {
        Reference<APTFile> reference;
        if (bl) {
            return null;
        }
        APTFile aPTFile = APTTraceFlags.APT_USE_SOFT_REFERENCE ? ((reference = file2ref2apt.get(charSequence)) == null ? null : reference.get()) : file2apt.get(charSequence);
        return aPTFile;
    }

    private static void _putAPTFile(CharSequence charSequence, APTFile aPTFile, boolean bl) {
        if (bl) {
            return;
        }
        if (APTTraceFlags.APT_USE_SOFT_REFERENCE) {
            file2ref2apt.put(charSequence, new SoftReference<APTFile>(aPTFile));
        } else {
            file2apt.put(charSequence, aPTFile);
        }
    }

    public static void close() {
        APTDriverImpl.invalidateAll();
    }

    private static class APTSyncCreator {
        private APTFile fullAPT = null;
        private APTFile lightAPT = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized APTFile findAPT(APTFileBuffer aPTFileBuffer, boolean bl) throws IOException {
            CharSequence charSequence = aPTFileBuffer.getAbsolutePath();
            if (bl && this.fullAPT != null) {
                return this.fullAPT;
            }
            if (!bl && this.lightAPT != null) {
                return this.lightAPT;
            }
            APTFile aPTFile = APTDriverImpl._getAPTFile(charSequence, bl);
            if (aPTFile != null) return aPTFile;
            Reader reader = null;
            try {
                TokenStream tokenStream;
                reader = aPTFileBuffer.getReader();
                if (!bl) {
                    tokenStream = APTTokenStreamBuilder.buildLightTokenStream(charSequence, reader);
                    aPTFile = APTBuilder.buildAPT(charSequence, tokenStream);
                    this.fullAPT = null;
                    if (aPTFile != null) {
                        if (APTTraceFlags.TEST_APT_SERIALIZATION) {
                            APTFile aPTFile2 = (APTFile)APTSerializeUtils.testAPTSerialization(aPTFileBuffer, aPTFile);
                            if (aPTFile2 != null) {
                                aPTFile = aPTFile2;
                            } else {
                                System.err.println("error on serialization apt for file " + charSequence);
                            }
                        }
                        this.lightAPT = aPTFile;
                        APTDriverImpl._putAPTFile(charSequence, this.lightAPT, false);
                    }
                } else {
                    tokenStream = APTTokenStreamBuilder.buildTokenStream(charSequence, reader);
                    this.fullAPT = aPTFile = APTBuilder.buildAPT(charSequence, tokenStream);
                    if (aPTFile != null) {
                        if (APTTraceFlags.TEST_APT_SERIALIZATION) {
                            APTFile aPTFile3 = (APTFile)APTSerializeUtils.testAPTSerialization(aPTFileBuffer, aPTFile);
                            if (aPTFile3 != null) {
                                aPTFile = aPTFile3;
                            } else {
                                System.err.println("error on serialization apt for file " + charSequence);
                            }
                        }
                        APTDriverImpl._putAPTFile(charSequence, this.fullAPT, true);
                        this.lightAPT = (APTFile)APTBuilder.buildAPTLight(aPTFile);
                        APTDriverImpl._putAPTFile(charSequence, this.lightAPT, false);
                    }
                }
                if (reader == null) return aPTFile;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    APTUtils.LOG.log(Level.SEVERE, "exception on closing stream\n{0}", new Object[]{iOException});
                }
                throw throwable;
            }
            try {
                reader.close();
                return aPTFile;
            }
            catch (IOException iOException) {
                APTUtils.LOG.log(Level.SEVERE, "exception on closing stream\n{0}", new Object[]{iOException});
            }
            return aPTFile;
        }
    }
}

