/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.j2ee.clientproject.api.AppClientProjectGenerator;
import org.netbeans.modules.j2ee.common.SharabilityUtility;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ModuleType;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.j2ee.earproject.util.EarProjectUtil;
import org.netbeans.modules.j2ee.ejbjarproject.api.EjbJarProjectGenerator;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.web.project.api.WebProjectCreateData;
import org.netbeans.modules.web.project.api.WebProjectUtilities;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EarProjectGenerator {
    private static final String DEFAULT_DOC_BASE_FOLDER = "src/conf";
    private static final String DEFAULT_BUILD_DIR = "build";
    private static final String DEFAULT_RESOURCE_FOLDER = "setup";
    private static final String SOURCE_ROOT_REF = "${source.root}";
    private final File prjDir;
    private final String name;
    private final String j2eeLevel;
    private final String serverInstanceID;
    private final String sourceLevel;
    private final FileObject prjDirFO;
    private String librariesDefinition;
    private String serverLibraryName;

    private EarProjectGenerator(File file, FileObject fileObject, String string, String string2, String string3, String string4, String string5, String string6) {
        this.prjDir = file;
        this.prjDirFO = fileObject;
        this.name = string;
        this.j2eeLevel = string2;
        this.serverInstanceID = string3;
        if (string4 != null && (string4.equals("1.6") || string4.equals("1.7"))) {
            string4 = "1.5";
        }
        this.sourceLevel = string4;
        this.librariesDefinition = string5;
        this.serverLibraryName = string6;
    }

    public static AntProjectHelper createProject(File file, String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        FileObject fileObject = FileUtil.createFolder((File)file);
        final EarProjectGenerator earProjectGenerator = new EarProjectGenerator(file, fileObject, string, string2, string3, string4, string5, string6);
        final AntProjectHelper[] antProjectHelperArray = new AntProjectHelper[1];
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper antProjectHelper;
                antProjectHelperArray[0] = antProjectHelper = earProjectGenerator.doCreateProject();
            }
        });
        return antProjectHelperArray[0];
    }

    public static AntProjectHelper importProject(File file, final File file2, String string, String string2, String string3, final String string4, String string5, final Map<FileObject, ModuleType> map, String string6, String string7) throws IOException {
        FileObject fileObject = FileUtil.createFolder((File)file);
        final EarProjectGenerator earProjectGenerator = new EarProjectGenerator(file, fileObject, string, string2, string3, string5, string6, string7);
        final AntProjectHelper[] antProjectHelperArray = new AntProjectHelper[1];
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper antProjectHelper;
                antProjectHelperArray[0] = antProjectHelper = earProjectGenerator.doImportProject(file2, map, string4);
            }
        });
        return antProjectHelperArray[0];
    }

    private AntProjectHelper doCreateProject() throws IOException {
        final AntProjectHelper antProjectHelper = this.setupProject();
        FileObject fileObject = FileUtil.createFolder((FileObject)this.prjDirFO, (String)DEFAULT_DOC_BASE_FOLDER);
        FileUtil.copyFile((FileObject)FileUtil.getConfigFile((String)"org-netbeans-modules-j2ee-earproject/MANIFEST.MF"), (FileObject)fileObject, (String)"MANIFEST");
        final EarProject earProject = (EarProject)ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        final ReferenceHelper referenceHelper = earProject.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                    editableProperties.put("source.root", ".");
                    editableProperties.setProperty("meta.inf", EarProjectGenerator.DEFAULT_DOC_BASE_FOLDER);
                    editableProperties.setProperty("resource.dir", EarProjectGenerator.DEFAULT_RESOURCE_FOLDER);
                    antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                    ProjectManager.getDefault().saveProject((Project)earProject);
                    EarProjectGenerator.copyRequiredLibraries(antProjectHelper, referenceHelper, EarProjectGenerator.this.serverInstanceID, EarProjectGenerator.this.serverLibraryName);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException.getException());
        }
        EarProject earProject2 = (EarProject)earProject.getLookup().lookup(EarProject.class);
        assert (earProject2 != null);
        EarProjectGenerator.setupDD(this.j2eeLevel, fileObject, earProject2);
        return antProjectHelper;
    }

    private static void copyRequiredLibraries(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, String string, String string2) throws IOException {
        if (!antProjectHelper.isSharableProject()) {
            return;
        }
        if (antProjectHelper.isSharableProject() && string2 != null && SharabilityUtility.findSharedServerLibrary((File)antProjectHelper.resolveFile(antProjectHelper.getLibrariesLocation()), (String)string2) == null) {
            SharabilityUtility.createLibrary((File)antProjectHelper.resolveFile(antProjectHelper.getLibrariesLocation()), (String)string2, (String)string);
        }
        SharabilityUtility.makeSureProjectHasCopyLibsLibrary((AntProjectHelper)antProjectHelper, (ReferenceHelper)referenceHelper);
    }

    private AntProjectHelper doImportProject(File file, Map<FileObject, ModuleType> map, String string) throws IOException {
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        FileObject fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)DEFAULT_DOC_BASE_FOLDER);
        AntProjectHelper antProjectHelper = this.setupProject();
        ReferenceHelper referenceHelper = new ReferenceHelper(antProjectHelper, antProjectHelper.createAuxiliaryConfiguration(), antProjectHelper.getStandardPropertyEvaluator());
        String string2 = referenceHelper.createForeignFileReference(file, null);
        String string3 = this.createFileReference(referenceHelper, fileObject, fileObject2);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        editableProperties.setProperty("source.root", string2);
        editableProperties.setProperty("meta.inf", string3);
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        FileObject fileObject3 = antProjectHelper.getProjectDirectory();
        EarProject earProject = (EarProject)ProjectManager.getDefault().findProject(fileObject3).getLookup().lookup(EarProject.class);
        if (null != earProject) {
            Application application = null;
            try {
                FileObject fileObject4 = earProject.getAppModule().getDeploymentDescriptor();
                FileObject fileObject5 = null;
                if (null != fileObject4) {
                    Enumeration enumeration = fileObject4.getParent().getChildren(false);
                    while (null != enumeration && enumeration.hasMoreElements()) {
                        fileObject5 = (FileObject)enumeration.nextElement();
                        if (!fileObject5.isData() || !fileObject5.canRead()) continue;
                        try {
                            FileUtil.copyFile((FileObject)fileObject5, (FileObject)fileObject4.getParent(), (String)("original_" + fileObject5.getName()), (String)fileObject5.getExt());
                        }
                        catch (IOException iOException) {}
                    }
                    application = DDProvider.getDefault().getDDRoot(fileObject4);
                    Module[] moduleArray = application.getModule();
                    if (null != moduleArray && moduleArray.length > 0) {
                        earProject.getAppModule().getConfigSupport().ensureConfigurationReady();
                        for (int i = 0; i < moduleArray.length; ++i) {
                            application.removeModule(moduleArray[i]);
                        }
                        if (EarProjectUtil.isDDWritable(earProject)) {
                            application.write(earProject.getAppModule().getDeploymentDescriptor());
                        }
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(EarProjectGenerator.class, (String)"MESSAGE_CheckContextRoots"), 2));
                    }
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, iOException.getLocalizedMessage());
            }
        }
        EarProjectGenerator.setupDD(this.j2eeLevel, fileObject2, earProject);
        if (map == null || map.isEmpty()) {
            map = ModuleType.detectModules(fileObject);
        }
        this.addUserModules(earProject, map, string, antProjectHelper, earProject);
        ProjectManager.getDefault().saveProject((Project)earProject);
        earProject.getAppModule().getConfigSupport().createInitialConfiguration();
        if (this.sourceLevel != null) {
            EarProjectGenerator.setPlatformSourceLevel(antProjectHelper, this.sourceLevel);
        }
        return antProjectHelper;
    }

    private void addUserModules(EarProject earProject, Map<FileObject, ModuleType> map, String string, AntProjectHelper antProjectHelper, EarProject earProject2) throws IOException {
        HashSet<Project> hashSet = new HashSet<Project>();
        HashSet<Project> hashSet2 = new HashSet<Project>();
        block4: for (Map.Entry<FileObject, ModuleType> object : map.entrySet()) {
            FileObject fileObject = object.getKey();
            ModuleType moduleType = object.getValue();
            Project project = this.addModule(earProject, moduleType, string, fileObject);
            assert (project != null) : "Directory " + fileObject + " does not contain valid project";
            switch (moduleType) {
                case EJB: {
                    hashSet.add(project);
                    continue block4;
                }
                case WEB: 
                case CLIENT: {
                    hashSet2.add(project);
                    continue block4;
                }
            }
            assert (false) : "Unknown module type: " + (Object)((Object)moduleType);
        }
        Project[] projectArray = hashSet2.toArray(new Project[hashSet2.size()]);
        for (Project project : hashSet) {
            EarProjectGenerator.addEJBToClassPaths(project, projectArray);
        }
    }

    public static void addEJBToClassPaths(Project project, Project ... projectArray) throws IOException {
        AntArtifact[] antArtifactArray;
        assert (project != null);
        for (AntArtifact antArtifact : antArtifactArray = AntArtifactQuery.findArtifactsByType((Project)project, (String)"jar")) {
            for (Project project2 : projectArray) {
                if (project2 == null) continue;
                ProjectClassPathExtender projectClassPathExtender = (ProjectClassPathExtender)project2.getLookup().lookup(ProjectClassPathExtender.class);
                URI[] uRIArray = antArtifact.getArtifactLocations();
                if (projectClassPathExtender == null || uRIArray.length <= 0) continue;
                projectClassPathExtender.addAntArtifact(antArtifact, uRIArray[0].normalize());
            }
        }
    }

    private Project addModule(EarProject earProject, ModuleType moduleType, String string, FileObject fileObject) throws IllegalArgumentException, IOException {
        Project project = this.getExistingJ2EEModuleProject(fileObject);
        if (project != null) {
            EarProjectProperties.addJ2eeSubprojects(earProject, new Project[]{project});
            return project;
        }
        FileObject fileObject2 = this.getJavaRoot(fileObject);
        File[] fileArray = this.getSourceFolders(fileObject2);
        File file = FileUtil.normalizeFile((File)new File(this.prjDir, fileObject.getNameExt()));
        AntProjectHelper antProjectHelper = null;
        switch (moduleType) {
            case WEB: {
                antProjectHelper = this.addWebModule(fileObject, fileArray, file, string);
                break;
            }
            case EJB: {
                antProjectHelper = this.addEJBModule(fileObject2, fileObject, file, string);
                break;
            }
            case CLIENT: {
                antProjectHelper = this.addAppClientModule(fileObject2, fileObject, file, string);
                break;
            }
            default: {
                assert (false) : "Unknown module type: " + (Object)((Object)moduleType);
                break;
            }
        }
        Project project2 = null;
        if (null != antProjectHelper) {
            project2 = ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
            EarProjectProperties.addJ2eeSubprojects(earProject, new Project[]{project2});
        }
        return project2;
    }

    private Project getExistingJ2EEModuleProject(FileObject fileObject) throws IOException {
        Project project = ProjectManager.getDefault().findProject(fileObject);
        if (EarProjectUtil.isJavaEEModule(project)) {
            return project;
        }
        return null;
    }

    private AntProjectHelper addAppClientModule(FileObject fileObject, FileObject fileObject2, File file, String string) throws IOException {
        FileObject fileObject3 = FileUtil.createFolder((FileObject)fileObject2, (String)DEFAULT_DOC_BASE_FOLDER);
        File file2 = FileUtil.toFile((FileObject)fileObject3);
        AntProjectHelper antProjectHelper = AppClientProjectGenerator.importProject((File)file, (String)fileObject2.getName(), (File[])new File[]{FileUtil.toFile((FileObject)fileObject)}, (File[])new File[0], (File)file2, null, (String)EarProjectGenerator.checkJ2eeVersion(this.j2eeLevel, this.serverInstanceID, J2eeModule.CLIENT), (String)this.serverInstanceID);
        if (string != null || this.sourceLevel != null) {
            AppClientProjectGenerator.setPlatform((AntProjectHelper)antProjectHelper, (String)string, (String)this.sourceLevel);
        }
        return antProjectHelper;
    }

    private AntProjectHelper addEJBModule(FileObject fileObject, FileObject fileObject2, File file, String string) throws IOException {
        FileObject fileObject3 = FileUtil.createFolder((FileObject)fileObject2, (String)DEFAULT_DOC_BASE_FOLDER);
        File file2 = FileUtil.toFile((FileObject)fileObject3);
        AntProjectHelper antProjectHelper = EjbJarProjectGenerator.importProject((File)file, (String)fileObject2.getName(), (File[])new File[]{FileUtil.toFile((FileObject)fileObject)}, (File[])new File[0], (File)file2, null, (String)EarProjectGenerator.checkJ2eeVersion(this.j2eeLevel, this.serverInstanceID, J2eeModule.EJB), (String)this.serverInstanceID);
        if (string != null || this.sourceLevel != null) {
            EjbJarProjectGenerator.setPlatform((AntProjectHelper)antProjectHelper, (String)string, (String)this.sourceLevel);
        }
        return antProjectHelper;
    }

    private AntProjectHelper addWebModule(FileObject fileObject, File[] fileArray, File file, String string) throws IOException {
        WebProjectCreateData webProjectCreateData = new WebProjectCreateData();
        webProjectCreateData.setProjectDir(file);
        webProjectCreateData.setName(fileObject.getName());
        webProjectCreateData.setWebModuleFO(fileObject);
        webProjectCreateData.setSourceFolders(fileArray);
        webProjectCreateData.setTestFolders(new File[0]);
        webProjectCreateData.setDocBase(FileUtil.createFolder((FileObject)fileObject, (String)"web"));
        webProjectCreateData.setLibFolder(null);
        webProjectCreateData.setJavaEEVersion(EarProjectGenerator.checkJ2eeVersion(this.j2eeLevel, this.serverInstanceID, J2eeModule.WAR));
        webProjectCreateData.setServerInstanceID(this.serverInstanceID);
        webProjectCreateData.setBuildfile("build.xml");
        webProjectCreateData.setJavaPlatformName(string);
        webProjectCreateData.setSourceLevel(this.sourceLevel);
        webProjectCreateData.setWebInfFolder(fileObject.getFileObject("web/WEB-INF"));
        return WebProjectUtilities.importProject((WebProjectCreateData)webProjectCreateData);
    }

    static FileObject setupDD(String string, FileObject fileObject, EarProject earProject) throws IOException {
        return EarProjectGenerator.setupDD(string, fileObject, earProject, false);
    }

    public static FileObject setupDD(String string, FileObject fileObject, Project project, boolean bl) throws IOException {
        String string2;
        FileObject fileObject2 = fileObject.getFileObject("application.xml");
        if (fileObject2 != null) {
            return fileObject2;
        }
        FileObject fileObject3 = null;
        if (EarProjectUtil.isDDCompulsory(project)) {
            fileObject3 = FileUtil.getConfigFile((String)"org-netbeans-modules-j2ee-earproject/ear-1.4.xml");
        } else if ("1.5".equals(string)) {
            if (bl) {
                fileObject3 = FileUtil.getConfigFile((String)"org-netbeans-modules-j2ee-earproject/ear-5.xml");
            } else {
                string2 = System.getProperty("line.separator");
                Logger.getLogger("global").log(Level.FINE, "Deployment descriptor (application.xml) is not compulsory for JAVA EE 5." + string2 + "If it's *really* needed, set force param to true." + string2);
            }
        } else assert (false) : "Unknown j2eeLevel: " + string;
        if (fileObject3 != null) {
            fileObject2 = FileUtil.copyFile((FileObject)fileObject3, (FileObject)fileObject, (String)"application");
            string2 = DDProvider.getDefault().getDDRoot(fileObject2);
            string2.setDisplayName(ProjectUtils.getInformation((Project)project).getDisplayName());
            EarProject earProject = (EarProject)project.getLookup().lookup(EarProject.class);
            if (earProject != null) {
                for (ClassPathSupport.Item item : EarProjectProperties.getJarContentAdditional(earProject)) {
                    EarProjectProperties.addItemToAppDD(earProject, (Application)string2, item);
                }
            }
            string2.write(fileObject2);
        }
        return fileObject2;
    }

    public static String checkJ2eeVersion(String string, String string2, Object object) {
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(string2);
        Set set = j2eePlatform.getSupportedSpecVersions(object);
        if (!set.contains(string) && set.contains("1.4")) {
            return "1.4";
        }
        return string;
    }

    private static String relativePath(FileObject fileObject, FileObject fileObject2) {
        if (fileObject2.equals(fileObject)) {
            return "";
        }
        if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) {
            throw new IllegalArgumentException("Cannot find relative path, " + fileObject + " is not parent of " + fileObject2);
        }
        return fileObject2.getPath().substring(fileObject.getPath().length() + 1);
    }

    private AntProjectHelper setupProject() throws IOException {
        JavaPlatform javaPlatform;
        SpecificationVersion specificationVersion;
        String string;
        EarProjectUtil.logUI(NbBundle.getBundle(EarProjectGenerator.class), "UI_EAR_PROJECT_CREATE_SHARABILITY", new Object[]{this.librariesDefinition != null, this.serverLibraryName != null});
        AntProjectHelper antProjectHelper = ProjectGenerator.createProject((FileObject)this.prjDirFO, (String)"org.netbeans.modules.j2ee.earproject", (String)this.librariesDefinition);
        EarProject earProject = (EarProject)ProjectManager.getDefault().findProject(this.prjDirFO);
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", "name");
        element2.appendChild(document.createTextNode(this.name));
        element.appendChild(element2);
        Element element3 = document.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", "minimum-ant-version");
        element3.appendChild(document.createTextNode("1.6.5"));
        element.appendChild(element3);
        Element element4 = document.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", "web-module-libraries");
        element.appendChild(element4);
        Element element5 = document.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", "web-module-additional-libraries");
        element.appendChild(element5);
        antProjectHelper.putPrimaryConfigurationData(element, true);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        editableProperties.setProperty("dist.dir", "dist");
        editableProperties.setProperty("dist.jar", "${dist.dir}/${jar.name}");
        editableProperties.setProperty("j2ee.platform", this.j2eeLevel);
        editableProperties.setProperty("jar.name", this.name + ".ear");
        editableProperties.setProperty("jar.compress", "false");
        editableProperties.setProperty("jar.content.additional", "");
        editableProperties.setProperty("client.module.uri", "");
        editableProperties.setProperty("client.urlPart", "");
        editableProperties.setProperty("display.browser", "true");
        boolean bl = false;
        try {
            bl = Deployment.getDefault().getServerInstance(this.serverInstanceID).isDeployOnSaveSupported();
        }
        catch (InstanceRemovedException instanceRemovedException) {
            // empty catch block
        }
        editableProperties.setProperty("j2ee.deploy.on.save", Boolean.toString(bl));
        Deployment deployment = Deployment.getDefault();
        editableProperties.setProperty("j2ee.server.type", deployment.getServerID(this.serverInstanceID));
        if (antProjectHelper.isSharableProject() && this.serverLibraryName != null) {
            editableProperties.setProperty("j2ee.platform.classpath", "${libs." + this.serverLibraryName + ".classpath}");
        }
        if ((string = this.sourceLevel) == null && ((string = (specificationVersion = (javaPlatform = JavaPlatformManager.getDefault().getDefaultPlatform()).getSpecification().getVersion()).toString()).equals("1.6") || string.equals("1.7"))) {
            string = "1.5";
        }
        editableProperties.setProperty("javac.source", string);
        editableProperties.setProperty("javac.debug", "true");
        editableProperties.setProperty("javac.deprecation", "false");
        editableProperties.setProperty("javac.target", string);
        editableProperties.setProperty("build.dir", DEFAULT_BUILD_DIR);
        editableProperties.setProperty("build.generated.dir", "${build.dir}/generated");
        editableProperties.setProperty("build.classes.excludes", "**/*.java,**/*.form,**/.nbattrs");
        editableProperties.setProperty("no.dependencies", "false");
        editableProperties.setProperty("platform.active", "default_platform");
        editableProperties.setProperty("debug.classpath", "${javac.classpath}::${jar.content.additional}:${run.classpath}");
        javaPlatform = antProjectHelper.getProperties("nbproject/private/private.properties");
        EarProjectProperties.storeJ2EEServerProperties(this.serverInstanceID, earProject, editableProperties, (EditableProperties)javaPlatform, this.serverLibraryName);
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        antProjectHelper.putProperties("nbproject/private/private.properties", (EditableProperties)javaPlatform);
        ProjectManager.getDefault().saveProject((Project)earProject);
        return antProjectHelper;
    }

    private String createFileReference(ReferenceHelper referenceHelper, FileObject fileObject, FileObject fileObject2) {
        if (FileUtil.isParentOf((FileObject)this.prjDirFO, (FileObject)fileObject2)) {
            return EarProjectGenerator.relativePath(this.prjDirFO, fileObject2);
        }
        if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) {
            String string = EarProjectGenerator.relativePath(fileObject, fileObject2);
            return string.length() > 0 ? "${source.root}/" + string : SOURCE_ROOT_REF;
        }
        return referenceHelper.createForeignFileReference(FileUtil.toFile((FileObject)fileObject2), null);
    }

    public static void setPlatformSourceLevel(final AntProjectHelper antProjectHelper, final String string) {
        FileObject fileObject = antProjectHelper.getProjectDirectory();
        if (fileObject == null) {
            return;
        }
        try {
            fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    ProjectManager.mutex().writeAccess(new Runnable(){

                        public void run() {
                            try {
                                EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                                String string = string;
                                if (string.equals("1.6") || string.equals("1.7")) {
                                    string = "1.5";
                                }
                                editableProperties.setProperty("javac.source", string);
                                editableProperties.setProperty("javac.target", string);
                                antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                                ProjectManager.getDefault().saveProject(ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory()));
                            }
                            catch (IOException iOException) {
                                Exceptions.printStackTrace((Throwable)iOException);
                            }
                        }
                    });
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public static String toClasspathString(File[] fileArray) {
        if (fileArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileArray.length; ++i) {
            stringBuffer.append(fileArray[i].getAbsolutePath());
            if (i + 1 >= fileArray.length) continue;
            stringBuffer.append(':');
        }
        return stringBuffer.toString();
    }

    private FileObject getJavaRoot(FileObject fileObject) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject("src/java");
        if (null == fileObject2) {
            FileObject fileObject3 = fileObject.getFileObject("src");
            if (null == fileObject3) {
                fileObject3 = fileObject.createFolder("src");
            }
            fileObject2 = fileObject3.createFolder("java");
        }
        return fileObject2;
    }

    private File[] getSourceFolders(FileObject fileObject) {
        File[] fileArray;
        if (null == fileObject) {
            fileArray = new File[]{};
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = FileUtil.toFile((FileObject)fileObject);
        }
        return fileArray;
    }
}

