/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.tasklist;

import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.tasklist.trampoline.Accessor;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.modules.tasklist.trampoline.TaskGroupFactory;
import org.netbeans.spi.tasklist.AccessorImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Task {
    private FileObject resource;
    private TaskGroup group;
    private String description;
    private int line;
    private ActionListener al;
    private static Set<String> unknownTaskGroups;

    public static Task create(FileObject fileObject, String string, String string2, int n) {
        return new Task(fileObject, Task.getTaskGroup(string), string2, n, null);
    }

    public static Task create(FileObject fileObject, String string, String string2, ActionListener actionListener) {
        return new Task(fileObject, Task.getTaskGroup(string), string2, -1, actionListener);
    }

    private Task(FileObject fileObject, TaskGroup taskGroup, String string, int n, ActionListener actionListener) {
        assert (null != taskGroup);
        assert (null != string);
        assert (null != fileObject);
        this.resource = fileObject;
        this.group = taskGroup;
        this.description = string;
        this.line = n;
        this.al = actionListener;
    }

    FileObject getResource() {
        return this.resource;
    }

    TaskGroup getGroup() {
        return this.group;
    }

    String getDescription() {
        return this.description;
    }

    int getLine() {
        return this.line;
    }

    ActionListener getActionListener() {
        return this.al;
    }

    static TaskGroup createGroup(Map<String, String> map) {
        return TaskGroupFactory.create(map);
    }

    private static TaskGroup getTaskGroup(String string) {
        TaskGroup taskGroup = TaskGroupFactory.getDefault().getGroup(string);
        if (null == taskGroup) {
            if (null == unknownTaskGroups || !unknownTaskGroups.contains(string)) {
                Logger.getLogger(Task.class.getName()).log(Level.INFO, NbBundle.getMessage(Task.class, (String)"Err_UnknownGroupName"), string);
                if (null == unknownTaskGroups) {
                    unknownTaskGroups = new HashSet<String>(10);
                }
                unknownTaskGroups.add(string);
            }
            taskGroup = TaskGroupFactory.getDefault().getDefaultGroup();
        }
        return taskGroup;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Task task = (Task)object;
        if (this.line != task.line) {
            return false;
        }
        if (this.description != task.description && this.description != null && !this.description.equals(task.description)) {
            return false;
        }
        if (this.group != task.group && this.group != null && !this.group.equals(task.group)) {
            return false;
        }
        return this.resource == task.resource || this.resource == null || this.resource.equals(task.resource);
    }

    public int hashCode() {
        int n = 7;
        n = 17 * n + this.line;
        n = 17 * n + (this.description != null ? this.description.hashCode() : 0);
        n = 17 * n + (this.group != null ? this.group.hashCode() : 0);
        n = 17 * n + (this.resource != null ? this.resource.hashCode() : 0);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(this.getResource());
        stringBuffer.append(", ");
        stringBuffer.append(this.getLine());
        stringBuffer.append(", ");
        stringBuffer.append(this.getDescription());
        stringBuffer.append(", ");
        stringBuffer.append(this.getGroup());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static {
        Accessor.DEFAULT = new AccessorImpl();
    }
}

