/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.UI;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.impl.HudsonManagerImpl;
import org.netbeans.modules.hudson.spi.ProjectHudsonJobCreatorFactory;
import org.netbeans.modules.hudson.spi.ProjectHudsonProvider;
import org.netbeans.modules.hudson.ui.actions.CreateJobPanel;
import org.netbeans.modules.hudson.util.Utilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;

public class CreateJob
extends AbstractAction {
    private final HudsonInstance instance;

    public CreateJob() {
        super(NbBundle.getMessage(CreateJob.class, (String)"CTL_CreateJob"));
        this.instance = null;
    }

    public CreateJob(HudsonInstance hudsonInstance) {
        super(NbBundle.getMessage(CreateJob.class, (String)"CreateJob.new_build"));
        this.instance = hudsonInstance;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Collection<HudsonInstanceImpl> collection;
        final CreateJobPanel createJobPanel = new CreateJobPanel();
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)createJobPanel, NbBundle.getMessage(CreateJob.class, (String)"CreateJob.title"));
        final AtomicReference<Dialog> atomicReference = new AtomicReference<Dialog>();
        final JButton jButton = new JButton(NbBundle.getMessage(CreateJob.class, (String)"CreateJob.create"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        CreateJob.this.finalizeJob(createJobPanel.instance, createJobPanel.creator, createJobPanel.name(), createJobPanel.selectedProject());
                    }
                });
                ((Dialog)atomicReference.get()).dispose();
            }
        });
        dialogDescriptor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("valid".equals(propertyChangeEvent.getPropertyName())) {
                    jButton.setEnabled(dialogDescriptor.isValid());
                }
            }
        });
        HudsonInstance hudsonInstance = this.instance != null ? this.instance : ((collection = HudsonManagerImpl.getDefault().getInstances()).isEmpty() ? null : (HudsonInstance)collection.iterator().next());
        createJobPanel.init(dialogDescriptor, hudsonInstance);
        dialogDescriptor.setOptions(new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION});
        dialogDescriptor.setClosingOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
        atomicReference.set(DialogDisplayer.getDefault().createDialog(dialogDescriptor));
        ((Dialog)atomicReference.get()).setVisible(true);
    }

    private void finalizeJob(HudsonInstance hudsonInstance, ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator projectHudsonJobCreator, String string, Project project) {
        try {
            Document document = projectHudsonJobCreator.configure();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLUtil.write((Document)document, (OutputStream)byteArrayOutputStream, (String)"UTF-8");
            String string2 = hudsonInstance.getUrl() + "createItem?name=" + Utilities.uriEncode(string);
            new ConnectionBuilder().instance(hudsonInstance).url(string2).header("Content-Type", "text/xml").postData(byteArrayOutputStream.toByteArray()).httpConnection().disconnect();
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(hudsonInstance.getUrl() + "job/" + Utilities.uriEncode(string) + "/"));
            ((HudsonInstanceImpl)hudsonInstance).synchronize();
            ProjectHudsonProvider.getDefault().recordAssociation(project, new ProjectHudsonProvider.Association(hudsonInstance.getUrl(), string));
            OpenProjects.getDefault().open(new Project[]{project}, false);
            UI.selectNode(hudsonInstance.getUrl(), string);
        }
        catch (IOException iOException) {
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(CreateJob.class, (String)"CreateJob.failure"));
            Logger.getLogger(CreateJob.class.getName()).log(Level.WARNING, null, iOException);
        }
    }
}

