/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.spi;

import java.net.URI;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.util.Utilities;
import org.openide.util.Lookup;

public abstract class ProjectHudsonProvider {
    public static ProjectHudsonProvider getDefault() {
        return new ProjectHudsonProvider(){

            public Association findAssociation(Project project) {
                for (ProjectHudsonProvider projectHudsonProvider : Lookup.getDefault().lookupAll(ProjectHudsonProvider.class)) {
                    Association association = projectHudsonProvider.findAssociation(project);
                    if (association == null) continue;
                    return association;
                }
                return null;
            }

            public boolean recordAssociation(Project project, Association association) {
                for (ProjectHudsonProvider projectHudsonProvider : Lookup.getDefault().lookupAll(ProjectHudsonProvider.class)) {
                    if (!projectHudsonProvider.recordAssociation(project, association)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public abstract Association findAssociation(Project var1);

    public Project findAssociatedProject(Association association) {
        HashMap<Association, Project> hashMap = new HashMap<Association, Project>();
        Project project = OpenProjects.getDefault().getOpenProjects();
        int n = ((Project[])project).length;
        for (int i = 0; i < n; ++i) {
            Project project2 = project[i];
            Association association2 = this.findAssociation(project2);
            if (association.equals(association2)) {
                return project2;
            }
            if (!hashMap.containsKey(association)) {
                hashMap.put(association2, project2);
                continue;
            }
            hashMap.put(association2, null);
        }
        if (association.getJobName() != null && (project = (Project)hashMap.get(Association.fromString(association.getServerUrl()))) != null) {
            return project;
        }
        return null;
    }

    public abstract boolean recordAssociation(Project var1, Association var2);

    public static final class Association {
        private final String serverURL;
        private final String jobName;

        public Association(String string, String string2) throws IllegalArgumentException {
            URI.create(string);
            if (!string.endsWith("/")) {
                throw new IllegalArgumentException(string + " must end in a slash");
            }
            if (!(string2 == null || string2.length() != 0 && string2.trim().equals(string2))) {
                throw new IllegalArgumentException("Must provide a nonempty or null job name: " + string2);
            }
            this.serverURL = string;
            this.jobName = string2;
        }

        public static Association forJob(HudsonJob hudsonJob) {
            return new Association(hudsonJob.getInstance().getUrl(), hudsonJob.getName());
        }

        public String getServerUrl() {
            return this.serverURL;
        }

        public String getJobName() {
            return this.jobName;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Association)) {
                return false;
            }
            return this.toString().equals(object.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return this.jobName != null ? this.serverURL + "job/" + Utilities.uriEncode(this.jobName) + "/" : this.serverURL;
        }

        public static Association fromString(String string) {
            Matcher matcher = Pattern.compile("(https?://.+?/)(?:job/([^/]+)/?)?").matcher(string);
            if (!matcher.matches()) {
                return null;
            }
            String string2 = matcher.group(2);
            return new Association(matcher.group(1), string2 != null ? Utilities.uriDecode(string2) : null);
        }
    }
}

