/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.impl.HudsonConnector;
import org.netbeans.modules.hudson.impl.HudsonJobImpl;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.ui.interfaces.OpenableInBrowser;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HudsonJobBuildImpl
implements HudsonJobBuild,
OpenableInBrowser {
    private final HudsonJobImpl job;
    private final int build;
    private final boolean building;
    private final HudsonJobBuild.Result result;
    private final HudsonConnector connector;
    private Collection<? extends HudsonJobChangeItem> changes;

    HudsonJobBuildImpl(HudsonConnector hudsonConnector, HudsonJobImpl hudsonJobImpl, int n, boolean bl, HudsonJobBuild.Result result) {
        this.connector = hudsonConnector;
        this.job = hudsonJobImpl;
        this.build = n;
        this.building = bl;
        this.result = result;
    }

    @Override
    public HudsonJob getJob() {
        return this.job;
    }

    @Override
    public int getNumber() {
        return this.build;
    }

    @Override
    public String getUrl() {
        return this.job.getUrl() + this.build + "/";
    }

    public String toString() {
        return this.getUrl();
    }

    @Override
    public boolean isBuilding() {
        return this.building;
    }

    @Override
    public HudsonJobBuild.Result getResult() {
        return this.result;
    }

    @Override
    public Collection<? extends HudsonJobChangeItem> getChanges() {
        if (this.changes == null) {
            Document document = this.connector.getDocument(this.getUrl() + "api/xml" + "?xpath=/*/changeSet");
            if (document != null) {
                for (HudsonSCM hudsonSCM : Lookup.getDefault().lookupAll(HudsonSCM.class)) {
                    this.changes = hudsonSCM.parseChangeSet(this.job, document.getDocumentElement());
                    if (this.changes == null) continue;
                    break;
                }
            }
            if (this.changes == null) {
                this.changes = Collections.emptyList();
            }
        }
        return this.changes;
    }

    @Override
    public FileSystem getArtifacts() {
        return this.job.getInstance().getArtifacts(this);
    }

    @Override
    public Collection<? extends HudsonMavenModuleBuild> getMavenModules() {
        ArrayList<HudsonMavenModuleBuildImpl> arrayList = new ArrayList<HudsonMavenModuleBuildImpl>();
        for (HudsonJobImpl.HudsonMavenModule hudsonMavenModule : this.job.mavenModules) {
            arrayList.add(new HudsonMavenModuleBuildImpl(hudsonMavenModule));
        }
        return arrayList;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(HudsonJobBuildImpl.class, (String)"HudsonJobBuildImpl.display_name", (Object)this.job.getDisplayName(), (Object)this.getNumber());
    }

    private final class HudsonMavenModuleBuildImpl
    implements HudsonMavenModuleBuild,
    OpenableInBrowser {
        private final HudsonJobImpl.HudsonMavenModule module;

        HudsonMavenModuleBuildImpl(HudsonJobImpl.HudsonMavenModule hudsonMavenModule) {
            this.module = hudsonMavenModule;
        }

        public String getName() {
            return this.module.name;
        }

        public String getDisplayName() {
            return this.module.displayName;
        }

        public HudsonJob.Color getColor() {
            return this.module.color;
        }

        public String getUrl() {
            return this.module.url + HudsonJobBuildImpl.this.build + "/";
        }

        public HudsonJobBuild getBuild() {
            return HudsonJobBuildImpl.this;
        }

        public FileSystem getArtifacts() {
            return HudsonJobBuildImpl.this.job.getInstance().getArtifacts(this);
        }

        public String toString() {
            return this.getUrl();
        }

        public String getBuildDisplayName() {
            return NbBundle.getMessage(HudsonJobBuildImpl.class, (String)"HudsonJobBuildImpl.display_name", (Object)this.getDisplayName(), (Object)HudsonJobBuildImpl.this.getNumber());
        }
    }
}

