/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.api;

import java.awt.EventQueue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.spi.ConnectionAuthenticator;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionBuilder {
    private static final Logger LOG = Logger.getLogger(ConnectionBuilder.class.getName());
    private static final RequestProcessor TIMER = new RequestProcessor(ConnectionBuilder.class.getName() + ".TIMER");
    private URL home;
    private URL url;
    private final Map<String, String> requestHeaders = new LinkedHashMap<String, String>();
    private byte[] postData;
    private Map<String, List<String>> responseHeaders;
    private int timeout;

    public ConnectionBuilder url(URL uRL) {
        this.url = uRL;
        return this;
    }

    public ConnectionBuilder url(String string) throws MalformedURLException {
        return this.url(new URL(string));
    }

    public ConnectionBuilder homeURL(URL uRL) {
        this.home = uRL;
        return this;
    }

    public ConnectionBuilder instance(HudsonInstance hudsonInstance) {
        try {
            this.home = new URL(hudsonInstance.getUrl());
        }
        catch (MalformedURLException malformedURLException) {
            LOG.warning(malformedURLException.toString());
        }
        return this;
    }

    public ConnectionBuilder job(HudsonJob hudsonJob) {
        HudsonInstance hudsonInstance = hudsonJob.getInstance();
        if (hudsonInstance != null) {
            this.instance(hudsonInstance);
        }
        return this;
    }

    public ConnectionBuilder header(String string, String string2) {
        this.requestHeaders.put(string, string2);
        return this;
    }

    public ConnectionBuilder postData(byte[] byArray) {
        this.postData = byArray;
        return this;
    }

    public ConnectionBuilder collectResponseHeaders(Map<String, List<String>> map) {
        this.responseHeaders = map;
        return this;
    }

    public ConnectionBuilder timeout(int n) {
        this.timeout = n;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLConnection connection() throws IOException {
        if (this.url == null) {
            throw new IllegalArgumentException("You must call the url method!");
        }
        if (this.url.getProtocol().matches("https?") && EventQueue.isDispatchThread()) {
            LOG.log(Level.FINER, "opening " + this.url, new IllegalStateException("Avoid connecting from EQ"));
            if (this.timeout == 0) {
                this.timeout = 3000;
            }
        }
        if (this.timeout == 0) {
            return this.doConnection();
        }
        final Thread thread = Thread.currentThread();
        RequestProcessor.Task task = TIMER.post(new Runnable(){

            public void run() {
                thread.interrupt();
            }
        }, this.timeout);
        try {
            URLConnection uRLConnection = this.doConnection();
            return uRLConnection;
        }
        finally {
            task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLConnection doConnection() throws IOException {
        URLConnection uRLConnection = this.url.openConnection();
        block14: while (true) {
            Object object;
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
            }
            if (uRLConnection instanceof HttpsURLConnection) {
                try {
                    object = SSLContext.getInstance("SSL");
                    ((SSLContext)object).init(null, new TrustManager[]{new X509TrustManager(){

                        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                        }

                        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                        }

                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }
                    }}, new SecureRandom());
                    ((HttpsURLConnection)uRLConnection).setSSLSocketFactory(((SSLContext)object).getSocketFactory());
                    ((HttpsURLConnection)uRLConnection).setHostnameVerifier(new HostnameVerifier(){

                        public boolean verify(String string, SSLSession sSLSession) {
                            return true;
                        }
                    });
                }
                catch (Exception exception) {
                    LOG.log(Level.FINE, "could not disable SSL verification", exception);
                }
            }
            object = uRLConnection.getURL();
            LOG.log(Level.FINER, "Trying to open {0}", object);
            if (this.home != null) {
                for (ConnectionAuthenticator connectionAuthenticator : Lookup.getDefault().lookupAll(ConnectionAuthenticator.class)) {
                    connectionAuthenticator.prepareRequest(uRLConnection, this.home);
                }
            }
            if (this.postData != null) {
                uRLConnection.setDoOutput(true);
            }
            for (Map.Entry entry : this.requestHeaders.entrySet()) {
                uRLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            try {
                uRLConnection.connect();
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw (IOException)new IOException("Connecting to " + object + ": " + exception.toString()).initCause(exception);
            }
            if (this.postData != null) {
                OutputStream outputStream = uRLConnection.getOutputStream();
                try {
                    outputStream.write(this.postData);
                }
                finally {
                    outputStream.close();
                }
            }
            if (!(uRLConnection instanceof HttpURLConnection)) break;
            if (this.responseHeaders != null) {
                this.responseHeaders.putAll(uRLConnection.getHeaderFields());
                LOG.log(Level.FINER, "  => {0}", this.responseHeaders);
                this.responseHeaders = null;
            }
            int n = ((HttpURLConnection)uRLConnection).getResponseCode();
            LOG.log(Level.FINER, "  => {0}", n);
            switch (n) {
                case 301: 
                case 302: {
                    URL uRL = new URL(uRLConnection.getHeaderField("Location"));
                    uRLConnection = uRL.openConnection();
                    continue block14;
                }
                case 403: {
                    if (this.home != null) {
                        for (ConnectionAuthenticator connectionAuthenticator : Lookup.getDefault().lookupAll(ConnectionAuthenticator.class)) {
                            URLConnection uRLConnection2 = connectionAuthenticator.forbidden(uRLConnection, this.home);
                            if (uRLConnection2 == null) continue;
                            LOG.log(Level.FINER, "Retrying after auth from {0}", connectionAuthenticator);
                            uRLConnection = uRLConnection2;
                            continue block14;
                        }
                    }
                    IOException iOException = new IOException("403 on " + this.url);
                    Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(ConnectionBuilder.class, (String)"ConnectionBuilder.log_in", (Object)this.url));
                    throw iOException;
                }
                case 404: {
                    throw new FileNotFoundException(((URL)object).toString());
                }
                case 200: {
                    break block14;
                }
                default: {
                    throw new IOException("Server rejected connection to " + object + " with code " + n);
                }
            }
            break;
        }
        return uRLConnection;
    }

    public HttpURLConnection httpConnection() throws IOException {
        URLConnection uRLConnection = this.connection();
        if (uRLConnection instanceof HttpURLConnection) {
            return (HttpURLConnection)uRLConnection;
        }
        throw new IOException("Not an HTTP connection: " + uRLConnection);
    }
}

