/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadGroupReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ThreadDeathEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ThreadStartEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadsCache
implements Executor {
    public static final String PROP_THREAD_STARTED = "threadStarted";
    public static final String PROP_THREAD_DIED = "threadDied";
    public static final String PROP_GROUP_ADDED = "groupAdded";
    private VirtualMachine vm;
    private JPDADebuggerImpl debugger;
    private Map<ThreadGroupReference, List<ThreadGroupReference>> groupMap;
    private Map<ThreadGroupReference, List<ThreadReference>> threadMap;
    private List<ThreadReference> allThreads;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final boolean[] canFireChanges = new boolean[]{false};

    public ThreadsCache(JPDADebuggerImpl jPDADebuggerImpl) {
        this.debugger = jPDADebuggerImpl;
        this.groupMap = new HashMap<ThreadGroupReference, List<ThreadGroupReference>>();
        this.threadMap = new HashMap<ThreadGroupReference, List<ThreadReference>>();
        this.allThreads = new ArrayList<ThreadReference>();
        VirtualMachine virtualMachine = jPDADebuggerImpl.getVirtualMachine();
        if (virtualMachine != null) {
            this.setVirtualMachine(virtualMachine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVirtualMachine(VirtualMachine virtualMachine) {
        List<ThreadGroupReference> list;
        List<ThreadReference> list2;
        Object object = this;
        synchronized (object) {
            if (this.vm == virtualMachine) {
                return;
            }
            try {
                this.vm = virtualMachine;
                ThreadStartRequest mirror = EventRequestManagerWrapper.createThreadStartRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine));
                ThreadDeathRequest threadDeathRequest = EventRequestManagerWrapper.createThreadDeathRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine));
                EventRequestWrapper.setSuspendPolicy(mirror, 0);
                EventRequestWrapper.setSuspendPolicy(threadDeathRequest, 0);
                this.debugger.getOperator().register(mirror, this);
                this.debugger.getOperator().register(threadDeathRequest, this);
                EventRequestWrapper.enable(mirror);
                EventRequestWrapper.enable(threadDeathRequest);
                this.init();
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                this.vm = null;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                this.vm = null;
            }
            list2 = this.allThreads;
            list = this.getAllGroups();
        }
        for (ThreadReference threadReference : list2) {
            this.pcs.firePropertyChange(PROP_THREAD_STARTED, null, threadReference);
        }
        for (ThreadGroupReference threadGroupReference : list) {
            this.pcs.firePropertyChange(PROP_GROUP_ADDED, null, threadGroupReference);
        }
        object = this.canFireChanges;
        synchronized (this.canFireChanges) {
            this.canFireChanges[0] = true;
            this.canFireChanges.notifyAll();
            // ** MonitorExit[object] (shouldn't be in output)
            return;
        }
    }

    private synchronized void init() throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper {
        this.allThreads = new ArrayList<ThreadReference>(VirtualMachineWrapper.allThreads(this.vm));
        ArrayList<ThreadGroupReference> arrayList = new ArrayList<ThreadGroupReference>(VirtualMachineWrapper.topLevelThreadGroups(this.vm));
        this.groupMap.put(null, arrayList);
        for (ThreadGroupReference object : arrayList) {
            this.initGroups(object);
        }
        ArrayList arrayList2 = new ArrayList();
        this.threadMap.put(null, arrayList2);
        for (ThreadReference threadReference : this.allThreads) {
            try {
                if (ThreadReferenceWrapper.threadGroup(threadReference) != null) continue;
                arrayList2.add(threadReference);
            }
            catch (ObjectCollectedExceptionWrapper illegalThreadStateExceptionWrapper) {
            }
            catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {}
        }
    }

    private void initGroups(ThreadGroupReference threadGroupReference) {
        try {
            ArrayList<ThreadGroupReference> arrayList = new ArrayList<ThreadGroupReference>(ThreadGroupReferenceWrapper.threadGroups0(threadGroupReference));
            ArrayList<ThreadReference> arrayList2 = new ArrayList<ThreadReference>(ThreadGroupReferenceWrapper.threads0(threadGroupReference));
            this.groupMap.put(threadGroupReference, arrayList);
            this.threadMap.put(threadGroupReference, arrayList2);
            for (ThreadGroupReference threadGroupReference2 : arrayList) {
                this.initGroups(threadGroupReference2);
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    public synchronized List<ThreadReference> getAllThreads() {
        return Collections.unmodifiableList(new ArrayList<ThreadReference>(this.allThreads));
    }

    public synchronized List<ThreadGroupReference> getTopLevelThreadGroups() {
        List<ThreadGroupReference> list = this.groupMap.get(null);
        if (list == null) {
            if (this.vm == null) {
                return Collections.EMPTY_LIST;
            }
            list = new ArrayList<ThreadGroupReference>(VirtualMachineWrapper.topLevelThreadGroups0(this.vm));
            this.groupMap.put(null, list);
        }
        return Collections.unmodifiableList(new ArrayList<ThreadGroupReference>(list));
    }

    public synchronized List<ThreadReference> getThreads(ThreadGroupReference threadGroupReference) {
        List<ThreadReference> list = this.threadMap.get(threadGroupReference);
        list = list == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ThreadReference>(list));
        return list;
    }

    public synchronized List<ThreadGroupReference> getGroups(ThreadGroupReference threadGroupReference) {
        List<ThreadGroupReference> list = this.groupMap.get(threadGroupReference);
        list = list == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ThreadGroupReference>(list));
        return list;
    }

    private synchronized List<ThreadGroupReference> getAllGroups() {
        ArrayList<ThreadGroupReference> arrayList = new ArrayList<ThreadGroupReference>();
        this.fillAllGroups(arrayList, null);
        return arrayList;
    }

    private void fillAllGroups(List<ThreadGroupReference> list, ThreadGroupReference threadGroupReference) {
        List<ThreadGroupReference> list2 = this.groupMap.get(threadGroupReference);
        if (list2 != null) {
            list.addAll(list2);
            for (ThreadGroupReference threadGroupReference2 : list2) {
                this.fillAllGroups(list, threadGroupReference2);
            }
        }
    }

    private List<ThreadGroupReference> addGroups(ThreadGroupReference threadGroupReference) {
        List<ThreadGroupReference> list;
        ThreadGroupReference threadGroupReference2;
        ArrayList<ThreadGroupReference> arrayList = new ArrayList<ThreadGroupReference>();
        try {
            threadGroupReference2 = ThreadGroupReferenceWrapper.parent(threadGroupReference);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            threadGroupReference2 = null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            threadGroupReference2 = null;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            Exceptions.printStackTrace((Throwable)objectCollectedExceptionWrapper);
            threadGroupReference2 = null;
        }
        if (this.groupMap.get(threadGroupReference2) == null) {
            arrayList.addAll(this.addGroups(threadGroupReference2));
        }
        if (!(list = this.groupMap.get(threadGroupReference2)).contains(threadGroupReference)) {
            list.add(threadGroupReference);
            arrayList.add(threadGroupReference);
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            this.groupMap.put(threadGroupReference, arrayList2);
            this.threadMap.put(threadGroupReference, arrayList3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean exec(Event event) {
        Iterator iterator;
        Object object;
        ThreadGroupReference threadGroupReference;
        ThreadReference threadReference;
        if (event instanceof ThreadStartEvent) {
            Object object2;
            try {
                threadReference = ThreadStartEventWrapper.thread((ThreadStartEvent)event);
                threadGroupReference = ThreadReferenceWrapper.threadGroup(threadReference);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return true;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return true;
            }
            catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                return true;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                return true;
            }
            object = null;
            iterator = this;
            // MONITORENTER : iterator
            if (threadGroupReference != null) {
                object = this.addGroups(threadGroupReference);
            }
            if (!(object2 = this.threadMap.get(threadGroupReference)).contains(threadReference)) {
                object2.add(threadReference);
            }
            if (!this.allThreads.contains(threadReference)) {
                this.allThreads.add(threadReference);
            }
            // MONITOREXIT : iterator
            iterator = (Iterator)this.canFireChanges;
            // MONITORENTER : this.canFireChanges
            if (!this.canFireChanges[0]) {
                try {
                    this.canFireChanges.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // MONITOREXIT : iterator
            if (object != null) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    object2 = (ThreadGroupReference)iterator.next();
                    this.pcs.firePropertyChange(PROP_GROUP_ADDED, null, object2);
                }
            }
            this.pcs.firePropertyChange(PROP_THREAD_STARTED, null, threadReference);
        }
        if (!(event instanceof ThreadDeathEvent)) return true;
        try {
            threadReference = ThreadDeathEventWrapper.thread((ThreadDeathEvent)event);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return true;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return true;
        }
        try {
            threadGroupReference = ThreadReferenceWrapper.threadGroup(threadReference);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return true;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return true;
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            threadGroupReference = null;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            threadGroupReference = null;
        }
        object = this;
        // MONITORENTER : object
        if (threadGroupReference != null) {
            iterator = this.threadMap.get(threadGroupReference);
        } else {
            iterator = null;
            for (List list : this.threadMap.values()) {
                if (!list.contains(threadReference)) continue;
                iterator = list;
            }
        }
        if (iterator != null) {
            iterator.remove(threadReference);
        }
        this.allThreads.remove(threadReference);
        // MONITOREXIT : object
        object = this.canFireChanges;
        // MONITORENTER : this.canFireChanges
        if (!this.canFireChanges[0]) {
            try {
                this.canFireChanges.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        // MONITOREXIT : object
        this.pcs.firePropertyChange(PROP_THREAD_DIED, threadReference, null);
        return true;
    }

    @Override
    public void removed(EventRequest eventRequest) {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }
}

