/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.FieldWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalArgumentExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;

class ObjectFieldVariable
extends AbstractObjectVariable
implements org.netbeans.api.debugger.jpda.Field {
    protected Field field;
    private ObjectReference objectReference;
    private String genericSignature;

    ObjectFieldVariable(JPDADebuggerImpl jPDADebuggerImpl, ObjectReference objectReference, Field field, String string, ObjectReference objectReference2) {
        super(jPDADebuggerImpl, objectReference, ObjectFieldVariable.getID(string, field));
        this.field = field;
        this.objectReference = objectReference2;
    }

    private static String getID(String string, Field field) {
        try {
            return string + '.' + TypeComponentWrapper.name(field) + "^";
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return string + '.' + internalExceptionWrapper.getCause().getLocalizedMessage() + "^";
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return string + ".0^";
        }
    }

    ObjectFieldVariable(JPDADebuggerImpl jPDADebuggerImpl, ObjectReference objectReference, Field field, String string, String string2, ObjectReference objectReference2) {
        this(jPDADebuggerImpl, objectReference, field, string, objectReference2);
        this.genericSignature = string2;
    }

    public String getName() {
        try {
            return TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
    }

    public String getClassName() {
        try {
            return ReferenceTypeWrapper.name(TypeComponentWrapper.declaringType(this.field));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
    }

    public JPDAClassType getDeclaringClass() {
        ReferenceType referenceType;
        try {
            referenceType = this.objectReference != null ? (ReferenceType)ValueWrapper.type(this.objectReference) : TypeComponentWrapper.declaringType(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            throw internalExceptionWrapper.getCause();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            throw vMDisconnectedExceptionWrapper.getCause();
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            throw objectCollectedExceptionWrapper.getCause();
        }
        return new JPDAClassTypeImpl(this.getDebugger(), referenceType);
    }

    public String getDeclaredType() {
        try {
            return FieldWrapper.typeName(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
    }

    public JPDAClassType getClassType() {
        Value value = this.getInnerValue();
        if (value != null) {
            return super.getClassType();
        }
        try {
            Type type;
            try {
                type = FieldWrapper.type(this.field);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return null;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return null;
            }
            if (type instanceof ReferenceType) {
                return new JPDAClassTypeImpl(this.getDebugger(), (ReferenceType)type);
            }
            return null;
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            return null;
        }
    }

    public boolean isStatic() {
        return TypeComponentWrapper.isStatic0(this.field);
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        try {
            boolean bl = false;
            if (this.objectReference != null) {
                ObjectReferenceWrapper.setValue(this.objectReference, this.field, value);
                bl = true;
            } else {
                ReferenceType referenceType = TypeComponentWrapper.declaringType(this.field);
                if (referenceType instanceof ClassType) {
                    ClassType classType = (ClassType)referenceType;
                    ClassTypeWrapper.setValue(classType, this.field, value);
                    bl = true;
                }
            }
            if (!bl) {
                throw new InvalidExpressionException(this.field.toString());
            }
        }
        catch (IllegalArgumentExceptionWrapper illegalArgumentExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)illegalArgumentExceptionWrapper.getCause());
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)internalExceptionWrapper);
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)vMDisconnectedExceptionWrapper);
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)classNotPreparedExceptionWrapper);
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)objectCollectedExceptionWrapper);
        }
    }

    public ObjectFieldVariable clone() {
        String string;
        try {
            string = TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            string = internalExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            string = "0";
        }
        return new ObjectFieldVariable(this.getDebugger(), (ObjectReference)this.getJDIValue(), this.field, this.getID().substring(0, this.getID().length() - ("." + string + (this.getJDIValue() instanceof ObjectReference ? "^" : "")).length()), this.genericSignature, this.objectReference);
    }

    public String toString() {
        try {
            return "ObjectFieldVariable " + TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "Disconnected";
        }
    }
}

